/*
 * Decompiled with CFR 0.152.
 */
package org.afree.chart.renderer.xy;

import android.graphics.Canvas;
import android.graphics.Paint;
import java.io.Serializable;
import org.afree.chart.axis.ValueAxis;
import org.afree.chart.entity.EntityCollection;
import org.afree.chart.plot.CrosshairState;
import org.afree.chart.plot.PlotOrientation;
import org.afree.chart.plot.PlotRenderingInfo;
import org.afree.chart.plot.XYPlot;
import org.afree.chart.renderer.xy.AbstractXYItemRenderer;
import org.afree.chart.renderer.xy.XYItemRenderer;
import org.afree.chart.renderer.xy.XYItemRendererState;
import org.afree.data.Range;
import org.afree.data.xy.VectorXYDataset;
import org.afree.data.xy.XYDataset;
import org.afree.graphics.PaintUtility;
import org.afree.graphics.geom.LineShape;
import org.afree.graphics.geom.PathShape;
import org.afree.graphics.geom.RectShape;
import org.afree.util.PublicCloneable;

public class VectorRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer,
Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = -8230857449049850336L;
    private double baseLength = 0.1;
    private double headLength = 0.14;

    public Range findDomainBounds(XYDataset dataset) {
        if (dataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        double minimum = Double.POSITIVE_INFINITY;
        double maximum = Double.NEGATIVE_INFINITY;
        int seriesCount = dataset.getSeriesCount();
        if (dataset instanceof VectorXYDataset) {
            VectorXYDataset vdataset = (VectorXYDataset)dataset;
            int series = 0;
            while (series < seriesCount) {
                int itemCount = dataset.getItemCount(series);
                int item = 0;
                while (item < itemCount) {
                    double lvalue;
                    double uvalue;
                    double delta = vdataset.getVectorXValue(series, item);
                    if (delta < 0.0) {
                        uvalue = vdataset.getXValue(series, item);
                        lvalue = uvalue + delta;
                    } else {
                        lvalue = vdataset.getXValue(series, item);
                        uvalue = lvalue + delta;
                    }
                    minimum = Math.min(minimum, lvalue);
                    maximum = Math.max(maximum, uvalue);
                    ++item;
                }
                ++series;
            }
        } else {
            int series = 0;
            while (series < seriesCount) {
                int itemCount = dataset.getItemCount(series);
                int item = 0;
                while (item < itemCount) {
                    double lvalue;
                    double uvalue = lvalue = dataset.getXValue(series, item);
                    minimum = Math.min(minimum, lvalue);
                    maximum = Math.max(maximum, uvalue);
                    ++item;
                }
                ++series;
            }
        }
        if (minimum > maximum) {
            return null;
        }
        return new Range(minimum, maximum);
    }

    public Range findRangeBounds(XYDataset dataset) {
        if (dataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        double minimum = Double.POSITIVE_INFINITY;
        double maximum = Double.NEGATIVE_INFINITY;
        int seriesCount = dataset.getSeriesCount();
        if (dataset instanceof VectorXYDataset) {
            VectorXYDataset vdataset = (VectorXYDataset)dataset;
            int series = 0;
            while (series < seriesCount) {
                int itemCount = dataset.getItemCount(series);
                int item = 0;
                while (item < itemCount) {
                    double lvalue;
                    double uvalue;
                    double delta = vdataset.getVectorYValue(series, item);
                    if (delta < 0.0) {
                        uvalue = vdataset.getYValue(series, item);
                        lvalue = uvalue + delta;
                    } else {
                        lvalue = vdataset.getYValue(series, item);
                        uvalue = lvalue + delta;
                    }
                    minimum = Math.min(minimum, lvalue);
                    maximum = Math.max(maximum, uvalue);
                    ++item;
                }
                ++series;
            }
        } else {
            int series = 0;
            while (series < seriesCount) {
                int itemCount = dataset.getItemCount(series);
                int item = 0;
                while (item < itemCount) {
                    double lvalue;
                    double uvalue = lvalue = dataset.getYValue(series, item);
                    minimum = Math.min(minimum, lvalue);
                    maximum = Math.max(maximum, uvalue);
                    ++item;
                }
                ++series;
            }
        }
        if (minimum > maximum) {
            return null;
        }
        return new Range(minimum, maximum);
    }

    public void drawItem(Canvas canvas, XYItemRendererState state, RectShape dataArea, PlotRenderingInfo info, XYPlot plot, ValueAxis domainAxis, ValueAxis rangeAxis, XYDataset dataset, int series, int item, CrosshairState crosshairState, int pass) {
        double x = dataset.getXValue(series, item);
        double y = dataset.getYValue(series, item);
        double dx = 0.0;
        double dy = 0.0;
        if (dataset instanceof VectorXYDataset) {
            dx = ((VectorXYDataset)dataset).getVectorXValue(series, item);
            dy = ((VectorXYDataset)dataset).getVectorYValue(series, item);
        }
        double xx0 = domainAxis.valueToJava2D(x, dataArea, plot.getDomainAxisEdge());
        double yy0 = rangeAxis.valueToJava2D(y, dataArea, plot.getRangeAxisEdge());
        double xx1 = domainAxis.valueToJava2D(x + dx, dataArea, plot.getDomainAxisEdge());
        double yy1 = rangeAxis.valueToJava2D(y + dy, dataArea, plot.getRangeAxisEdge());
        PlotOrientation orientation = plot.getOrientation();
        LineShape line = orientation.equals(PlotOrientation.HORIZONTAL) ? new LineShape(yy0, xx0, yy1, xx1) : new LineShape(xx0, yy0, xx1, yy1);
        Paint paint = PaintUtility.createPaint(1, this.getItemPaintType(series, item), this.getItemStroke(series, item).floatValue(), this.getItemEffect(series, item));
        line.draw(canvas, paint);
        double dxx = xx1 - xx0;
        double dyy = yy1 - yy0;
        double bx = xx0 + (1.0 - this.baseLength) * dxx;
        double by = yy0 + (1.0 - this.baseLength) * dyy;
        double cx = xx0 + (1.0 - this.headLength) * dxx;
        double cy = yy0 + (1.0 - this.headLength) * dyy;
        double angle = 0.0;
        if (dxx != 0.0) {
            angle = 1.5707963267948966 - Math.atan(dyy / dxx);
        }
        double deltaX = 2.0 * Math.cos(angle);
        double deltaY = 2.0 * Math.sin(angle);
        double leftx = cx + deltaX;
        double lefty = cy - deltaY;
        double rightx = cx - deltaX;
        double righty = cy + deltaY;
        PathShape p = new PathShape();
        if (orientation == PlotOrientation.VERTICAL) {
            p.moveTo((float)xx1, (float)yy1);
            p.lineTo((float)rightx, (float)righty);
            p.lineTo((float)bx, (float)by);
            p.lineTo((float)leftx, (float)lefty);
        } else {
            p.moveTo((float)yy1, (float)xx1);
            p.lineTo((float)righty, (float)rightx);
            p.lineTo((float)by, (float)bx);
            p.lineTo((float)lefty, (float)leftx);
        }
        p.closePath();
        p.draw(canvas, paint);
        EntityCollection entities = null;
        if (info != null && (entities = info.getOwner().getEntityCollection()) != null) {
            RectShape rectShape = new RectShape();
            line.getBounds(rectShape);
            this.addEntity(entities, rectShape, dataset, series, item, 0.0, 0.0);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof VectorRenderer)) {
            return false;
        }
        VectorRenderer that = (VectorRenderer)obj;
        if (this.baseLength != that.baseLength) {
            return false;
        }
        if (this.headLength != that.headLength) {
            return false;
        }
        return super.equals(obj);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

