/*
 * Decompiled with CFR 0.152.
 */
package org.afree.chart.text;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import java.io.Serializable;
import org.afree.chart.text.TextUtilities;
import org.afree.graphics.PaintType;
import org.afree.graphics.PaintUtility;
import org.afree.graphics.SolidColor;
import org.afree.graphics.geom.Font;
import org.afree.ui.RefineryUtilities;
import org.afree.ui.Size2D;
import org.afree.ui.TextAnchor;

public class TextFragment
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final Font DEFAULT_FONT = new Font("Serif", 1, 12);
    public static final PaintType DEFAULT_PAINT = new SolidColor(Color.argb((int)0, (int)0, (int)0, (int)0));
    private String text;
    private Font font;
    private PaintType paintType;

    public TextFragment(String text) {
        this(text, DEFAULT_FONT, DEFAULT_PAINT);
    }

    public TextFragment(String text, Font font) {
        this(text, font, DEFAULT_PAINT);
    }

    public TextFragment(String text, Font font, PaintType paintType) {
        if (text == null) {
            throw new IllegalArgumentException("Null 'text' argument.");
        }
        if (font == null) {
            throw new IllegalArgumentException("Null 'font' argument.");
        }
        if (paintType == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.text = text;
        this.font = font;
        this.paintType = paintType;
    }

    public String getText() {
        return this.text;
    }

    public Font getFont() {
        return this.font;
    }

    public PaintType getPaintType() {
        return this.paintType;
    }

    public void draw(Canvas canvas, float anchorX, float anchorY, TextAnchor anchor, float rotateX, float rotateY, double angle) {
        Paint paint = PaintUtility.createPaint(1, this.paintType, this.font);
        RefineryUtilities.drawRotatedString(this.text, canvas, anchorX, anchorY, anchor, rotateX, rotateY, paint, (float)angle);
    }

    public Size2D calculateDimensions(Canvas canvas) {
        Paint paint = PaintUtility.createPaint(1, this.paintType, this.font);
        return new Size2D(TextUtilities.getTextWidth(this.text, paint), TextUtilities.getTextHeight(paint));
    }

    public float calculateBaselineOffset(TextAnchor anchor) {
        float result = 0.0f;
        Paint paint = PaintUtility.createPaint(1, this.paintType, this.font);
        Paint.FontMetrics fm = paint.getFontMetrics();
        if (anchor == TextAnchor.TOP_LEFT || anchor == TextAnchor.TOP_CENTER || anchor == TextAnchor.TOP_RIGHT) {
            result = Math.abs(fm.ascent);
        } else if (anchor == TextAnchor.BOTTOM_LEFT || anchor == TextAnchor.BOTTOM_CENTER || anchor == TextAnchor.BOTTOM_RIGHT) {
            result = -Math.abs(fm.descent) - Math.abs(fm.leading);
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof TextFragment) {
            TextFragment tf = (TextFragment)obj;
            if (!this.text.equals(tf.text)) {
                return false;
            }
            if (!this.font.equals(tf.font)) {
                return false;
            }
            return this.paintType.equals(tf.paintType);
        }
        return false;
    }
}

