/*
 * Decompiled with CFR 0.152.
 */
package org.afree.chart.title;

import android.graphics.Canvas;
import org.afree.chart.block.Arrangement;
import org.afree.chart.block.BlockContainer;
import org.afree.chart.block.BlockResult;
import org.afree.chart.block.EntityBlockParams;
import org.afree.chart.entity.LegendItemEntity;
import org.afree.chart.entity.StandardEntityCollection;
import org.afree.data.general.Dataset;
import org.afree.graphics.geom.RectShape;

public class LegendItemBlockContainer
extends BlockContainer {
    private static final long serialVersionUID = -8133931573818868206L;
    private Dataset dataset;
    private Comparable seriesKey;
    private int series;
    private String toolTipText;
    private String urlText;

    public LegendItemBlockContainer(Arrangement arrangement, Dataset dataset, Comparable seriesKey) {
        super(arrangement);
        this.dataset = dataset;
        this.seriesKey = seriesKey;
    }

    public Dataset getDataset() {
        return this.dataset;
    }

    public Comparable getSeriesKey() {
        return this.seriesKey;
    }

    public int getSeriesIndex() {
        return this.series;
    }

    public String getToolTipText() {
        return this.toolTipText;
    }

    public void setToolTipText(String text) {
        this.toolTipText = text;
    }

    public String getURLText() {
        return this.urlText;
    }

    public void setURLText(String text) {
        this.urlText = text;
    }

    public Object draw(Canvas canvas, RectShape area, Object params) {
        super.draw(canvas, area, null);
        EntityBlockParams ebp = null;
        BlockResult r = new BlockResult();
        if (params instanceof EntityBlockParams && (ebp = (EntityBlockParams)params).getGenerateEntities()) {
            StandardEntityCollection ec = new StandardEntityCollection();
            LegendItemEntity entity = new LegendItemEntity(area.clone());
            entity.setSeriesIndex(this.series);
            entity.setSeriesKey(this.seriesKey);
            entity.setDataset(this.dataset);
            entity.setToolTipText(this.getToolTipText());
            entity.setURLText(this.getURLText());
            ec.add(entity);
            r.setEntityCollection(ec);
        }
        return r;
    }
}

