/*
 * Decompiled with CFR 0.152.
 */
package org.afree.ui;

import android.graphics.PointF;
import java.io.Serializable;
import org.afree.graphics.geom.RectShape;
import org.afree.ui.Size2D;

public final class RectangleAnchor
implements Serializable {
    private static final long serialVersionUID = -2457494205644416327L;
    public static final RectangleAnchor CENTER = new RectangleAnchor("RectangleAnchor.CENTER");
    public static final RectangleAnchor TOP = new RectangleAnchor("RectangleAnchor.TOP");
    public static final RectangleAnchor TOP_LEFT = new RectangleAnchor("RectangleAnchor.TOP_LEFT");
    public static final RectangleAnchor TOP_RIGHT = new RectangleAnchor("RectangleAnchor.TOP_RIGHT");
    public static final RectangleAnchor BOTTOM = new RectangleAnchor("RectangleAnchor.BOTTOM");
    public static final RectangleAnchor BOTTOM_LEFT = new RectangleAnchor("RectangleAnchor.BOTTOM_LEFT");
    public static final RectangleAnchor BOTTOM_RIGHT = new RectangleAnchor("RectangleAnchor.BOTTOM_RIGHT");
    public static final RectangleAnchor LEFT = new RectangleAnchor("RectangleAnchor.LEFT");
    public static final RectangleAnchor RIGHT = new RectangleAnchor("RectangleAnchor.RIGHT");
    private String name;

    private RectangleAnchor(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RectangleAnchor)) {
            return false;
        }
        RectangleAnchor order = (RectangleAnchor)obj;
        return this.name.equals(order.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public static PointF coordinates(RectShape RectShape2, RectangleAnchor anchor) {
        PointF result = new PointF();
        if (anchor == CENTER) {
            result.set(RectShape2.getCenterX(), RectShape2.getCenterY());
        } else if (anchor == TOP) {
            result.set(RectShape2.getCenterX(), RectShape2.getMinY());
        } else if (anchor == BOTTOM) {
            result.set(RectShape2.getCenterX(), RectShape2.getMaxY());
        } else if (anchor == LEFT) {
            result.set(RectShape2.getMinX(), RectShape2.getCenterY());
        } else if (anchor == RIGHT) {
            result.set(RectShape2.getMaxX(), RectShape2.getCenterY());
        } else if (anchor == TOP_LEFT) {
            result.set(RectShape2.getMinX(), RectShape2.getMinY());
        } else if (anchor == TOP_RIGHT) {
            result.set(RectShape2.getMaxX(), RectShape2.getMinY());
        } else if (anchor == BOTTOM_LEFT) {
            result.set(RectShape2.getMinX(), RectShape2.getMaxY());
        } else if (anchor == BOTTOM_RIGHT) {
            result.set(RectShape2.getMaxX(), RectShape2.getMaxY());
        }
        return result;
    }

    public static RectShape createRectShape(Size2D dimensions, double anchorX, double anchorY, RectangleAnchor anchor) {
        RectShape result = null;
        double w = dimensions.getWidth();
        double h = dimensions.getHeight();
        if (anchor == CENTER) {
            result = new RectShape(anchorX - w / 2.0, anchorY - h / 2.0, w, h);
        } else if (anchor == TOP) {
            result = new RectShape(anchorX - w / 2.0, anchorY - h / 2.0, w, h);
        } else if (anchor == BOTTOM) {
            result = new RectShape(anchorX - w / 2.0, anchorY - h / 2.0, w, h);
        } else if (anchor == LEFT) {
            result = new RectShape(anchorX, anchorY - h / 2.0, w, h);
        } else if (anchor == RIGHT) {
            result = new RectShape(anchorX - w, anchorY - h / 2.0, w, h);
        } else if (anchor == TOP_LEFT) {
            result = new RectShape(anchorX - w / 2.0, anchorY - h / 2.0, w, h);
        } else if (anchor == TOP_RIGHT) {
            result = new RectShape(anchorX - w / 2.0, anchorY - h / 2.0, w, h);
        } else if (anchor == BOTTOM_LEFT) {
            result = new RectShape(anchorX - w / 2.0, anchorY - h / 2.0, w, h);
        } else if (anchor == BOTTOM_RIGHT) {
            result = new RectShape(anchorX - w / 2.0, anchorY - h / 2.0, w, h);
        }
        return result;
    }
}

