/*
 * Decompiled with CFR 0.152.
 */
package org.afree.ui;

import android.graphics.Canvas;
import android.graphics.Paint;
import org.afree.chart.text.TextUtilities;
import org.afree.graphics.geom.RectShape;
import org.afree.ui.TextAnchor;

public abstract class RefineryUtilities {
    public static void drawRotatedString(String text, Canvas canvas, float x, float y, TextAnchor textAnchor, Paint paint, float angle) {
        RefineryUtilities.drawRotatedString(text, canvas, x, y, textAnchor, x, y, paint, angle);
    }

    public static void drawRotatedString(String text, Canvas canvas, float x, float y, TextAnchor textAnchor, float rotateX, float rotateY, Paint paint, float angle) {
        float[] textAdj = RefineryUtilities.deriveTextBoundsAnchorOffsets(paint, text, textAnchor);
        canvas.save();
        if ((double)angle == 0.0) {
            canvas.drawText(text, x + textAdj[0], y + textAdj[1], paint);
        } else {
            canvas.rotate((float)Math.toDegrees(angle), rotateX, rotateY);
            canvas.drawText(text, x + textAdj[0], y + textAdj[1], paint);
        }
        canvas.restore();
    }

    private static float[] deriveTextBoundsAnchorOffsets(Paint paint, String text, TextAnchor anchor) {
        float[] result = new float[2];
        Paint.FontMetrics fm = paint.getFontMetrics();
        RectShape bounds = TextUtilities.getTextBounds(text, paint);
        float ascent = Math.abs(fm.ascent);
        float halfAscent = ascent / 2.0f;
        float descent = Math.abs(fm.descent);
        float leading = Math.abs(fm.leading);
        float xAdj = 0.0f;
        float yAdj = 0.0f;
        if (anchor == TextAnchor.TOP_CENTER || anchor == TextAnchor.CENTER || anchor == TextAnchor.BOTTOM_CENTER || anchor == TextAnchor.BASELINE_CENTER || anchor == TextAnchor.HALF_ASCENT_CENTER) {
            xAdj = -bounds.getWidth() / 2.0f;
        } else if (anchor == TextAnchor.TOP_RIGHT || anchor == TextAnchor.CENTER_RIGHT || anchor == TextAnchor.BOTTOM_RIGHT || anchor == TextAnchor.BASELINE_RIGHT || anchor == TextAnchor.HALF_ASCENT_RIGHT) {
            xAdj = -bounds.getWidth();
        }
        if (anchor == TextAnchor.TOP_LEFT || anchor == TextAnchor.TOP_CENTER || anchor == TextAnchor.TOP_RIGHT) {
            yAdj = -descent - leading + bounds.getHeight();
        } else if (anchor == TextAnchor.HALF_ASCENT_LEFT || anchor == TextAnchor.HALF_ASCENT_CENTER || anchor == TextAnchor.HALF_ASCENT_RIGHT) {
            yAdj = halfAscent;
        } else if (anchor == TextAnchor.CENTER_LEFT || anchor == TextAnchor.CENTER || anchor == TextAnchor.CENTER_RIGHT) {
            yAdj = -descent - leading + (float)((double)bounds.getHeight() / 2.0);
        } else if (anchor == TextAnchor.BASELINE_LEFT || anchor == TextAnchor.BASELINE_CENTER || anchor == TextAnchor.BASELINE_RIGHT) {
            yAdj = 0.0f;
        } else if (anchor == TextAnchor.BOTTOM_LEFT || anchor == TextAnchor.BOTTOM_CENTER || anchor == TextAnchor.BOTTOM_RIGHT) {
            yAdj = -Math.abs(fm.descent) - Math.abs(fm.leading);
        }
        result[0] = xAdj;
        result[1] = yAdj;
        return result;
    }
}

