/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.auth;

import twitter4j.auth.AccessToken;
import twitter4j.auth.Authorization;
import twitter4j.auth.BasicAuthorization;
import twitter4j.auth.NullAuthorization;
import twitter4j.auth.OAuthAuthorization;
import twitter4j.conf.Configuration;

public final class AuthorizationFactory {
    public static Authorization getInstance(Configuration conf) {
        Authorization auth = null;
        String consumerKey = conf.getOAuthConsumerKey();
        String consumerSecret = conf.getOAuthConsumerSecret();
        if (null != consumerKey && null != consumerSecret) {
            OAuthAuthorization oauth = new OAuthAuthorization(conf);
            String accessToken = conf.getOAuthAccessToken();
            String accessTokenSecret = conf.getOAuthAccessTokenSecret();
            if (null != accessToken && null != accessTokenSecret) {
                oauth.setOAuthAccessToken(new AccessToken(accessToken, accessTokenSecret));
            }
            auth = oauth;
        } else {
            String screenName = conf.getUser();
            String password = conf.getPassword();
            if (null != screenName && null != password) {
                auth = new BasicAuthorization(screenName, password);
            }
        }
        if (null == auth) {
            auth = NullAuthorization.getInstance();
        }
        return auth;
    }
}

