package com.td;

import java.util.Calendar;
import java.util.Date;

import android.app.TimePickerDialog;
import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemSelectedListener;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Spinner;
import android.widget.TimePicker;

import com.td.utility.BaseActivity;
import com.td.utility.DateUtil;
import com.td.utility.Debug;
import com.td.utility.EditPrefUtil;
import com.td.utility.FormattedDate;

public class HistoryConfActivity extends BaseActivity {
	private EditPrefUtil pref = new EditPrefUtil(this);
	private Spinner spinner1;
	private EditText editText1;
	private EditText editText2;
	private FormattedDate[] weeks;

	@Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.history_conf);

        try {
        Calendar cal;
        Date date;
        
        cal = Calendar.getInstance();
        date = cal.getTime();
        spinner1 = (Spinner) findViewById(R.id.spinner71);
		spinner1.setOnItemSelectedListener(new OnItemSelectedListener(){
			public void onItemSelected(AdapterView<?> parent, View view,
					int position, long id) {
				Date d = weeks[position].getDate();
				int ymd = DateUtil.getYmd(d);
				pref.put(HistoryActivity.PREF_HIS_YMD, ymd);
				pref.put(HistoryActivity.PREF_HIS_YMD_POS, position);
			}
			
			public void onNothingSelected(AdapterView<?> view) {
				;
			}
		});
		weeks = new FormattedDate[DateUtil.WEEK];
		for (int i = 0; i < DateUtil.WEEK; i++){
			weeks[DateUtil.WEEK - (i + 1)] = new FormattedDate(date);
			cal.add(Calendar.DATE, -1);
			date = cal.getTime();
		}
		ArrayAdapter<FormattedDate> adapter1 = new ArrayAdapter<FormattedDate>(
				this, android.R.layout.simple_spinner_item, weeks);
		adapter1.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
		spinner1.setAdapter(adapter1);
        
        editText1 = (EditText) findViewById(R.id.editText71);
		editText1.setOnClickListener(new OnClickListener(){
			public void onClick(View view) {
				String t = editText1.getText().toString();
				String strHour = DateUtil.getHour(t);
				String strMinute = DateUtil.getMinute(t);
				
				int hour = Integer.parseInt(strHour);
				int minute = Integer.parseInt(strMinute);
				TimePickerDialog timePickerDialog = new TimePickerDialog(
						HistoryConfActivity.this,
						new TimePickerDialog.OnTimeSetListener() {
							public void onTimeSet(TimePicker view,
									int hourOfDay, int minute) {
								String s = DateUtil.formattedHm(DateUtil.getHm(
										hourOfDay, minute));
								editText1.setText(s);

								pref.put(HistoryActivity.PREF_HIS_ST_HOUR, hourOfDay);
								pref.put(HistoryActivity.PREF_HIS_ST_MINUTE, minute);
							}
						}, hour, minute, true);
				timePickerDialog.show();
			}});
		
        editText2 = (EditText) findViewById(R.id.editText72);
		editText2.setOnClickListener(new OnClickListener(){
			public void onClick(View view) {
				String t = editText2.getText().toString();
				String strHour = DateUtil.getHour(t);
				String strMinute = DateUtil.getMinute(t);
				
				int hour = Integer.parseInt(strHour);
				int minute = Integer.parseInt(strMinute);
				TimePickerDialog timePickerDialog = new TimePickerDialog(
						HistoryConfActivity.this,
						new TimePickerDialog.OnTimeSetListener() {
							public void onTimeSet(TimePicker view,
									int hourOfDay, int minute) {
								String s = DateUtil.formattedHm(DateUtil.getHm(
										hourOfDay, minute));
								editText2.setText(s);

								pref.put(HistoryActivity.PREF_HIS_EN_HOUR, hourOfDay);
								pref.put(HistoryActivity.PREF_HIS_EN_MINUTE, minute);
							}
						}, hour, minute, true);
				timePickerDialog.show();
			}});

		Button button1 = (Button) this.findViewById(R.id.button71);
		button1.setOnClickListener(new OnClickListener() {
			public void onClick(View view) {
				pref.update();
				
				HistoryConfActivity.this.setResult(RESULT_OK);
		        HistoryConfActivity.this.finish();
			}
		});

		Button button2 = (Button) this.findViewById(R.id.button72);
		button2.setOnClickListener(new OnClickListener() {
			public void onClick(View view) {
				HistoryConfActivity.this.setResult(RESULT_CANCELED);
				HistoryConfActivity.this.finish();
			}
		});
		}
		catch (Exception e){
			Debug.d(this, null, e);
			showDialog(this, e);			
		}
	}

    @Override
	protected void onStart() {
		super.onStart();
		
		try {
		String data = pref.get(HistoryActivity.PREF_HIS_DATA);
		if (data != null){
			pref.restore(HistoryActivity.PREF_HIS_DATA);
		}
        int prefStHour = pref.getInt(HistoryActivity.PREF_HIS_ST_HOUR);
        int prefStMinute = pref.getInt(HistoryActivity.PREF_HIS_ST_MINUTE);
        int prefEnHour = pref.getInt(HistoryActivity.PREF_HIS_EN_HOUR);
        int prefEnMinute = pref.getInt(HistoryActivity.PREF_HIS_EN_MINUTE);
        int prefYmdPos = pref.getInt(HistoryActivity.PREF_HIS_YMD_POS);

		spinner1.setSelection(prefYmdPos);
		editText1.setText(DateUtil.formattedHm(DateUtil.getHm(prefStHour,
				prefStMinute)));
		editText2.setText(DateUtil.formattedHm(DateUtil.getHm(prefEnHour,
				prefEnMinute)));
		}
		catch (Exception e){
			Debug.d(this, null, e);
			showDialog(this, e);			
		}		
    }
    
	@Override
	protected void onStop() {
		try {
		pref.save(HistoryActivity.PREF_HIS_DATA);
		}
		catch (Exception e){
			Debug.d(this, null, e);
			showDialog(this, e);			
		}
		
		super.onStop();
	}
	
	public static void init(Context context) {
		EditPrefUtil pref = new EditPrefUtil(context);
		pref.remove(HistoryActivity.PREF_HIS_DATA);
		pref.update();
	}	
}
