package com.td;

import org.afree.chart.AFreeChart;
import org.afree.graphics.geom.RectShape;

import android.content.Context;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;

public class HistoryView extends View {
    private AFreeChart chart;
	private int rr = -1;
	private static float dw = 1;
	private HistoryActivity activity;
	
    public HistoryView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public void setHistoryActivity(HistoryActivity activity){
    	this.activity = activity;
    }
    
    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
		
        int width = this.getWidth();
		int height = this.getHeight();
		RectShape chartArea = new RectShape(0.0, 0.0, width, height);
		this.chart.draw(canvas, chartArea);
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
    	int w = activity.getScrollViewWidth();
        int width = (int)(w * dw);
		int height = measureHeight(heightMeasureSpec);
    	setMeasuredDimension(width, height);
    }


	private int measureHeight(int measureSpec) {
		int result = 0;
		int specSize = MeasureSpec.getSize(measureSpec);

		result = specSize;
		return result;
	}
	
	public void setChart(AFreeChart chart) {
        this.chart = chart;
    }
	
	@Override
	public boolean onTouchEvent(MotionEvent event) {
		if (chart == null){
			return true;
		}
		int type = event.getAction();
		int count = event.getPointerCount();
		
		switch (type){
		case MotionEvent.ACTION_DOWN:
			rr = -1;
			break;
		case MotionEvent.ACTION_MOVE:
			int history = event.getHistorySize() / count;
			
			for (int i = 0; i < history; i++){
				int index1 = event.findPointerIndex(0);
				int index2 = event.findPointerIndex(1);

				if (index1 >= 0 && index2 >= 0){
					int ux1 = (int) event.getHistoricalX(index1, i);
					int uy1 = (int) event.getHistoricalY(index1, i);
					int ux2 = (int) event.getHistoricalX(index2, i);
					int uy2 = (int) event.getHistoricalY(index2, i);
					int ss = (ux1 - ux2) * (ux1 - ux2) + (uy1 - uy2) * (uy1 - uy2);
					if (rr >= 0){
						float drr = rotateR(rr, ss);
						if (drr != 0){
							magnification(drr);						
						}
					}
					rr = ss;					
				}
				else if (index1 >= 0 || index2 >= 0){
					rr = -1;
				}
			}
			int index1 = event.findPointerIndex(0);
			int index2 = event.findPointerIndex(1);
			if (index1 >= 0 && index2 >= 0){
				int ux1 = (int) event.getX(index1);
				int uy1 = (int) event.getY(index1);
				int ux2 = (int) event.getX(index2);
				int uy2 = (int) event.getY(index2);
				int ss = (ux1 - ux2) * (ux1 - ux2) + (uy1 - uy2) * (uy1 - uy2);
				if (rr >= 0){
					float drr = rotateR(rr, ss);
					if (drr != 0){
						magnification(drr);						
					}
				}
				rr = ss;
			}
			else if (index1 >= 0 || index2 >= 0){
				rr = -1;
			}
			break;
		}
		
		return true;
	}

	private void magnification(float drr) {
		float prefDw = dw;
		
		dw += drr;
		if (dw < 1){
			dw = 1;
		}
		else if (dw > 5){
			dw = 5;
		}
		
    	activity.preMagnification();
    	int w = activity.getScrollViewWidth();
        int width = (int)(w * dw);
    	this.setMinimumWidth(width);
    	activity.magnification(prefDw, dw);
		this.requestLayout();
	}

	private float rotateR(int src, int dst){
		if (src > dst){
			return -0.5f;
		}
		else if (src < dst){
			return 0.5f;			
		}
		else {
			return 0.0f;
		}
	}
}
