package com.td;

import java.util.Calendar;
import java.util.List;

import android.content.Intent;

import com.td.broadcast.DelayReceiver;
import com.td.db.Train;
import com.td.db.TrainDao;
import com.td.test.TestException;
import com.td.utility.ConfUtil;
import com.td.utility.Debug;
import com.td.utility.EditPrefUtil;
import com.td.utility.StringMap;

public class TrainDelayedActivityTest {
	private static DelayReceiver context;
	private static TrainDelayedActivity activity;
	
	public static void main(TrainDelayedActivity activity, DelayReceiver context) {
		TrainDelayedActivityTest.context = context;
		TrainDelayedActivityTest.activity = activity;
		TrainDelayedActivityTest obj = new TrainDelayedActivityTest();
		EditPrefUtil pref = new EditPrefUtil(activity);
		
		Debug.i(obj, "start");
		try {
			pref.remove(TrainDelayedActivity.PREF_TRD_DELAY);
			ConfUtil.setWidth(pref, 5);
			pref.update();

			List<Train> list = TrainDao.getInstance().search();
			Train train = list.get(0);
			
			test_updateDelay(train.getId());
		} catch (TestException e) {
			Debug.i(obj, null, e);
		}
		pref.remove(TrainDelayedActivity.PREF_TRD_DELAY);
		pref.update();
		Debug.i(obj, "end");
	}

	public static void test_updateDelay(long id) throws TestException{
		Intent intent = null;
		EditPrefUtil pref = null;
		String retData = null;
		Calendar cal = null;
		long t = -1;
		String expData = null;
		StringMap expMap = null;
		long t2 = -1;
		boolean expRet = false;
		
		cal = Calendar.getInstance();
		for (int i = 0; i < 4; i++){
			t = cal.getTimeInMillis();
			pref = new EditPrefUtil(activity);
			intent = new Intent();
			expMap = new StringMap();
			
			switch (i){
			case 0:
				// 0x
				intent.putExtra("ID", id);
				
				expMap.put(String.valueOf(id), String.valueOf(t));
				t2 = t + 5 * 60 * 1000 + 1;
				expRet = false;
				break;
			case 1:
				// 1x
				intent.putExtra("ID", id);
				
				expMap.put(String.valueOf(id), String.valueOf(t));
				t2 = t + 5 * 60 * 1000;
				expRet = true;
				break;
			case 2:
				// 2x
				intent.putExtra("ID", id + 1);
				
				expMap.put(String.valueOf(id), String.valueOf(t));
				expMap.put(String.valueOf(id + 1), String.valueOf(t));
				t2 = t + 5 * 60 * 1000;
				expRet = true;
				break;
			case 3:
				// 2A1x
				intent.putExtra("ID", id + 1);
				
				expMap.put(String.valueOf(id), String.valueOf(t));
				expMap.put(String.valueOf(id + 1), String.valueOf(t + 1));

				t2 = t + 5 * 60 * 1000 + 1;
				t = t + 1;
				expRet = true;
				break;
			}
			//data = map.getData();
			//pref.put(TrainDelayedActivity.PREF_TRD_DELAY, data);
			//pref.update();
			
			context.updateDelay(intent, pref, t);

			retData = pref.get(TrainDelayedActivity.PREF_TRD_DELAY);
			expData = expMap.getData();
			
			if (!expData.equals(retData)){
				throw new TestException();
			}
			
			String retStr = activity.updateDelayMsg(t2);
			if (expRet != (retStr != null)){
				throw new TestException();
			}
			
			String msg = pref.get(TrainDelayedActivity.PREF_TRD_DELAY_MSG);
			if (msg == null || msg.length() == 0){
				msg = "[xȂ]";
			}
			msg = "[" + i + "] " + msg;
			
			Debug.t(activity, msg);
		}
	}
}
