package com.td.broadcast;

import java.util.Calendar;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.widget.Toast;

import com.td.TrainDelayedActivity;
import com.td.utility.EditPrefUtil;
import com.td.utility.StatusFlagFactory;
import com.td.utility.StringMap;

public class DelayReceiver extends BroadcastReceiver {
	public static String DELAY = "com.td.broadcast.DelayReceiver.DELAY";
	public static String DEBUG = "com.td.broadcast.DelayReceiver.DEBUG";
	public static String START_SERVICE = "com.td.broadcast.DelayReceiver.START_SERVICE";
	public static String STOP_SERVICE = "com.td.broadcast.DelayReceiver.STOP_SERVICE";
	public static String UPDATE = "com.td.broadcast.DelayReceiver.UPDATE";
	
	@Override
	public void onReceive(Context context, Intent intent) {
		Bundle bundle = intent.getExtras();
		String action = intent.getAction();
		if (action.equals(DEBUG)){
			String text = bundle.getString("TEXT");
			Toast.makeText(context, text, Toast.LENGTH_LONG).show();			
		}
		else if (action.equals(START_SERVICE)){
			;
		}
		else if (action.equals(STOP_SERVICE)){
			;
		}
		else if (action.equals(UPDATE)){
			;
		}
		else if (action.equals(DELAY)){
			EditPrefUtil pref = new EditPrefUtil(context);
			updateDelay(intent, pref);

			// Cʕ`
			Intent updaetIntent = new Intent(DelayReceiver.UPDATE);
			context.sendBroadcast(updaetIntent);						
		}
		else if (action.equals(Intent.ACTION_BOOT_COMPLETED)){
			// dIɃtONA
			StatusFlagFactory.getInstance().init(context);
		}
	}

	public void updateDelay(Intent intent, EditPrefUtil pref){
		Calendar cal = Calendar.getInstance();
		long t = cal.getTimeInMillis();

		updateDelay(intent, pref, t);
	}
	
	public void updateDelay(Intent intent, EditPrefUtil pref, long t){
		StringMap map = new StringMap();
		String data = pref.get(TrainDelayedActivity.PREF_TRD_DELAY);
		if (data != null){
			map.setData(data);
		}
		
		long id = intent.getLongExtra("ID", -1);
		map.put(String.valueOf(id), String.valueOf(t));
		
		data = map.getData();
		pref.put(TrainDelayedActivity.PREF_TRD_DELAY, data);
		pref.update();		
	}
}
