package com.td.db;

import java.util.ArrayList;
import java.util.List;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;

import com.td.HistoryContentProvider;
import com.td.utility.Debug;

public class HistoryDao {
	private static HistoryDao instance = null;
	
	public static HistoryDao getInstance(){
		if (instance == null){
			instance = new HistoryDao();
		}
		return instance;
	}
	
	private HistoryDao(){
		
	}
	
	private List<History> search(Context context, String selection, String[] selectionArgs){
		ContentResolver resolver = context.getContentResolver();
		Cursor cursor = resolver.query(HistoryContentProvider.CONTENT_URI,
				HistoryContentProvider.Projection.projection,
				selection,
				selectionArgs,
				HistoryContentProvider.Fields.ID + " ASC");
		List<History> list = new ArrayList<History>();
		
		try {
	        if (cursor.moveToFirst()) {
	            do {
	            	int n = 0;
	            	long id = cursor.getLong(n++);
	            	long routeId = cursor.getLong(n++);
	        		int ymd = cursor.getInt(n++);
	        		int hm = cursor.getInt(n++);
	        		int week = cursor.getInt(n++);
	        		int period = cursor.getInt(n++);
	        		long num = cursor.getLong(n++);
	        		int status = cursor.getInt(n++);
	        		
	        		if (Debug.isDebug()){
						Debug.d(this, "" + id + " " + routeId + " " + ymd + " " + hm
								+ " " + week + " " + period + " " + num + " " + status);
	        		}
					History history = new History(id, routeId, ymd, hm, week,
							period, num, status);
					list.add(history);
	            } while (cursor.moveToNext());
	        }		
		}
		finally {
			if (cursor != null){
				cursor.close();
				cursor = null;
			}
		}
        return list;
	}

	public List<History> search(Context context, long routeId, int ymd, int startHm, int endHm){
		String selection = "YMD = ? AND ? <= HM AND HM <= ? AND ROUTE_ID = ?";
		String[] selectionArgs = new String[4];
		selectionArgs[0] = String.valueOf(ymd);
		selectionArgs[1] = String.valueOf(startHm);
		selectionArgs[2] = String.valueOf(endHm);
		selectionArgs[3] = String.valueOf(routeId);
		
		return search(context, selection, selectionArgs);
	}

	public List<History> search(Context context, int ymd, int startHm, int endHm){
		String selection = "YMD = ? AND ? <= HM AND HM <= ?";
		String[] selectionArgs = new String[3];
		selectionArgs[0] = String.valueOf(ymd);
		selectionArgs[1] = String.valueOf(startHm);
		selectionArgs[2] = String.valueOf(endHm);
		
		return search(context, selection, selectionArgs);
	}

	public List<History> search(Context context){
		return search(context, null, null);
	}

	public void delete(Context context){
		delete(context, null, null);
	}
	
	public void deleteByYmd(Context context, int ymd){
		String selection = "YMD < ?";
		String[] selectionArgs = new String[1];;
		selectionArgs[0] = String.valueOf(ymd);
		
		delete(context, selection, selectionArgs);
	}
	
	private void delete(Context context, String selection, String[] selectionArgs){
		ContentResolver resolver = context.getContentResolver();
		resolver.delete(HistoryContentProvider.CONTENT_URI, selection, selectionArgs);
	}
}
