package com.td.db;

import java.util.ArrayList;
import java.util.List;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteStatement;

public class LogDao {
	private static LogDao instance = null;
	private SQLiteStatement insertStmt = null;
	private SQLiteStatement deleteStmt = null;

	public static LogDao getInstance() {
		if (instance == null) {
			instance = new LogDao();
		}
		return instance;
	}

	private LogDao() {

	}

	public void onCreate(SQLiteDatabase db) {
		db.execSQL("CREATE TABLE LOG (" + android.provider.BaseColumns._ID
				+ " INTEGER PRIMARY KEY AUTOINCREMENT,"
				+ "YMD INTEGER,"
				+ "HM INTEGER,"
				+ "MESSAGE TEST" + ");");
	}

	public void init(SQLiteDatabase db) {

	}

	public void start(SQLiteDatabase db) {
		insertStmt = db.compileStatement("INSERT INTO LOG ("
				+ "YMD, HM, MESSAGE" + ") VALUES (" + "?, ?, ?"
				+ ");");
		deleteStmt = db.compileStatement("DELETE FROM LOG");
	}

	public List<Log> search() {
		return search(null, null, android.provider.BaseColumns._ID);
	}

	public Log searchById(long id) {
		String selection = android.provider.BaseColumns._ID + " = ?";
		String[] selectionArgs = new String[1];

		selectionArgs[0] = String.valueOf(id);

		List<Log> list = search(selection, selectionArgs, null);
		return (list.size() > 0) ? list.get(0) : null;
	}

	private List<Log> search(String selection, String[] selectionArgs,
			String orderBy) {
		List<Log> list = new ArrayList<Log>();
		DatabaseHelper helper = DatabaseHelper.getInstance();
		SQLiteDatabase db = helper.getReadableDatabase();

		Cursor cursor = db.query("LOG", new String[] {
				android.provider.BaseColumns._ID, "YMD", "HM",
				"MESSAGE" }, selection, selectionArgs, null, null, orderBy);
		try {
			cursor.moveToFirst();
			int size = cursor.getCount();
			for (int i = 0; i < size; i++) {
				Log log = new Log(cursor.getInt(0), cursor.getInt(1),
						cursor.getInt(2), cursor.getString(3));
				list.add(log);
				cursor.moveToNext();
			}
		} finally {
			if (cursor != null) {
				cursor.close();
			}
		}
		return list;
	}

	public List<Train> search(long pid) {
		String sql = "select train._id, train.name, train.search_text, train.selected "
				+ "from train "
				+ "inner join relation on relation.pid = ? and relation.tid = train._id";
		String[] selectionArgs = new String[1];
		selectionArgs[0] = String.valueOf(pid);

		List<Train> list = new ArrayList<Train>();

		DatabaseHelper helper = DatabaseHelper.getInstance();
		SQLiteDatabase db = helper.getReadableDatabase();
		Cursor cursor = db.rawQuery(sql, selectionArgs);
		try {
			cursor.moveToFirst();
			int size = cursor.getCount();
			for (int i = 0; i < size; i++) {
				Train train = new Train(cursor.getInt(0), cursor.getString(1),
						cursor.getString(2), cursor.getInt(3));
				list.add(train);
				cursor.moveToNext();
			}
		} finally {
			if (cursor != null) {
				cursor.close();
			}
		}
		return list;
	}
	public void add(Log log) {
		DatabaseHelper helper = DatabaseHelper.getInstance();
		SQLiteDatabase db = helper.getWritableDatabase();
		add(db, log);
	}

	private long add(SQLiteDatabase db, Log log) {
		long id = -1;
		db.beginTransaction();
		try {
			int i = 1;
			SQLiteStatement stmt = insertStmt;
			stmt.bindLong(i++, log.getYmd());
			stmt.bindLong(i++, log.getHm());
			stmt.bindString(i++, log.getMessage());
			id = stmt.executeInsert();
			db.setTransactionSuccessful();
		} finally {
			db.endTransaction();
		}
		return id;
	}

	public void delete() {
		DatabaseHelper helper = DatabaseHelper.getInstance();
		SQLiteDatabase db = helper.getWritableDatabase();
		db.beginTransaction();
		try {
			SQLiteStatement stmt = deleteStmt;
			stmt.execute();
			db.setTransactionSuccessful();
		} finally {
			db.endTransaction();
		}
	}
	
	public void deleteNT() {
		SQLiteStatement stmt = deleteStmt;
		stmt.execute();
	}
}
