package com.td.service;

import java.util.Calendar;
import java.util.Date;
import java.util.List;

import twitter4j.QueryResult;
import twitter4j.Tweet;
import twitter4j.TwitterAdapter;
import twitter4j.TwitterException;
import twitter4j.TwitterMethod;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;

import com.td.HistoryContentProvider;
import com.td.broadcast.DelayReceiver;
import com.td.db.Keyword;
import com.td.db.Train;
import com.td.utility.ConfUtil;
import com.td.utility.DateUtil;
import com.td.utility.Debug;
import com.td.utility.Delay;
import com.td.utility.EditPrefUtil;
import com.td.utility.ExceptionUtil;

public class TrainTwitterAdapter extends TwitterAdapter {
	public static final long START_ID = Long.MAX_VALUE;
	public static final long ERROR_ID = START_ID - 1;
	public static final long DELAY_ID = START_ID - 2;

	private TrainDelayedService impl;
	private EditPrefUtil pref;

	private Calendar cal;

	public TrainTwitterAdapter(TrainDelayedService impl) {
		this.impl = impl;
		pref = new EditPrefUtil(impl.getContext());
	}

	public void setCalender(Calendar cal) {
		this.cal = cal;
	}

	@Override
	public void searched(QueryResult result) {
		super.searched(result);

		try {
			Debug.l("TrainTwitterAdapter.searched()");
			
			ExceptionUtil.getInstance().throwException(
					ExceptionUtil.TAG_E42);

			int len = ConfUtil.getLen(pref);

			long min = Long.MAX_VALUE;
			long max = 0;

			Date minDate = null;
			Date maxDate = null;
			Date curDate = cal.getTime();

			long cur = curDate.getTime();
			long from = cur - len * 60 * 1000;
			int count = 0;
			long diff = 0;

			Debug.d(this, "Jn:" + DateUtil.formatted(cal));

			List<Tweet> tweets = result.getTweets();
			for (Tweet tweet : tweets) {
				String text = tweet.getText();
				Date at = tweet.getCreatedAt();				
				long l = at.getTime();
				
				if (l < from) {
					continue;
				}
				if (!filter(text)) {
					// xȊȌ
					// Debug.d(this, "NO MATCH:" + text);
					continue;
				}
				if (l < min) {
					min = l;
					minDate = at;
				}
				if (l > max) {
					max = l;
					maxDate = at;
				}

				count++;
			}
			diff = 0;
			if (minDate != null && maxDate != null) {
				diff = len;
			}

			String query = result.getQuery();
			long routeId = -1;
			List<Train> trains = impl.getTrains();
			if (trains != null) {
				Train train = null;
				for (Train t : trains) {
					if (query.equals(t.getSearchText())) {
						train = t;
						routeId = t.getId();
						break;
					}
				}
				if (train == null) {
					return;
				}

				if (minDate != null && maxDate != null) {
					Debug.d(this, minDate.toString(), "-", maxDate.toString());
				}
				if (ExceptionUtil.getInstance().isDebug(ExceptionUtil.TAG_E90)) {
					count += 10 + (int)(Math.random() * 10);
				}
				
				Debug.d(this, "routeId=" + routeId);
				Debug.d(this, "diff=" + diff);
				Debug.d(this, "count=" + count);

				checkDelay(train, cal, count, len);

				insert(routeId, len, count, 0);
			}
		} catch (Exception e) {
			Debug.d(this, null, e);
		}
	}

	public boolean checkDelay(Train train, Calendar curCal, int count, int len) {
		boolean isDelay = true;

		int cntpmi = count / len; // twit/
		int h = ConfUtil.getHeight(pref);

		if (cntpmi < h) {
			// TwitH𒴂ĂȂ
			return false;
		}

		String data = ConfUtil.getDelay(pref);
		Delay[] delays = Delay.getInstances(data);
		Delay newDelay = null;

		Delay delay = Delay.search(delays, train.getId());
		if (delay != null) {
			Calendar dCal = DateUtil.getCalendar(delay.getYmd(), delay.getHm());
			long t = dCal.getTimeInMillis();
			int w = ConfUtil.getWidth(pref);
			long cur = curCal.getTimeInMillis();
			if (cur - t < w * 60 * 1000) {
				// Ō̒x玞ԂoĂȂ(x̎Ԃ͍XV)
				if (Debug.isDebug()){
					Debug.t(impl.getContext(),
							train.getName()
									+ " Ō̒x玞Ԗo "
									+ DateUtil.formattedHm(DateUtil
											.getHm(curCal.getTime()))
									+ " "
									+ DateUtil.formattedHm(DateUtil.getHm(dCal
											.getTime())) + " " + w);
				}
				isDelay = false;
			} else {
				// O̒xAēxx
				Debug.t(impl.getContext(), train.getName() + " O̒xAēxx");
			}
			Date d = curCal.getTime();
			delay.setYmd(DateUtil.getYmd(d));
			delay.setHm(DateUtil.getHm(d));
		} else {
			// VKo^(x)
			Date d = curCal.getTime();
			int ymd = DateUtil.getYmd(d);
			int hm = DateUtil.getHm(d);
			newDelay = new Delay(train.getId(), ymd, hm, 0, true);

			Debug.t(impl.getContext(), train.getName() + " VKo^(x)");

			TrainTwitterAdapter.insert(impl.getContext(), curCal,
					TrainTwitterAdapter.DELAY_ID, -1, (int) train.getId(), -1);
		}
		//
		StringBuffer sb = Delay.getData(delays);
		if (newDelay != null) {
			Delay.setData(sb, newDelay);
		}
		ConfUtil.setDelay(pref, sb.toString());

		if (isDelay) {
			// xʒm
			if (impl != null) {
				impl.notificate(train.getName());

				Intent intent = new Intent(DelayReceiver.DELAY);
				intent.putExtra("ID", train.getId());
				impl.getContext().sendBroadcast(intent);
			}
		}
		pref.update();
		return isDelay;
	}

	private boolean filter(String text) {
		List<Keyword> keywords = impl.getKeywords();
		if (keywords == null) {
			return false;
		}

		for (Keyword keyword : keywords) {
			if (text.indexOf(keyword.getText()) >= 0) {
				return true;
			}
		}
		return false;
	}

	private void insert(long routeId, long diff, int count, int status) {
		insert(impl.getContext(), cal, routeId, diff, count, status);
	}

	public static void insert(Context context, Calendar cal, long routeId,
			long diff, long count, int status) {
		Date date = cal.getTime();

		int ymd = DateUtil.getYmd(date);
		int hm = DateUtil.getHm(date);
		int w = cal.get(Calendar.DAY_OF_WEEK) - 1;

		Debug.d(context, "insert " + ymd, "/" + hm, "/" + w);

		ContentValues values = new ContentValues();
		values.put(HistoryContentProvider.Fields.ROUTE_ID, routeId);
		values.put(HistoryContentProvider.Fields.YMD, ymd);
		values.put(HistoryContentProvider.Fields.HM, hm);
		values.put(HistoryContentProvider.Fields.WEEK, w);
		values.put(HistoryContentProvider.Fields.PERIOD, diff);
		values.put(HistoryContentProvider.Fields.NUM, count);
		values.put(HistoryContentProvider.Fields.STATUS, status);

		Uri uri = context.getContentResolver().insert(
				HistoryContentProvider.CONTENT_URI, values);
		Debug.d(context, uri.toString());
	}

	@Override
	public void onException(TwitterException e, TwitterMethod method) {
		Debug.d(this, null, e);
		if (Debug.isDebug()) {
			insert(ERROR_ID, -1, -1, -1);
		}
	}
}
