package com.td.utility;

public class ConfUtil {
	public static final String PREF_CNF_LEN = "CNF_LEN";
	public static final String PREF_CNF_WIDTH = "CNF_WIDTH";
	public static final String PREF_CNF_HEIGHT = "CNF_HEIGHT";
	public static final String PREF_CNF_DED = "CNF_DED";

	public static final int W = 10;
	public static final int H = 5;
	
	public static void init(PrefUtil pref){
		pref.remove(PREF_CNF_LEN);
		pref.remove(PREF_CNF_WIDTH);
		pref.remove(PREF_CNF_HEIGHT);
		pref.remove(PREF_CNF_DED);
		
		// ftHglݒ
		getLen(pref);
		getWidth(pref);
		getHeight(pref);
		getDelay(pref);
	}
	
	public static int getLen(PrefUtil pref){
		return pref.getInt(PREF_CNF_LEN, DateUtil.LEN);
	}

	public static void setLen(PrefUtil pref, int len){
		pref.put(PREF_CNF_LEN, len);
	}

	public static int getWidth(PrefUtil pref){
		return pref.getInt(PREF_CNF_WIDTH, W);
	}

	public static void setWidth(PrefUtil pref, int len){
		pref.put(PREF_CNF_WIDTH, len);
	}

	public static int getHeight(PrefUtil pref){
		return pref.getInt(PREF_CNF_HEIGHT, H);
	}

	public static void setHeight(PrefUtil pref, int len){
		pref.put(PREF_CNF_HEIGHT, len);
	}

	public static String getDelay(PrefUtil pref){
		return pref.get(PREF_CNF_DED, "");
	}

	public static void setDelay(PrefUtil pref, String data){
		pref.put(PREF_CNF_DED, data);
	}

}
