package com.td.utility;

import java.util.HashMap;

public class DBCache<T, S> implements DBCacheInterface<T, S> {
	private DBCacheInterface<T, S> impl;
	//private HashMap<S, T> map = new HashMap<S, T>();
	private HashMap<String, T> map = new HashMap<String, T>();
	
	public DBCache(DBCacheInterface<T, S> impl){
		this.impl = impl;
	}

	public T get(S key) {
		String s = key.toString();
		T value = map.get(s);
		if (value != null){
			return value;
		}
		value = impl.get(key);
		map.put(s, value);
		return value;
	}
}
