package com.td.utility;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.SharedPreferences.Editor;
import android.content.pm.PackageManager.NameNotFoundException;

public class PrefUtilImpl implements PrefUtil {
	private Context context;
	
	public PrefUtilImpl(Context context){
		this.context = context;
	}
	
	public void put(String key, String value) {
		// TODO
//		SharedPreferences pref = context.getSharedPreferences("com.td",
//				Context.MODE_WORLD_READABLE | Context.MODE_WORLD_WRITEABLE);
		SharedPreferences pref = null;
		try {
			Context ctxt = context.createPackageContext("com.td", Context.CONTEXT_RESTRICTED);
			pref = ctxt.getSharedPreferences("TrainDelayedActivity",
					Context.MODE_WORLD_READABLE | Context.MODE_WORLD_WRITEABLE);
		} catch (NameNotFoundException e) {
			// TODO
			Debug.l(e.getMessage());

			Debug.d(this, null, e);
			return;
		}
		
		Editor e = pref.edit();
		e.putString(key, value);
		e.commit();
	}

	public void put(String key, int value) {
		put(key, String.valueOf(value));
	}
	
	public String get(String key) {
		// TODO
//		SharedPreferences pref = context.getSharedPreferences("com.td",
//				Context.MODE_WORLD_READABLE);
		SharedPreferences pref = null;
		try {
			Context ctxt = context.createPackageContext("com.td", Context.CONTEXT_RESTRICTED);
			pref = ctxt.getSharedPreferences("TrainDelayedActivity",
					Context.MODE_WORLD_READABLE);
		} catch (NameNotFoundException e) {
			// TODO
			Debug.l(e.getMessage());

			Debug.d(this, null, e);
			return null;
		}

		return pref.getString(key, null);
	}

	public int getInt(String key) {
		return Integer.parseInt(get(key));
	}

	public String get(String key, String initValue) {
		String value = get(key);
		if (value != null){
			return value;
		}
		put(key, initValue);
		return initValue;
	}
	
	public int getInt(String key, int initValue) {
		return Integer.valueOf(get(key, String.valueOf(initValue)));
	}
	
	public void remove(String key){
		put(key, null);
	}
}
