package com.td.wait;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;

import com.td.WaitActivity;
import com.td.db.DatabaseHelper;
import com.td.db.PrefectureDao;
import com.td.db.RelationDao;
import com.td.db.TrainDao;
import com.td.utility.ConfUtil;
import com.td.utility.Debug;
import com.td.utility.EditPrefUtil;
import com.td.utility.StatusFlagFactory;

public class InitializeWating extends WatingImpl {
	private EditPrefUtil pref;
	private Thread thread = null;
	private int status = WaitActivity.ID_NONE;
	
	public void onStart() {
		if (thread != null){
			return;
		}
		thread = new Thread() {
			public void run() {
				try {
					init();
					status = WaitActivity.ID_OK;
				}
				catch (Exception e){
					Debug.d(this, null, e);
					status = WaitActivity.ID_NG;					
				}
			}
		};
		thread.start();
	}

	public void onStop() {
		thread = null;
	}

	private void init() {
		Context context = getContext();
		pref = new EditPrefUtil(context);

		ConfUtil.init(pref);
		pref.update();
		
		StatusFlagFactory sff = StatusFlagFactory.getInstance();
		sff.init(context);

		DatabaseHelper helper = DatabaseHelper.getInstance();
		SQLiteDatabase db = helper.getWritableDatabase();

		helper.initDB(db, false);
	}

	public int getStatus() {
		return status;
	}
}
