package com.td.wait;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Handler;
import android.os.IBinder;
import android.os.RemoteException;

import com.td.WaitActivity;
import com.td.service.ITrainService;
import com.td.service.ITrainServiceCallback;
import com.td.service.TrainService;
import com.td.utility.Debug;

public class TrainServiceWaiting extends WatingImpl implements
		ServiceConnection {
	private ITrainService serviceImpl;
	private int status = WaitActivity.ID_NONE;
	
	public void onStart() {
		try {
			Context context = getContext();

			Intent intent = new Intent(context, TrainService.class);

			context.bindService(intent, this, Context.BIND_AUTO_CREATE);

			// ActivityłT[rXIȂ
			context.startService(intent);
		} catch (Exception e) {
			Debug.d(this, null, e);
		}
	}

	public void onStop() {
		try {
			Context context = getContext();
			if (context != null) {
				context.unbindService(this);
				setContext(null);
			}
		} catch (Exception e) {
			Debug.d(this, null, e);
		}
	}

	public void onServiceConnected(ComponentName name, IBinder service) {
		try {
			serviceImpl = ITrainService.Stub.asInterface(service);

			serviceImpl.setListener(interfaceImpl);

			doService();
		} catch (RemoteException e) {
			Debug.d(this, null, e);

			this.status = WaitActivity.ID_NG;
		}
	}

	public void onServiceDisconnected(ComponentName name) {
		// ServiceƂ̐ڑ\؂ꂽiKILLȂǁjꍇɌĂ΂
		serviceImpl = null;
	}

	private void doService() throws RemoteException {
		if (serviceImpl == null) {
			return;
		}
		int val = serviceImpl.doExecute("DUMMY");

		Context context = getContext();
		Debug.t(context, "serviceImpl.doExecute() " + val);
	}

	private ITrainServiceCallback.Stub interfaceImpl = new ITrainServiceCallback.Stub() {
		public void notify(String msg, int status) throws RemoteException {
			TrainServiceWaiting.this.status = status;
		}
	};

	public int getStatus() {
		return status;
	}
}
