/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.mail;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;

public interface MailService {
    public void send(Message var1) throws IOException;

    public void sendToAdmins(Message var1) throws IOException;

    public static class Message {
        private String sender;
        private String replyTo;
        private Collection<String> to;
        private Collection<String> cc;
        private Collection<String> bcc;
        private String subject;
        private String textBody;
        private String htmlBody;
        private Collection<Attachment> attachments;
        private Collection<Header> headers;

        public Message() {
        }

        public Message(String sender, String to, String subject, String textBody) {
            this.sender = sender;
            this.to = Arrays.asList(to);
            this.subject = subject;
            this.textBody = textBody;
        }

        public String getSender() {
            return this.sender;
        }

        public void setSender(String sender) {
            this.sender = sender;
        }

        public String getReplyTo() {
            return this.replyTo;
        }

        public void setReplyTo(String replyTo) {
            this.replyTo = replyTo;
        }

        public Collection<String> getTo() {
            return this.to;
        }

        public void setTo(Collection<String> to) {
            this.to = to;
        }

        public void setTo(String ... to) {
            this.to = Arrays.asList(to);
        }

        public Collection<String> getCc() {
            return this.cc;
        }

        public void setCc(Collection<String> cc) {
            this.cc = cc;
        }

        public void setCc(String ... cc) {
            this.cc = Arrays.asList(cc);
        }

        public Collection<String> getBcc() {
            return this.bcc;
        }

        public void setBcc(Collection<String> bcc) {
            this.bcc = bcc;
        }

        public void setBcc(String ... bcc) {
            this.bcc = Arrays.asList(bcc);
        }

        public String getSubject() {
            return this.subject;
        }

        public void setSubject(String subject) {
            this.subject = subject;
        }

        public String getTextBody() {
            return this.textBody;
        }

        public void setTextBody(String textBody) {
            this.textBody = textBody;
        }

        public String getHtmlBody() {
            return this.htmlBody;
        }

        public void setHtmlBody(String htmlBody) {
            this.htmlBody = htmlBody;
        }

        public Collection<Attachment> getAttachments() {
            return this.attachments;
        }

        public void setAttachments(Collection<Attachment> attachments) {
            this.attachments = attachments;
        }

        public void setAttachments(Attachment ... attachments) {
            this.attachments = Arrays.asList(attachments);
        }

        public Collection<Header> getHeaders() {
            return this.headers;
        }

        public void setHeaders(Collection<Header> headers) {
            this.headers = headers;
        }

        public void setHeaders(Header ... headers) {
            this.headers = Arrays.asList(headers);
        }
    }

    public static class Header {
        private final String name;
        private final String value;

        public Header(String name, String value) {
            if (name == null || value == null || name.length() == 0 || value.length() == 0) {
                throw new IllegalArgumentException("Header needs name and value");
            }
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static class Attachment {
        private final String fileName;
        private final byte[] data;

        public Attachment(String fileName, byte[] data) {
            if (data == null || fileName == null || fileName.length() == 0) {
                throw new IllegalArgumentException("Attachment needs content and name");
            }
            this.fileName = fileName;
            this.data = data;
        }

        public String getFileName() {
            return this.fileName;
        }

        public byte[] getData() {
            return this.data;
        }
    }
}

