/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.urlfetch;

import com.google.appengine.api.urlfetch.HTTPHeader;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class HTTPResponse
implements Serializable {
    static final long serialVersionUID = -4270789523885950851L;
    private final int responseCode;
    private final List<HTTPHeader> headers;
    private byte[] content;
    private URL finalUrl;

    HTTPResponse(int responseCode) {
        this.responseCode = responseCode;
        this.headers = new ArrayList<HTTPHeader>();
        this.finalUrl = null;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public byte[] getContent() {
        return this.content;
    }

    public URL getFinalUrl() {
        return this.finalUrl;
    }

    public List<HTTPHeader> getHeaders() {
        return Collections.unmodifiableList(this.headers);
    }

    void addHeader(String name, String value) {
        this.headers.add(new HTTPHeader(name, value));
    }

    void setContent(byte[] content) {
        this.content = content;
    }

    void setFinalUrl(URL finalUrl) {
        this.finalUrl = finalUrl;
    }
}

