/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.net.sourceforge.yamlbeans.emitter;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

class EmitterWriter {
    private static final Map<Integer, String> ESCAPE_REPLACEMENTS = new HashMap<Integer, String>();
    private final Writer writer;
    private boolean whitespace = true;
    int column = 0;
    boolean indentation = true;

    public EmitterWriter(Writer writer) {
        this.writer = writer;
    }

    public void writeStreamStart() {
    }

    public void writeStreamEnd() throws IOException {
        this.flushStream();
    }

    public void writeIndicator(String string, boolean bl, boolean bl2, boolean bl3) throws IOException {
        String string2 = null;
        string2 = this.whitespace || !bl ? string : " " + string;
        this.whitespace = bl2;
        this.indentation = this.indentation && bl3;
        this.column += string2.length();
        this.writer.write(string2);
    }

    public void writeIndent(int n) throws IOException {
        if (n == -1) {
            n = 0;
        }
        if (!this.indentation || this.column > n || this.column == n && !this.whitespace) {
            this.writeLineBreak(null);
        }
        if (this.column < n) {
            this.whitespace = true;
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = n - this.column;
            for (int i = 0; i < n2; ++i) {
                stringBuffer.append(" ");
            }
            this.column = n;
            this.writer.write(stringBuffer.toString());
        }
    }

    public void writeVersionDirective(String string) throws IOException {
        this.writer.write("%YAML " + string);
        this.writeLineBreak(null);
    }

    public void writeTagDirective(String string, String string2) throws IOException {
        this.writer.write("%TAG " + string + " " + string2);
        this.writeLineBreak(null);
    }

    public void writeDoubleQuoted(String string, boolean bl, int n, int n2, boolean bl2) throws IOException {
        this.writeIndicator("\"", true, false, false);
        int n3 = 0;
        String string2 = null;
        for (int i = 0; i <= string.length(); ++i) {
            int n4 = 0;
            if (i < string.length()) {
                n4 = string.codePointAt(i);
            }
            if (n4 == 0 || "\"\\\u0085".indexOf(n4) != -1 || 32 > n4 || n4 > 126) {
                if (n3 < i) {
                    string2 = string.substring(n3, i);
                    this.column += string2.length();
                    this.writer.write(string2);
                    n3 = i;
                }
                if (n4 != 0) {
                    if (ESCAPE_REPLACEMENTS.containsKey(n4)) {
                        string2 = "\\" + ESCAPE_REPLACEMENTS.get(n4);
                    } else if (bl2) {
                        string2 = Integer.toString(n4, 16);
                        if (string2.length() == 1) {
                            string2 = "000" + string2;
                        } else if (string2.length() == 2) {
                            string2 = "00" + string2;
                        } else if (string2.length() == 3) {
                            string2 = "0" + string2;
                        }
                        string2 = "\\u" + string2;
                    } else {
                        string2 = new String(Character.toChars(n4));
                    }
                    this.column += string2.length();
                    this.writer.write(string2);
                    n3 = i + 1;
                }
            }
            if (0 >= i || i >= string.length() - 1 || n4 != 32 && n3 > i || this.column + (i - n3) <= n2 || !bl) continue;
            string2 = n3 < i ? string.substring(n3, i) + '\\' : "\\";
            if (n3 < i) {
                n3 = i;
            }
            this.column += string2.length();
            this.writer.write(string2);
            this.writeIndent(n);
            this.whitespace = false;
            this.indentation = false;
            if (string.charAt(n3) != ' ') continue;
            string2 = "\\";
            this.column += string2.length();
            this.writer.write(string2);
        }
        this.writeIndicator("\"", false, false, false);
    }

    public void writeSingleQuoted(String string, boolean bl, int n, int n2) throws IOException {
        this.writeIndicator("'", true, false, false);
        boolean bl2 = false;
        boolean bl3 = false;
        int n3 = 0;
        char c = '\u0000';
        String string2 = null;
        for (int i = 0; i <= string.length(); ++i) {
            c = '\u0000';
            if (i < string.length()) {
                c = string.charAt(i);
            }
            if (bl2) {
                if (c == '\u0000' || c != ' ') {
                    if (n3 + 1 == i && this.column > n2 && bl && n3 != 0 && i != string.length()) {
                        this.writeIndent(n);
                    } else {
                        string2 = string.substring(n3, i);
                        this.column += string2.length();
                        this.writer.write(string2);
                    }
                    n3 = i;
                }
            } else if (bl3) {
                if (c == '\u0000' || '\n' != c && '\u0085' != c) {
                    string2 = string.substring(n3, i);
                    int n4 = string2.length();
                    for (int j = 0; j < n4; ++j) {
                        char c2 = string2.charAt(j);
                        if ('\n' == c2) {
                            this.writeLineBreak(null);
                            continue;
                        }
                        this.writeLineBreak("" + c2);
                    }
                    this.writeIndent(n);
                    n3 = i;
                }
            } else if (c == '\u0000' || '\n' != c && '\u0085' != c) {
                if (n3 < i) {
                    string2 = string.substring(n3, i);
                    this.column += string2.length();
                    this.writer.write(string2);
                    n3 = i;
                }
                if (c == '\'') {
                    string2 = "''";
                    this.column += 2;
                    this.writer.write(string2);
                    n3 = i + 1;
                }
            }
            if (c == '\u0000') continue;
            bl2 = c == ' ';
            bl3 = c == '\n' || c == '\u0085';
        }
        this.writeIndicator("'", false, false, false);
    }

    public void writeFolded(String string, int n, int n2) throws IOException {
        String string2 = this.determineChomp(string);
        this.writeIndicator(">" + string2, true, false, false);
        this.writeIndent(n);
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n3 = 0;
        String string3 = null;
        for (int i = 0; i <= string.length(); ++i) {
            char c = '\u0000';
            if (i < string.length()) {
                c = string.charAt(i);
            }
            if (bl3) {
                if (c == '\u0000' || '\n' != c && '\u0085' != c) {
                    if (!bl && c != '\u0000' && c != ' ' && string.charAt(n3) == '\n') {
                        this.writeLineBreak(null);
                    }
                    bl = c == ' ';
                    string3 = string.substring(n3, i);
                    int n4 = string3.length();
                    for (int j = 0; j < n4; ++j) {
                        char c2 = string3.charAt(j);
                        if ('\n' == c2) {
                            this.writeLineBreak(null);
                            continue;
                        }
                        this.writeLineBreak("" + c2);
                    }
                    if (c != '\u0000') {
                        this.writeIndent(n);
                    }
                    n3 = i;
                }
            } else if (bl2) {
                if (c != ' ') {
                    if (n3 + 1 == i && this.column > n2) {
                        this.writeIndent(n);
                    } else {
                        string3 = string.substring(n3, i);
                        this.column += string3.length();
                        this.writer.write(string3);
                    }
                    n3 = i;
                }
            } else if (c == '\u0000' || ' ' == c || '\n' == c || '\u0085' == c) {
                string3 = string.substring(n3, i);
                this.writer.write(string3);
                if (c == '\u0000') {
                    this.writeLineBreak(null);
                }
                n3 = i;
            }
            if (c == '\u0000') continue;
            bl3 = '\n' == c || '\u0085' == c;
            bl2 = c == ' ';
        }
    }

    public void writeLiteral(String string, int n) throws IOException {
        String string2 = this.determineChomp(string);
        this.writeIndicator("|" + string2, true, false, false);
        this.writeIndent(n);
        boolean bl = false;
        int n2 = 0;
        String string3 = null;
        for (int i = 0; i <= string.length(); ++i) {
            char c = '\u0000';
            if (i < string.length()) {
                c = string.charAt(i);
            }
            if (bl) {
                if (c == '\u0000' || '\n' != c && '\u0085' != c) {
                    string3 = string.substring(n2, i);
                    int n3 = string3.length();
                    for (int j = 0; j < n3; ++j) {
                        char c2 = string3.charAt(j);
                        if ('\n' == c2) {
                            this.writeLineBreak(null);
                            continue;
                        }
                        this.writeLineBreak("" + c2);
                    }
                    if (c != '\u0000') {
                        this.writeIndent(n);
                    }
                    n2 = i;
                }
            } else if (c == '\u0000' || '\n' == c || '\u0085' == c) {
                string3 = string.substring(n2, i);
                this.writer.write(string3);
                if (c == '\u0000') {
                    this.writeLineBreak(null);
                }
                n2 = i;
            }
            if (c == '\u0000') continue;
            bl = '\n' == c || '\u0085' == c;
        }
    }

    public void writePlain(String string, boolean bl, int n, int n2) throws IOException {
        if (string == null || "".equals(string)) {
            return;
        }
        String string2 = null;
        if (!this.whitespace) {
            string2 = " ";
            this.column += string2.length();
            this.writer.write(string2);
        }
        this.whitespace = false;
        this.indentation = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n3 = 0;
        for (int i = 0; i <= string.length(); ++i) {
            char c = '\u0000';
            if (i < string.length()) {
                c = string.charAt(i);
            }
            if (bl2) {
                if (c != ' ') {
                    if (n3 + 1 == i && this.column > n2 && bl) {
                        this.writeIndent(n);
                        this.whitespace = false;
                        this.indentation = false;
                    } else {
                        string2 = string.substring(n3, i);
                        this.column += string2.length();
                        this.writer.write(string2);
                    }
                    n3 = i;
                }
            } else if (bl3) {
                if (c != '\n' && c != '\u0085') {
                    if (string.charAt(n3) == '\n') {
                        this.writeLineBreak(null);
                    }
                    string2 = string.substring(n3, i);
                    int n4 = string2.length();
                    for (int j = 0; j < n4; ++j) {
                        char c2 = string2.charAt(j);
                        if ('\n' == c2) {
                            this.writeLineBreak(null);
                            continue;
                        }
                        this.writeLineBreak("" + c2);
                    }
                    this.writeIndent(n);
                    this.whitespace = false;
                    this.indentation = false;
                    n3 = i;
                }
            } else if (c == '\u0000' || ' ' == c || '\n' == c || '\u0085' == c) {
                string2 = string.substring(n3, i);
                this.column += string2.length();
                this.writer.write(string2);
                n3 = i;
            }
            if (c == '\u0000') continue;
            bl2 = c == ' ';
            bl3 = c == '\n' || c == '\u0085';
        }
    }

    public void writeLineBreak(String string) throws IOException {
        if (string == null) {
            string = "\n";
        }
        this.whitespace = true;
        this.indentation = true;
        this.column = 0;
        this.writer.write(string);
    }

    public void flushStream() throws IOException {
        this.writer.flush();
    }

    private String determineChomp(String string) {
        String string2 = string.substring(string.length() - 2, string.length() - 1);
        while (string2.length() < 2) {
            string2 = " " + string2;
        }
        char c = string2.charAt(string2.length() - 1);
        char c2 = string2.charAt(string2.length() - 2);
        return c == '\n' || c == '\u0085' ? (c2 == '\n' || c2 == '\u0085' ? "+" : "") : "-";
    }

    public void close() throws IOException {
        this.writer.close();
    }

    static {
        ESCAPE_REPLACEMENTS.put(0, "0");
        ESCAPE_REPLACEMENTS.put(7, "a");
        ESCAPE_REPLACEMENTS.put(8, "b");
        ESCAPE_REPLACEMENTS.put(9, "t");
        ESCAPE_REPLACEMENTS.put(10, "n");
        ESCAPE_REPLACEMENTS.put(11, "v");
        ESCAPE_REPLACEMENTS.put(12, "f");
        ESCAPE_REPLACEMENTS.put(13, "r");
        ESCAPE_REPLACEMENTS.put(27, "e");
        ESCAPE_REPLACEMENTS.put(34, "\"");
        ESCAPE_REPLACEMENTS.put(92, "\\");
        ESCAPE_REPLACEMENTS.put(133, "N");
        ESCAPE_REPLACEMENTS.put(160, "_");
    }
}

