package com.yuji.tdb.twitter;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;

import twitter4j.Query;
import twitter4j.QueryResult;
import twitter4j.Status;
import twitter4j.Tweet;
import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.TwitterFactory;
import twitter4j.auth.AccessToken;
import twitter4j.conf.ConfigurationBuilder;

import com.yuji.tdb.common.CommonUtil;

public class TwitterUtil {
	private static final Logger log = Logger
			.getLogger(TwitterUtil.class.getName());
	private static TwitterUtil instance = null;
	private static Object obj = new Object();

	public static TwitterUtil getInstance() {
		if (instance == null) {
			synchronized (obj) {
				if (instance == null) {
					instance = new TwitterUtil();
				}
			}
		}
		return instance;
	}

	private TwitterUtil() {

	}

	public void main(String consumerKey, String consumerSecret, AccessToken accessToken) {

		String text = "lk";

		try {
			ConfigurationBuilder confBuilder = new ConfigurationBuilder();
			confBuilder.setDebugEnabled(true).setOAuthConsumerKey(consumerKey)
					.setOAuthConsumerSecret(consumerSecret);
			TwitterFactory factory = new TwitterFactory(confBuilder.build());
			Twitter twitter = factory.getInstance(accessToken);

			Calendar cal = Calendar.getInstance();
			Date date = cal.getTime();
			long cur = date.getTime();
			
			Query query = new Query();
			query.setRpp(1000); // TODO
			query.setQuery(text);
			QueryResult result = twitter.search(query);
			List<Tweet> tweets = result.getTweets();
			
			int count = 0;
			int hit = 0;
			int mhit = 0;
			
			int index;
			int mindex = 0;
			int size = tweets.size();
			for (index = 0; index < size; index++) {
				Tweet tweet = tweets.get(index);
				
				Date at = tweet.getCreatedAt();
				long t = at.getTime();
				String message = tweet.getText();
				
				if (t < cur - 30 * 60 * 1000){
					continue;
				}
				hit = filter(message);
				if (hit <= 0) {
					// xȊȌ
					continue;
				}
				if (hit > mhit){
					hit = mhit;
					mindex = index;
				}

				System.out.println("@" + tweet.getFromUser() + " - "
						+ tweet.getText() + at);
				count++;
			}
		
			String message = "";
			if (count < 10){
				message = "xȂ " + date.toString();			
			}
			else {
				int N = 50;
				
				String sample = tweets.get(mindex).getText();
				if (sample.length() > N){
					sample = sample.substring(0, N);
				}
				sample = CommonUtil.replaceString(sample, "@", "(a)");
				message = sample + " " + date.toString() + " count=" + count;							
			}
			Status status = twitter.updateStatus(message);
		} catch (TwitterException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			log.severe(e.toString());
		}
	}
	
	private static List<String> keywords = null;

	public int filter(String text) {
		if (keywords == null) {
			keywords = new ArrayList<String>();
			keywords.add("x");
			keywords.add("x");
			keywords.add("Uւ");
			keywords.add("U");
			keywords.add("~");
			keywords.add("");
		}

		int count = 0;
		for (String keyword : keywords) {
			if (text.indexOf(keyword) >= 0) {
				count++;
			}
		}
		return count;
	}
}
