/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.conversion;

import com.google.appengine.api.conversion.ConversionErrorCode;
import com.google.appengine.api.conversion.ConversionResult;
import com.google.appengine.api.conversion.ConversionServicePb;
import com.google.appengine.api.conversion.Document;
import com.google.appengine.api.conversion.DocumentProtoConverter;
import com.google.appengine.repackaged.com.google.common.base.Converter;

class ConversionResultProtoConverter
extends Converter<ConversionResult, ConversionServicePb.ConversionOutput> {
    private final DocumentProtoConverter documentProtoConverter = new DocumentProtoConverter();

    ConversionResultProtoConverter() {
    }

    @Override
    public ConversionServicePb.ConversionOutput doForward(ConversionResult result) {
        if (result.success()) {
            return ConversionServicePb.ConversionOutput.newBuilder().setErrorCode(ConversionServicePb.ConversionServiceError.ErrorCode.OK).setOutput((ConversionServicePb.DocumentInfo)this.documentProtoConverter.convert(result.getOutputDoc())).build();
        }
        return ConversionServicePb.ConversionOutput.newBuilder().setErrorCode(ConversionErrorCode.enumToProto(result.getErrorCode())).build();
    }

    @Override
    public ConversionResult doBackward(ConversionServicePb.ConversionOutput resultPb) {
        if (resultPb.getErrorCode() == ConversionServicePb.ConversionServiceError.ErrorCode.OK) {
            return new ConversionResult((Document)this.documentProtoConverter.reverse(resultPb.getOutput()));
        }
        return new ConversionResult(ConversionErrorCode.intToEnum(resultPb.getErrorCode().getNumber()));
    }
}

