/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.search;

import java.io.IOException;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.search.StringTerm;

public final class BodyTerm
extends StringTerm {
    public BodyTerm(String pattern) {
        super(pattern);
    }

    @Override
    public boolean match(Message message) {
        try {
            return this.matchPart(message);
        }
        catch (IOException e) {
            return false;
        }
        catch (MessagingException e) {
            return false;
        }
    }

    private boolean matchPart(Part part) throws MessagingException, IOException {
        if (part.isMimeType("multipart/*")) {
            Multipart mp = (Multipart)part.getContent();
            int count = mp.getCount();
            for (int i = 0; i < count; ++i) {
                BodyPart bp = mp.getBodyPart(i);
                if (!this.matchPart(bp)) continue;
                return true;
            }
            return false;
        }
        if (part.isMimeType("text/*")) {
            String content = (String)part.getContent();
            return super.match(content);
        }
        if (part.isMimeType("message/rfc822")) {
            return this.matchPart((Part)part.getContent());
        }
        return false;
    }
}

