/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search;

import com.google.appengine.api.search.FieldExpression;
import com.google.appengine.api.search.SearchServicePb;
import com.google.appengine.api.search.SortSpec;
import com.google.appengine.api.search.Util;
import com.google.appengine.api.search.checkers.Preconditions;
import com.google.appengine.api.search.checkers.SearchRequestChecker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class SearchRequest {
    private final String query;
    private final int limit;
    private final CursorType cursorType;
    private final int matchedCountAccuracy;
    private final List<SortSpec> sortSpecs;
    private final List<String> fieldsToReturn;
    private final List<String> fieldsToSnippet;
    private final List<FieldExpression> expressionsToReturn;
    private final String cursor;
    private final Integer offset;
    private final Boolean idsOnly;

    private SearchRequest(Builder builder) {
        this.query = builder.query;
        this.limit = SearchRequestChecker.checkLimit(Util.defaultIfNull(builder.limit, 20));
        this.matchedCountAccuracy = Util.defaultIfNull(builder.matchedCountAccuracy, 100);
        this.cursor = builder.cursor;
        this.offset = SearchRequestChecker.checkOffset(builder.offset);
        this.cursorType = Util.defaultIfNull(builder.cursorType, CursorType.NONE);
        this.sortSpecs = new ArrayList<SortSpec>(builder.sortSpecs);
        this.fieldsToReturn = new ArrayList<String>(builder.fieldsToReturn);
        this.fieldsToSnippet = new ArrayList<String>(builder.fieldsToSnippet);
        this.expressionsToReturn = new ArrayList<FieldExpression>(builder.expressionsToReturn);
        this.idsOnly = builder.idsOnly;
        this.checkValid();
    }

    public String getQuery() {
        return this.query;
    }

    public int getLimit() {
        return this.limit;
    }

    public String getCursor() {
        return this.cursor;
    }

    public int getOffset() {
        return this.offset == null ? 0 : this.offset;
    }

    public CursorType getCursorType() {
        return this.cursorType;
    }

    public int getMatchedCountAccuracy() {
        return this.matchedCountAccuracy;
    }

    public List<SortSpec> getSortSpecs() {
        return Collections.unmodifiableList(this.sortSpecs);
    }

    public boolean isReturningIdsOnly() {
        return this.idsOnly == null ? false : this.idsOnly;
    }

    public List<String> getFieldsToReturn() {
        return Collections.unmodifiableList(this.fieldsToReturn);
    }

    public List<String> getFieldsToSnippet() {
        return Collections.unmodifiableList(this.fieldsToSnippet);
    }

    public List<FieldExpression> getExpressionsToReturn() {
        return Collections.unmodifiableList(this.expressionsToReturn);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(SearchRequest request) {
        return new Builder(request);
    }

    private SearchRequest checkValid() {
        Preconditions.checkNotNull(this.query, "query cannot be null");
        Preconditions.checkNotNull(this.limit, "number of documents to return cannot be null");
        SearchRequestChecker.checkCursor(this.cursor);
        SearchRequestChecker.checkFieldNames(this.fieldsToReturn);
        return this;
    }

    private static String quoteString(String argument) {
        return "\"" + argument.replace("\"", "\\\"") + "\"";
    }

    SearchServicePb.SearchParams.Builder copyToProtocolBuffer() {
        SearchServicePb.SearchParams.Builder builder = SearchServicePb.SearchParams.newBuilder().setQuery(this.query);
        builder.setLimit(this.getLimit());
        if (this.cursor != null) {
            builder.setCursor(this.cursor);
        }
        if (this.offset != null) {
            builder.setOffset(this.offset);
        }
        if (this.idsOnly != null) {
            builder.setKeysOnly(this.idsOnly);
        }
        switch (this.cursorType) {
            case RESULT_CURSOR: {
                builder.setCursorType(SearchServicePb.SearchParams.CursorType.PER_RESULT);
                break;
            }
            case RESPONSE_CURSOR: {
                builder.setCursorType(SearchServicePb.SearchParams.CursorType.SINGLE);
                break;
            }
            case NONE: {
                builder.setCursorType(SearchServicePb.SearchParams.CursorType.NONE);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("unknown cursor type %d", new Object[]{this.cursorType}));
            }
        }
        builder.setMatchedCountAccuracy(this.matchedCountAccuracy);
        for (SortSpec sortSpec : this.sortSpecs) {
            if (sortSpec.getType() == SortSpec.SortType.CUSTOM) {
                builder.addSortSpec(sortSpec.copyToProtocolBuffer());
                continue;
            }
            builder.setScorerSpec(sortSpec.copyToScorerSpecProtocolBuffer());
        }
        if (!(this.fieldsToReturn.isEmpty() && this.fieldsToSnippet.isEmpty() && this.expressionsToReturn.isEmpty())) {
            SearchServicePb.FieldSpec.Builder fieldSpec = SearchServicePb.FieldSpec.newBuilder();
            fieldSpec.addAllName(this.fieldsToReturn);
            for (String field : this.fieldsToSnippet) {
                FieldExpression.Builder expressionBuilder = FieldExpression.newBuilder().setName(field);
                expressionBuilder.setExpression("snippet(" + SearchRequest.quoteString(this.query) + ", " + field + ")");
                fieldSpec.addExpression(expressionBuilder.build().copyToProtocolBuffer());
            }
            for (FieldExpression expression : this.expressionsToReturn) {
                fieldSpec.addExpression(expression.copyToProtocolBuffer());
            }
            builder.setFieldSpec(fieldSpec);
        }
        return builder;
    }

    public String toString() {
        return String.format("SearchRequest(query=%s, limit=%d%s%s%s%s%s, matchedCountAccuracy=%d%s%s%s)", this.query, this.limit, Util.fieldToString("IDsOnly", this.idsOnly), Util.iterableFieldToString("sortSpecs", this.sortSpecs), Util.iterableFieldToString("fieldsToReturn", this.fieldsToReturn), Util.iterableFieldToString("fieldsToSnippet", this.fieldsToSnippet), Util.iterableFieldToString("expressionsToReturn", this.expressionsToReturn), this.matchedCountAccuracy, Util.fieldToString("cursor", this.cursor), Util.fieldToString("cursorType", (Object)this.cursorType), Util.fieldToString("offset", this.offset));
    }

    public static final class Builder {
        private String query;
        private Integer limit;
        private List<SortSpec> sortSpecs = new ArrayList<SortSpec>();
        private List<String> fieldsToReturn = new ArrayList<String>();
        private List<String> fieldsToSnippet = new ArrayList<String>();
        private List<FieldExpression> expressionsToReturn = new ArrayList<FieldExpression>();
        private String cursor;
        private CursorType cursorType;
        private Integer matchedCountAccuracy;
        private Integer offset;
        private Boolean idsOnly;

        private Builder() {
        }

        private Builder(SearchRequest request) {
            this.query = request.getQuery();
            this.limit = request.getLimit();
            this.cursor = request.getCursor();
            this.cursorType = request.getCursorType();
            this.matchedCountAccuracy = request.getMatchedCountAccuracy();
            this.sortSpecs = new ArrayList<SortSpec>(request.getSortSpecs());
            this.fieldsToReturn = new ArrayList<String>(request.getFieldsToReturn());
            this.expressionsToReturn = new ArrayList<FieldExpression>(request.getExpressionsToReturn());
        }

        public Builder setQuery(String query) {
            this.query = SearchRequestChecker.checkQuery(query);
            return this;
        }

        public Builder setLimit(int limit) {
            this.limit = SearchRequestChecker.checkLimit(limit);
            return this;
        }

        public Builder setCursor(String cursor) {
            Preconditions.checkArgument(this.offset == null, "offset and cursor cannot be set in the same request");
            this.cursor = Preconditions.checkNotNull(cursor, "cursor cannot be null");
            return this;
        }

        public Builder setOffset(int offset) {
            Preconditions.checkArgument(this.cursor == null, "offset and cursor cannot be set in the same request");
            this.offset = SearchRequestChecker.checkOffset(offset);
            return this;
        }

        public Builder setCursorType(CursorType cursorType) {
            this.cursorType = Preconditions.checkNotNull(cursorType, "cursor type cannot be null");
            return this;
        }

        public Builder setMatchedCountAccuracy(int matchedCountAccuracy) {
            this.matchedCountAccuracy = SearchRequestChecker.checkMatchedCountAccuracy(matchedCountAccuracy);
            return this;
        }

        public Builder setFieldsToReturn(String ... fields) {
            Preconditions.checkNotNull(fields, "field names cannot be null");
            Preconditions.checkArgument(this.idsOnly == null, "You may not set fields to return if search returns keys only");
            ArrayList<String> returningFields = new ArrayList<String>(fields.length);
            for (String field : fields) {
                returningFields.add(field);
            }
            this.fieldsToReturn = SearchRequestChecker.checkFieldNames(returningFields);
            return this;
        }

        public Builder setFieldsToSnippet(String ... fieldsToSnippet) {
            Preconditions.checkNotNull(this.fieldsToReturn, "field names cannot be null");
            ArrayList<String> snippetingFields = new ArrayList<String>(fieldsToSnippet.length);
            for (String field : fieldsToSnippet) {
                snippetingFields.add(field);
            }
            this.fieldsToSnippet = SearchRequestChecker.checkFieldNames(snippetingFields);
            return this;
        }

        public Builder addExpressionToReturn(FieldExpression.Builder expressionBuilder) {
            Preconditions.checkArgument(this.idsOnly == null, "You may not add expressions to return if search returns keys only");
            return this.addExpressionToReturn(expressionBuilder.build());
        }

        public Builder setReturningIdsOnly(boolean idsOnly) {
            Preconditions.checkArgument(this.expressionsToReturn.isEmpty(), "You cannot request IDs only if expressions to return are set");
            Preconditions.checkArgument(this.fieldsToReturn.isEmpty(), "You cannot request IDs only if fields to return are already set");
            this.idsOnly = idsOnly;
            return this;
        }

        public Builder addExpressionToReturn(FieldExpression expression) {
            this.expressionsToReturn.add(expression);
            return this;
        }

        public Builder addSortSpec(SortSpec sortSpec) {
            this.sortSpecs.add(Preconditions.checkNotNull(sortSpec, "sort spec cannot be null"));
            return this;
        }

        public Builder addSortSpec(SortSpec.Builder sortSpecBuilder) {
            this.sortSpecs.add(Preconditions.checkNotNull(sortSpecBuilder, "sort spec builder cannot be null").build());
            return this;
        }

        public SearchRequest build() {
            return new SearchRequest(this);
        }
    }

    public static enum CursorType {
        NONE,
        RESPONSE_CURSOR,
        RESULT_CURSOR;

    }
}

