/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.apphosting.api.DatastorePb;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class CompositeIndexManager {
    private static final String DATASTORE_INDEX_WITH_PROPERTIES_XML_FORMAT = "    <datastore-index kind=\"%s\" ancestor=\"%s\" source=\"%s\">\n%s    </datastore-index>\n\n";
    private static final String DATASTORE_INDEX_NO_PROPERTIES_XML_FORMAT = "    <datastore-index kind=\"%s\" ancestor=\"%s\" source=\"%s\"/>\n\n";
    private static final String PROPERTY_XML_FORMAT = "        <property name=\"%s\" direction=\"%s\"/>\n";

    protected String generateXmlForIndex(OnestoreEntity.Index index, IndexSource source) {
        boolean isAncestor = index.isAncestor();
        if (index.propertySize() == 0) {
            return String.format(DATASTORE_INDEX_NO_PROPERTIES_XML_FORMAT, new Object[]{index.getEntityType(), isAncestor, source});
        }
        StringBuilder sb = new StringBuilder();
        for (OnestoreEntity.Index.Property prop : index.propertys()) {
            String dir = prop.getDirectionEnum() == OnestoreEntity.Index.Property.Direction.ASCENDING ? "asc" : "desc";
            sb.append(String.format(PROPERTY_XML_FORMAT, prop.getName(), dir));
        }
        return String.format(DATASTORE_INDEX_WITH_PROPERTIES_XML_FORMAT, new Object[]{index.getEntityType(), isAncestor, source, sb.toString()});
    }

    protected OnestoreEntity.Index compositeIndexForQuery(IndexComponentsOnlyQuery indexOnlyQuery) {
        DatastorePb.Query query = indexOnlyQuery.getQuery();
        boolean hasKind = query.hasKind();
        boolean isAncestor = query.hasAncestor();
        List<DatastorePb.Query.Filter> filters = query.filters();
        List<DatastorePb.Query.Order> orders = query.orders();
        if (filters.isEmpty() && orders.isEmpty()) {
            return null;
        }
        Set<String> eqProps = indexOnlyQuery.getEqualityProps();
        List<OnestoreEntity.Index.Property> indexProperties = indexOnlyQuery.getIndexProps();
        if (hasKind && !eqProps.isEmpty() && eqProps.size() == filters.size() && !indexOnlyQuery.hasKeyProperty() && orders.isEmpty()) {
            return null;
        }
        if (!(!hasKind || isAncestor || indexProperties.size() > 1 || indexOnlyQuery.hasKeyProperty() && indexProperties.get(0).getDirectionEnum() != OnestoreEntity.Index.Property.Direction.ASCENDING)) {
            return null;
        }
        OnestoreEntity.Index index = new OnestoreEntity.Index();
        index.setEntityType(query.getKind());
        index.setAncestor(isAncestor);
        index.mutablePropertys().addAll(indexProperties);
        return index;
    }

    protected OnestoreEntity.Index minimumCompositeIndexForQuery(IndexComponentsOnlyQuery indexOnlyQuery, Collection<OnestoreEntity.Index> indexes) {
        List<OnestoreEntity.Index.Property> postfix = indexOnlyQuery.getIndexProps().subList(indexOnlyQuery.getEqualityProps().size(), indexOnlyQuery.getIndexProps().size());
        HashSet<String> prefixRemaining = new HashSet<String>(indexOnlyQuery.getEqualityProps());
        boolean ancestorRemaining = indexOnlyQuery.getQuery().hasAncestor();
        OnestoreEntity.Index index = this.compositeIndexForQuery(indexOnlyQuery);
        for (OnestoreEntity.Index candidateIndex : indexes) {
            List<OnestoreEntity.Index.Property> indexPostfix;
            int indexPrefixSize = candidateIndex.propertySize() - postfix.size();
            if (!candidateIndex.getEntityType().equals(index.getEntityType()) || !indexOnlyQuery.getQuery().hasAncestor() && candidateIndex.isAncestor() || indexPrefixSize < 0 || !((Object)postfix).equals(indexPostfix = candidateIndex.propertys().subList(indexPrefixSize, candidateIndex.propertySize()))) continue;
            HashSet<String> indexPrefix = new HashSet<String>(indexPrefixSize);
            for (OnestoreEntity.Index.Property prop : candidateIndex.propertys().subList(0, indexPrefixSize)) {
                indexPrefix.add(prop.getName());
            }
            if (!indexOnlyQuery.getEqualityProps().containsAll(indexPrefix)) continue;
            prefixRemaining.removeAll(indexPrefix);
            if (candidateIndex.isAncestor()) {
                ancestorRemaining = false;
            }
            if (!prefixRemaining.isEmpty() || ancestorRemaining) continue;
            return null;
        }
        OnestoreEntity.Index minimumIndex = (OnestoreEntity.Index)index.clone();
        if (!ancestorRemaining) {
            minimumIndex.setAncestor(false);
        }
        Iterator<OnestoreEntity.Index.Property> itr = minimumIndex.mutablePropertys().subList(0, indexOnlyQuery.getEqualityProps().size()).iterator();
        while (itr.hasNext()) {
            OnestoreEntity.Index.Property prop = itr.next();
            if (prefixRemaining.contains(prop.getName())) continue;
            itr.remove();
        }
        return minimumIndex;
    }

    protected static class KeyTranslator
    extends com.google.appengine.api.datastore.KeyTranslator {
        protected KeyTranslator() {
        }
    }

    protected static class ValidatedQuery
    extends com.google.appengine.api.datastore.ValidatedQuery {
        public ValidatedQuery(DatastorePb.Query query) {
            super(query);
        }
    }

    protected static class IndexComponentsOnlyQuery
    extends com.google.appengine.api.datastore.IndexComponentsOnlyQuery {
        public IndexComponentsOnlyQuery(DatastorePb.Query query) {
            super(query);
        }
    }

    protected static enum IndexSource {
        auto,
        manual;

    }
}

