/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.apphosting.api.DatastorePb;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

class NormalizedQuery {
    static final Set<DatastorePb.Query.Filter.Operator> INEQUALITY_OPERATORS = NormalizedQuery.makeImmutableSet(DatastorePb.Query.Filter.Operator.GREATER_THAN, DatastorePb.Query.Filter.Operator.GREATER_THAN_OR_EQUAL, DatastorePb.Query.Filter.Operator.LESS_THAN, DatastorePb.Query.Filter.Operator.LESS_THAN_OR_EQUAL);
    protected final DatastorePb.Query query;

    public NormalizedQuery(DatastorePb.Query query) {
        this.query = (DatastorePb.Query)query.clone();
        this.normalizeQuery();
    }

    public DatastorePb.Query getQuery() {
        return this.query;
    }

    private void normalizeQuery() {
        HashSet<String> equalityProperties = new HashSet<String>();
        HashSet<String> inequalityProperties = new HashSet<String>();
        for (DatastorePb.Query.Filter f : this.query.filters()) {
            if (f.propertySize() == 1 && f.getOpEnum() == DatastorePb.Query.Filter.Operator.IN) {
                f.setOp(DatastorePb.Query.Filter.Operator.EQUAL);
            }
            if (f.propertySize() < 1) continue;
            if (f.getOpEnum() == DatastorePb.Query.Filter.Operator.EQUAL) {
                equalityProperties.add(f.getProperty(0).getName());
                continue;
            }
            if (!INEQUALITY_OPERATORS.contains(f.getOpEnum())) continue;
            inequalityProperties.add(f.getProperty(0).getName());
        }
        equalityProperties.removeAll(inequalityProperties);
        Iterator<DatastorePb.Query.Order> i = this.query.orderIterator();
        while (i.hasNext()) {
            if (equalityProperties.add(i.next().getProperty())) continue;
            i.remove();
        }
        for (DatastorePb.Query.Filter f : this.query.filters()) {
            if (f.getOpEnum() != DatastorePb.Query.Filter.Operator.EQUAL || f.propertySize() < 1 || !f.getProperty(0).getName().equals("__key__")) continue;
            this.query.clearOrder();
            break;
        }
        boolean foundKeyOrder = false;
        Iterator<DatastorePb.Query.Order> i2 = this.query.orderIterator();
        while (i2.hasNext()) {
            String property = i2.next().getProperty();
            if (foundKeyOrder) {
                i2.remove();
                continue;
            }
            if (!property.equals("__key__")) continue;
            foundKeyOrder = true;
        }
    }

    static <T> Set<T> makeImmutableSet(T ... of) {
        return Collections.unmodifiableSet(new HashSet<T>(Arrays.asList(of)));
    }
}

