/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search.query;

import com.google.appengine.api.search.query.QueryTreeVisitor;
import com.google.appengine.repackaged.org.antlr.runtime.tree.Tree;

public class QueryTreeWalker<T> {
    private final QueryTreeVisitor<T> visitor;

    public QueryTreeWalker(QueryTreeVisitor<T> visitor) {
        this.visitor = visitor;
    }

    public static Tree simplify(Tree tree) {
        for (int i = 0; i < tree.getChildCount(); ++i) {
            Tree optimized;
            Tree child = tree.getChild(i);
            if (child == (optimized = QueryTreeWalker.simplify(child))) continue;
            tree.setChild(i, optimized);
        }
        switch (tree.getType()) {
            case 5: 
            case 6: {
                if (tree.getChildCount() != 1) break;
                return tree.getChild(0);
            }
        }
        return tree;
    }

    public void walk(Tree node, T context) {
        if (node == null) {
            throw new IllegalArgumentException("Unexpected null node");
        }
        switch (node.getType()) {
            case 5: {
                this.visitor.visitConjunction(this, node, context);
                break;
            }
            case 6: {
                this.visitor.visitDisjunction(this, node, context);
                break;
            }
            case 10: {
                this.visitor.visitNegation(this, node, context);
                break;
            }
            case 13: {
                this.visitor.visitRestriction(this, node, context);
                break;
            }
            case 8: {
                this.visitor.visitFuzzy(this, node, context);
                break;
            }
            case 9: {
                this.visitor.visitLiteral(this, node, context);
                break;
            }
            case 16: {
                this.visitor.visitValue(this, node, context);
                break;
            }
            case 19: {
                this.visitor.visitLessThan(this, node, context);
                break;
            }
            case 21: {
                this.visitor.visitGreaterThan(this, node, context);
                break;
            }
            case 18: {
                this.visitor.visitLessOrEqual(this, node, context);
                break;
            }
            case 20: {
                this.visitor.visitGreaterOrEqual(this, node, context);
                break;
            }
            case 23: {
                this.visitor.visitEqual(this, node, context);
                break;
            }
            case 24: {
                this.visitor.visitContains(this, node, context);
                break;
            }
            default: {
                this.visitor.visitOther(this, node, context);
            }
        }
    }
}

