/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.collect;

import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.Cut;
import com.google.appengine.repackaged.com.google.common.collect.Range;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible
@GoogleInternal
public final class Ranges {
    private Ranges() {
    }

    private static <C extends Comparable<?>> Range<C> create(Cut<C> lowerBound, Cut<C> upperBound) {
        return new Range<C>(lowerBound, upperBound);
    }

    public static <C extends Comparable<?>> Range<C> open(C lower, C upper) {
        return Ranges.create(new Cut.AboveValue<C>(lower), new Cut.BelowValue<C>(upper));
    }

    public static <C extends Comparable<?>> Range<C> closed(C lower, C upper) {
        return Ranges.create(new Cut.BelowValue<C>(lower), new Cut.AboveValue<C>(upper));
    }

    public static <C extends Comparable<?>> Range<C> closedOpen(C lower, C upper) {
        return Ranges.create(new Cut.BelowValue<C>(lower), new Cut.BelowValue<C>(upper));
    }

    public static <C extends Comparable<?>> Range<C> openClosed(C lower, C upper) {
        return Ranges.create(new Cut.AboveValue<C>(lower), new Cut.AboveValue<C>(upper));
    }

    public static <C extends Comparable<?>> Range<C> range(C lower, Range.BoundType lowerType, C upper, Range.BoundType upperType) {
        Preconditions.checkNotNull(lowerType);
        Preconditions.checkNotNull(upperType);
        Cut lowerBound = lowerType == Range.BoundType.OPEN ? new Cut.AboveValue<C>(lower) : new Cut.BelowValue<C>(lower);
        Cut upperBound = upperType == Range.BoundType.OPEN ? new Cut.BelowValue<C>(upper) : new Cut.AboveValue<C>(upper);
        return Ranges.create(lowerBound, upperBound);
    }

    public static <C extends Comparable<?>> Range<C> lessThan(C endpoint) {
        return Ranges.create(Ranges.<C>noLowerBound(), new Cut.BelowValue<C>(endpoint));
    }

    public static <C extends Comparable<?>> Range<C> greaterThan(C endpoint) {
        return Ranges.create(new Cut.AboveValue<C>(endpoint), Ranges.<C>noUpperBound());
    }

    public static <C extends Comparable<?>> Range<C> atLeast(C endpoint) {
        return Ranges.create(new Cut.BelowValue<C>(endpoint), Ranges.<C>noUpperBound());
    }

    public static <C extends Comparable<?>> Range<C> atMost(C endpoint) {
        return Ranges.create(Ranges.<C>noLowerBound(), new Cut.AboveValue<C>(endpoint));
    }

    public static <C extends Comparable<?>> Range<C> all() {
        return Ranges.create(Ranges.<C>noLowerBound(), Ranges.<C>noUpperBound());
    }

    private static <C extends Comparable<?>> Cut<C> noLowerBound() {
        return Cut.BELOW_ALL;
    }

    private static <C extends Comparable<?>> Cut<C> noUpperBound() {
        return Cut.ABOVE_ALL;
    }
}

