/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development.gwt;

import com.google.appengine.tools.development.DevAppServer;
import com.google.appengine.tools.development.DevAppServerFactory;
import com.google.appengine.tools.info.SdkInfo;
import com.google.appengine.tools.info.UpdateCheck;
import com.google.appengine.tools.util.Logging;
import com.google.gwt.core.ext.ServletContainer;
import com.google.gwt.core.ext.ServletContainerLauncher;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class AppEngineLauncher
extends ServletContainerLauncher {
    private static final String ADDRESS = "0.0.0.0";

    public ServletContainer start(TreeLogger logger, int port, File appRootDir) throws UnableToCompleteException {
        Properties properties;
        LogAdapterHandler logAdapter = new LogAdapterHandler(logger);
        logAdapter.install();
        Logging.initializeLogging();
        logAdapter.adjustRootHandlers();
        this.checkStartParams(logger, port, appRootDir);
        TreeLogger branch = logger.branch(TreeLogger.INFO, "Initializing AppEngine server");
        this.maybePerformUpdateCheck(branch);
        DevAppServer server = new DevAppServerFactory().createDevAppServer(appRootDir, ADDRESS, port);
        server.setThrowOnEnvironmentVariableMismatch(false);
        Properties stringProperties = properties = System.getProperties();
        server.setServiceProperties(stringProperties);
        try {
            server.start();
            return new AppEngineServletContainer(logger, server, logAdapter);
        }
        catch (Exception e) {
            branch.log(TreeLogger.ERROR, "Unable to start AppEngine server", (Throwable)e);
            throw new UnableToCompleteException();
        }
    }

    protected void maybePerformUpdateCheck(TreeLogger logger) {
        ByteArrayOutputStream baos;
        UpdateCheck updateCheck = new UpdateCheck(SdkInfo.getDefaultServer());
        if (updateCheck.allowedToCheckForUpdates() && updateCheck.maybePrintNagScreen(new PrintStream(baos = new ByteArrayOutputStream()))) {
            logger.log(TreeLogger.WARN, new String(baos.toByteArray()));
        }
        if (updateCheck.checkJavaVersion(new PrintStream(baos = new ByteArrayOutputStream()))) {
            logger.log(TreeLogger.WARN, new String(baos.toByteArray()));
        }
    }

    private void checkStartParams(TreeLogger logger, int port, File appRootDir) {
        if (logger == null) {
            throw new NullPointerException("logger cannot be null");
        }
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("port must be either 0 (for auto) or less than 65536");
        }
        if (appRootDir == null) {
            throw new NullPointerException("app root directory cannot be null");
        }
    }

    private static class LogAdapterHandler
    extends Handler
    implements PropertyChangeListener {
        private final TreeLogger treeLogger;

        public LogAdapterHandler(TreeLogger treeLogger) {
            this.treeLogger = treeLogger;
            this.setLevel(Level.FINEST);
            this.setFilter(null);
            this.setFormatter(new Formatter(){

                public String format(LogRecord record) {
                    return this.formatMessage(record);
                }
            });
        }

        public void install() {
            this.adjustRootHandlers();
            LogManager.getLogManager().addPropertyChangeListener(this);
        }

        public void propertyChange(PropertyChangeEvent event) {
            this.adjustRootHandlers();
        }

        void adjustRootHandlers() {
            Logger root = Logger.getLogger("");
            boolean foundOurHandler = false;
            for (Handler handler : new ArrayList<Handler>(Arrays.asList(root.getHandlers()))) {
                if (handler == this) {
                    foundOurHandler = true;
                    continue;
                }
                if (!(handler instanceof ConsoleHandler)) continue;
                root.removeHandler(handler);
            }
            if (!foundOurHandler) {
                root.addHandler(this);
            }
        }

        public void uninstall() {
            LogManager.getLogManager().removePropertyChangeListener(this);
            Logger.getLogger("").removeHandler(this);
        }

        public synchronized void publish(LogRecord record) {
            String message;
            if (!this.isLoggable(record)) {
                return;
            }
            TreeLogger.Type type = this.convertLogLevel(record.getLevel());
            if (!this.treeLogger.isLoggable(type)) {
                return;
            }
            try {
                message = this.getFormatter().format(record);
            }
            catch (Exception ex) {
                this.reportError(null, ex, 5);
                return;
            }
            this.treeLogger.log(type, message, record.getThrown());
        }

        private TreeLogger.Type convertLogLevel(Level level) {
            long intLevel = level.intValue();
            if (intLevel >= (long)Level.SEVERE.intValue()) {
                return TreeLogger.Type.ERROR;
            }
            if (intLevel >= (long)Level.WARNING.intValue()) {
                return TreeLogger.Type.WARN;
            }
            if (intLevel >= (long)Level.INFO.intValue()) {
                return TreeLogger.Type.INFO;
            }
            if (intLevel >= (long)Level.FINE.intValue()) {
                return TreeLogger.Type.TRACE;
            }
            if (intLevel >= (long)Level.FINER.intValue()) {
                return TreeLogger.Type.DEBUG;
            }
            return TreeLogger.Type.ALL;
        }

        public void flush() {
        }

        public void close() {
            this.flush();
        }
    }

    private static class AppEngineServletContainer
    extends ServletContainer {
        private final TreeLogger logger;
        private final DevAppServer server;
        private final LogAdapterHandler logAdapter;

        public AppEngineServletContainer(TreeLogger logger, DevAppServer server, LogAdapterHandler logAdapter) {
            this.logger = logger;
            this.server = server;
            this.logAdapter = logAdapter;
        }

        public int getPort() {
            return this.server.getPort();
        }

        public void refresh() throws UnableToCompleteException {
            TreeLogger branch = this.logger.branch(TreeLogger.INFO, "Reloading AppEngine server");
            try {
                this.server.restart();
            }
            catch (Exception e) {
                branch.log(TreeLogger.ERROR, "Unable to reload AppEngine server", (Throwable)e);
                throw new UnableToCompleteException();
            }
            branch.log(TreeLogger.INFO, "Reload completed successfully");
        }

        public void stop() throws UnableToCompleteException {
            TreeLogger branch = this.logger.branch(TreeLogger.INFO, "Stopping AppEngine server");
            try {
                this.server.shutdown();
            }
            catch (Exception e) {
                branch.log(TreeLogger.ERROR, "Unable to stop AppEngine server", (Throwable)e);
                throw new UnableToCompleteException();
            }
            branch.log(TreeLogger.INFO, "Stopped successfully");
            this.logAdapter.uninstall();
        }
    }
}

