<?php
/*
 * PHP version 5
 *
 * @copyright Copyright 2010, Cake. (http://trpgtools-onweb.sourceforge.jp/)
 * @category Controller
 * @package  TRPG Data Bank
 * @version  beta
 * @author   Cake <cake_67@users.sourceforge.jp>
 * @license  http://www.opensource.org/licenses/mit-license.php The MIT License
 * @link     http://trpgtools-onweb.sourceforge.jp/
 */

class CharactersHasProfilesController extends AppController {

	var $name = 'CharactersHasProfiles';
	var $helpers = array(
	);

	var $disableTokenActions = array();


	/* メソッド */

	/* アクションメソッド */

	function delete($profile_id = null) {
		if (!$profile_id) {
			$this->Session->setFlash(__('Invalid URL.', true));
			$this->redirect(array('controller' => 'characters', 'action'=>'index'));
		}

		$character = $this->CharactersHasProfile->Character->find('first', array(
			'conditions' => array(
				'Character.id' => $this->params['named']['character_id'],
			),
			'fields' => array(
				'Character.id',
				'Character.user_id',
				'Character.name',
			),
			'recursive' => -1,
		));

		if (empty($character)) {
			$this->Session->setFlash(__('No Character', true));
			$this->redirect(array('controller'=>'characters', 'action'=>'index'));
		}

		if (!$this->isOwner($character['Character'], $this->user_id)) {
			$this->Session->setFlash(__('No Permission', true));
			$this->redirect(array('controller'=>'characters', 'action'=>'index'));
		}

			$this->data['clearCache'] = array(
				'character_id' => $character['Character']['id'],
				'user_id' => $this->user_id,
				'system_id' => $character['System']['id'],
			);

		$this->CharactersHasProfile->deleteAll(
			 array(
				'CharactersHasProfile.profile_id' => $profile_id,
				'CharactersHasProfile.character_id' => $this->params['named']['character_id'],
			),
			false
		);

		$this->CharactersHasProfile->deleteCacheCharacter($character['Character']['id'], true);

		$this->Session->setFlash(__('Profile deleted', true));
		$this->redirect(array('controller'=>'characters', 'action'=>'view',$this->params['named']['character_id'] ));
	}

}
