<?php
/*
 * PHP version 5
 *
 * @copyright Copyright 2010, Cake. (http://trpgtools-onweb.sourceforge.jp/)
 * @category Controller
 * @package  TRPG Data Bank
 * @version  beta
 * @author   Cake <cake_67@users.sourceforge.jp>
 * @license  http://www.opensource.org/licenses/mit-license.php The MIT License
 * @link     http://trpgtools-onweb.sourceforge.jp/
 */

class DefaultProfilesController extends AppController {

	var $name = 'DefaultProfiles';

	var $helpers = array(
		'Profiledisp',
		'Select',
	);

	var $disableTokenActions = array();

	/* メソッド */

	function beforeFilter() {
		parent::beforeFilter();

		// Cache
		$this->cacheAction = array(
		);

		// 認証なしアクセス可
	}

	function beforeRender()
	{
		parent::beforeRender();

		$this->set_public_flag4view();
	}

	/* アクションメソッド */
	function admin_edit($profile_id = null) {
		if (!$profile_id ) {
			$this->Session->setFlash(__('Invalid data.', true));
			$this->redirect(array('controller' => 'systems', 'action'=>'admin_index'));
		}

		$profile = $this->get_profile4profile_id($profile_id);
		if (empty($profile)) {
			$this->Session->setFlash(__('Invalid Profile', true));
			$this->redirect(array('controller' => 'systems', 'action'=>'admin_index'));
		}

		if (!empty($this->data)) {
			$this->post_data = $this->data;
			$this->data = array();

			$allow_blank = false;
			if (CorePlus::get_profile_type($profile['Profile']['profile_type']) == 'checkbox') {
				$allow_blank = true;
			}

			$this->data['CharactersHasProfile'] = $this->_set_new_characters_has_profile($this->post_data['CharactersHasProfile'], $profile_id, array(), $allow_blank);

			// 全空欄なら現在のdefault_profiles削除
			if (empty($this->data['CharactersHasProfile'])) {
				$this->DefaultProfile->deleteAll(array(
					'DefaultProfile.profile_id' => $profile_id
				));

				$this->Session->setFlash(__('The default profile has been saved', true));
				$this->redirect(array('action' => 'edit', $profile_id));
			}

			foreach ($this->data['CharactersHasProfile'] as $k => $v) {
				$this->data['DefaultProfile'][$k]['profile_id'] = $profile_id;
				if (!empty($v['profile_select_id'])) {
					$this->data['DefaultProfile'][$k]['profile_select_id'] = $v['profile_select_id'];
				}
				if (!empty($v['profile_table_id'])) {
					$this->data['DefaultProfile'][$k]['profile_table_id'] = $v['profile_table_id'];
				}
				if (!empty($v['profile_table_static_id'])) {
					$this->data['DefaultProfile'][$k]['profile_table_static_id'] = $v['profile_table_static_id'];
				}

				if (!isset($v['value'])) {
					$this->data['DefaultProfile'][$k]['value'] = '';
				} else {
					$this->data['DefaultProfile'][$k]['value'] = $v['value'];
				}

				if (!isset($v['public_flag'])) {
					$this->data['DefaultProfile'][$k]['public_flag'] = 1;
				} else {
					$this->data['DefaultProfile'][$k]['public_flag'] = $v['public_flag'];
				}
			}
			unset($this->data["CharactersHasProfile"]);

//			$this->data['DefaultProfile']['__Token'] = $this->post_data['DefaultProfile']['__Token'];

			/* validate */
			if ($this->DefaultProfile->saveAll($this->data['DefaultProfile'], array('validate' => 'only'))) {

				// 現在のdefault_profiles削除
				$this->DefaultProfile->deleteAll(array(
					'DefaultProfile.profile_id' => $profile_id
				));

				/* データ保存 */
				$this->DefaultProfile->create();
				if ($this->DefaultProfile->saveAll($this->data['DefaultProfile'], array(
					'validate' => false,
					 'fieldList' => $this->DefaultProfile->fields['edit'], 
				))) {
					$this->Session->setFlash(__('The default profile has been saved', true));
//					$this->redirect(array('controller' => 'systems', 'action' => 'view', $profile['Profile']['system_id']));
					$this->redirect(array('action' => 'edit', $profile_id));
				}	

				$this->Session->setFlash(__('The default profile could not be saved. Please, try again.', true));
				$this->data = $this->post_data;
			}
		}

		$this->data['System'] = $profile['System'];
		unset($profile['System']);

		$profile['Profile']['CharactersHasProfile'] = $profile['DefaultProfile'];

		$profile['Profile']['ProfileSelect'] = $profile['ProfileSelect'];
		unset($profile['ProfileSelect']);

		$profile['Profile']['ProfileTable'] = $profile['ProfileTable'];
		unset($profile['ProfileTable']);

		$this->data['System']['Profile'][0] = $profile['Profile'];


//		$defalt_profiles_num = count($profile['DefaultProfile']);
		switch (CorePlus::get_profile_type($profile['Profile']['profile_type'])) {
			case 'table':
			case 'm-input':
				$num = 3;
				break;
			default: 
				$num = 1;
				break;
		}
		$this->set('form_nums', $num);

		$this->set('title_for_layout', " - ". sprintf(__('DefaultProfile for %s %s', true), $this->data['System']['name'], $this->data['System']['Profile'][0]['name']));

	}

	function admin_delete_all($ids = null) {
		if (!$ids) {
			$this->Session->setFlash(__('Invalid Id.', true));
			$this->redirect(array('controllers' => 'systems', 'action'=>'index'));
		}

		$id = explode('_', $ids);

		if (!empty($id)) {
			$conditions = array();
			$profile_id = null;
			foreach ($id as $k => $v) {
				$defaultProfile = $this->DefaultProfile->find('first', array(
					'conditions' => array(
						'DefaultProfile.id' => $v,
					),
					'contain' => array(
						'Profile',
					),
					'recursive' => 1,
				));

				if (empty($defaultProfile) || !isset($defaultProfile['DefaultProfile'])) {
					$this->Session->setFlash(__('Invalid Id.', true));
					$this->redirect(array('controllers' => 'systems', 'action'=>'index'));
				}

				if ($k == 0) {
					$profile_id = $defaultProfile['DefaultProfile']['profile_id'];
				} elseif ($defaultProfile['DefaultProfile']['profile_id'] != $profile_id) {
					$this->Session->setFlash(__('Invalid Id.', true));
					$this->redirect(array('controllers' => 'default_profiles', 'action'=>'edit', $profile_id));
				}

				if (!empty($v) && is_string($v)) {
					if (CorePlus::get_profile_type($defaultProfile['Profile']['profile_type']) == 's-table') {
						if ($k !=0) {
							$this->DefaultProfile->id = $v;
							$this->DefaultProfile->saveField('value', '');
							$this->DefaultProfile->id = $v;
							$this->DefaultProfile->saveField('public_flag', 1);
						}
					} else {
						$conditions['DefaultProfile.id'][] = $v;
					}
				}
			}
		} else {
			$this->Session->setFlash(__('Invalid Id.', true));
			$this->redirect(array('controllers' => 'systems', 'action'=>'index'));
		}

		if (CorePlus::get_profile_type($defaultProfile['Profile']['profile_type']) != 's-table') {
			if ($this->DefaultProfile->deleteAll($conditions)) {
				$this->Session->setFlash(__('Default profile deleted', true));
			} else {
				$this->Session->setFlash(__('Default profile was not deleted', true));
			}
		} else {
			$this->Session->setFlash(__('Default profile deleted', true));
		}
		$this->redirect(array('controllers' => 'default_profiles', 'action'=>'edit', $profile_id));
	}


	function get_profile4profile_id($profile_id)
	{
		if (!$profile_id) {
			$this->Session->setFlash(__('Invalid ProfileTable.', true));
			$this->redirect(array('controller' => 'systems', 'action'=>'admin_index'));
		}

		$profile = $this->DefaultProfile->Profile->find('first', array(
			'conditions' => array(
				'Profile.id' => $profile_id,
			),
			'contain' => array(
				'System',
				'DefaultProfile',
				'ProfileSelect',
				'ProfileTable' => array(
					'ProfileTableStatic',
				),
			),
		));

		if (!empty($profile['ProfileSelect'])) {
			foreach ($profile['ProfileSelect'] as $k => $v) {

				if (isset($v['sort_order'])  && !empty($v['sort_order'])) {
					$sort_order[$k] = $v['sort_order'];
				} else {
					$sort_order[$k] = 0;
				}
			}
			if (!empty($sort_order)) {
				$profile['ProfileSelect'] = $this->sort4sort_order($profile['ProfileSelect'], $sort_order);
			}
		}
		if (!empty($profile['ProfileTable'])) {
			foreach ($profile['ProfileTable'] as $k => $v) {

				if (isset($v['sort_order'])  && !empty($v['sort_order'])) {
					$sort_order[$k] = $v['sort_order'];
				} else {
					$sort_order[$k] = 0;
				}
			}
			if (!empty($sort_order)) {
				$profile['ProfileTable'] = $this->sort4sort_order($profile['ProfileTable'], $sort_order);
			}
		}

		return $profile;
	}
}

