using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics;
using System.IO;
using System.Xml;
using Plugin;
using System.Runtime.InteropServices;

namespace TypingManager
{
    public partial class Form1 : Form
    {
        private IKeyboardHookBase keyHook;
        private StrokeNumLog strokeNumLog;
        private StrokeTimeLog strokeTimeLog;
        private StrokeTimeView strokeTimeView;
        private PluginController pluginController;
        private KeyStrokeView keyStrokeView;
        private KeyState keyState;
        private TypingSpeed typingSpeed;
        private GraphChanger graphChanger;
        private TimerTaskController timerTaskController = null;
        private ConfigForm configForm = new ConfigForm();
        private uint WM_TaskbarCreated = 0;

        // O擾EBhE^Cg
        // ^CgႤꍇ̂݃vZX擾Ȃ
        private string lastAppTitle = "";
        private string lastAppPath = "";

        /// <summary>
        /// tʑŌXgr[ƃvZXʑŌXgr[
        /// ΂E̍ڂ猩ĉE̗]̕
        /// ڐďc̃XN[o[ƕȂ
        /// ܂C̃XN[o[oĂDhl
        /// </summary>
        public const int LISTVIEW_RMARGIN = 25;
        public const int LISTVEW_SMALL_ICON_SIZE = 16;

        #region vpeB...
        public TextBox TodayStrokeTime { get { return textBox8; } }
        public TextBox HourStrokeTime { get { return textBox20; } }
        public TextBox TodaySpecificStrokeTime { get { return textBox25; } }
        public TextBox HourSpecificStrokeTime { get { return textBox23; } }
        public TextBox LastEventType
        {
            get { return textBox1; }
        }
        public TextBox LastKeyCode
        {
            get { return textBox2; }
        }
        public TextBox LastKeyName
        {
            get { return textBox3; }
        }
        public TextBox LastAppPath
        {
            get { return textBox4; }
        }
        public TextBox TodayStrokeNum
        {
            get { return textBox5; }
        }
        public TextBox YesterdayStrokeNum
        {
            get { return textBox7; }
        }
        public TextBox TotalNum
        {
            get { return textBox9; }
        }
        public TextBox TotalAppNum
        {
            get { return textBox10; }
        }
        public TextBox TypeSpeedText
        {
            get { return textBox11; }
        }
        public TextBox HibetuTotalType
        {
            get { return textBox14; }
        }
        public TextBox HibetuAvgType
        {
            get { return textBox15; }
        }
        public TextBox HibetuSelectNum
        {
            get { return textBox16; }
        }
        public TextBox HibetuMaxType
        {
            get { return textBox17; }
        }
        public TextBox HibetuMinType
        {
            get { return textBox18; }
        }
        public PictureBox TypeSpeedPicture
        {
            get { return pictureBox1; }
        }
        public GroupBox HistoryGraphName
        {
            get { return groupBox2; }
        }
        public PictureBox HistoryPicture
        {
            get { return pictureBox2; }
        }
        public TextBox HistoryMaxValue
        {
            get { return textBox13; }
        }
        public TextBox HistoryMinValue
        {
            get { return textBox12; }
        }
        public ToolStripMenuItem IsTopMostMenu
        {
            get { return ɎOɕ\ToolStripMenuItem; }
        }
        public ToolStripMenuItem IsSaveTitleStroke
        {
            get { return EBhE^Cgʂ̑ŌۑTToolStripMenuItem; }
        }
        public ToolStripMenuItem GraphMarkMenu
        {
            get { return Ot̃}[NMToolStripMenuItem; }
        }
        public ToolStripStatusLabel DateTimeStatus
        {
            get { return toolStripStatusLabel1; }
        }
        public ToolStripStatusLabel TotalLogDayNum
        {
            get { return toolStripStatusLabel2; }
        }
        public ListView ProcessStrokeView
        {
            get { return listView1; }
        }
        public ListView DayStrokeView
        {
            get { return listView2; }
        }
        public RadioButton ProcessViewTypeToday
        {
            get { return radioButton3; }
        }
        public RadioButton ProcessViewTypeAll
        {
            get { return radioButton4; }
        }
        public ToolStripMenuItem PluginMenu
        {
            get { return vOCPToolStripMenuItem; }
        }
        #endregion

        [DllImport("user32.dll", SetLastError = true)]
        private static extern uint RegisterWindowMessage(string register_string);

        public Form1()
        {
            InitializeComponent();

            // ÑEBhȄԂ͐ݒŕς悤ɂ悤
            //this.WindowState = FormWindowState.Minimized;
            this.ShowInTaskbar = false;

            // Oۑp̃fBNg̑݃`FbNƐ
            Plugin.LogDir.LogDirectoryCheck();

            WM_TaskbarCreated = RegisterWindowMessage("TaskbarCreated");

            // AvP[V̐ݒt@Cǂݍ
            try
            {
                AppConfig.Load();
            }
            catch (IOException)
            {
                MessageBox.Show("ݒt@C̓ǂݍ݂Ɏs܂B" + Environment.NewLine +
                        "ݒt@CҏWĂvZXꍇ͏IĂB", Properties.Resources.ApplicationName);
                this.Close();
                return;
            }
            catch (XmlException)
            {
                MessageBox.Show("ݒt@Cɖ肪\܂B" + Environment.NewLine +
                        "configtH_̃t@CĂȂmFĂB", Properties.Resources.ApplicationName);
                this.Close();
                return;
            }
            IsTopMostMenu.Checked = AppConfig.TopMost;
            if (AppConfig.TabIndex >= tabControl1.TabCount || AppConfig.TabIndex < 0)
            {
                AppConfig.TabIndex = 0;
            }
            tabControl1.TabIndex = AppConfig.TabIndex;
            this.Text = Properties.Resources.ApplicationName;

            // L[{[htbN̊Jn
            if (AppConfig.StandardHook)
            {
                keyHook = new KeyboardProxyHook();
                keyHook.KeyboardHooked += new KeyboardHookedEventHandler(keyHookProc);
            }
            else
            {
                keyHook = new KeyboardHook();
                keyHook.KeyboardHooked += new KeyboardHookedEventHandler(keyHookProc);
            }

            // eXgr[̕Ȃ
            ProcessStrokeView.SmallImageList = new ImageList();
            ProcessStrokeView.SmallImageList.ImageSize = new Size(LISTVEW_SMALL_ICON_SIZE, LISTVEW_SMALL_ICON_SIZE);
            ProcessStrokeView.Columns[2].Width = ProcessStrokeView.Width -
                ProcessStrokeView.Columns[1].Width - ProcessStrokeView.Columns[0].Width - LISTVIEW_RMARGIN;
            ProcessStrokeView.ListViewItemSorter = new NumSort(2);
            DayStrokeView.SmallImageList = new ImageList();
            DayStrokeView.SmallImageList.ImageSize = new Size(1, LISTVEW_SMALL_ICON_SIZE);
            DayStrokeView.Columns[2].Width = DayStrokeView.Width - DayStrokeView.Columns[0].Width - 
                DayStrokeView.Columns[1].Width - LISTVIEW_RMARGIN;
            DayStrokeView.ListViewItemSorter = new NumSort(1,2);
            
            // Xe[^Xo[Ɍݎ𔽉f
            DateTimeStatus.Text = DateTime.Now.ToString();

            // ŌJEgSNX
            strokeNumLog = new StrokeNumLog();

            // ŌxvZNX쐬iTv20j
            typingSpeed = new TypingSpeed(20);
            
            // ŌԂ̃JEgSNX
            strokeTimeLog = new StrokeTimeLog(typingSpeed);

            // L[̏ԂۑNX
            keyState = new KeyState();

            // vOCRg[̍쐬ƃvOC̓ǂݍ
            pluginController = new PluginController(this);
            pluginController.AddStrokePlugin(strokeNumLog);
            pluginController.AddStrokePlugin(strokeNumLog.ProcessName);
            pluginController.AddStrokePlugin(strokeTimeLog);
            try
            {
                pluginController.Load();
                pluginController.Init();
            }
            catch (IOException)
            {
                MessageBox.Show("Ot@C̓ǂݍ݂Ɏs܂B" + Environment.NewLine +
                        "Ot@CҏWĂvZXꍇ͏IĂB", Properties.Resources.ApplicationName);
                keyHook.Dispose();
                this.Enabled = false;
                return;
            }
            pluginController.AddMenu(PluginMenu);

            // L[͂ɉđŌOGUIɔfNX
            keyStrokeView = new KeyStrokeView(this, strokeNumLog);
            keyStrokeView.DayStrokeViewLoad();
            // ׂẴvZX̃ACRǂݍނ悤ɂĂƋ낵Ԃ
            keyStrokeView.ProcessViewLoad();
            keyStrokeView.MainTabLoad();

            // ŌԂtH[ɔf
            strokeTimeView = new StrokeTimeView(strokeTimeLog, TodayStrokeTime, HourStrokeTime,
                TodaySpecificStrokeTime, HourSpecificStrokeTime);

            // NotifyIconi^XNgCACRj̃eLXgύX
            notifyIcon1.Text = string.Format(":{0}{1}:{2}{3}v:{4}",
                strokeNumLog.TodayTotalType, Environment.NewLine,
                strokeNumLog.YesterdayTotalType, Environment.NewLine,
                strokeNumLog.TotalType);

            // ǂݍAppConfigGUIɔf
            SetProcessViewType();       // vZXʑŌ̕\^Cṽ`FbN
            SetSaveTitleStrokeMenu();   // ^Cgʂ̑Ōۑ邩̃`FbN
            SetGraphMarkCheck(AppConfig.MarkType); // Otɂ}[N

            // OtɊւݒ
            graphChanger = new GraphChanger(HistoryPicture, HistoryMaxValue, HistoryMinValue,
                TypeSpeedPicture, TypeSpeedText, textBox6);
            graphChanger.SetMargin(HistoryMaxValue.Width+3, 1, 5, 3);
            graphChanger.SetGraph(LineGraphType.StrokeNumPerMinute, "Ō̗(1)", 60, 200, "{1} ({0}O)");
            graphChanger.SetGraph(LineGraphType.StrokeNumPerHour, "Ō̗(1Ԃ)", 24, 5000, "{1} ({0}ԑO)");
            graphChanger.SetGraph(LineGraphType.StrokeNumPerDay, "Ō̗(1)", 30, 5000, "{1} ({0}O)");
            graphChanger.SetGraph(LineGraphType.TypeSpeedPerStroke, "Ōx̗i/j", 60, 200, "{1:f0}/");
            graphChanger.SetMarkSize(LineGraphMarkType.Plus, 4);
            graphChanger.SetMarkSize(LineGraphMarkType.Square, 3);
            graphChanger.SetMarkSize(LineGraphMarkType.VerticalBar, 4);
            graphChanger.SetMarkSize(LineGraphMarkType.HorizonBar, 4);
            graphChanger.SetDataSource(strokeNumLog, typingSpeed);

            // Otɂ}[N̕ύX
            graphChanger.SetGraphMark(AppConfig.MarkType);

            // Otɒl̐ݒ
            graphChanger.SetGraphValue();

            // Ot̍XV
            HistoryGraphName.Text = graphChanger[AppConfig.LineGraphType].GraphName;

            // Timergp^XN̓o^
            timerTaskController = new TimerTaskController();
            timerTaskController.AddTask(strokeNumLog, StrokeNumLog.TIMER_ID_NEWDAY, 1, 0, 0);
            timerTaskController.AddTask(pluginController, PluginController.TIMER_ID_AUTOSAVE, 0, AppConfig.ScheduleTiming, 0);
            timerTaskController.AddTask(graphChanger, GraphChanger.TIMER_ID_UPDATE, 0, 0, 1);
            timerTaskController.AddTask(strokeTimeLog, StrokeTimeLog.TIMER_ID_COUNT, 0, 0, 1);
            timerTaskController.AddTask(strokeTimeView, StrokeTimeView.TIMER_ID_UPDATE, 0, 0, 1);
        }

        /// <summary>
        /// L[̏グƂɌĂяotbNvV[W
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void keyHookProc(object sender, KeyboardHookedEventArgs e)
        {
            uint now = QueryTime.NowMiliSec;
            string app_title = ProcessWindowName.GetFrontWindowTitle();
            string app_path = lastAppPath;
            if (!AppConfig.GetAppPathByTitleChange || app_title != lastAppTitle)
            {
                lastAppTitle = app_title;
                lastAppPath = app_path = ProcessWindowName.GetFrontProcessName();
            }
            

            if (e.UpDown == KeyboardUpDown.Down)
            {
                keyState.KeyDown((int)e.KeyCode);
                pluginController.KeyDown(keyState, now, app_path, app_title);
                keyState.SetDownState();
                /*
                if (keyStatePlugin.IsPushKey(e.KeyCode))
                {
                    Console.WriteLine((char)e.KeyCode + ":" + e.KeyCode.ToString("d") + ":" + e.ScanCode.ToString("d") + ":push");
                }
                */
                //Console.WriteLine(e.KeyCode.ToString("d") + ":" + e.ScanCode.ToString("d") + ":down");
            }
            else
            {
                keyState.KeyUp((int)e.KeyCode);
                pluginController.KeyUp(keyState, now, app_path, app_title);
                //Debug.WriteLine(QueryTime.Now);
                //Console.WriteLine(e.KeyCode.ToString("d") + ":" + e.ScanCode.ToString("d") + ":up");
                typingSpeed.Stroke(now);
            }
            notifyIcon1.Text = string.Format(":{0}{1}:{2}{3}v:{4}",
                strokeNumLog.TodayTotalType, Environment.NewLine,
                strokeNumLog.YesterdayTotalType, Environment.NewLine,
                strokeNumLog.TotalType);
            UpdateKeyEventInfo(e.UpDown, (int)e.KeyCode, app_path);
        }

        private void UpdateKeyEventInfo(KeyboardUpDown updown, int vkey, string app_path)
        {
            LastEventType.Text = updown.ToString();
            LastKeyCode.Text = vkey.ToString();
            LastKeyName.Text = VirtualKeyName.GetKeyName(vkey);
            LastAppPath.Text = Path.GetFileName(app_path);
        }

        /// <summary>
        /// ĨOۑȂ
        /// AvP[VIs
        /// ̊֐𒼐ڎgȂthis.Close()gƁD
        /// Form1_FormClosingĂ΂āC炳AppFinalize()Ă΂D
        /// </summary>
        /// <returns></returns>
        private bool AppFinalize()
        {
            if (AppConfig.ShowExitMessage)
            {
                DialogResult res = MessageBox.Show("I܂H", "ImF",
                    MessageBoxButtons.OKCancel);
                if (res == DialogResult.Cancel)
                {
                    return false;
                }
            }
            AppConfig.TabIndex = tabControl1.SelectedIndex;
            AppConfig.Save();
            try
            {
                pluginController.Close();
            }
            catch (IOException)
            {
                DialogResult result = MessageBox.Show("O̕ۑɎs܂B" + Environment.NewLine +
                    "Ot@CҏWĂvZXꍇ͏IĂB" +
                    "̂܂܋Iꍇ́u͂vCIȂꍇ́uvNbNĂB", Properties.Resources.ApplicationName, MessageBoxButtons.YesNo);
                if (result == DialogResult.No)
                {
                    return false;
                }
            }
            keyHook.Dispose();
            return true;
        }

        private void IToolStripMenuItem_Click(object sender, EventArgs e)
        {
            // FormClosing̒ŏȈs
            this.Close();
        }

        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            Debug.WriteLine("Form1_FormClosed");
            if (!AppFinalize())
            {
                e.Cancel = true;
            }
        }

        /// <summary>
        /// ftHg1bƂɃ^C}[Ă΂
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void timer1_Tick(object sender, EventArgs e)
        {
            if (timerTaskController != null)
            {
                try
                {
                    timerTaskController.CallTask(DateTime.Now);
                }
                catch (IOException)
                {
                    MessageBox.Show("O̕ۑɎs܂B" + Environment.NewLine +
                        "Ot@CҏWĂvZXꍇ͏IĂB", Properties.Resources.ApplicationName);
                }
            }
            DateTimeStatus.Text = DateTime.Now.ToString();
        }

        /// <summary>
        /// Ōx̏uԒlOt̕`
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void pictureBox1_Paint(object sender, PaintEventArgs e)
        {
            graphChanger.DrawGauge(e.Graphics);
        }

        /// <summary>
        /// uCv^u̗OtNbNꂽƂɌĂяo
        /// \Ot̎ނύX
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void pictureBox2_MouseClick(object sender, MouseEventArgs e)
        {
            if (e.Button == MouseButtons.Left)
            {
                Array type_array = Enum.GetValues(typeof(LineGraphType));
                int next = (int)AppConfig.LineGraphType + 1;
                next = next >= type_array.Length ? 0 : next;
                AppConfig.LineGraphType = (LineGraphType)type_array.GetValue(next);

                HistoryGraphName.Text = graphChanger[AppConfig.LineGraphType].GraphName;
                graphChanger.SetGraphValue();
            }
        }

        private void pictureBox2_Paint(object sender, PaintEventArgs e)
        {
            graphChanger[AppConfig.LineGraphType].Draw(e.Graphics);
        }

        #region Otɂ}[N̕ύX
        private void ȂToolStripMenuItem_Click(object sender, EventArgs e)
        {
            graphChanger.SetGraphMark(LineGraphMarkType.None);
            AppConfig.MarkType = LineGraphMarkType.None;
        }

        private void toolStripMenuItem2_Click(object sender, EventArgs e)
        {
            graphChanger.SetGraphMark(LineGraphMarkType.Plus);
            AppConfig.MarkType = LineGraphMarkType.Plus;
        }

        private void toolStripMenuItem3_Click(object sender, EventArgs e)
        {
            graphChanger.SetGraphMark(LineGraphMarkType.Square);
            AppConfig.MarkType = LineGraphMarkType.Square;
        }

        private void toolStripMenuItem4_Click(object sender, EventArgs e)
        {
            graphChanger.SetGraphMark(LineGraphMarkType.HorizonBar);
            AppConfig.MarkType = LineGraphMarkType.HorizonBar;
        }

        private void toolStripMenuItem5_Click(object sender, EventArgs e)
        {
            graphChanger.SetGraphMark(LineGraphMarkType.VerticalBar);
            AppConfig.MarkType = LineGraphMarkType.VerticalBar;
        }

        private void Ot̃}[NMToolStripMenuItem_DropDownItemClicked(object sender, ToolStripItemClickedEventArgs e)
        {
            foreach (ToolStripMenuItem menu in GraphMarkMenu.DropDownItems)
            {
                menu.Checked = false;
            }
        }

        /// <summary>
        /// w肵^CṽOt}[Nj[̃`FbNɔf
        /// </summary>
        /// <param name="type"></param>
        private void SetGraphMarkCheck(LineGraphMarkType type)
        {
            foreach (ToolStripMenuItem menu in GraphMarkMenu.DropDownItems)
            {
                menu.Checked = false;
            }
            if (type == LineGraphMarkType.Plus)
            {
                ToolStripMenuItem item = (ToolStripMenuItem)(GraphMarkMenu.DropDownItems[1]);
                item.Checked = true;
            }
            else if (type == LineGraphMarkType.Square)
            {
                ToolStripMenuItem item = (ToolStripMenuItem)(GraphMarkMenu.DropDownItems[2]);
                item.Checked = true;
            }
            else if (type == LineGraphMarkType.HorizonBar)
            {
                ToolStripMenuItem item = (ToolStripMenuItem)(GraphMarkMenu.DropDownItems[3]);
                item.Checked = true;
            }
            else if (type == LineGraphMarkType.VerticalBar)
            {
                ToolStripMenuItem item = (ToolStripMenuItem)(GraphMarkMenu.DropDownItems[4]);
                item.Checked = true;
            }
        }
        #endregion

        #region eXgr[̃\[g
        /// <summary>
        /// vZXʑŌXgr[̃\[g
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void listView1_ColumnClick(object sender, ColumnClickEventArgs e)
        {
            SortListView(ProcessStrokeView, e.Column);
        }

        /// <summary>
        /// ʑŌXgr[̃\[g
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void listView2_ColumnClick(object sender, ColumnClickEventArgs e)
        {
            SortListView(DayStrokeView, e.Column);
        }

        /// <summary>
        /// Xgr[Ɨw肵ă\[g
        /// </summary>
        /// <param name="view"></param>
        /// <param name="column"></param>
        private void SortListView(ListView view, int column)
        {
            NumSort sorter = (NumSort)view.ListViewItemSorter;
            sorter.Column = column;
            view.Sort();
            sorter.ChangeSortOrder();
        }
        #endregion

        private void X^[gAbvɓo^ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            ShortCut.Save(Path.Combine(Environment.GetFolderPath(Environment.SpecialFolder.Startup),
                "Ōtomo 2.0.lnk"), Application.ExecutablePath,
                Path.GetDirectoryName(Application.ExecutablePath), "Ōtomo 2.0ւ̃V[gJbg");
            MessageBox.Show(Properties.Resources.StartupRegist);
        }

        private void X^[gAbvToolStripMenuItem_Click(object sender, EventArgs e)
        {
            string path = Path.Combine(Environment.GetFolderPath(Environment.SpecialFolder.Startup),
                             "Ōtomo 2.0.lnk");
            if (File.Exists(path))
            {
                File.Delete(path);
            }
            MessageBox.Show(Properties.Resources.StartupUnregist);
        }

        /// <summary>
        /// uvZXʑŌv^uō̃vZXʑŌNbN
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void radioButton3_CheckedChanged(object sender, EventArgs e)
        {
            AppConfig.ProcessViewType = ProcessStrokeViewType.Today;
            keyStrokeView.ProcessViewLoad();
        }

        /// <summary>
        /// uvZXʑŌv^ułׂẴvZXʑŌNbN
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void radioButton4_CheckedChanged(object sender, EventArgs e)
        {
            AppConfig.ProcessViewType = ProcessStrokeViewType.All;
            keyStrokeView.ProcessViewLoad();
        }

        #region AppConfig̒lGUIj[̃`FbNԂɔf
        /// <summary>
        /// AppConfig̒lGUIj[̃`FbNԂɔf
        /// </summary>
        private void SetProcessViewType()
        {
            if (AppConfig.ProcessViewType == ProcessStrokeViewType.All)
            {
                ProcessViewTypeAll.Checked = true;
                ProcessViewTypeToday.Checked = false;
            }
            else
            {
                ProcessViewTypeToday.Checked = true;
                ProcessViewTypeAll.Checked = false;
            }
        }

        /// <summary>
        /// AppConfig̒lGUIj[̃`FbNԂɔf
        /// </summary>
        private void SetSaveTitleStrokeMenu()
        {
            if (AppConfig.SaveTitleStroke)
            {
                IsSaveTitleStroke.Checked = true;
            }
            else
            {
                IsSaveTitleStroke.Checked = false;
            }
        }

        /// <summary>
        /// GUI̕ύXAppConfigɔf
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void EBhE^Cgʂ̑ŌۑTToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (IsSaveTitleStroke.Checked)
            {
                AppConfig.SaveTitleStroke = true;
            }
            else
            {
                AppConfig.SaveTitleStroke = false;
            }
        }
        #endregion

        /// <summary>
        /// vZXʑŌXgr[ōڂENbNƂɌĂяo
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void listView1_MouseClick(object sender, MouseEventArgs e)
        {
            ListViewHitTestInfo info = listView1.HitTest(e.X, e.Y);
            if (info.SubItem != null &&
                AppConfig.ProcessViewType == ProcessStrokeViewType.Today &&
                e.Button == MouseButtons.Right)
            {
                string path = info.Item.Text;
                ContextMenu menu = MakeTitleListContextMenu(strokeNumLog, path);
                menu.Show(listView1, new Point(e.X + 10, e.Y + 20));
                Console.WriteLine(info.Item.Text);
            }
        }

        private ContextMenu MakeTitleListContextMenu(StrokeNumLog num_log, string app_path)
        {
            ContextMenu menu = new ContextMenu();
            string item_path = app_path;
            int app_id = num_log.ProcessName.GetID(item_path);

            if (app_id == -1)
            {
                return menu;
            }

            List<string> descend_title = num_log.AppLog[app_id].GetTitleList();
            List<int> title_total = new List<int>();
            for (int i = 0; i < descend_title.Count; i++)
            {
                // num_log.AppLog[app_id]app_id݂ȂƂO鋰ꂪ
                title_total.Add(
                    num_log.AppLog[app_id].GetTitleTotal(descend_title[i])
                );
            }
            List<int> order_list = Misc.SortOrder(title_total, true);
            for (int i = 0; i < descend_title.Count; i++)
            {
                string format = (string)AppConfig.RightClickCopyFormat.Clone();
                format = format.Replace("\\t", "\t");
                format = format.Replace("%1", title_total[order_list[i]].ToString());
                format = format.Replace("%2", descend_title[order_list[i]]);
                menu.MenuItems.Add(format);
                // eڂNbNƂɂ̃eLXgRs[
                menu.MenuItems[menu.MenuItems.Count - 1].Click += new EventHandler(Menu_Copy);
            }
            menu.MenuItems.Add("-");
            menu.MenuItems.Add("Nbv{[hɃRs[(&C)");

            // uNbv{[hɃRs[vj[NbNƂ
            // ẽj[QƂ邽߁CTagɓo^Ă
            menu.MenuItems[menu.MenuItems.Count - 1].Tag = menu;
            menu.MenuItems[menu.MenuItems.Count - 1].Click += new EventHandler(Title_Menu_Click);

            return menu;
        }

        /// <summary>
        /// vZXʑŌXgr[ŕ\j[
        /// uNbv{[hɃRs[vNbNƂɌĂяo
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        void Title_Menu_Click(object sender, EventArgs e)
        {
            MenuItem sender_item = (MenuItem)sender;
            ContextMenu menu = (ContextMenu)sender_item.Tag;
            
            string copy_text = "";
            for (int i = 0; i < menu.MenuItems.Count - 2; i++)
            {
                copy_text += menu.MenuItems[i].Text + Environment.NewLine;
            }
            if (copy_text != "")
            {
                // Nbv{[hɕRs[
                // AvP[VINbv{[hɎc
                Clipboard.SetText(copy_text);
            }
        }

        void Menu_Copy(object sender, EventArgs e)
        {
            MenuItem sender_item = (MenuItem)sender;
            string copy_text = sender_item.Text;
            if (copy_text != "")
            {
                // Nbv{[hɕRs[
                // AvP[VINbv{[hɎc
                Clipboard.SetText(copy_text);
            }
        }

        /// <summary>
        /// ʑŌXgr[̑IڂύXꂽƂɌĂяo
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void listView2_SelectedIndexChanged(object sender, EventArgs e)
        {
            int total = 0;
            int max = 0;
            int min = int.MaxValue;
            int item_num = listView2.SelectedItems.Count;
            float average = 0;

            foreach (ListViewItem item in listView2.SelectedItems)
            {
                int type_num = int.Parse(item.SubItems[2].Text);
                total += type_num;
                if(type_num > max) max = type_num;
                if(type_num < min) min = type_num;
            }
            
            // IڂȂꍇł\0ɖ߂߂returnȂ
            if (item_num == 0)
            {
                min = 0;
                average = 0;
            }
            else
            {
                average = total / item_num;
            }
            HibetuTotalType.Text = total.ToString();
            HibetuMaxType.Text = string.Format("{0}", max);
            HibetuMinType.Text = string.Format("{0}", min);
            HibetuAvgType.Text = string.Format("{0}", average);
            HibetuSelectNum.Text = item_num.ToString();
        }

        /// <summary>
        /// ʑŌXgr[̍ڂ"E"NbNƂɌĂяo
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void listView2_MouseClick(object sender, MouseEventArgs e)
        {
            ListViewHitTestInfo info = listView2.HitTest(e.X, e.Y);
            if (info.SubItem != null && e.Button == MouseButtons.Right)
            {
                DateTime date = (DateTime)info.Item.Tag;
                StrokeNumLog num_log = strokeNumLog;

                // ̃f[^ȊO̓OɕۑĂ̂ǂݍ
                if (date.ToString(Plugin.LogDir.DAY_FORMAT) != DateTime.Now.ToString(Plugin.LogDir.DAY_FORMAT))
                {
                    // t@C݂ȂĂv
                    num_log = new StrokeNumLog();
                    num_log.Load(date);
                }

                ContextMenu menu = new ContextMenu();
                List<AppKeyLog> app_list = new List<AppKeyLog>(num_log.AppLog.Values);
                List<int> num_list = new List<int>();
                for(int i=0; i<app_list.Count;i++)
                {
                    num_list.Add(app_list[i].Total);
                    //Console.WriteLine("{0} - [{1}]", app_list[i].AppID, num_list[i]);
                }
                List<int> order_list = Misc.SortOrder(num_list, true);
                
                /*
                Console.WriteLine("ёւ");
                for (int i = 0; i < app_list.Count; i++)
                {
                    Console.WriteLine("{0} - {1}",order_list[i], num_list[i]);
                }
                */
                for(int i=0; i<app_list.Count; i++)
                {
                    string app_name = num_log.ProcessName.GetName(
                                        app_list[order_list[i]].AppID);
                    string app_path = num_log.ProcessName.GetPath(
                                        app_list[order_list[i]].AppID);
                    Debug.WriteLine(string.Format("id:{0}, name:{1}, path:{2}",
                        app_list[order_list[i]].AppID,app_name,app_path));
                    int app_total = num_list[order_list[i]];

                    string format = (string)AppConfig.RightClickCopyFormat.Clone();
                    format = format.Replace("\\t", "\t");
                    format = format.Replace("%1", app_total.ToString());
                    format = format.Replace("%2", app_name);
                    menu.MenuItems.Add(format);
                    ContextMenu sub_menu = MakeTitleListContextMenu(num_log, app_path);
                    
                    if (sub_menu.MenuItems.Count > 2)
                    {
                        MenuItem[] menu_items = new MenuItem[sub_menu.MenuItems.Count];
                        for (int j = 0; j < sub_menu.MenuItems.Count; j++)
                        {
                            menu_items[j] = sub_menu.MenuItems[j].CloneMenu();
                        }
                        
                        //  sub_menu.MenuItems.CopyTo(menu_items,0)Ƃ
                        // ȉ̃XebvsƁCȂsub_menuMenuItemsۂɂȂ
                        // ̂悤CloneMenu()gƑvDDDȂ낤H
                        menu.MenuItems[menu.MenuItems.Count - 1].MenuItems.AddRange(menu_items);

                        menu.MenuItems[menu.MenuItems.Count - 1].MenuItems[menu_items.Length - 1].Tag = sub_menu;
                    }
                }
                menu.MenuItems.Add("-");
                menu.MenuItems.Add("Nbv{[hɃRs[(&C)");
                menu.MenuItems[menu.MenuItems.Count - 1].Tag = menu;
                menu.MenuItems[menu.MenuItems.Count - 1].Click += new EventHandler(Title_Menu_Click);

                menu.Show(listView2, new Point(e.X + 10, e.Y + 20));
            }
        }

        /// <summary>
        /// ʑŌXgr[ōڂ̏}EXhbOƂɌĂяo
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void listView2_MouseMove(object sender, MouseEventArgs e)
        {
            ListViewHitTestInfo info = listView2.HitTest(e.X, e.Y);
            if (info.SubItem != null && e.Button == MouseButtons.Left)
            {
                info.Item.Selected = true;
                // 24̓Xgr[wb_[̍C17̓ACe̍
                // 萔ɂ̂Ȃ񂩂ꂾ̂ŁDD
                if (info.Item.Position.Y < 24 + 17 && info.Item.Index > 1)
                {
                    listView2.EnsureVisible(info.Item.Index - 1);
                }
                else if (info.Item.Position.Y > listView2.Height - 24 && info.Item.Index < listView2.Items.Count - 1)
                {
                    listView2.EnsureVisible(info.Item.Index);
                }
            }
        }

        /// <summary>
        /// vZXʑŌXgr[Ctrl+AƂɌĂяo
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void listView1_KeyDown(object sender, KeyEventArgs e)
        {
            if (e.KeyCode == Keys.A && e.Modifiers == Keys.Control)
            {
                SelectAllListViewItem(listView1);
            }
            else if (e.KeyCode == Keys.F2 && listView1.SelectedItems.Count > 0)
            {
                ListViewItem item = listView1.SelectedItems[0];
                ListViewInputBox input = new ListViewInputBox(listView1, item, 1);
                input.FinishInput += new ListViewInputBox.InputEventHandler(input_FinishInput);
                input.Show();
            }
        }

        /// <summary>
        /// ʑŌXgr[Ctrl+AƂɌĂяo
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void listView2_KeyDown(object sender, KeyEventArgs e)
        {
            if (e.KeyCode == Keys.A && e.Modifiers == Keys.Control)
            {
                SelectAllListViewItem(listView2);
            }
        }

        /// <summary>
        /// Xgr[̃ACeׂđI
        /// </summary>
        /// <param name="view"></param>
        private void SelectAllListViewItem(ListView view)
        {
            foreach (ListViewItem item in view.Items)
            {
                item.Selected = true;
            }
        }

        private void listView1_MouseDoubleClick(object sender, MouseEventArgs e)
        {
            ListViewHitTestInfo info = listView1.HitTest(e.X, e.Y);
            if (info.SubItem != null && e.Button == MouseButtons.Left)
            {
                ListViewInputBox input = new ListViewInputBox(listView1, info.Item, 1);
                input.FinishInput += new ListViewInputBox.InputEventHandler(input_FinishInput);
                input.Show();
            }
        }

        void input_FinishInput(object sender, ListViewInputBox.InputEventArgs e)
        {
            //Console.WriteLine(e.Path);
            //Console.WriteLine(e.NewName);
            string old_name = strokeNumLog.ProcessName.GetName(e.Path);

            // OύXꂽƂXgr[̏ƕۑs
            if (old_name != e.NewName)
            {
                strokeNumLog.ProcessName.SetName(e.Path, e.NewName);
                strokeNumLog.ProcessName.Save();
                keyStrokeView.ProcessViewNameUpdate(e.Path, e.NewName);
            }
        }

        private void ɎOɕ\ToolStripMenuItem_CheckedChanged(object sender, EventArgs e)
        {
            AppConfig.TopMost = ɎOɕ\ToolStripMenuItem.Checked;
            this.TopMost = AppConfig.TopMost;
        }

        private void vOCꗗVToolStripMenuItem_Click(object sender, EventArgs e)
        {
            ViewPluginForm form = new ViewPluginForm(pluginController);
            form.ShowDialog(this);
        }

        #region ^XNgC֌W...
        protected override void WndProc(ref Message m)
        {
            if (m.Msg == WM_TaskbarCreated)
            {
                notifyIcon1.Visible = true;
            }
            base.WndProc(ref m);
        }

        private void notifyIcon1_MouseClick(object sender, MouseEventArgs e)
        {
            if (e.Button == MouseButtons.Left)
            {
                WindowOpen();
            }
        }

        private void WindowOpen()
        {
            if (this.WindowState == FormWindowState.Minimized)
            {
                this.Show();
                this.WindowState = FormWindowState.Normal;
            }
            this.Activate();
        }

        /// <summary>
        /// ^XNgCACR̃ReLXgj[NbNƂɌĂяo
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void JOToolStripMenuItem_Click(object sender, EventArgs e)
        {
            WindowOpen();
        }

        /// <summary>
        /// ^XNgCACR̃ReLXgj[NbNƂɌĂяo
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void CToolStripMenuItem_Click(object sender, EventArgs e)
        {
            this.Close();
        }
        #endregion

        private void Form1_Load(object sender, EventArgs e)
        {
            notifyIcon1.Icon = new Icon(Properties.Resources.TypingManager, new Size(16, 16));
        }

        private void Form1_Resize(object sender, EventArgs e)
        {
            if (WindowState == FormWindowState.Minimized)
            {
                Hide();
            }
        }

        private void ݒCToolStripMenuItem_Click(object sender, EventArgs e)
        {
            configForm.ScheduledLogging = AppConfig.ScheduleLogging;
            configForm.ScheduleLogTiming = AppConfig.ScheduleTiming;
            configForm.UseStandardHook = AppConfig.StandardHook;
            configForm.GetAppPathByTitleChange = AppConfig.GetAppPathByTitleChange;
            configForm.ShowExitMessage = AppConfig.ShowExitMessage;
            configForm.NoStrokeLimitTime = AppConfig.NoStrokeLimitTime;
            configForm.SelectedItemCopyFormat = AppConfig.SelectedItemCopyFormat;
            configForm.RightClickCopyFormat = AppConfig.RightClickCopyFormat;
            configForm.MinStrokeTimeSpeed = AppConfig.MinStrokeTimeSpeed;
            configForm.MaxStrokeTimeSpeed = AppConfig.MaxStrokeTimeSpeed;
            DialogResult result = configForm.ShowDialog(this);
            if (result == DialogResult.OK)
            {
                AppConfig.ScheduleLogging = configForm.ScheduledLogging;
                AppConfig.ScheduleTiming = configForm.ScheduleLogTiming;
                AppConfig.GetAppPathByTitleChange = configForm.GetAppPathByTitleChange;
                AppConfig.ShowExitMessage = configForm.ShowExitMessage;
                AppConfig.NoStrokeLimitTime = configForm.NoStrokeLimitTime;
                timerTaskController.AddTask(pluginController, PluginController.TIMER_ID_AUTOSAVE, 0, AppConfig.ScheduleTiming, 0);
                AppConfig.SelectedItemCopyFormat = configForm.SelectedItemCopyFormat;
                AppConfig.RightClickCopyFormat = configForm.RightClickCopyFormat;
                AppConfig.MinStrokeTimeSpeed = configForm.MinStrokeTimeSpeed;
                AppConfig.MaxStrokeTimeSpeed = configForm.MaxStrokeTimeSpeed;
                if (AppConfig.StandardHook != configForm.UseStandardHook)
                {
                    AppConfig.StandardHook = configForm.UseStandardHook;
                    MessageBox.Show(this,
                        "L[͊Ď@̐ݒ肪ύX܂B\n" +
                        "ݒ͍ċNɗLɂȂ܂B");
                }
            }
        }

        /// <summary>
        /// vZXʑŌr[ōڏhbOƂɌĂ΂
        /// {^Ȃ}EXړ̍ڂI
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void listView1_MouseMove(object sender, MouseEventArgs e)
        {
            ListViewHitTestInfo info = listView1.HitTest(e.X, e.Y);
            if (e.Button == MouseButtons.Left && info.SubItem != null)
            {
                info.Item.Selected = true;
                // 24̓Xgr[wb_[̍C17̓ACe̍
                // 萔ɂ̂Ȃ񂩂ꂾ̂ŁDD
                if (info.Item.Position.Y < 24 + 17 && info.Item.Index > 1)
                {
                    listView1.EnsureVisible(info.Item.Index - 1);
                }
                else if (info.Item.Position.Y > listView1.Height - 24 && info.Item.Index < listView1.Items.Count - 1)
                {
                    listView1.EnsureVisible(info.Item.Index);
                }
            }
        }

        private void IڂRs[CToolStripMenuItem_Click(object sender, EventArgs e)
        {
            ListView view = null;
            StringBuilder copy_text = new StringBuilder();
            switch (tabControl1.SelectedIndex)
            {
                case 1:
                    view = ProcessStrokeView;
                    break;
                case 2:
                    view = DayStrokeView;
                    break;
            }
            if (view != null)
            {
                foreach (ListViewItem item in view.SelectedItems)
                {
                    string line_format = (string)AppConfig.SelectedItemCopyFormat.Clone();
                    line_format = line_format.Replace("\\t", "\t");
                    for (int i = 0; i < item.SubItems.Count; i++)
                    {
                        string replace_mark = string.Format("%{0}",i+1);
                        line_format = line_format.Replace(replace_mark, item.SubItems[i].Text);
                    }
                    copy_text.AppendLine(line_format);
                }
            }
            if (copy_text.Length != 0)
            {
                // Nbv{[hɕRs[
                // AvP[VINbv{[hɎc
                Clipboard.SetText(copy_text.ToString());
            }
        }

        private void pictureBox2_MouseMove(object sender, MouseEventArgs e)
        {
            //Console.WriteLine("pictureBox2_MouseMove");
            Point p = Cursor.Position;
            graphChanger.MoveText(p.X, p.Y);
        }

        private void pictureBox2_MouseEnter(object sender, EventArgs e)
        {
            //Console.WriteLine("pictureBox2_MouseEnter");
            Point p = Cursor.Position;
            graphChanger.ShowText(p.X, p.Y);
        }

        private void pictureBox2_MouseLeave(object sender, EventArgs e)
        {
            //Console.WriteLine("pictureBox2_MouseLeave");
            graphChanger.HideText();
        }
    }
}
