/*
 * Decompiled with CFR 0.152.
 */
package org.ultramonkey.l7.model;

import java.net.ConnectException;
import java.net.Socket;
import java.util.HashSet;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.ultramonkey.l7.controller.DirectorController;
import org.ultramonkey.l7.controller.DirectorData;
import org.ultramonkey.l7.controller.L7vsConfController;
import org.ultramonkey.l7.controller.L7vsConfData;
import org.ultramonkey.l7.controller.LogSet;
import org.ultramonkey.l7.model.FileNotReadException;
import org.ultramonkey.l7.model.FileNotWriteException;
import org.ultramonkey.l7.model.L7SyncSocket;
import org.ultramonkey.l7.model.MessageView;
import org.ultramonkey.l7.model.Parameter;
import org.ultramonkey.l7.model.Payload;
import org.ultramonkey.l7.model.SyncCategoryIdSet;
import org.ultramonkey.l7.model.UserData;
import org.ultramonkey.l7.model.UserManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class L7SyncManager {
    protected Logger debugLogger = Logger.getLogger((String)"l7sync_Sync");
    protected Logger debugDirectorLogger = Logger.getLogger((String)"l7sync_Sync.DirectorData");
    protected Logger debugL7vsdConfLogger = Logger.getLogger((String)"l7sync_Sync.L7vsdConfData");
    protected Logger debugUserLogger = Logger.getLogger((String)"l7sync_Sync.UserData");
    protected String categoryName;
    protected String actHost;
    protected String sbyHost;
    protected int sbyPort;
    protected Logger logger = Logger.getLogger((String)"l7sync_Sync");
    protected Logger directorLogger = Logger.getLogger((String)"l7sync_Sync.DirectorData");
    protected Logger l7vsdConfLogger = Logger.getLogger((String)"l7sync_Sync.L7vsdConfData");
    protected Logger userLogger = Logger.getLogger((String)"l7sync_Sync.UserData");

    public L7SyncManager() {
        if (this.debugLogger.isDebugEnabled()) {
            this.debugLogger.debug((Object)"11058 class L7SyncManager created.");
        }
        Parameter parameter = Parameter.getInstance();
        this.actHost = parameter.getValue("actHost");
        this.sbyHost = parameter.getValue("sbyHost");
        this.sbyPort = Integer.parseInt(parameter.getValue("sbyPort"));
    }

    public void syncAct(HashSet<Integer> categoryIdSet) throws MessageView {
        if (this.debugLogger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("L7SyncManager::syncAct(HashSet<Integer> categoryIdSet) throws MessageView in ");
            buf.append("categoryIdSet= " + categoryIdSet.toString());
            this.debugLogger.debug((Object)("11059 " + buf.toString()));
        }
        Vector<Payload> payloadVec = new Vector<Payload>();
        Payload payload = null;
        L7SyncSocket l7SyncSocket = new L7SyncSocket();
        for (int categoryId : categoryIdSet) {
            switch (this.getDataTypeFromId(categoryId)) {
                case DIRECTORDATA: {
                    try {
                        DirectorController directorController = new DirectorController();
                        payload = new Payload(categoryId, directorController.getDirectorData());
                        break;
                    }
                    catch (Exception e) {
                        this.logger.error((Object)("41007 Failed to set DirectorData : " + e));
                        throw new MessageView(40012, "l7sync_StartStop", "Failed to set  DirectorData :" + e);
                    }
                }
                case L7VSCONFDATA: {
                    L7vsConfController l7vsConfController = new L7vsConfController();
                    try {
                        payload = new Payload(categoryId, l7vsConfController.getConfData());
                        break;
                    }
                    catch (FileNotReadException e) {
                        this.logger.error((Object)("41008 Failed to set L7vsConfData : " + e));
                        throw new MessageView(40013, "l7sync_Sync", "Failed to get data L7vsConfData :" + e);
                    }
                }
                case USERDATA: {
                    try {
                        UserManager userManager = new UserManager();
                        payload = new Payload(categoryId, userManager.getUserList());
                        break;
                    }
                    catch (FileNotReadException e) {
                        this.logger.error((Object)("41009 Failed to set L7vsdConfData : " + e));
                        throw new MessageView(40030, "l7sync_Sync", "Failed to get data UserData :" + e);
                    }
                }
                default: {
                    throw new MessageView(40027, "l7sync_StartStop", "Invalid category id.");
                }
            }
            payloadVec.add(payload);
        }
        try {
            if (this.sbyHost == null) {
                throw new ConnectException();
            }
            Socket socket = new Socket(this.sbyHost, this.sbyPort);
            l7SyncSocket.openConnection(socket.getInputStream(), socket.getOutputStream());
        }
        catch (Exception e) {
            this.logger.error((Object)("41010 Failed to open connection : " + e));
            throw new MessageView(40014, "l7sync_StartStop", "Failed to open connection");
        }
        this.sendRecv(l7SyncSocket, payloadVec);
        try {
            l7SyncSocket.closeConnection();
        }
        catch (MessageView m) {
            this.logger.error((Object)("41011 " + m.message));
            throw m;
        }
        if (this.debugLogger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("L7SyncManager::syncAct(HashSet<Integer> categoryIdSet) throws MessageView out ");
            this.debugLogger.debug((Object)("11060 " + buf.toString()));
        }
    }

    /*
     * Unable to fully structure code
     */
    public void syncSby() throws MessageView {
        if (this.debugLogger.isDebugEnabled()) {
            buf = new StringBuffer();
            buf.append("L7SyncManager::syncSby() throws MessageView in ");
            this.debugLogger.debug((Object)("11061 " + buf.toString()));
        }
        l7SyncSocket = new L7SyncSocket();
        recvPayload = null;
        try {
            l7SyncSocket.openConnection(System.in, System.out);
            if (true) ** GOTO lbl56
        }
        catch (MessageView m) {
            this.logger.error((Object)("41012 " + m.message));
            throw m;
        }
        do {
            try {
                recvPayload = new Payload(recvData);
                switch (L7SyncManager.$SWITCH_TABLE$org$ultramonkey$l7$model$L7SyncManager$SyncDataType()[this.getDataTypeFromId(recvPayload.categoryId).ordinal()]) {
                    case 1: {
                        directorController = new DirectorController();
                        try {
                            sbyDirectorData = this.compareDirectorData(recvPayload, directorController.getDirectorData());
                            if (sbyDirectorData == null) break;
                            directorController.setDirectorData(sbyDirectorData);
                            break;
                        }
                        catch (Exception e) {
                            throw new MessageView(40015, "l7sync_StartStop", "Failed to get data DirectorData");
                        }
                    }
                    case 2: {
                        l7vsConfController = new L7vsConfController();
                        try {
                            sbyL7vsConfData = this.compareL7vsConfData(recvPayload, l7vsConfController.getConfData());
                            if (sbyL7vsConfData == null) break;
                            l7vsConfController.setConfData(sbyL7vsConfData);
                            break;
                        }
                        catch (FileNotReadException e) {
                            throw new MessageView(40016, "l7sync_Sync", "Failed to get data L7vsConfData :" + e);
                        }
                        catch (FileNotWriteException e) {
                            throw new MessageView(40017, "l7sync_Sync", "Failed to set  L7vsConfData :" + e);
                        }
                    }
                    case 3: {
                        try {
                            userManager = new UserManager();
                            sbyUserVec = this.compareUserData(recvPayload, userManager.getUserList());
                            if (sbyUserVec == null) break;
                            userManager.setUserList(sbyUserVec);
                            break;
                        }
                        catch (Exception e) {
                            throw new MessageView(40018, "l7sync_StartStop", "Failed to get data userdata");
                        }
                    }
                    default: {
                        throw new MessageView(40028, "l7sync_StartStop", "Invalid category id.");
                    }
                }
                sendPayload = new Payload(1, new DirectorData());
                this.logger.info((Object)("21001 " + SyncCategoryIdSet.toCategoryName(recvPayload.categoryId) + " was synchronized."));
            }
            catch (MessageView m) {
                this.logger.error((Object)("41013 " + m.message));
                sendPayload = new Payload(2, new DirectorData());
            }
            l7SyncSocket.sendData(sendPayload.getMessage());
lbl56:
            // 2 sources

        } while ((recvData = l7SyncSocket.recvData()) != null);
        if (this.debugLogger.isDebugEnabled()) {
            buf = new StringBuffer();
            buf.append("L7SyncManager::syncSby() throws MessageView out ");
            this.debugLogger.debug((Object)("11062 " + buf.toString()));
        }
    }

    protected void sendRecv(L7SyncSocket l7SyncSocket, Vector<Payload> payloadVec) throws MessageView {
        if (this.debugLogger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("L7SyncManager::sendRecv(L7SyncSocket l7SyncSocket, Vector<Payload> payloadVec) throws MessageView in ");
            buf.append("l7SyncSocket= " + l7SyncSocket.toString() + ", ");
            buf.append("payloadVec= " + payloadVec.toString());
            this.debugLogger.debug((Object)("11063 " + buf.toString()));
        }
        for (Payload payload : payloadVec) {
            l7SyncSocket.sendData(payload.getMessage());
            Payload recvPayload = new Payload(l7SyncSocket.recvData());
            switch (recvPayload.categoryId) {
                case 2: {
                    this.logger.error((Object)("41014 Failed to synchronize  : " + SyncCategoryIdSet.toCategoryName(payload.categoryId)));
                    throw new MessageView(40019, "l7sync_Connection", "Failed to synchronize  : " + SyncCategoryIdSet.toCategoryName(payload.categoryId));
                }
                case 1: {
                    this.logger.info((Object)("21002 " + SyncCategoryIdSet.toCategoryName(payload.categoryId) + " was synchronized."));
                    break;
                }
                default: {
                    throw new MessageView(40029, "l7sync_StartStop", "Invalid category id.");
                }
            }
        }
        if (this.debugLogger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("L7SyncManager::sendRecv(L7SyncSocket l7SyncSocket, Vector<Payload> payloadVec) throws MessageView out ");
            this.debugLogger.debug((Object)("11064 " + buf.toString()));
        }
    }

    protected DirectorData compareDirectorData(Payload recvData, DirectorData sbyDirectorData) throws MessageView {
        if (this.debugDirectorLogger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("L7SyncManager::compareDirectorData(Payload recvData, DirectorData sbyDirectorData) throws MessageView in ");
            buf.append("recvData= " + recvData.toString() + ", ");
            buf.append("sbyDirectorData= " + sbyDirectorData.toString());
            this.debugDirectorLogger.debug((Object)("11065 " + buf.toString()));
        }
        DirectorData actDirectorData = recvData.getDirectorData();
        boolean needSync = false;
        switch (recvData.categoryId) {
            case 9: {
                if (actDirectorData.checkTimeOut != sbyDirectorData.checkTimeOut) {
                    this.directorLogger.info((Object)"21003 Different data between active server and stand-by server : checkTimeOut ");
                    sbyDirectorData.checkTimeOut = actDirectorData.checkTimeOut;
                    needSync = true;
                }
                if (actDirectorData.negotiateTimeOut != sbyDirectorData.negotiateTimeOut) {
                    this.directorLogger.info((Object)"21004 Different data between active server and stand-by server : negotiateTimeOut ");
                    sbyDirectorData.negotiateTimeOut = actDirectorData.negotiateTimeOut;
                    needSync = true;
                }
                if (actDirectorData.checkInterval != sbyDirectorData.checkInterval) {
                    this.directorLogger.info((Object)"21005 Different data between active server and stand-by server : checkInterval ");
                    sbyDirectorData.checkInterval = actDirectorData.checkInterval;
                    needSync = true;
                }
                if (actDirectorData.checkCount != sbyDirectorData.checkCount) {
                    this.directorLogger.info((Object)"21006 Different data between active server and stand-by server : checkCount ");
                    sbyDirectorData.checkCount = actDirectorData.checkCount;
                    needSync = true;
                }
                if (actDirectorData.autoreload != sbyDirectorData.autoreload) {
                    this.directorLogger.info((Object)"21007 Different data between active server and stand-by server : autoreload ");
                    sbyDirectorData.autoreload = actDirectorData.autoreload;
                    needSync = true;
                }
                if (!actDirectorData.callback.equals(sbyDirectorData.callback)) {
                    this.directorLogger.info((Object)"21008 Different data between active server and stand-by server : callback ");
                    sbyDirectorData.callback = actDirectorData.callback;
                    needSync = true;
                }
                if (!actDirectorData.fallback.equals(sbyDirectorData.fallback)) {
                    this.directorLogger.info((Object)"21009 Different data between active server and stand-by server : fallback ");
                    sbyDirectorData.fallback = actDirectorData.fallback;
                    needSync = true;
                }
                if (!actDirectorData.logfile.equals(sbyDirectorData.logfile)) {
                    this.directorLogger.info((Object)"21010 Different data between active server and stand-by server : logfile ");
                    sbyDirectorData.logfile = actDirectorData.logfile;
                    needSync = true;
                }
                if (!actDirectorData.execute.equals(sbyDirectorData.execute)) {
                    this.directorLogger.info((Object)"21011 Different data between active server and stand-by server : execute ");
                    sbyDirectorData.execute = actDirectorData.execute;
                    needSync = true;
                }
                if (!actDirectorData.supervised.equals(sbyDirectorData.supervised)) {
                    this.directorLogger.info((Object)"21012 Different data between active server and stand-by server : supervised ");
                    sbyDirectorData.supervised = actDirectorData.supervised;
                    needSync = true;
                }
                if (actDirectorData.quiescent.equals(sbyDirectorData.quiescent)) break;
                this.directorLogger.info((Object)"21013 Different data between active server and stand-by server : quiescent ");
                sbyDirectorData.quiescent = actDirectorData.quiescent;
                needSync = true;
                break;
            }
            case 10: {
                if (actDirectorData.virtualSettings.size() != sbyDirectorData.virtualSettings.size()) {
                    sbyDirectorData.virtualSettings = actDirectorData.virtualSettings;
                    this.directorLogger.info((Object)"21014 Different data between active server and stand-by server : virtualSettings ");
                    needSync = true;
                    break;
                }
                if (actDirectorData.virtualSettings.equals(sbyDirectorData.virtualSettings)) break;
                sbyDirectorData.virtualSettings = actDirectorData.virtualSettings;
                needSync = true;
                break;
            }
            default: {
                throw new MessageView(40020, "l7sync_Sync.DirectorData", "Invalid category id.");
            }
        }
        if (!needSync) {
            this.directorLogger.info((Object)("21015 The same data between active server and stand-by server : " + SyncCategoryIdSet.toCategoryName(recvData.categoryId)));
            if (this.debugDirectorLogger.isDebugEnabled()) {
                StringBuffer buf = new StringBuffer();
                buf.append("L7SyncManager::compareDirectorData(Payload recvData, DirectorData sbyDirectorData) throws MessageView out ");
                buf.append("return= null");
                this.debugDirectorLogger.debug((Object)("11066 " + buf.toString()));
            }
            return null;
        }
        if (this.debugDirectorLogger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("L7SyncManager::compareDirectorData(Payload recvData, DirectorData sbyDirectorData) throws MessageView out ");
            buf.append("return= " + sbyDirectorData.toString());
            this.debugDirectorLogger.debug((Object)("11067 " + buf.toString()));
        }
        return sbyDirectorData;
    }

    protected Vector<UserData> compareUserData(Payload recvData, Vector<UserData> sbyUserVec) throws MessageView {
        if (this.debugUserLogger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("L7SyncManager::compareUserData(Payload recvData, Vector<UserData> sbyUserVec) throws MessageView in ");
            buf.append("recvData= " + recvData.toString() + ", ");
            buf.append("sbyUserVec= " + sbyUserVec.toString());
            this.debugUserLogger.debug((Object)("11068 " + buf.toString()));
        }
        if (11 != recvData.categoryId) {
            throw new MessageView(40021, "l7sync_Sync.UserData", "Invalid category id.");
        }
        Vector<UserData> actUserVec = recvData.getUserData();
        if (actUserVec.size() != sbyUserVec.size() || !actUserVec.equals(sbyUserVec)) {
            this.userLogger.info((Object)("21016 Different data between active server and stand-by server : " + SyncCategoryIdSet.toCategoryName(recvData.categoryId)));
            if (this.debugUserLogger.isDebugEnabled()) {
                StringBuffer buf = new StringBuffer();
                buf.append("L7SyncManager::compareUserData(Payload recvData, Vector<UserData> sbyUserVec) throws MessageView out ");
                buf.append("return= " + actUserVec.toString());
                this.debugUserLogger.debug((Object)("11069 " + buf.toString()));
            }
            return actUserVec;
        }
        this.userLogger.info((Object)("21017 The same data between active server and stand-by server : " + SyncCategoryIdSet.toCategoryName(recvData.categoryId)));
        if (this.debugUserLogger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("L7SyncManager::compareUserData(Payload recvData, Vector<UserData> sbyUserVec) throws MessageView out ");
            buf.append("return= null");
            this.debugUserLogger.debug((Object)("11070 " + buf.toString()));
        }
        return null;
    }

    protected L7vsConfData compareL7vsConfData(Payload recvData, L7vsConfData sbyL7vsdConfData) throws MessageView {
        if (this.debugL7vsdConfLogger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("L7SyncManager::compareL7vsConfData(Payload recvData, L7vsConfData sbyL7vsdConfData) throws MessageView in ");
            buf.append("recvData= " + recvData.toString() + ", ");
            buf.append("sbyL7vsdConfData= " + sbyL7vsdConfData.toString());
            this.debugL7vsdConfLogger.debug((Object)("11071 " + buf.toString()));
        }
        L7vsConfData actL7vsdConfData = recvData.getL7vsdConfData();
        boolean needSync = false;
        L7vsConfController confController = new L7vsConfController();
        switch (recvData.categoryId) {
            case 3: {
                needSync = this.compareLogSettings(actL7vsdConfData.logger.lbLog, sbyL7vsdConfData.logger.lbLog);
                if (!needSync) break;
                sbyL7vsdConfData.logger.lbLog = actL7vsdConfData.logger.lbLog;
                break;
            }
            case 4: {
                needSync = this.compareLogSettings(actL7vsdConfData.logger.admLog, sbyL7vsdConfData.logger.admLog);
                if (!needSync) break;
                sbyL7vsdConfData.logger.admLog = actL7vsdConfData.logger.admLog;
                break;
            }
            case 5: {
                needSync = this.compareLogSettings(actL7vsdConfData.logger.snmpLog, sbyL7vsdConfData.logger.snmpLog);
                if (!needSync) break;
                sbyL7vsdConfData.logger.snmpLog = actL7vsdConfData.logger.snmpLog;
                break;
            }
            case 12: {
                boolean lbLogFlg = this.compareLogSettings(actL7vsdConfData.logger.lbLog, sbyL7vsdConfData.logger.lbLog);
                boolean admLogFlg = this.compareLogSettings(actL7vsdConfData.logger.admLog, sbyL7vsdConfData.logger.admLog);
                boolean snmpLogFlg = this.compareLogSettings(actL7vsdConfData.logger.snmpLog, sbyL7vsdConfData.logger.snmpLog);
                boolean bl = needSync = lbLogFlg || admLogFlg || snmpLogFlg;
                if (!needSync) break;
                sbyL7vsdConfData.logger.lbLog = actL7vsdConfData.logger.lbLog;
                sbyL7vsdConfData.logger.admLog = actL7vsdConfData.logger.admLog;
                sbyL7vsdConfData.logger.snmpLog = actL7vsdConfData.logger.snmpLog;
                break;
            }
            case 6: {
                if (actL7vsdConfData.replicationInterval == sbyL7vsdConfData.replicationInterval) break;
                this.logger.info((Object)"21018 Different data between active server and stand-by server: Replication");
                sbyL7vsdConfData.replicationInterval = actL7vsdConfData.replicationInterval;
                needSync = true;
                break;
            }
            case 7: {
                if (actL7vsdConfData.snmpInterval == sbyL7vsdConfData.snmpInterval) break;
                this.logger.info((Object)"21019 Different data between active server and stand-by server: snmpInterval");
                sbyL7vsdConfData.snmpInterval = actL7vsdConfData.snmpInterval;
                needSync = true;
                break;
            }
            case 8: {
                if (actL7vsdConfData.admCmdInterval != sbyL7vsdConfData.admCmdInterval) {
                    this.logger.info((Object)"21020 Different data between active server and stand-by server: admCmdInterval");
                    sbyL7vsdConfData.admCmdInterval = actL7vsdConfData.admCmdInterval;
                    needSync = true;
                }
                if (actL7vsdConfData.admCmdCount != sbyL7vsdConfData.admCmdCount) {
                    this.logger.info((Object)"21021 Different data between active server and stand-by server: admCmdCount");
                    sbyL7vsdConfData.admCmdCount = actL7vsdConfData.admCmdCount;
                    needSync = true;
                }
                if (actL7vsdConfData.admConInterval != sbyL7vsdConfData.admConInterval) {
                    this.logger.info((Object)"21022 Different data between active server and stand-by server: admConInterval");
                    sbyL7vsdConfData.admConInterval = actL7vsdConfData.admConInterval;
                    needSync = true;
                }
                if (actL7vsdConfData.admConCount == sbyL7vsdConfData.admConCount) break;
                this.logger.info((Object)"21023 Different data between active server and stand-by server: admConCount");
                sbyL7vsdConfData.admConCount = actL7vsdConfData.admConCount;
                needSync = true;
                break;
            }
            default: {
                this.l7vsdConfLogger.error((Object)"41015 Invalid category id.");
                throw new MessageView(40022, "l7sync_Sync.L7vsdConfData", "Invalid category id.");
            }
        }
        if (!needSync) {
            this.l7vsdConfLogger.info((Object)("21024 The same data between active server and stand-by server : " + SyncCategoryIdSet.toCategoryName(recvData.categoryId)));
            if (this.debugL7vsdConfLogger.isDebugEnabled()) {
                StringBuffer buf = new StringBuffer();
                buf.append("L7SyncManager::compareL7vsConfData(Payload recvData, L7vsConfData sbyL7vsdConfData) throws MessageView out ");
                buf.append("return= null");
                this.debugL7vsdConfLogger.debug((Object)("11072 " + buf.toString()));
            }
            return null;
        }
        if (this.debugL7vsdConfLogger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("L7SyncManager::compareL7vsConfData(Payload recvData, L7vsConfData sbyL7vsdConfData) throws MessageView out ");
            buf.append("return= " + sbyL7vsdConfData.toString());
            this.debugL7vsdConfLogger.debug((Object)("11073 " + buf.toString()));
        }
        return sbyL7vsdConfData;
    }

    protected SyncDataType getDataTypeFromId(int categoryId) throws MessageView {
        StringBuffer buf;
        if (this.debugLogger.isDebugEnabled()) {
            buf = new StringBuffer();
            buf.append("L7SyncManager::getDataTypeFromId(int categoryId) throws MessageView in ");
            buf.append("categoryId=" + categoryId);
            this.debugLogger.debug((Object)("11074 " + buf.toString()));
        }
        switch (categoryId) {
            case 9: 
            case 10: {
                if (this.debugLogger.isDebugEnabled()) {
                    buf = new StringBuffer();
                    buf.append("L7SyncManager::getDataTypeFromId(int categoryId) throws MessageView out ");
                    buf.append("return= SyncDataType.DIRECTORDATA");
                    this.debugLogger.debug((Object)("11075 " + buf.toString()));
                }
                return SyncDataType.DIRECTORDATA;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: {
                if (this.debugLogger.isDebugEnabled()) {
                    buf = new StringBuffer();
                    buf.append("L7SyncManager::getDataTypeFromId(int categoryId) throws MessageView out ");
                    buf.append("return= SyncDataType.L7VSCONFDATA");
                    this.debugLogger.debug((Object)("11076 " + buf.toString()));
                }
                return SyncDataType.L7VSCONFDATA;
            }
            case 11: {
                if (this.debugLogger.isDebugEnabled()) {
                    buf = new StringBuffer();
                    buf.append("L7SyncManager::getDataTypeFromId(int categoryId) throws MessageView out ");
                    buf.append("return= SyncDataType.USERDATA");
                    this.debugLogger.debug((Object)("11077 " + buf.toString()));
                }
                return SyncDataType.USERDATA;
            }
        }
        throw new MessageView(40023, "l7sync_Sync", "Invalid category id.");
    }

    protected boolean compareLogSettings(LogSet actLogger, LogSet sbyLogger) {
        if (this.debugL7vsdConfLogger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("L7SyncManager::compareLogSettings(LogSet actLogger, LogSet sbyLogger) in ");
            buf.append("actLogger= " + actLogger.toString() + ", ");
            buf.append("sbyLogger= " + sbyLogger.toString());
            this.debugL7vsdConfLogger.debug((Object)("11078 " + buf.toString()));
        }
        boolean syncFlag = false;
        if (!actLogger.logLevel.equals(sbyLogger.logLevel)) {
            this.l7vsdConfLogger.info((Object)"21025 Different data between active server and stand-by server : LogLevel ");
            syncFlag = true;
        }
        if (!actLogger.maxFileSize.equals(sbyLogger.maxFileSize)) {
            this.l7vsdConfLogger.info((Object)"21026 Different data between active server and stand-by server : maxFileSize ");
            syncFlag = true;
        }
        if (actLogger.maxBackupIndex != sbyLogger.maxBackupIndex) {
            this.l7vsdConfLogger.info((Object)"21027 Different data between active server and stand-by server : maxBackupIndex ");
            syncFlag = true;
        }
        if (!actLogger.fileName.equals(sbyLogger.fileName)) {
            this.l7vsdConfLogger.info((Object)"21028 Different data between active server and stand-by server : fileName ");
            syncFlag = true;
        }
        if (!actLogger.rotation.equals(sbyLogger.rotation)) {
            this.l7vsdConfLogger.info((Object)"21029 Different data between active server and stand-by server : rotation ");
            syncFlag = true;
        }
        if (this.debugL7vsdConfLogger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("L7SyncManager::compareLogSettings(LogSet actLogger, LogSet sbyLogger) out ");
            buf.append("return= " + syncFlag);
            this.debugL7vsdConfLogger.debug((Object)("11079 " + buf.toString()));
        }
        return syncFlag;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum SyncDataType {
        DIRECTORDATA,
        L7VSCONFDATA,
        USERDATA;

    }
}

