/*
 * Decompiled with CFR 0.152.
 */
package org.ultramonkey.l7.view;

import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.ultramonkey.l7.controller.EndPoint;
import org.ultramonkey.l7.controller.VirtualSetting;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationCheck {
    private Logger logger = Logger.getLogger((String)"l7gui_I/O");

    public ValidationCheck() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"11336 class ValidationCheck created.");
        }
    }

    public boolean vsCheck(HashMap<String, String> inputVsMap, HashMap<String, String> invalidMap, VirtualSetting vs) {
        String sorry_port;
        String rs_weight;
        String rs_port;
        String rs_ip;
        String db;
        String login_pass;
        String login_user;
        String virtual_host;
        String method;
        String receive;
        String request;
        String check_port;
        String up_callback;
        String down_callback;
        String quiescent;
        String check_service;
        Pattern pattern;
        Matcher matcher;
        String check_type;
        String timeout;
        String max_conn;
        String sched;
        String option;
        String port;
        if (this.logger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("ValidationCheck::vsCheck(HashMap<String, String> inputVsMap, HashMap<String, String> invalidMap, VirtualSetting vs) in ");
            buf.append("inputVsMap=(" + inputVsMap + "), ");
            buf.append("invalidMap=(" + invalidMap + "), ");
            buf.append("vs=(" + vs + ")");
            this.logger.debug((Object)("11337 " + buf.toString()));
        }
        boolean validationFlag = true;
        boolean MIN_IP = false;
        int MAX_IP = 255;
        int PARTITION = 4;
        boolean MIN_PORT = true;
        int MAX_PORT = 65535;
        int MAX_PORT_LENGTH = 10;
        int MAX_OPTION_LENGTH = 127;
        long MIN_QOS_SERVICE = 0L;
        long MAX_QOS_SERVICE = 999L;
        long MIN_QOS_CON = 0L;
        long MAX_QOS_CON = 999L;
        boolean MIN_CON = false;
        int MAX_CON = 100000;
        boolean MIN_TIME_OUT = true;
        int MAX_TIME_OUT = Integer.MAX_VALUE;
        int MAX_CHECK_TYPE_LENGTH = 10;
        int DOWN_CALLBACK_LENGTH = 127;
        int UP_CALLBACK_LENGTH = 127;
        boolean MIN_CHECKPORT = true;
        int MAX_CHECKPORT = 65535;
        int MAX_REQUEST_LENGTH = 127;
        int MAX_RECEIVE_LENGTH = 127;
        int MAX_VIRTUAL_HOST_LENGTH = 127;
        int MAX_LOGIN_USER_LENGTH = 32;
        int MAX_LOGIN_PASS_LENGTH = 32;
        int MAX_DB_LENGTH = 32;
        boolean MIN_WEIGHT = false;
        int MAX_WEIGHT = 100;
        String vip = inputVsMap.get("vip");
        if (vip == null || vip.length() == 0) {
            invalidMap.put("vip", "Required fields.");
            validationFlag = false;
        } else if (vip.equals("0.0.0.0")) {
            invalidMap.put("vip", "Invalid value.");
            validationFlag = false;
        } else {
            String[] tmp_vip = vip.split("\\.", 4);
            int int_vip = 0;
            if (tmp_vip.length != 4) {
                invalidMap.put("vip", "Invalid value.");
                validationFlag = false;
            } else {
                int i = 0;
                while (i < 4) {
                    block138: {
                        try {
                            int_vip = Integer.parseInt(tmp_vip[i]);
                            if (int_vip < 0 || int_vip > 255) {
                                invalidMap.put("vip", "Invalid value.");
                                validationFlag = false;
                            }
                            break block138;
                        }
                        catch (NumberFormatException e) {
                            invalidMap.put("vip", "Invalid value.");
                            validationFlag = false;
                        }
                        break;
                    }
                    ++i;
                }
            }
        }
        if (vip != null) {
            vs.virtual.host = vip;
        }
        if ((port = inputVsMap.get("port")) == null || port.length() == 0) {
            invalidMap.put("port", "Required fields.");
            validationFlag = false;
        } else {
            block139: {
                try {
                    int int_port = Integer.parseInt(port);
                    if (int_port < 1 || int_port > 65535) {
                        invalidMap.put("port", "Invalid value.");
                        validationFlag = false;
                    }
                }
                catch (NumberFormatException e) {
                    Pattern pattern2 = Pattern.compile("[^\\x20-\\x7e]");
                    Matcher matcher2 = pattern2.matcher(port);
                    if (port.length() <= 10 && !matcher2.find()) break block139;
                    invalidMap.put("port", "Invalid value.");
                    validationFlag = false;
                }
            }
            vs.virtual.port = port;
        }
        String protomod = inputVsMap.get("protomod");
        if (protomod != null && protomod.length() == 0) {
            invalidMap.put("protomod", "Required fields.");
            validationFlag = false;
        } else if (protomod == null || !protomod.equals("cinsert") && !protomod.equals("url") && !protomod.equals("sslid") && !protomod.equals("sessionless")) {
            invalidMap.put("protomod", "Invalid value.");
            validationFlag = false;
        }
        if (protomod != null) {
            vs.protomod = protomod;
        }
        if ((option = inputVsMap.get("option")) != null && option.length() > 0) {
            Pattern pattern3 = Pattern.compile("[^\\x20-\\x7e]");
            Matcher matcher3 = pattern3.matcher(option);
            if (option.length() > 127 || matcher3.find()) {
                invalidMap.put("option", "Invalid value.");
                validationFlag = false;
            }
        }
        if (option != null) {
            vs.option = option;
        }
        if (vs.getKey() == null) {
            invalidMap.put("option", "Invalid value.");
            validationFlag = false;
        }
        if ((sched = inputVsMap.get("sched")) != null && sched.length() == 0) {
            invalidMap.put("sched", "Required fields.");
            validationFlag = false;
        } else if (sched == null || !sched.equals("rr") && !sched.equals("wrr") && !sched.equals("lc")) {
            invalidMap.put("sched", "Invalid value.");
            validationFlag = false;
        }
        if (sched != null) {
            vs.sched = sched;
        }
        String qos_service = inputVsMap.get("qos_service");
        String qos_service_unit = inputVsMap.get("qos_service_unit");
        if (qos_service != null && qos_service.length() > 0) {
            long long_qos_service = 0L;
            try {
                long_qos_service = Long.parseLong(qos_service);
                if (long_qos_service < 0L || long_qos_service > 999L) {
                    invalidMap.put("qos_service", "Invalid value.");
                    validationFlag = false;
                } else if (qos_service_unit == null || !qos_service_unit.equals("bps")) {
                    if (qos_service_unit != null && qos_service_unit.equals("Kbps")) {
                        long_qos_service *= 1000L;
                    } else if (qos_service_unit != null && qos_service_unit.equals("Mbps")) {
                        long_qos_service *= 1000000L;
                    } else if (qos_service_unit != null && qos_service_unit.equals("Gbps")) {
                        long_qos_service *= 1000000000L;
                    } else {
                        invalidMap.put("qos_service", "Invalid value.");
                        validationFlag = false;
                    }
                }
            }
            catch (NumberFormatException e) {
                invalidMap.put("qos_service", "Invalid value.");
                validationFlag = false;
            }
            vs.qosservice = long_qos_service;
        }
        String qos_conn = inputVsMap.get("qos_conn");
        String qos_conn_unit = inputVsMap.get("qos_conn_unit");
        if (qos_conn != null && qos_conn.length() > 0) {
            long long_qos_conn = 0L;
            try {
                long_qos_conn = Long.parseLong(qos_conn);
                if (long_qos_conn < 0L || long_qos_conn > 999L) {
                    invalidMap.put("qos_conn", "Invalid value.");
                    validationFlag = false;
                } else if (qos_conn_unit == null || !qos_conn_unit.equals("bps")) {
                    if (qos_conn_unit != null && qos_conn_unit.equals("Kbps")) {
                        long_qos_conn *= 1000L;
                    } else if (qos_conn_unit != null && qos_conn_unit.equals("Mbps")) {
                        long_qos_conn *= 1000000L;
                    } else if (qos_conn_unit != null && qos_conn_unit.equals("Gbps")) {
                        long_qos_conn *= 1000000000L;
                    } else {
                        invalidMap.put("qos_conn", "Invalid value.");
                        validationFlag = false;
                    }
                }
            }
            catch (NumberFormatException e) {
                invalidMap.put("qos_conn", "Invalid value.");
                validationFlag = false;
            }
            vs.qosclient = long_qos_conn;
        }
        if ((max_conn = inputVsMap.get("max_conn")) != null && max_conn.length() > 0) {
            int int_max_conn = 0;
            try {
                int_max_conn = Integer.parseInt(max_conn);
                if (int_max_conn < 0 || int_max_conn > 100000) {
                    invalidMap.put("max_conn", "Invalid value.");
                    validationFlag = false;
                }
            }
            catch (NumberFormatException e) {
                invalidMap.put("max_conn", "Invalid value.");
                validationFlag = false;
            }
            vs.maxconn = int_max_conn;
        }
        if ((timeout = inputVsMap.get("timeout")) != null && timeout.length() > 0) {
            int int_timeout = 0;
            try {
                int_timeout = Integer.parseInt(timeout);
                if (int_timeout < 1 || int_timeout > Integer.MAX_VALUE) {
                    invalidMap.put("timeout", "Invalid value.");
                    validationFlag = false;
                }
            }
            catch (NumberFormatException e) {
                invalidMap.put("timeout", "Invalid value.");
                validationFlag = false;
            }
            vs.timeout = int_timeout;
        }
        if (!((check_type = inputVsMap.get("check_type")) == null || check_type.length() <= 0 || check_type.length() >= 10 || (matcher = (pattern = Pattern.compile("[0-9]")).matcher(check_type)).matches() || check_type.equals("negotiate") || check_type.equals("connect") || check_type.equals("ping") || check_type.equals("off") || check_type.equals("on"))) {
            invalidMap.put("check_type", "Invalid value.");
            validationFlag = false;
        }
        if (check_type != null) {
            vs.checktype = check_type;
        }
        if (!((check_service = inputVsMap.get("check_service")) == null || check_service.length() <= 0 || check_service.equals("ftp") || check_service.equals("smtp") || check_service.equals("dns") || check_service.equals("http") || check_service.equals("pop") || check_service.equals("nntp") || check_service.equals("imap") || check_service.equals("ldap") || check_service.equals("https") || check_service.equals("mysql") || check_service.equals("pgsql") || check_service.equals("dns") || check_service.equals("sip") || check_service.equals("none"))) {
            invalidMap.put("check_service", "Invalid value.");
            validationFlag = false;
        }
        if (check_service != null) {
            vs.service = check_service;
        }
        if ((quiescent = inputVsMap.get("quiescent")) != null && quiescent.length() > 0 && !quiescent.equals("yes") && !quiescent.equals("no")) {
            invalidMap.put("quiescent", "Invalid value.");
            validationFlag = false;
        }
        if (quiescent != null) {
            vs.quiescent = quiescent;
        }
        if ((down_callback = inputVsMap.get("down_callback")) != null && down_callback.length() > 0) {
            Pattern pattern4 = Pattern.compile("[^\\x20-\\x7e]");
            Matcher matcher4 = pattern4.matcher(down_callback);
            if (down_callback.length() > 127 || matcher4.find()) {
                invalidMap.put("down_callback", "Invalid value.");
                validationFlag = false;
            }
        }
        if (down_callback != null) {
            vs.downcallback = down_callback;
        }
        if ((up_callback = inputVsMap.get("up_callback")) != null && up_callback.length() > 0) {
            Pattern pattern5 = Pattern.compile("[^\\x20-\\x7e]");
            Matcher matcher5 = pattern5.matcher(up_callback);
            if (up_callback.length() > 127 || matcher5.find()) {
                invalidMap.put("up_callback", "Invalid value.");
                validationFlag = false;
            }
        }
        if (up_callback != null) {
            vs.upcallback = up_callback;
        }
        if ((check_port = inputVsMap.get("check_port")) != null && check_port.length() > 0) {
            int int_checkport = 0;
            try {
                int_checkport = Integer.parseInt(check_port);
                if (int_checkport < 1 || int_checkport > 65535) {
                    invalidMap.put("check_port", "Invalid value.");
                    validationFlag = false;
                }
            }
            catch (NumberFormatException e) {
                invalidMap.put("check_port", "Invalid value.");
                validationFlag = false;
            }
            vs.checkport = int_checkport;
        }
        if ((request = inputVsMap.get("request")) != null && request.length() > 0) {
            Pattern pattern6 = Pattern.compile("[^\\x20-\\x7e]");
            Matcher matcher6 = pattern6.matcher(request);
            if (request.length() > 127 || matcher6.find()) {
                invalidMap.put("request", "Invalid value.");
                validationFlag = false;
            }
        }
        if (request != null) {
            vs.request = request;
        }
        if ((receive = inputVsMap.get("receive")) != null && receive.length() > 0) {
            Pattern pattern7 = Pattern.compile("[^\\x20-\\x7e]");
            Matcher matcher7 = pattern7.matcher(receive);
            if (receive.length() > 127 || matcher7.find()) {
                invalidMap.put("receive", "Invalid value.");
                validationFlag = false;
            }
        }
        if (receive != null) {
            vs.receive = receive;
        }
        if ((method = inputVsMap.get("method")) != null && method.length() > 0 && !method.equals("GET") && !method.equals("HEAD")) {
            invalidMap.put("method", "Invalid value.");
            validationFlag = false;
        }
        if (method != null) {
            vs.httpmethod = method;
        }
        if ((virtual_host = inputVsMap.get("virtual_host")) != null && virtual_host.length() > 0) {
            Pattern pattern8 = Pattern.compile("[^\\x20-\\x7e]");
            Matcher matcher8 = pattern8.matcher(virtual_host);
            if (virtual_host.length() > 127 || matcher8.find()) {
                invalidMap.put("virtual_host", "Invalid value.");
                validationFlag = false;
            }
        }
        if (virtual_host != null) {
            vs.virtualhost = virtual_host;
        }
        if ((login_user = inputVsMap.get("login_user")) != null && login_user.length() > 0) {
            Pattern pattern9 = Pattern.compile("[^\\x20-\\x7e]");
            Matcher matcher9 = pattern9.matcher(login_user);
            if (login_user.length() > 32 || matcher9.find()) {
                invalidMap.put("login_user", "Invalid value.");
                validationFlag = false;
            }
        }
        if (login_user != null) {
            vs.login = login_user;
        }
        if ((login_pass = inputVsMap.get("login_pass")) != null && login_pass.length() > 0) {
            Pattern pattern10 = Pattern.compile("[^\\x20-\\x7e]");
            Matcher matcher10 = pattern10.matcher(login_pass);
            if (login_pass.length() > 32 || matcher10.find()) {
                invalidMap.put("login_pass", "Invalid value.");
                validationFlag = false;
            }
        }
        if (login_pass != null) {
            vs.passwd = login_pass;
        }
        if ((db = inputVsMap.get("db")) != null && db.length() > 0) {
            Pattern pattern11 = Pattern.compile("[^\\x20-\\x7e]");
            Matcher matcher11 = pattern11.matcher(db);
            if (db.length() > 32 || matcher11.find()) {
                invalidMap.put("db", "Invalid value.");
                validationFlag = false;
            }
        }
        if (db != null) {
            vs.database = db;
        }
        int num = 1;
        while ((rs_ip = inputVsMap.get("rs" + num + "_ip")) != null && (rs_port = inputVsMap.get("rs" + num + "_port")) != null && (rs_weight = inputVsMap.get("rs" + num + "_weight")) != null) {
            block141: {
                if (rs_ip.length() == 0 && rs_port.length() == 0 && rs_weight.length() == 0) {
                    ++num;
                    continue;
                }
                if (rs_ip.length() == 0) {
                    invalidMap.put("rs" + num + "_ip", "Required fields.");
                    validationFlag = false;
                } else if (rs_ip.equals("0.0.0.0")) {
                    invalidMap.put("rs" + num + "_ip", "Invalid value.");
                    validationFlag = false;
                } else {
                    String[] tmp_rs_addr = rs_ip.split("\\.", 4);
                    int int_rs_addr = 0;
                    if (tmp_rs_addr.length != 4) {
                        invalidMap.put("rs" + num + "_ip", "Invalid value.");
                        validationFlag = false;
                    } else {
                        int i = 0;
                        while (i < 4) {
                            block140: {
                                try {
                                    int_rs_addr = Integer.parseInt(tmp_rs_addr[i]);
                                    if (int_rs_addr < 0 || int_rs_addr > 255) {
                                        invalidMap.put("rs" + num + "_ip", "Invalid value.");
                                        validationFlag = false;
                                    }
                                    break block140;
                                }
                                catch (NumberFormatException e) {
                                    invalidMap.put("rs" + num + "_ip", "Invalid value.");
                                    validationFlag = false;
                                }
                                break;
                            }
                            ++i;
                        }
                    }
                }
                if (rs_port.length() == 0) {
                    invalidMap.put("rs" + num + "_port", "Required fields.");
                    validationFlag = false;
                } else {
                    try {
                        int int_rs_port = Integer.parseInt(rs_port);
                        if (int_rs_port < 1 || int_rs_port > 65535) {
                            invalidMap.put("rs" + num + "_port", "Invalid value.");
                            validationFlag = false;
                        }
                    }
                    catch (NumberFormatException e) {
                        Pattern pattern12 = Pattern.compile("[^\\x20-\\x7e]");
                        Matcher matcher12 = pattern12.matcher(rs_port);
                        if (rs_port.length() <= 10 && !matcher12.find()) break block141;
                        invalidMap.put("rs" + num + "_port", "Invalid value.");
                        validationFlag = false;
                    }
                }
            }
            int int_rs_weight = 1;
            if (rs_weight.length() == 0) {
                invalidMap.put("rs" + num + "_weight", "Required fields.");
                validationFlag = false;
            } else {
                try {
                    int_rs_weight = Integer.parseInt(rs_weight);
                    if (int_rs_weight < 0 || int_rs_weight > 100) {
                        invalidMap.put("rs" + num + "_weight", "Invalid value.");
                        validationFlag = false;
                    }
                }
                catch (NumberFormatException e) {
                    invalidMap.put("rs" + num + "_weight", "Invalid value.");
                    validationFlag = false;
                }
            }
            EndPoint rs = new EndPoint(rs_ip, rs_port, int_rs_weight, 0L, 0L);
            vs.real.add(rs);
            ++num;
        }
        String sorry_ip = inputVsMap.get("sorry_ip");
        if (sorry_ip != null && sorry_ip.length() > 0) {
            if (sorry_ip.equals("0.0.0.0")) {
                invalidMap.put("sorry_ip", "Invalid value.");
                validationFlag = false;
            } else {
                String[] tmp_sorry_ip = sorry_ip.split("\\.", 4);
                int int_sorry_ip = 0;
                if (tmp_sorry_ip.length != 4) {
                    invalidMap.put("sorry_ip", "Invalid value.");
                    validationFlag = false;
                } else {
                    int i = 0;
                    while (i < 4) {
                        block142: {
                            try {
                                int_sorry_ip = Integer.parseInt(tmp_sorry_ip[i]);
                                if (int_sorry_ip < 0 || int_sorry_ip > 255) {
                                    invalidMap.put("sorry_ip", "Invalid value.");
                                    validationFlag = false;
                                }
                                break block142;
                            }
                            catch (NumberFormatException e) {
                                invalidMap.put("sorry_ip", "Invalid value.");
                                validationFlag = false;
                            }
                            break;
                        }
                        ++i;
                    }
                }
            }
            vs.sorryserver.host = sorry_ip;
        }
        if ((sorry_port = inputVsMap.get("sorry_port")) != null && sorry_port.length() > 0) {
            block143: {
                try {
                    int int_sorry_port = Integer.parseInt(sorry_port);
                    if (int_sorry_port < 1 || int_sorry_port > 65535) {
                        invalidMap.put("sorry_port", "Invalid value.");
                        validationFlag = false;
                    }
                }
                catch (NumberFormatException e) {
                    Pattern pattern13 = Pattern.compile("[^\\x20-\\x7e]");
                    Matcher matcher13 = pattern13.matcher(sorry_port);
                    if (sorry_port.length() <= 10 && !matcher13.find()) break block143;
                    invalidMap.put("sorry_port", "Invalid value.");
                    validationFlag = false;
                }
            }
            vs.sorryserver.port = sorry_port;
        }
        String sorry_flag = inputVsMap.get("sorry_flag");
        vs.sorryflag = false;
        if (sorry_flag != null && sorry_flag.length() > 0) {
            if (sorry_flag.equals("on")) {
                vs.sorryflag = true;
            } else if (sorry_flag.equals("off")) {
                vs.sorryflag = false;
            } else {
                invalidMap.put("sorry_flag", "Invalid value.");
                validationFlag = false;
            }
        }
        if (this.logger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("ValidationCheck::vsCheck(HashMap<String, String> inputVsMap, HashMap<String, String> invalidMap, VirtualSetting vs) out ");
            buf.append("return=" + validationFlag);
            this.logger.debug((Object)("11338 " + buf.toString()));
        }
        return validationFlag;
    }
}

