<%@ page
	import="org.ultramonkey.l7.model.*,org.ultramonkey.l7.controller.*,org.ultramonkey.l7.view.*"
	language="java" contentType="text/html; charset=UTF-8"
	pageEncoding="UTF-8"%>

<%
	 /*
	 * check session
	 */
	L7guiServletBase base = new L7guiServletBase();
	if (session.isNew() || base.checkSession(session) == false) {
		MessageView error = new MessageView(41338,
		LogCategorySet.GUI_USER_AUTHENTICATION,
		Message.INVALID_SESSSION);
		session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
		response.sendRedirect(RedirectPages.LOGIN);
		return;
	}

	/*
	 * get thread status
	 */

	String threadStatus = (String) session
			.getAttribute(SessionKeys.THREAD_STATUS);
		if (threadStatus == null) {
		MessageView error = new MessageView(41339,
		LogCategorySet.GUI_REPLICATION,
		Message.UNEXPECTED_ERROR);
		session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
		response.sendRedirect(RedirectPages.LOGIN);
		return;
	} else if (threadStatus.equals(SessionKeys.THREAD_RUNNING)) {
		//
	} else if (threadStatus.equals(SessionKeys.THREAD_SUCCESS)) {
		response.sendRedirect(RedirectPages.REPLICATION_INFO);
		return;
	} else if (threadStatus.equals(SessionKeys.THREAD_FAIL)) {
		response.sendRedirect(RedirectPages.REPLICATION_NG);
		return;
	} else {
		MessageView error = new MessageView(41340,
		LogCategorySet.GUI_REPLICATION,
		Message.UNEXPECTED_ERROR);
		session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
		response.sendRedirect(RedirectPages.LOGIN);
		return;
	}

	/*
	 * get Replication Info
	 */
	L7guiFramework framework = new L7guiFramework();
	ClusterData repInfo = framework.getClusterData();
	if (repInfo == null) {
		MessageView error = new MessageView(41341,
		LogCategorySet.GUI_REPLICATION,
		Message.UNEXPECTED_ERROR);
		session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
		response.sendRedirect(RedirectPages.LOGIN);
		return;
	}

	String repMaster = repInfo.self_ip;
	String repSlave = repInfo.other_ip;
	 
	if ((repMaster == null) || (repSlave == null)) {
		MessageView error = new MessageView(41342,
		LogCategorySet.GUI_REPLICATION,
		Message.UNEXPECTED_ERROR);
		session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
		response.sendRedirect(RedirectPages.LOGIN);
		return;
	}
%>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
	<meta http-equiv="Pragma" content="no-cache">
	<meta http-equiv="Cache-Control" content="no-cache">
	<meta http-equiv="Expires" content="0"> 		
	<meta http-equiv="Content-Script-Type" content="text/javascript" />
	<meta http-equiv="Content-Style-Type" content="text/css" />
	<meta http-equiv="refresh" content="<%= RedirectPages.REFRESH_TIME %>" />
	<noscript>
	<meta http-equiv="refresh"
		content="<%= RedirectPages.NOSCRIPT_TIME %>; url=<%= RedirectPages.LOGIN %>" />
	</noscript>
	
	<link rel="stylesheet" type="text/css" href="l7gui_basic_style.css" />
	<link rel="shortcut icon" href="images/favicon.ico" />
	<title>Replicating</title>
</head>

<body>
<h1 class="title">Replicating</h1>
<h2>Please wait.</h2>
<h3>(Master) <%=repMaster%></h3>

<img class="arrow1" src="images/arrowlogo1.gif" alt="arrowlogo1" />

<h3>(Slave) <%=repSlave%></h3>

</body>
</html>

