/*
 * Decompiled with CFR 0.152.
 */
package org.ultramonkey.l7.controller;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Stack;
import org.ultramonkey.l7.controller.L7vsConfData;
import org.ultramonkey.l7.controller.LogData;
import org.ultramonkey.l7.model.FileNotReadException;
import org.ultramonkey.l7.model.FileNotWriteException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class L7vsConfController {
    protected static String FILENAME = "/etc/l7vs/l7vs.cf";
    protected static String LOGGER_MASTER_KEY = "logger";
    protected static String L7VSADM_MASTER_KEY = "l7vsadm";
    protected static String REPLICATION_MASTER_KEY = "replication";
    protected static String SNMPAGENT_MASTER_KEY = "snmpagent";
    protected static String LB_LOG_FILENAME_KEY = "l7vsd_log_filename";
    protected static String LB_LOG_ROTATION_KEY = "l7vsd_rotation";
    protected static String LB_LOG_MAXBACKUPINDEX_KEY = "l7vsd_max_backup_index";
    protected static String LB_LOG_ROTATE_TIMING_KEY = "l7vsd_rotation_timing";
    protected static String LB_LOG_ROTATE_TIMING_VALUE_KEY = "l7vsd_rotation_timing_value";
    protected static String LB_LOG_MAXFILESIZE_KEY = "l7vsd_max_filesize";
    protected static String LB_LOGCATEGORY_NETWORK_KEY = "l7vsd_network";
    protected static String LB_LOGCATEGORY_NETWORK_BANDWIDTH_KEY = "l7vsd_network.bandwidth";
    protected static String LB_LOGCATEGORY_NETWORK_NUM_CONNECTION_KEY = "l7vsd_network.num_connection";
    protected static String LB_LOGCATEGORY_NETWORK_QOS_KEY = "l7vsd_network.qos";
    protected static String LB_LOGCATEGORY_VIRTUALSERVICE_KEY = "l7vsd_virtual_service";
    protected static String LB_LOGCATEOGRY_REALSERVER_KEY = "l7vsd_real_server";
    protected static String LB_LOGCATEOGRY_SORRYSERVER_KEY = "l7vsd_sorry_server";
    protected static String LB_LOGCATEOGRY_REALSERVER_BALANCING_KEY = "l7vsd_real_server.balancing";
    protected static String LB_LOGCATEOGRY_REPLICATION_KEY = "l7vsd_replication";
    protected static String LB_LOGCATEOGRY_STARTSTOP_KEY = "l7vsd_start_stop";
    protected static String LB_LOGCATEOGRY_SYSTEM_KEY = "l7vsd_system";
    protected static String LB_LOGCATEOGRY_SYSTEMMEMORY_KEY = "l7vsd_system.memory";
    protected static String LB_LOGCATEOGRY_SYSTEMSOCKET_KEY = "l7vsd_system.socket";
    protected static String LB_LOGCATEOGRY_SYSTEMSIGNAL_KEY = "l7vsd_system.signal";
    protected static String LB_LOGCATEOGRY_ENVIROMENT_KEY = "l7vsd_environment";
    protected static String LB_LOGCATEOGRY_ENVIROMENTPARAMTER_KEY = "l7vsd_environment.parameter";
    protected static String LB_LOGCATEGORY_LOGGER_KEY = "l7vsd_logger";
    protected static String LB_LOGCATEGORY_PARAMTER = "l7vsd_parameter";
    protected static String LB_LOGCATEGORY_EVENT_KEY = "l7vsd_event";
    protected static String LB_LOGCATEGORY_SCHEDULE_KEY = "l7vsd_schedule";
    protected static String LB_LOGCATEGORY_PROGRAM_KEY = "l7vsd_program";
    protected static String LB_LOGCATEGORY_PROTOCOL_KEY = "l7vsd_protocol";
    protected static String LB_LOGCATEGORY_MODULE_KEY = "l7vsd_module";
    protected static String ADM_LOG_FILENAME_KEY = "l7vsadm_log_filename";
    protected static String ADM_LOG_ROTATION_KEY = "l7vsadm_rotation";
    protected static String ADM_LOG_MAXBACKUPINDEX_KEY = "l7vsadm_max_backup_index";
    protected static String ADM_LOG_ROTATE_TIMING_KEY = "l7vsadm_rotation_timing";
    protected static String ADM_LOG_ROTATE_TIMING_VALUE_KEY = "l7vsadm_rotation_timing_value";
    protected static String ADM_LOG_MAXFILESIZE_KEY = "l7vsadd_max_filesize";
    protected static String ADM_LOGCATEGORY_PARSE_KEY = "l7vsadm_parse";
    protected static String ADM_LOGCATEGORY_OPERATE_KEY = "l7vsadm_operate";
    protected static String ADM_LOGCATEGORY_COMMUNICATE_KEY = "l7vsadm_communicate";
    protected static String ADM_LOGCATEGORY_CONFIG_RESULT_KEY = "l7vsadm_config_result";
    protected static String ADM_LOGCATEOGRY_COMMON = "l7vsadm_common";
    protected static String ADM_LOGCATEGORY_LOGGER = "l7vsadm_logger";
    protected static String ADM_LOGCATEGORY_PARAMETER = "l7vsadm_parameter";
    protected static String ADM_LOGCATEOGRY_PROTOCOL = "l7vsadm_protocol";
    protected static String ADM_LOGCATEOGRY_MODULE = "l7vsadm_module";
    protected static String SNMP_LOG_FILENAME_KEY = "snmpagent_log_filename";
    protected static String SNMP_LOG_ROTATION_KEY = "snmpagent_rotation";
    protected static String SNMP_LOG_MAXBACKUPINDEX_KEY = "snmpagent_max_backup_index";
    protected static String SNMP_LOG_ROTATE_TIMING_KEY = "snmpagent_rotation_timing";
    protected static String SNMP_LOG_ROTATE_TIMING_VALUE_KEY = "snmpagent_rotation_timing_value";
    protected static String SNMP_MAX_FILESIZE_KEY = "snmpagent_max_filesize";
    protected static String SNMP_LOGCATEOGRY_STARTSTOP_KEY = "snmpagent_start_stop";
    protected static String SNMP_LOGCATEGORY_MANAGER_RECEIVE_KEY = "snmpagent_manager_receive";
    protected static String SNMP_LOGCATEGORY_MANAGER_SEND_KEY = "snmpagent_manager_send";
    protected static String SNMP_LOGCATEGORY_L7VSD_RECEIVE_KEY = "snmpagent_l7vsd_receive";
    protected static String SNMP_LOGCATEGORY_L7VSD_SEND_KEY = "snmpagent_l7vsd_send";
    protected static String SNMP_LOGCATEGORY_LOGGER = "snmpagent_logger";
    protected static String SNMP_LOGCATEGORY_PARAMETER = "snmpagent_parameter";
    protected static String ADM_CMD_INTERVAL_KEY = "cmd_interval";
    protected static String ADM_CMD_COUNT_KEY = "cmd_count";
    protected static String ADM_CON_INTERVAL_KEY = "con_interval";
    protected static String ADM_CON_COUNT_KEY = "con_count";
    protected static String REPLICATION_IPADDR_KEY = "ip_addr";
    protected static String REPLICATION_SERVICENAME_KEY = "service_name";
    protected static String REPLICATION_NIC_KEY = "nic";
    protected static String REPLICATION_INTERVAL_KEY = "interval";
    protected static String REPLICATION_COMPULSORILY_INTERVAL_KEY = "compulsorily_interval";
    protected static String REPLICATION_COMPONENT_ID_BASE_KEY = "cmponent_id_";
    protected static String REPLICATION_COMPONENT_SIZE_BASE_KEY = "cmponent_size_";
    protected static String SNMPAGENT_NIC_KEY = "nic";
    protected static String SNMPAGENT_IPADDR_KEY = "ip_addr";
    protected static String SNMPAGENT_PORT_KEY = "port";
    protected static String SNMPAGENT_INTERVAL_KEY = "interval";
    protected static String SNMPAGENT_STATUS_KEY = "status";
    protected static int MAX_REPLICATION_COMPONENT_COUNT = 99;

    protected Pair<String, String> paseKey(String inLine) {
        if (inLine == null) {
            return null;
        }
        int pos = inLine.indexOf("=");
        if (pos == -1) {
            return new Pair<String, String>(inLine, "");
        }
        String first = inLine.substring(0, pos);
        String second = inLine.substring(pos + 1, inLine.length());
        if (first.indexOf(35) != -1) {
            return new Pair<String, String>("", "");
        }
        if (second.indexOf(35) != -1) {
            pos = second.indexOf(35);
            second = second.substring(0, pos);
        }
        first = first.trim();
        if ((second = second.trim()).matches("^\".*\"$")) {
            second = second.substring(1, second.length() - 1);
        }
        Pair<String, String> pair = new Pair<String, String>(first, second);
        return pair;
    }

    protected static LogData.LogLevel convStringToLogLevel(String instr) throws FileNotReadException {
        if (instr == null) {
            FileNotReadException exception = new FileNotReadException();
            exception.setErrMessage("function L7vsConfController::convStringToLogLevel(String) param is null");
            throw exception;
        }
        if (instr.equals("debug")) {
            return LogData.LogLevel.DEBUG;
        }
        if (instr.equals("DEBUG")) {
            return LogData.LogLevel.DEBUG;
        }
        if (instr.equals("error")) {
            return LogData.LogLevel.ERROR;
        }
        if (instr.equals("ERROR")) {
            return LogData.LogLevel.ERROR;
        }
        if (instr.equals("fatal")) {
            return LogData.LogLevel.FATAL;
        }
        if (instr.equals("FATAL")) {
            return LogData.LogLevel.FATAL;
        }
        if (instr.equals("info")) {
            return LogData.LogLevel.INFO;
        }
        if (instr.equals("INFO")) {
            return LogData.LogLevel.INFO;
        }
        if (instr.equals("warn")) {
            return LogData.LogLevel.WARN;
        }
        if (instr.endsWith("WARN")) {
            return LogData.LogLevel.WARN;
        }
        FileNotReadException exception = new FileNotReadException();
        exception.setErrMessage("");
        throw exception;
    }

    protected static String convLogLevelToLogString(LogData.LogLevel inlevel) {
        if (inlevel == LogData.LogLevel.DEBUG) {
            return "\"debug\"";
        }
        if (inlevel == LogData.LogLevel.ERROR) {
            return "\"error\"";
        }
        if (inlevel == LogData.LogLevel.FATAL) {
            return "\"fatal\"";
        }
        if (inlevel == LogData.LogLevel.INFO) {
            return "\"info\"";
        }
        if (inlevel == LogData.LogLevel.WARN) {
            return "\"warn\"";
        }
        return "";
    }

    protected void readLoggerParameter(L7vsConfData data, LinkedList<String> inList) throws FileNotReadException {
        if (data == null || inList == null) {
            return;
        }
        for (String buffer : inList) {
            Pair<String, String> pair = this.paseKey(buffer);
            if (pair.first().equals(LB_LOG_FILENAME_KEY)) {
                data.logger.lbLog.fileName = pair.second();
                continue;
            }
            if (pair.first().equals(LB_LOG_ROTATION_KEY)) {
                data.logger.lbLog.rotation = pair.second();
                continue;
            }
            if (pair.first().equals(LB_LOG_MAXBACKUPINDEX_KEY)) {
                try {
                    data.logger.lbLog.maxBackupIndex = Integer.parseInt(pair.second());
                }
                catch (NumberFormatException e) {
                    data.logger.lbLog.maxBackupIndex = 0;
                }
                continue;
            }
            if (pair.first().equals(LB_LOG_ROTATE_TIMING_KEY)) {
                data.logger.lbLog.rotationTiming = pair.second();
                continue;
            }
            if (pair.first().equals(LB_LOG_ROTATE_TIMING_VALUE_KEY)) {
                data.logger.lbLog.rotationTimingValue = pair.second();
                continue;
            }
            if (pair.first().equals(LB_LOG_MAXFILESIZE_KEY)) {
                data.logger.lbLog.maxFileSize = pair.second();
                continue;
            }
            if (pair.first().equals(LB_LOGCATEGORY_NETWORK_KEY)) {
                data.logger.lbLog.logLevel.put(LogData.LogCategory.L7VSD_NETWORK, L7vsConfController.convStringToLogLevel(pair.second()));
                continue;
            }
            if (pair.first().equals(LB_LOGCATEGORY_NETWORK_BANDWIDTH_KEY)) {
                data.logger.lbLog.logLevel.put(LogData.LogCategory.L7VSD_NETWORK_BANDWIDTH, L7vsConfController.convStringToLogLevel(pair.second()));
                continue;
            }
            if (pair.first().equals(LB_LOGCATEGORY_NETWORK_NUM_CONNECTION_KEY)) {
                data.logger.lbLog.logLevel.put(LogData.LogCategory.L7VSD_NETWORK_NUM_CONNECTION, L7vsConfController.convStringToLogLevel(pair.second()));
                continue;
            }
            if (pair.first().equals(LB_LOGCATEGORY_NETWORK_QOS_KEY)) {
                data.logger.lbLog.logLevel.put(LogData.LogCategory.L7VSD_NETWORK_QOS, L7vsConfController.convStringToLogLevel(pair.second()));
                continue;
            }
            if (pair.first().equals(LB_LOGCATEGORY_VIRTUALSERVICE_KEY)) {
                data.logger.lbLog.logLevel.put(LogData.LogCategory.L7VSD_VIRTUAL_SERVICE, L7vsConfController.convStringToLogLevel(pair.second()));
                continue;
            }
            if (pair.first().equals(LB_LOGCATEOGRY_REALSERVER_KEY)) {
                data.logger.lbLog.logLevel.put(LogData.LogCategory.L7VSD_REAL_SERVER, L7vsConfController.convStringToLogLevel(pair.second()));
                continue;
            }
            if (pair.first().equals(LB_LOGCATEOGRY_SORRYSERVER_KEY)) {
                data.logger.lbLog.logLevel.put(LogData.LogCategory.L7VSD_SORRY_SERVER, L7vsConfController.convStringToLogLevel(pair.second()));
                continue;
            }
            if (pair.first().equals(LB_LOGCATEOGRY_REALSERVER_BALANCING_KEY)) {
                data.logger.lbLog.logLevel.put(LogData.LogCategory.L7VSD_REAL_SERVER_BALANCING, L7vsConfController.convStringToLogLevel(pair.second()));
                continue;
            }
            if (pair.first().equals(LB_LOGCATEOGRY_REPLICATION_KEY)) {
                data.logger.lbLog.logLevel.put(LogData.LogCategory.L7VSD_REPLICATION, L7vsConfController.convStringToLogLevel(pair.second()));
                continue;
            }
            if (pair.first().equals(LB_LOGCATEOGRY_STARTSTOP_KEY)) {
                data.logger.lbLog.logLevel.put(LogData.LogCategory.L7VSD_START_STOP, L7vsConfController.convStringToLogLevel(pair.second()));
                continue;
            }
            if (pair.first().equals(LB_LOGCATEOGRY_SYSTEM_KEY)) {
                data.logger.lbLog.logLevel.put(LogData.LogCategory.L7VSD_SYSTEM, L7vsConfController.convStringToLogLevel(pair.second()));
                continue;
            }
            if (pair.first().equals(LB_LOGCATEOGRY_SYSTEMMEMORY_KEY)) {
                data.logger.lbLog.logLevel.put(LogData.LogCategory.L7VSD_SYSTEM_MEMORY, L7vsConfController.convStringToLogLevel(pair.second()));
                continue;
            }
            if (pair.first().equals(LB_LOGCATEOGRY_SYSTEMSOCKET_KEY)) {
                data.logger.lbLog.logLevel.put(LogData.LogCategory.L7VSD_SYSTEM_SOCKET, L7vsConfController.convStringToLogLevel(pair.second()));
                continue;
            }
            if (pair.first().equals(LB_LOGCATEOGRY_SYSTEMSIGNAL_KEY)) {
                data.logger.lbLog.logLevel.put(LogData.LogCategory.L7VSD_SYSTEM_SIGNAL, L7vsConfController.convStringToLogLevel(pair.second()));
                continue;
            }
            if (pair.first().equals(LB_LOGCATEOGRY_ENVIROMENT_KEY)) {
                data.logger.lbLog.logLevel.put(LogData.LogCategory.L7VSD_ENVIRONMENT, L7vsConfController.convStringToLogLevel(pair.second()));
                continue;
            }
            if (pair.first().equals(LB_LOGCATEOGRY_ENVIROMENTPARAMTER_KEY)) {
                data.logger.lbLog.logLevel.put(LogData.LogCategory.L7VSD_ENVIRONMENT_PARAMETER, L7vsConfController.convStringToLogLevel(pair.second()));
                continue;
            }
            if (pair.first().equals(LB_LOGCATEGORY_LOGGER_KEY)) {
                data.logger.lbLog.logLevel.put(LogData.LogCategory.L7VSD_LOGGER, L7vsConfController.convStringToLogLevel(pair.second()));
                continue;
            }
            if (pair.first().equals(LB_LOGCATEGORY_PARAMTER)) {
                data.logger.lbLog.logLevel.put(LogData.LogCategory.L7VSD_PARAMETER, L7vsConfController.convStringToLogLevel(pair.second()));
                continue;
            }
            if (pair.first().equals(LB_LOGCATEGORY_EVENT_KEY)) {
                data.logger.lbLog.logLevel.put(LogData.LogCategory.L7VSD_EVENT, L7vsConfController.convStringToLogLevel(pair.second()));
                continue;
            }
            if (pair.first().equals(LB_LOGCATEGORY_SCHEDULE_KEY)) {
                data.logger.lbLog.logLevel.put(LogData.LogCategory.L7VSD_SCHEDULE, L7vsConfController.convStringToLogLevel(pair.second()));
                continue;
            }
            if (pair.first().equals(LB_LOGCATEGORY_PROGRAM_KEY)) {
                data.logger.lbLog.logLevel.put(LogData.LogCategory.L7VSD_PROGRAM, L7vsConfController.convStringToLogLevel(pair.second()));
                continue;
            }
            if (pair.first().equals(LB_LOGCATEGORY_PROTOCOL_KEY)) {
                data.logger.lbLog.logLevel.put(LogData.LogCategory.L7VSD_PROTOCOL, L7vsConfController.convStringToLogLevel(pair.second()));
                continue;
            }
            if (pair.first().equals(LB_LOGCATEGORY_MODULE_KEY)) {
                data.logger.lbLog.logLevel.put(LogData.LogCategory.L7VSD_MODULE, L7vsConfController.convStringToLogLevel(pair.second()));
                continue;
            }
            if (pair.first().equals(ADM_LOG_FILENAME_KEY)) {
                data.logger.admLog.fileName = pair.second();
                continue;
            }
            if (pair.first().equals(ADM_LOG_ROTATION_KEY)) {
                data.logger.admLog.rotation = pair.second();
                continue;
            }
            if (pair.first().equals(ADM_LOG_MAXBACKUPINDEX_KEY)) {
                try {
                    data.logger.admLog.maxBackupIndex = Integer.parseInt(pair.second());
                }
                catch (NumberFormatException e) {
                    data.logger.admLog.maxBackupIndex = 0;
                }
                continue;
            }
            if (pair.first().equals(ADM_LOG_ROTATE_TIMING_KEY)) {
                data.logger.admLog.rotationTiming = pair.second();
                continue;
            }
            if (pair.first().equals(ADM_LOG_ROTATE_TIMING_VALUE_KEY)) {
                data.logger.admLog.rotationTimingValue = pair.second();
                continue;
            }
            if (pair.first().equals(ADM_LOG_MAXFILESIZE_KEY)) {
                data.logger.admLog.maxFileSize = pair.second();
                continue;
            }
            if (pair.first().equals(ADM_LOGCATEGORY_PARSE_KEY)) {
                data.logger.admLog.logLevel.put(LogData.LogCategory.L7VSADM_PARSE, L7vsConfController.convStringToLogLevel(pair.second()));
                continue;
            }
            if (pair.first().equals(ADM_LOGCATEGORY_OPERATE_KEY)) {
                data.logger.admLog.logLevel.put(LogData.LogCategory.L7VSADM_OPERATE, L7vsConfController.convStringToLogLevel(pair.second()));
                continue;
            }
            if (pair.first().equals(ADM_LOGCATEGORY_COMMUNICATE_KEY)) {
                data.logger.admLog.logLevel.put(LogData.LogCategory.L7VSADM_COMMUNICATE, L7vsConfController.convStringToLogLevel(pair.second()));
                continue;
            }
            if (pair.first().equals(ADM_LOGCATEGORY_CONFIG_RESULT_KEY)) {
                data.logger.admLog.logLevel.put(LogData.LogCategory.L7VSADM_CONFIG_RESULT, L7vsConfController.convStringToLogLevel(pair.second()));
                continue;
            }
            if (pair.first().equals(ADM_LOGCATEOGRY_COMMON)) {
                data.logger.admLog.logLevel.put(LogData.LogCategory.L7VSADM_COMMON, L7vsConfController.convStringToLogLevel(pair.second()));
                continue;
            }
            if (pair.first().equals(ADM_LOGCATEGORY_LOGGER)) {
                data.logger.admLog.logLevel.put(LogData.LogCategory.L7VSADM_LOGGER, L7vsConfController.convStringToLogLevel(pair.second()));
                continue;
            }
            if (pair.first().equals(ADM_LOGCATEGORY_PARAMETER)) {
                data.logger.admLog.logLevel.put(LogData.LogCategory.L7VSADM_PARAMETER, L7vsConfController.convStringToLogLevel(pair.second()));
                continue;
            }
            if (pair.first().equals(ADM_LOGCATEOGRY_PROTOCOL)) {
                data.logger.admLog.logLevel.put(LogData.LogCategory.L7VSADM_PROTOCOL, L7vsConfController.convStringToLogLevel(pair.second()));
                continue;
            }
            if (pair.first().equals(ADM_LOGCATEOGRY_MODULE)) {
                data.logger.admLog.logLevel.put(LogData.LogCategory.L7VSADM_MODULE, L7vsConfController.convStringToLogLevel(pair.second()));
                continue;
            }
            if (pair.first().equals(SNMP_LOG_FILENAME_KEY)) {
                data.logger.snmpLog.fileName = pair.second();
                continue;
            }
            if (pair.first().equals(SNMP_LOG_ROTATION_KEY)) {
                data.logger.snmpLog.rotation = pair.second();
                continue;
            }
            if (pair.first().equals(SNMP_LOG_MAXBACKUPINDEX_KEY)) {
                try {
                    data.logger.snmpLog.maxBackupIndex = Integer.parseInt(pair.second());
                }
                catch (NumberFormatException e) {
                    data.logger.snmpLog.maxBackupIndex = 0;
                }
                continue;
            }
            if (pair.first().equals(SNMP_LOG_ROTATE_TIMING_KEY)) {
                data.logger.snmpLog.rotationTiming = pair.second();
                continue;
            }
            if (pair.first().equals(SNMP_LOG_ROTATE_TIMING_VALUE_KEY)) {
                data.logger.snmpLog.rotationTimingValue = pair.second();
                continue;
            }
            if (pair.first().equals(SNMP_MAX_FILESIZE_KEY)) {
                data.logger.snmpLog.maxFileSize = pair.second();
                continue;
            }
            if (pair.first().equals(SNMP_LOGCATEOGRY_STARTSTOP_KEY)) {
                data.logger.snmpLog.logLevel.put(LogData.LogCategory.SNMPAGENT_START_STOP, L7vsConfController.convStringToLogLevel(pair.second()));
                continue;
            }
            if (pair.first().equals(SNMP_LOGCATEGORY_MANAGER_RECEIVE_KEY)) {
                data.logger.snmpLog.logLevel.put(LogData.LogCategory.SNMPAGENT_MANAGER_RECEIVE, L7vsConfController.convStringToLogLevel(pair.second()));
                continue;
            }
            if (pair.first().equals(SNMP_LOGCATEGORY_MANAGER_SEND_KEY)) {
                data.logger.snmpLog.logLevel.put(LogData.LogCategory.SNMPAGENT_MANAGER_SEND, L7vsConfController.convStringToLogLevel(pair.second()));
                continue;
            }
            if (pair.first().equals(SNMP_LOGCATEGORY_L7VSD_RECEIVE_KEY)) {
                data.logger.snmpLog.logLevel.put(LogData.LogCategory.SNMPAGENT_L7VSD_RECEIVE, L7vsConfController.convStringToLogLevel(pair.second()));
                continue;
            }
            if (pair.first().equals(SNMP_LOGCATEGORY_L7VSD_SEND_KEY)) {
                data.logger.snmpLog.logLevel.put(LogData.LogCategory.SNMPAGENT_L7VSD_SEND, L7vsConfController.convStringToLogLevel(pair.second()));
                continue;
            }
            if (pair.first().equals(SNMP_LOGCATEGORY_LOGGER)) {
                data.logger.snmpLog.logLevel.put(LogData.LogCategory.SNMPAGENT_LOGGER, L7vsConfController.convStringToLogLevel(pair.second()));
                continue;
            }
            if (!pair.first().equals(SNMP_LOGCATEGORY_PARAMETER)) continue;
            data.logger.snmpLog.logLevel.put(LogData.LogCategory.SNMPAGENT_PARAMETER, L7vsConfController.convStringToLogLevel(pair.second()));
        }
    }

    protected void readAdmParameter(L7vsConfData data, LinkedList<String> inList) throws FileNotReadException {
        if (data == null || inList == null) {
            return;
        }
        for (String buffer : inList) {
            Pair<String, String> pair = this.paseKey(buffer);
            if (pair.first().indexOf(ADM_CMD_INTERVAL_KEY) != -1) {
                try {
                    data.admCmdInterval = Integer.parseInt(pair.second());
                }
                catch (NumberFormatException e) {
                    data.admCmdInterval = 0;
                }
                continue;
            }
            if (pair.first().indexOf(ADM_CMD_COUNT_KEY) != -1) {
                try {
                    data.admCmdCount = Integer.parseInt(pair.second());
                }
                catch (NumberFormatException e) {
                    data.admCmdCount = 0;
                }
                continue;
            }
            if (pair.first().indexOf(ADM_CON_INTERVAL_KEY) != -1) {
                try {
                    data.admConInterval = Integer.parseInt(pair.second());
                }
                catch (NumberFormatException e) {
                    data.admConInterval = 0;
                }
                continue;
            }
            if (pair.first().indexOf(ADM_CON_COUNT_KEY) == -1) continue;
            try {
                data.admConCount = Integer.parseInt(pair.second());
            }
            catch (NumberFormatException e) {
                data.admConCount = 0;
            }
        }
    }

    protected void readSNMPAgentParameter(L7vsConfData data, LinkedList<String> inList) throws FileNotReadException {
        if (data == null || inList == null) {
            return;
        }
        for (String buffer : inList) {
            Pair<String, String> pair = this.paseKey(buffer);
            if (pair.first().indexOf(SNMPAGENT_NIC_KEY) != -1) {
                data.snmpNIC = pair.second();
                continue;
            }
            if (pair.first().indexOf(SNMPAGENT_IPADDR_KEY) != -1) {
                data.snmpIpAddr = pair.second();
                continue;
            }
            if (pair.first().indexOf(SNMPAGENT_PORT_KEY) != -1) {
                data.snmpPort = pair.second();
                continue;
            }
            if (pair.first().indexOf(SNMPAGENT_INTERVAL_KEY) == -1) continue;
            try {
                data.snmpInterval = Integer.parseInt(pair.second());
            }
            catch (NumberFormatException e) {
                data.snmpInterval = 0;
            }
        }
    }

    protected void readReplicationParameter(L7vsConfData data, LinkedList<String> inList) throws FileNotReadException {
        Pair pair;
        if (data == null || inList == null) {
            return;
        }
        HashMap<String, Pair<String, String>> map = new HashMap<String, Pair<String, String>>();
        for (String string : inList) {
            Pair tmpPair;
            String number;
            pair = this.paseKey(string);
            if (pair.first().indexOf(REPLICATION_IPADDR_KEY) != -1) {
                data.replicationOtherNode.host = pair.second();
                continue;
            }
            if (pair.first().indexOf(REPLICATION_SERVICENAME_KEY) != -1) {
                data.replicationOtherNode.port = (String)pair.second();
                continue;
            }
            if (((String)pair.first()).indexOf(REPLICATION_NIC_KEY) != -1) {
                data.replicationNic = (String)pair.second();
                continue;
            }
            if (((String)pair.first()).indexOf(REPLICATION_INTERVAL_KEY) != -1 && ((String)pair.first()).indexOf(REPLICATION_COMPULSORILY_INTERVAL_KEY) == -1) {
                try {
                    data.replicationInterval = Integer.parseInt((String)pair.second());
                }
                catch (NumberFormatException e) {
                    data.replicationInterval = 0;
                }
                continue;
            }
            if (((String)pair.first()).indexOf(REPLICATION_COMPONENT_ID_BASE_KEY) != -1) {
                number = ((String)pair.first()).substring(REPLICATION_COMPONENT_ID_BASE_KEY.length(), REPLICATION_COMPONENT_ID_BASE_KEY.length() + 2);
                tmpPair = (Pair)map.get(number);
                if (tmpPair == null) {
                    map.put(number, new Pair<String, String>((String)pair.second(), ""));
                    continue;
                }
                tmpPair.set((String)pair.first(), (String)tmpPair.second());
                continue;
            }
            if (((String)pair.first()).indexOf(REPLICATION_COMPONENT_SIZE_BASE_KEY) == -1) continue;
            number = ((String)pair.first()).substring(REPLICATION_COMPONENT_SIZE_BASE_KEY.length(), REPLICATION_COMPONENT_SIZE_BASE_KEY.length() + 2);
            tmpPair = (Pair)map.get(number);
            if (tmpPair == null) {
                map.put(number, new Pair<String, String>("", (String)pair.second()));
                continue;
            }
            tmpPair.set((String)tmpPair.first(), (String)pair.second());
        }
        data.component = new HashMap();
        for (Map.Entry entry : map.entrySet()) {
            pair = (Pair)entry.getValue();
            try {
                data.component.put((String)pair.first(), Integer.parseInt((String)pair.second()));
            }
            catch (NumberFormatException e) {
                data.component.put((String)pair.first(), 0);
            }
        }
    }

    protected L7vsConfData loadFromFile() throws FileNotReadException {
        String buffer;
        Stack<String> stack = new Stack<String>();
        try {
            FileReader file = new FileReader(FILENAME);
            BufferedReader reader = new BufferedReader(file);
            while ((buffer = reader.readLine()) != null) {
                if (buffer.length() == 0 || buffer.charAt(0) == '#') continue;
                stack.push(buffer);
            }
        }
        catch (Exception e) {
            FileNotReadException ex = new FileNotReadException();
            ex.setErrMessage("Cannot read file : " + FILENAME + "/ base exception = " + e.getMessage());
            throw ex;
        }
        L7vsConfData data = new L7vsConfData();
        LinkedList<String> tmpList = new LinkedList<String>();
        while (!stack.empty()) {
            buffer = (String)stack.pop();
            int pos = (buffer = buffer.trim()).indexOf(35);
            if (pos == 0) continue;
            if (pos != -1) {
                buffer = buffer.substring(0, pos);
            } else if (buffer.charAt(0) == '[' && buffer.charAt(buffer.length() - 1) == ']') {
                if (buffer.indexOf(LOGGER_MASTER_KEY) != -1) {
                    this.readLoggerParameter(data, tmpList);
                    tmpList.clear();
                    continue;
                }
                if (buffer.indexOf(L7VSADM_MASTER_KEY) != -1) {
                    this.readAdmParameter(data, tmpList);
                    tmpList.clear();
                    continue;
                }
                if (buffer.indexOf(REPLICATION_MASTER_KEY) != -1) {
                    this.readReplicationParameter(data, tmpList);
                    tmpList.clear();
                    continue;
                }
                if (buffer.indexOf(SNMPAGENT_MASTER_KEY) != -1) {
                    this.readSNMPAgentParameter(data, tmpList);
                    tmpList.clear();
                    continue;
                }
            }
            tmpList.addFirst(buffer);
        }
        return data;
    }

    private static String trimQuote(String s) {
        if (s != null && s.matches("^\".*\"$")) {
            s = s.substring(1, s.length() - 1);
        }
        return s;
    }

    protected void searchInsertData(String key, String value, LinkedList<String> list, int start, int end) {
        int i = start;
        while (i < end) {
            String buffer = list.get(i).trim();
            if (buffer.length() != 0) {
                Pair<String, String> pair;
                int commentpos = buffer.indexOf("#");
                if (commentpos != -1) {
                    buffer = buffer.substring(commentpos, buffer.length());
                }
                if ((pair = this.paseKey(buffer)).first().length() != 0 && pair.first().equals(key)) {
                    if (pair.second().equals(L7vsConfController.trimQuote(value))) {
                        return;
                    }
                    StringBuffer buf = new StringBuffer();
                    if (commentpos == -1) {
                        buf.append('#');
                    }
                    buf.append(list.get(i));
                    list.remove(i);
                    list.add(i, buf.toString());
                    list.add(i + 1, String.valueOf(key) + "=" + value);
                    return;
                }
            }
            ++i;
        }
        list.add(end + 1, String.valueOf(key) + "=" + value);
    }

    protected void saveToFile(L7vsConfData data) throws FileNotWriteException {
        int cmntpos;
        String buf;
        LogData.LogLevel level;
        LinkedList<String> datas = new LinkedList<String>();
        try {
            String buffer;
            FileReader file = new FileReader(FILENAME);
            BufferedReader reader = new BufferedReader(file);
            while ((buffer = reader.readLine()) != null) {
                datas.addLast(buffer);
            }
        }
        catch (Exception e) {
            FileNotWriteException ex = new FileNotWriteException();
            ex.setErrMessage("Cannot open file : " + FILENAME);
            throw ex;
        }
        int startpos = 0;
        int endpos = 0;
        int i = 0;
        while (i < datas.size()) {
            String buffer = ((String)datas.get(i)).trim();
            if (buffer.length() != 0 && buffer.charAt(0) != '#') {
                int cmntpos2 = buffer.indexOf("#");
                if (cmntpos2 != -1) {
                    buffer = buffer.substring(0, cmntpos2).trim();
                }
                if (buffer.charAt(0) == '[' && buffer.charAt(buffer.length() - 1) == ']') {
                    if (buffer.indexOf("logger") != -1 || buffer.indexOf("LOGGER") != -1) {
                        startpos = i + 1;
                    } else if (startpos != 0) {
                        endpos = i;
                        break;
                    }
                }
            }
            ++i;
        }
        if (endpos == 0) {
            endpos = datas.size();
        }
        if (data.logger.lbLog.fileName != null && data.logger.lbLog.fileName.length() != 0) {
            this.searchInsertData(LB_LOG_FILENAME_KEY, "\"" + data.logger.lbLog.fileName + "\"", datas, startpos, endpos);
        }
        if (data.logger.lbLog.rotation != null && data.logger.lbLog.rotation.length() != 0) {
            this.searchInsertData(LB_LOG_ROTATION_KEY, "\"" + data.logger.lbLog.rotation + "\"", datas, startpos, ++endpos);
        }
        if (data.logger.lbLog.maxBackupIndex != 0) {
            this.searchInsertData(LB_LOG_MAXBACKUPINDEX_KEY, String.valueOf(data.logger.lbLog.maxBackupIndex), datas, startpos, ++endpos);
        }
        if (data.logger.lbLog.rotationTiming != null && data.logger.lbLog.rotationTiming.length() != 0) {
            this.searchInsertData(LB_LOG_ROTATE_TIMING_KEY, "\"" + data.logger.lbLog.rotationTiming + "\"", datas, startpos, ++endpos);
        }
        if (data.logger.lbLog.rotationTimingValue != null && data.logger.lbLog.rotationTimingValue.length() != 0) {
            this.searchInsertData(LB_LOG_ROTATE_TIMING_KEY, "\"" + data.logger.lbLog.rotationTimingValue + "\"", datas, startpos, ++endpos);
        }
        if (data.logger.lbLog.maxFileSize != null && data.logger.lbLog.maxFileSize.length() != 0) {
            this.searchInsertData(LB_LOG_MAXFILESIZE_KEY, "\"" + data.logger.lbLog.maxFileSize + "\"", datas, startpos, ++endpos);
        }
        if ((level = data.logger.lbLog.logLevel.get((Object)LogData.LogCategory.L7VSD_NETWORK)) != null && (buf = L7vsConfController.convLogLevelToLogString(level)).length() != 0) {
            this.searchInsertData(LB_LOGCATEGORY_NETWORK_KEY, buf, datas, startpos, ++endpos);
        }
        if ((level = data.logger.lbLog.logLevel.get((Object)LogData.LogCategory.L7VSD_NETWORK_BANDWIDTH)) != null && (buf = L7vsConfController.convLogLevelToLogString(level)).length() != 0) {
            this.searchInsertData(LB_LOGCATEGORY_NETWORK_BANDWIDTH_KEY, buf, datas, startpos, ++endpos);
        }
        if ((level = data.logger.lbLog.logLevel.get((Object)LogData.LogCategory.L7VSD_NETWORK_NUM_CONNECTION)) != null && (buf = L7vsConfController.convLogLevelToLogString(level)).length() != 0) {
            this.searchInsertData(LB_LOGCATEGORY_NETWORK_NUM_CONNECTION_KEY, buf, datas, startpos, ++endpos);
        }
        if ((level = data.logger.lbLog.logLevel.get((Object)LogData.LogCategory.L7VSD_NETWORK_QOS)) != null && (buf = L7vsConfController.convLogLevelToLogString(level)).length() != 0) {
            this.searchInsertData(LB_LOGCATEGORY_NETWORK_QOS_KEY, buf, datas, startpos, ++endpos);
        }
        if ((level = data.logger.lbLog.logLevel.get((Object)LogData.LogCategory.L7VSD_VIRTUAL_SERVICE)) != null && (buf = L7vsConfController.convLogLevelToLogString(level)).length() != 0) {
            this.searchInsertData(LB_LOGCATEGORY_VIRTUALSERVICE_KEY, buf, datas, startpos, ++endpos);
        }
        if ((level = data.logger.lbLog.logLevel.get((Object)LogData.LogCategory.L7VSD_REAL_SERVER)) != null && (buf = L7vsConfController.convLogLevelToLogString(level)).length() != 0) {
            this.searchInsertData(LB_LOGCATEOGRY_REALSERVER_KEY, buf, datas, startpos, ++endpos);
        }
        if ((level = data.logger.lbLog.logLevel.get((Object)LogData.LogCategory.L7VSD_SORRY_SERVER)) != null && (buf = L7vsConfController.convLogLevelToLogString(level)).length() != 0) {
            this.searchInsertData(LB_LOGCATEOGRY_SORRYSERVER_KEY, buf, datas, startpos, ++endpos);
        }
        if ((level = data.logger.lbLog.logLevel.get((Object)LogData.LogCategory.L7VSD_REAL_SERVER_BALANCING)) != null && (buf = L7vsConfController.convLogLevelToLogString(level)).length() != 0) {
            this.searchInsertData(LB_LOGCATEOGRY_REALSERVER_BALANCING_KEY, buf, datas, startpos, ++endpos);
        }
        if ((level = data.logger.lbLog.logLevel.get((Object)LogData.LogCategory.L7VSD_REPLICATION)) != null && (buf = L7vsConfController.convLogLevelToLogString(level)).length() != 0) {
            this.searchInsertData(LB_LOGCATEOGRY_REPLICATION_KEY, buf, datas, startpos, ++endpos);
        }
        if ((level = data.logger.lbLog.logLevel.get((Object)LogData.LogCategory.L7VSD_START_STOP)) != null && (buf = L7vsConfController.convLogLevelToLogString(level)).length() != 0) {
            this.searchInsertData(LB_LOGCATEOGRY_STARTSTOP_KEY, buf, datas, startpos, ++endpos);
        }
        if ((level = data.logger.lbLog.logLevel.get((Object)LogData.LogCategory.L7VSD_SYSTEM)) != null && (buf = L7vsConfController.convLogLevelToLogString(level)).length() != 0) {
            this.searchInsertData(LB_LOGCATEOGRY_SYSTEM_KEY, buf, datas, startpos, ++endpos);
        }
        if ((level = data.logger.lbLog.logLevel.get((Object)LogData.LogCategory.L7VSD_SYSTEM_MEMORY)) != null && (buf = L7vsConfController.convLogLevelToLogString(level)).length() != 0) {
            this.searchInsertData(LB_LOGCATEOGRY_SYSTEMMEMORY_KEY, buf, datas, startpos, ++endpos);
        }
        if ((level = data.logger.lbLog.logLevel.get((Object)LogData.LogCategory.L7VSD_SYSTEM_SOCKET)) != null && (buf = L7vsConfController.convLogLevelToLogString(level)).length() != 0) {
            this.searchInsertData(LB_LOGCATEOGRY_SYSTEMSOCKET_KEY, buf, datas, startpos, ++endpos);
        }
        if ((level = data.logger.lbLog.logLevel.get((Object)LogData.LogCategory.L7VSD_SYSTEM_SIGNAL)) != null && (buf = L7vsConfController.convLogLevelToLogString(level)).length() != 0) {
            this.searchInsertData(LB_LOGCATEOGRY_SYSTEMSIGNAL_KEY, buf, datas, startpos, ++endpos);
        }
        if ((level = data.logger.lbLog.logLevel.get((Object)LogData.LogCategory.L7VSD_ENVIRONMENT)) != null && (buf = L7vsConfController.convLogLevelToLogString(level)).length() != 0) {
            this.searchInsertData(LB_LOGCATEOGRY_ENVIROMENT_KEY, buf, datas, startpos, ++endpos);
        }
        if ((level = data.logger.lbLog.logLevel.get((Object)LogData.LogCategory.L7VSD_ENVIRONMENT_PARAMETER)) != null && (buf = L7vsConfController.convLogLevelToLogString(level)).length() != 0) {
            this.searchInsertData(LB_LOGCATEOGRY_ENVIROMENTPARAMTER_KEY, buf, datas, startpos, ++endpos);
        }
        if ((level = data.logger.lbLog.logLevel.get((Object)LogData.LogCategory.L7VSD_LOGGER)) != null && (buf = L7vsConfController.convLogLevelToLogString(level)).length() != 0) {
            this.searchInsertData(LB_LOGCATEGORY_LOGGER_KEY, buf, datas, startpos, ++endpos);
        }
        if ((level = data.logger.lbLog.logLevel.get((Object)LogData.LogCategory.L7VSD_PARAMETER)) != null && (buf = L7vsConfController.convLogLevelToLogString(level)).length() != 0) {
            this.searchInsertData(LB_LOGCATEGORY_PARAMTER, buf, datas, startpos, ++endpos);
        }
        if ((level = data.logger.lbLog.logLevel.get((Object)LogData.LogCategory.L7VSD_SCHEDULE)) != null && (buf = L7vsConfController.convLogLevelToLogString(level)).length() != 0) {
            this.searchInsertData(LB_LOGCATEGORY_SCHEDULE_KEY, buf, datas, startpos, ++endpos);
        }
        if ((level = data.logger.lbLog.logLevel.get((Object)LogData.LogCategory.L7VSD_EVENT)) != null && (buf = L7vsConfController.convLogLevelToLogString(level)).length() != 0) {
            this.searchInsertData(LB_LOGCATEGORY_EVENT_KEY, buf, datas, startpos, ++endpos);
        }
        if ((level = data.logger.lbLog.logLevel.get((Object)LogData.LogCategory.L7VSD_PROGRAM)) != null && (buf = L7vsConfController.convLogLevelToLogString(level)).length() != 0) {
            this.searchInsertData(LB_LOGCATEGORY_PROGRAM_KEY, buf, datas, startpos, ++endpos);
        }
        if ((level = data.logger.lbLog.logLevel.get((Object)LogData.LogCategory.L7VSD_PROTOCOL)) != null && (buf = L7vsConfController.convLogLevelToLogString(level)).length() != 0) {
            this.searchInsertData(LB_LOGCATEGORY_PROTOCOL_KEY, buf, datas, startpos, ++endpos);
        }
        if ((level = data.logger.lbLog.logLevel.get((Object)LogData.LogCategory.L7VSD_MODULE)) != null && (buf = L7vsConfController.convLogLevelToLogString(level)).length() != 0) {
            this.searchInsertData(LB_LOGCATEGORY_MODULE_KEY, buf, datas, startpos, ++endpos);
        }
        if (data.logger.admLog.fileName != null && data.logger.admLog.fileName.length() != 0) {
            this.searchInsertData(ADM_LOG_FILENAME_KEY, "\"" + data.logger.admLog.fileName + "\"", datas, startpos, ++endpos);
        }
        if (data.logger.admLog.rotation != null && data.logger.admLog.rotation.length() != 0) {
            this.searchInsertData(ADM_LOG_ROTATION_KEY, "\"" + data.logger.admLog.rotation + "\"", datas, startpos, ++endpos);
        }
        if (data.logger.admLog.maxBackupIndex != 0) {
            this.searchInsertData(ADM_LOG_MAXBACKUPINDEX_KEY, String.valueOf(data.logger.admLog.maxBackupIndex), datas, startpos, ++endpos);
        }
        if (data.logger.admLog.rotationTiming != null && data.logger.admLog.rotationTiming.length() != 0) {
            this.searchInsertData(ADM_LOG_ROTATE_TIMING_KEY, "\"" + data.logger.admLog.rotationTiming + "\"", datas, startpos, ++endpos);
        }
        if (data.logger.admLog.rotationTimingValue != null && data.logger.admLog.rotationTimingValue.length() != 0) {
            this.searchInsertData(ADM_LOG_ROTATE_TIMING_VALUE_KEY, "\"" + data.logger.admLog.rotationTimingValue + "\"", datas, startpos, ++endpos);
        }
        if (data.logger.admLog.maxFileSize != null && data.logger.admLog.maxFileSize.length() != 0) {
            this.searchInsertData(ADM_LOG_MAXFILESIZE_KEY, "\"" + data.logger.admLog.maxFileSize + "\"", datas, startpos, ++endpos);
        }
        if ((level = data.logger.admLog.logLevel.get((Object)LogData.LogCategory.L7VSADM_PARSE)) != null && (buf = L7vsConfController.convLogLevelToLogString(level)).length() != 0) {
            this.searchInsertData(ADM_LOGCATEGORY_PARSE_KEY, buf, datas, startpos, ++endpos);
        }
        if ((level = data.logger.admLog.logLevel.get((Object)LogData.LogCategory.L7VSADM_OPERATE)) != null && (buf = L7vsConfController.convLogLevelToLogString(level)).length() != 0) {
            this.searchInsertData(ADM_LOGCATEGORY_OPERATE_KEY, buf, datas, startpos, ++endpos);
        }
        if ((level = data.logger.admLog.logLevel.get((Object)LogData.LogCategory.L7VSADM_COMMUNICATE)) != null && (buf = L7vsConfController.convLogLevelToLogString(level)).length() != 0) {
            this.searchInsertData(ADM_LOGCATEGORY_COMMUNICATE_KEY, buf, datas, startpos, ++endpos);
        }
        if ((level = data.logger.admLog.logLevel.get((Object)LogData.LogCategory.L7VSADM_CONFIG_RESULT)) != null && (buf = L7vsConfController.convLogLevelToLogString(level)).length() != 0) {
            this.searchInsertData(ADM_LOGCATEGORY_CONFIG_RESULT_KEY, buf, datas, startpos, ++endpos);
        }
        if ((level = data.logger.admLog.logLevel.get((Object)LogData.LogCategory.L7VSADM_COMMON)) != null && (buf = L7vsConfController.convLogLevelToLogString(level)).length() != 0) {
            this.searchInsertData(ADM_LOGCATEOGRY_COMMON, buf, datas, startpos, ++endpos);
        }
        if ((level = data.logger.admLog.logLevel.get((Object)LogData.LogCategory.L7VSADM_LOGGER)) != null && (buf = L7vsConfController.convLogLevelToLogString(level)).length() != 0) {
            this.searchInsertData(ADM_LOGCATEGORY_LOGGER, buf, datas, startpos, ++endpos);
        }
        if ((level = data.logger.admLog.logLevel.get((Object)LogData.LogCategory.L7VSADM_PARAMETER)) != null && (buf = L7vsConfController.convLogLevelToLogString(level)).length() != 0) {
            this.searchInsertData(ADM_LOGCATEGORY_PARAMETER, buf, datas, startpos, ++endpos);
        }
        if ((level = data.logger.admLog.logLevel.get((Object)LogData.LogCategory.L7VSADM_PROTOCOL)) != null && (buf = L7vsConfController.convLogLevelToLogString(level)).length() != 0) {
            this.searchInsertData(ADM_LOGCATEOGRY_PROTOCOL, buf, datas, startpos, ++endpos);
        }
        if ((level = data.logger.admLog.logLevel.get((Object)LogData.LogCategory.L7VSADM_MODULE)) != null && (buf = L7vsConfController.convLogLevelToLogString(level)).length() != 0) {
            this.searchInsertData(ADM_LOGCATEOGRY_MODULE, buf, datas, startpos, ++endpos);
        }
        if (data.logger.snmpLog.fileName != null && data.logger.snmpLog.fileName.length() != 0) {
            this.searchInsertData(SNMP_LOG_FILENAME_KEY, "\"" + data.logger.snmpLog.fileName + "\"", datas, startpos, ++endpos);
        }
        if (data.logger.snmpLog.rotation != null && data.logger.snmpLog.rotation.length() != 0) {
            this.searchInsertData(SNMP_LOG_ROTATION_KEY, "\"" + data.logger.snmpLog.rotation + "\"", datas, startpos, ++endpos);
        }
        if (data.logger.snmpLog.maxBackupIndex != 0) {
            this.searchInsertData(SNMP_LOG_MAXBACKUPINDEX_KEY, String.valueOf(data.logger.snmpLog.maxBackupIndex), datas, startpos, ++endpos);
        }
        if (data.logger.snmpLog.rotationTiming != null && data.logger.snmpLog.rotationTiming.length() != 0) {
            this.searchInsertData(SNMP_LOG_ROTATE_TIMING_KEY, "\"" + data.logger.snmpLog.rotationTiming + "\"", datas, startpos, ++endpos);
        }
        if (data.logger.snmpLog.rotationTimingValue != null && data.logger.snmpLog.rotationTimingValue.length() != 0) {
            this.searchInsertData(SNMP_LOG_ROTATE_TIMING_VALUE_KEY, "\"" + data.logger.snmpLog.rotationTimingValue + "\"", datas, startpos, ++endpos);
        }
        if (data.logger.snmpLog.maxFileSize != null && data.logger.snmpLog.maxFileSize.length() != 0) {
            this.searchInsertData(SNMP_MAX_FILESIZE_KEY, "\"" + data.logger.snmpLog.maxFileSize + "\"", datas, startpos, ++endpos);
        }
        if ((level = data.logger.snmpLog.logLevel.get((Object)LogData.LogCategory.SNMPAGENT_START_STOP)) != null && (buf = L7vsConfController.convLogLevelToLogString(level)).length() != 0) {
            this.searchInsertData(SNMP_LOGCATEOGRY_STARTSTOP_KEY, buf, datas, startpos, ++endpos);
        }
        if ((level = data.logger.snmpLog.logLevel.get((Object)LogData.LogCategory.SNMPAGENT_MANAGER_RECEIVE)) != null && (buf = L7vsConfController.convLogLevelToLogString(level)).length() != 0) {
            this.searchInsertData(SNMP_LOGCATEGORY_MANAGER_RECEIVE_KEY, buf, datas, startpos, ++endpos);
        }
        if ((level = data.logger.snmpLog.logLevel.get((Object)LogData.LogCategory.SNMPAGENT_MANAGER_SEND)) != null && (buf = L7vsConfController.convLogLevelToLogString(level)).length() != 0) {
            this.searchInsertData(SNMP_LOGCATEGORY_MANAGER_SEND_KEY, buf, datas, startpos, ++endpos);
        }
        if ((level = data.logger.snmpLog.logLevel.get((Object)LogData.LogCategory.SNMPAGENT_L7VSD_RECEIVE)) != null && (buf = L7vsConfController.convLogLevelToLogString(level)).length() != 0) {
            this.searchInsertData(SNMP_LOGCATEGORY_L7VSD_RECEIVE_KEY, buf, datas, startpos, ++endpos);
        }
        if ((level = data.logger.snmpLog.logLevel.get((Object)LogData.LogCategory.SNMPAGENT_L7VSD_SEND)) != null && (buf = L7vsConfController.convLogLevelToLogString(level)).length() != 0) {
            this.searchInsertData(SNMP_LOGCATEGORY_L7VSD_SEND_KEY, buf, datas, startpos, ++endpos);
        }
        if ((level = data.logger.snmpLog.logLevel.get((Object)LogData.LogCategory.SNMPAGENT_LOGGER)) != null && (buf = L7vsConfController.convLogLevelToLogString(level)).length() != 0) {
            this.searchInsertData(SNMP_LOGCATEGORY_LOGGER, buf, datas, startpos, ++endpos);
        }
        if ((level = data.logger.snmpLog.logLevel.get((Object)LogData.LogCategory.SNMPAGENT_PARAMETER)) != null && (buf = L7vsConfController.convLogLevelToLogString(level)).length() != 0) {
            this.searchInsertData(SNMP_LOGCATEGORY_PARAMETER, buf, datas, startpos, ++endpos);
        }
        startpos = 0;
        endpos = 0;
        int i2 = 0;
        while (i2 < datas.size()) {
            String buffer = datas.get(i2).trim();
            if (buffer.length() != 0 && buffer.charAt(0) != '#') {
                cmntpos = buffer.indexOf("#");
                if (cmntpos != -1) {
                    buffer = buffer.substring(0, cmntpos).trim();
                }
                if (buffer.charAt(0) == '[' && buffer.charAt(buffer.length() - 1) == ']') {
                    if (buffer.indexOf("l7vsadm") != -1 || buffer.indexOf("L7VSADM") != -1) {
                        startpos = i2 + 1;
                    } else if (startpos != 0) {
                        endpos = i2;
                        break;
                    }
                }
            }
            ++i2;
        }
        if (endpos == 0) {
            endpos = datas.size();
        }
        if (data.admConInterval != 0) {
            this.searchInsertData(ADM_CMD_INTERVAL_KEY, String.valueOf(data.admCmdInterval), datas, startpos, ++endpos);
        }
        if (data.admCmdCount != 0) {
            this.searchInsertData(ADM_CMD_COUNT_KEY, String.valueOf(data.admCmdCount), datas, startpos, ++endpos);
        }
        if (data.admConInterval != 0) {
            this.searchInsertData(ADM_CON_INTERVAL_KEY, String.valueOf(data.admConInterval), datas, startpos, ++endpos);
        }
        if (data.admConCount != 0) {
            this.searchInsertData(ADM_CON_COUNT_KEY, String.valueOf(data.admConCount), datas, startpos, ++endpos);
        }
        startpos = 0;
        endpos = 0;
        i2 = 0;
        while (i2 < datas.size()) {
            String buffer = datas.get(i2).trim();
            if (buffer.length() != 0 && buffer.charAt(0) != '#') {
                cmntpos = buffer.indexOf("#");
                if (cmntpos != -1) {
                    buffer = buffer.substring(0, cmntpos).trim();
                }
                if (buffer.charAt(0) == '[' && buffer.charAt(buffer.length() - 1) == ']') {
                    if (buffer.indexOf("replication") != -1 || buffer.indexOf("REPLICATION") != -1) {
                        startpos = i2 + 1;
                    } else if (startpos != 0) {
                        endpos = i2;
                        break;
                    }
                }
            }
            ++i2;
        }
        if (endpos == 0) {
            endpos = datas.size();
        }
        if (data.replicationOtherNode.host != null && data.replicationOtherNode.host.length() != 0) {
            this.searchInsertData(REPLICATION_IPADDR_KEY, "\"" + data.replicationOtherNode.host + "\"", datas, startpos, ++endpos);
        }
        if (data.replicationOtherNode.port != null && data.replicationOtherNode.port.length() != 0) {
            this.searchInsertData(REPLICATION_SERVICENAME_KEY, "\"" + data.replicationOtherNode.port + "\"", datas, startpos, ++endpos);
        }
        if (data.replicationNic != null && data.replicationNic.length() != 0) {
            this.searchInsertData(REPLICATION_NIC_KEY, "\"" + data.replicationNic + "\"", datas, startpos, ++endpos);
        }
        if (data.replicationInterval != 0) {
            this.searchInsertData(REPLICATION_INTERVAL_KEY, String.valueOf(data.replicationInterval), datas, startpos, ++endpos);
        }
        if (data.component != null) {
            int cmpno = 0;
            for (Map.Entry<String, Integer> entry : data.component.entrySet()) {
                StringBuffer compIdKey = new StringBuffer();
                StringBuffer compSizeKey = new StringBuffer();
                compIdKey.append(REPLICATION_COMPONENT_ID_BASE_KEY);
                compSizeKey.append(REPLICATION_COMPONENT_SIZE_BASE_KEY);
                if (cmpno < 10) {
                    compIdKey.append("0");
                    compSizeKey.append("0");
                }
                compIdKey.append(cmpno);
                compSizeKey.append(cmpno);
                this.searchInsertData(compIdKey.toString(), "\"" + entry.getKey() + "\"", datas, startpos, ++endpos);
                this.searchInsertData(compSizeKey.toString(), String.valueOf(entry.getValue()), datas, startpos, ++endpos);
                ++cmpno;
            }
        }
        startpos = 0;
        endpos = 0;
        i2 = 0;
        while (i2 < datas.size()) {
            String buffer = datas.get(i2).trim();
            if (buffer.length() != 0 && buffer.charAt(0) != '#') {
                int cmntpos3 = buffer.indexOf("#");
                if (cmntpos3 != -1) {
                    buffer = buffer.substring(0, cmntpos3).trim();
                }
                if (buffer.charAt(0) == '[' || buffer.charAt(buffer.length() - 1) == ']') {
                    if (buffer.indexOf("snmpagent") != -1 || buffer.indexOf("SNMPAGENT") != -1) {
                        startpos = i2 + 1;
                    } else if (startpos != 0) {
                        endpos = i2;
                        break;
                    }
                }
            }
            ++i2;
        }
        if (endpos == 0) {
            endpos = datas.size();
        }
        if (data.snmpNIC != null && data.snmpNIC.length() != 0) {
            this.searchInsertData(SNMPAGENT_NIC_KEY, "\"" + data.snmpNIC + "\"", datas, startpos, ++endpos);
        }
        if (data.snmpIpAddr != null && data.snmpIpAddr.length() != 0) {
            this.searchInsertData(SNMPAGENT_IPADDR_KEY, "\"" + data.snmpIpAddr + "\"", datas, startpos, ++endpos);
        }
        if (data.snmpPort != null && data.snmpPort.length() != 0) {
            this.searchInsertData(SNMPAGENT_PORT_KEY, "\"" + data.snmpPort + "\"", datas, startpos, ++endpos);
        }
        if (data.snmpInterval != 0) {
            this.searchInsertData(SNMPAGENT_INTERVAL_KEY, String.valueOf(data.snmpInterval), datas, startpos, endpos);
        }
        try {
            File file = new File(FILENAME);
            if (file.exists()) {
                Date date = new Date();
                File backfile = new File(String.valueOf(FILENAME) + ".back_" + String.valueOf(date.getTime()));
                file.renameTo(backfile);
                file = new File(FILENAME);
            }
            FileWriter writer = new FileWriter(file);
            Iterator itr = datas.iterator();
            while (itr.hasNext()) {
                StringBuffer buf2 = new StringBuffer((String)itr.next());
                buf2.append('\n');
                writer.write(buf2.toString());
            }
            writer.flush();
        }
        catch (Exception e) {
            FileNotWriteException ex = new FileNotWriteException();
            ex.setErrMessage("Cannot write file : " + FILENAME);
            throw ex;
        }
    }

    public synchronized L7vsConfData getConfData() throws FileNotReadException {
        return this.loadFromFile();
    }

    public synchronized void setConfData(L7vsConfData cf) throws FileNotWriteException {
        if (cf == null) {
            FileNotWriteException exception = new FileNotWriteException();
            exception.setErrMessage("L7vConfData class is null!");
            exception.setErrNo(0);
            throw exception;
        }
        this.saveToFile(cf);
    }

    protected class ComponentSet {
        public Pair<String, String> idPair;
        public Pair<String, String> sizePair;

        protected ComponentSet() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class Pair<E, N> {
        protected E elementFirst;
        protected N elementSecond;

        public Pair(E firstIn, N secondIn) {
            this.elementFirst = firstIn;
            this.elementSecond = secondIn;
        }

        public void set(E firstIn, N secondIn) {
            this.elementFirst = firstIn;
            this.elementSecond = secondIn;
        }

        public E first() {
            return this.elementFirst;
        }

        public N second() {
            return this.elementSecond;
        }
    }
}

