package org.ultramonkey.l7.controller;

import java.util.regex.*;
import java.io.*;

import org.apache.log4j.Logger;
import org.ultramonkey.l7.model.LogCategorySet;

/**
 * 
 * <p>
 * class GetServ
 * </p>
 * <p>
 * Copyright(c) NTT COMWARE 2008
 * </p>
 * 
 * @author tanuma
 */
public class GetServ {

	/**
	 * services filename
	 */
	private static final String SERVICE_FILENAME = "/etc/services";

	/**
	 * 
	 * <p>
	 * byName method
	 * </p>
	 * 
	 * @param name
	 *            service name
	 * @param proto
	 *            protocol name
	 * @return
	 */
	public static String byName(String name, String proto) {
		// --- debug log (in method) ---
		Logger ioFileLogger = Logger.getLogger(LogCategorySet.GUI_IO_FILE);
		if (ioFileLogger.isDebugEnabled()) {
			ioFileLogger
					.debug("11584 GetServ::byName(String name, String proto) in name=\""
							+ name + "\", proto=\"" + proto + "\"");
		}
		// --- debug log (in method) ---

		if (name == null || proto == null) {
			// --- debug log (out method) ---
			if (ioFileLogger.isDebugEnabled()) {
				ioFileLogger
						.debug("11585 GetServ::byName(String name, String proto) out return=null");
			}
			// --- debug log (out method) ---
			return null;
		}

		try {
			String port = null;
			String line;

			String regex = "^([-_a-zA-Z0-9]+)\\s+(\\d+)/([-_a-zA-Z0-9]+)([-_a-zA-Z0-9\\s]+)*$";
			Pattern p = Pattern.compile(regex);

			BufferedReader br = new BufferedReader(new InputStreamReader(
					new FileInputStream(SERVICE_FILENAME)));

			while ((line = br.readLine()) != null && port == null) {
				line = line.replaceAll("#.*", "");
				if (line.length() != 0) {
					Matcher m = p.matcher(line.trim());
					if (m.matches() && m.group(3).equals(proto)) {
						if (m.group(1).equals(name)) {
							port = m.group(2);
						} else if (m.group(4) != null) {
							String[] aliases = m.group(4).split("\\s");
							for (String alias : aliases) {
								if (alias.equals(name)) {
									port = m.group(2);
									break;
								}
							}
						}
					}
				}
			}
			br.close();
			if (port != null) {
				// --- debug log (out method) ---
				if (ioFileLogger.isDebugEnabled()) {
					ioFileLogger.debug("11586 GetServ::byName(String name, String proto) out return=\"" + port + "\"");
				}
				// --- debug log (out method) ---
				return port;
			} else {
				// --- debug log (out method) ---
				if (ioFileLogger.isDebugEnabled()) {
					ioFileLogger.debug("11587 GetServ::byName(String name, String proto) out return=\"" + name + "\"");
				}
				// --- debug log (out method) ---
				return name;
			}
		} catch (IOException ioe) {
			// --- debug log (out method) ---
			if (ioFileLogger.isDebugEnabled()) {
				ioFileLogger.debug("11588 GetServ::byName(String name, String proto) out return=null");
			}
			// --- debug log (out method) ---
			return null;
		}
	}
}
