<%@ page
	import="org.ultramonkey.l7.model.*,org.ultramonkey.l7.controller.*,org.ultramonkey.l7.view.*,java.util.*"
	language="java" contentType="text/html; charset=UTF-8"
	pageEncoding="UTF-8"%>

<%
	/*
	 * check session
	 */
    L7guiServletBase base = new L7guiServletBase();
	if (session.isNew() || base.checkSession(session) == false) {
		MessageView error = new MessageView(41302,
		LogCategorySet.GUI_USER_AUTHENTICATION,
		Message.INVALID_SESSSION);
		session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
		response.sendRedirect(RedirectPages.LOGIN);
		return;
	}

	
	/*
	 * check snmpAgent status
	 */
	L7guiFramework framework = new L7guiFramework();
	SnmpAgentData snmp = framework.getSnmpAgentData();
	if (snmp == null) {
		MessageView error = new MessageView(41303,
		LogCategorySet.GUI_IO_COMMAND,
		Message.UNEXPECTED_ERROR);
		session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
		response.sendRedirect(RedirectPages.LOGIN);
	}
	
	/*
	 * get cluster status
	 */

	ClusterData cd = framework.getClusterData();
	if (cd == null) {
		MessageView error = new MessageView(41304,
		LogCategorySet.GUI_IO_COMMAND,
		Message.CLUSTER_DATA_ERROR);
		session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
		response.sendRedirect(RedirectPages.LOGIN);
	}

	/*
	 * fix style seat
	 */
	String cssSeat = "l7gui_single_style.css";
	if (cd.self_status == ClusterStatus.ACTIVE) {
		cssSeat = "l7gui_act_style.css";
	} else if (cd.self_status == ClusterStatus.STANDBY) {
		cssSeat = "l7gui_sby_style.css";
	}
%>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
    <meta http-equiv="Pragma" content="no-cache">
	<meta http-equiv="Cache-Control" content="no-cache">
	<meta http-equiv="Expires" content="0"> 			
	<meta http-equiv="Content-Script-Type" content="text/javascript" />
	<meta http-equiv="Content-Style-Type" content="text/css" />
	<script src="l7gui.js" type="text/javascript"></script>
	<noscript>
	<meta http-equiv="refresh"
		content="<%= RedirectPages.NOSCRIPT_TIME %>; url=<%= RedirectPages.LOGIN %>" />
	</noscript>
	<link rel="stylesheet" type="text/css" href="<%=cssSeat %>" />
	<link rel="shortcut icon" href="images/favicon.ico" />

<title>Log Top</title>

</head>
<body class="normal">
<jsp:include page="menu.jsp" flush="false" />

<div id="content">

<h1>Log Info</h1>

<h2>Log List</h2>
<h4>Please select one of the following logs that you would like to download or change log level.</h4><br />

<h3>- <a href="log_lb.jsp">Load balancer (l7vsd)</a></h3>
<h3>- <a href="log_adm.jsp">Admin command (l7vsadm)</a></h3>
<h3>- <a href="log_directord.jsp">Moniter RealServer (l7directord)</a></h3>
<% if (snmp.status == SnmpAgentStatus.CONNECTING){
%>
<h3>- <a href="log_snmp.jsp">SNMPAgent (l7agent)</a></h3>
<%
}
%>
<h3>- <a href="log_gui.jsp">GUI (l7gui)</a></h3>
<%
	if (cd.self_status == ClusterStatus.ACTIVE
		|| cd.self_status == ClusterStatus.STANDBY) {
%>

	<h3>- <a href="log_sync.jsp">Sync Resource (l7sync)</a></h3>
	<h3>- <a href="log_ha.jsp">Cluster</a></h3>
<%
}
%>

</div>
</body>
</html>
