package org.ultramonkey.l7.view;

import java.io.IOException;
import java.util.Enumeration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.log4j.Logger;
import org.ultramonkey.l7.model.*;

/**
 * 
 * <p>
 * class PwChangeServlet
 * </p>
 * <p>
 * Copyright(c) NTT COMWARE 2008
 * </p>
 * 
 * @author kubota
 */

public class UserModServlet extends org.ultramonkey.l7.view.L7guiServletBase {
	static final long serialVersionUID = 1L;

	private Logger logger = Logger.getLogger(LogCategorySet.GUI_IO);

	/*
	 * (non-Java-doc)
	 * 
	 * @see javax.servlet.http.HttpServlet#HttpServlet()
	 */
	public UserModServlet() {
		super();
        // --- debug log (constructor) ---
		if (logger.isDebugEnabled()) {
			logger.debug("11414 class UserModServlet created.");
		}
		// --- debug log (constructor) ---
	}

	/*
	 * (non-Java-doc)
	 * 
	 * @see javax.servlet.http.HttpServlet#doGet(HttpServletRequest request,
	 *      HttpServletResponse response)
	 */
	protected void doGet(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		// --- debug log (in method) ---
		if (logger.isDebugEnabled()) {
			StringBuffer buf = new StringBuffer();
            buf.append("UserModServlet::doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException in ");
            buf.append("request=(" + request + "), ");
            buf.append("response=(" + response + ")");
            logger.debug("11415 " + buf.toString());
            request.setCharacterEncoding("UTF-8");
			logger.debug("11416 QueryString=\"" + request.getQueryString() + "\"");
		}
		// --- debug log (in method) ---

		response.sendRedirect(RedirectPages.LOGIN);

		// --- debug log (out method) ---
		if (logger.isDebugEnabled()) {
            logger.debug("11417 UserModServlet::doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
		}
		// --- debug log (out method) ---
		return;
	}

	/*
	 * (non-Java-doc)
	 * 
	 * @see javax.servlet.http.HttpServlet#doPost(HttpServletRequest request,
	 *      HttpServletResponse response)
	 */
	protected void doPost(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		// --- debug log (in method) ---
		if (logger.isDebugEnabled()) {
			StringBuffer buf = new StringBuffer();
            buf.append("UserModServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException in ");
            buf.append("request=(" + request + "), ");
            buf.append("response=(" + response + ")");
            logger.debug("11418 " + buf.toString());
            request.setCharacterEncoding("UTF-8");
			Enumeration keys = request.getParameterNames();
			String post = "";
			while (keys.hasMoreElements()) {
				if (post.length() != 0)
					post += "&";
				String key = (String) keys.nextElement();
				post += key + "=" + request.getParameter(key);
			}
			logger.debug("11419 PostData=\"" + post + "\"");
		}
		// --- debug log (in method) ---

		// check login session
		super.doPost(request, response);

		HttpSession session = request.getSession(false);
		if (login == false || session == null) {
			if (session != null) {
				MessageView error = new MessageView(41184, LogCategorySet.GUI_USER_AUTHENTICATION,
						Message.INVALID_SESSSION);
				session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
			}
			response.sendRedirect(RedirectPages.LOGIN);
			// --- debug log (out method) ---
			if (logger.isDebugEnabled()) {
	            logger.debug("11420 UserModServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
			}
			// --- debug log (out method) ---
			return;
		}

		UserData currentUser = (UserData) session
				.getAttribute(SessionKeys.LOGIN_SESSION);
		if (currentUser == null) {
			MessageView error = new MessageView(41185, LogCategorySet.GUI_USER_AUTHENTICATION,
					Message.UNEXPECTED_ERROR);
			session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
			response.sendRedirect(RedirectPages.LOGIN);
			// --- debug log (out method) ---
			if (logger.isDebugEnabled()) {
	            logger.debug("11421 UserModServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
			}
			// --- debug log (out method) ---
			return;
		}

		// post Data check
        request.setCharacterEncoding("UTF-8");
		String description = request.getParameter("description");
		String curPass = request.getParameter("password");
		String newPass1 = request.getParameter("new1_passwd");
		String newPass2 = request.getParameter("new2_passwd");
		String button_mode = request.getParameter("button");
		if ((description == null) || (curPass == null) || (newPass1 == null)
				|| (newPass2 == null) || (button_mode == null)
				|| (button_mode.equals(ButtonMode.CHANGE) == false)) {
			MessageView error = new MessageView(41186, LogCategorySet.GUI_USER_MANAGE,
					Message.UNEXPECTED_ERROR);
			session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
			response.sendRedirect(RedirectPages.LOGIN);
			// --- debug log (out method) ---
			if (logger.isDebugEnabled()) {
	            logger.debug("11422 UserModServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
			}
			// --- debug log (out method) ---
			return;
		}

		boolean validationFlag = true;
		validationFlag = validationCheck(session, description, curPass,
				newPass1, newPass2);
		if (validationFlag == false) {
			UserData inputUser = new UserData();
			inputUser.description = description;
			session.setAttribute(SessionKeys.INPUT_USERDATA, inputUser);
			response.sendRedirect(RedirectPages.USER_MODIFY);
			// --- debug log (out method) ---
			if (logger.isDebugEnabled()) {
	            logger.debug("11423 UserModServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
			}
			// --- debug log (out method) ---
			return;
		}

		// User authentication
		UserManager user = UserManager.getInstance();
		UserData authCheck = null;
		try {
			authCheck = user.authUser(currentUser.userName, curPass);
		} catch (Exception e) {
			MessageView error = new MessageView(41187, LogCategorySet.GUI_START_STOP,
					Message.UNEXPECTED_ERROR);
			session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
			response.sendRedirect(RedirectPages.LOGIN);
			// --- debug log (out method) ---
			if (logger.isDebugEnabled()) {
	            logger.debug("11424 UserModServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
			}
			// --- debug log (out method) ---
			return;
		}

		if (authCheck == null) {
			MessageView error = new MessageView(21076, LogCategorySet.GUI_USER_MANAGE,
					Message.PASSWORD_INVALID);
			session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
			response.sendRedirect(RedirectPages.USER_MODIFY);
			// --- debug log (out method) ---
			if (logger.isDebugEnabled()) {
	            logger.debug("11425 UserModServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
			}
			// --- debug log (out method) ---
			return;
		}

		// Password Change
		UserData modUser = new UserData();
		modUser.userName = currentUser.userName;
		modUser.description = description;
		modUser.passwd = newPass1;
		
		boolean passChange = true;
		try {
			passChange = user.changeUser(modUser);
		} catch (FileNotWriteException e) {
			MessageView error = new MessageView(41188,LogCategorySet.GUI_IO_FILE, 
					Message.WRITE_ERROR);
			session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
			response.sendRedirect(RedirectPages.LOGIN);
			// --- debug log (out method) ---
			if (logger.isDebugEnabled()) {
	            logger.debug("11426 UserModServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
			}
			// --- debug log (out method) ---
			return;
		} catch (Exception e) {
			MessageView error = new MessageView(41189, LogCategorySet.GUI_USER_MANAGE,
					Message.UNEXPECTED_ERROR);
			session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
			response.sendRedirect(RedirectPages.LOGIN);
			// --- debug log (out method) ---
			if (logger.isDebugEnabled()) {
	            logger.debug("11427 UserModServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
			}
			// --- debug log (out method) ---
			return;
		}

		if (passChange == true) {
			session.setAttribute(SessionKeys.LOGIN_SESSION, modUser);
			MessageView error = new MessageView(21077, LogCategorySet.GUI_USER_MANAGE,
					Message.USER_CHANGE_SUCCESS);
			session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
			session.setAttribute(SessionKeys.GUI_SYNC_STATE, SessionKeys.NO_SYNC);
			response.sendRedirect(RedirectPages.USER_MODIFY_SUCCESS);
		} else {
			session.setAttribute(SessionKeys.LOGIN_SESSION, authCheck);
			MessageView error = new MessageView(41190, LogCategorySet.GUI_USER_MANAGE,
					Message.UNEXPECTED_ERROR);
			session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
			response.sendRedirect(RedirectPages.USER_MODIFY_FAIL);
		}
		
		// --- debug log (out method) ---
		if (logger.isDebugEnabled()) {
            logger.debug("11428 UserModServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
		}
		// --- debug log (out method) ---
		return;
	}

	/**
	 * 
	 * <p>
	 * validationCheck method
	 * </p>
	 * 
	 * @param session
	 * @param description
	 * @param curPass
	 * @param newPass1
	 * @param newPass2
	 * @return
	 */
	boolean validationCheck(HttpSession session, String description,
			String curPass, String newPass1, String newPass2) {
		// --- debug log (in method) ---
		if (logger.isDebugEnabled()) {
			StringBuffer buf = new StringBuffer();
			buf.append("UserModServlet::validationCheck(HttpSession session, String description, String newPass1, String newPass2) in ");
			buf.append("session=(" + session + "), ");
			buf.append("description=\"" + description + "\", ");
			buf.append("newPass1=\"" + newPass1 + "\", ");
			buf.append("newPass2=\"" + newPass2);
			logger.debug("11429 " + buf.toString());
		}
		// --- debug log (in method) ---

		boolean validationFlag = true;
		final int MAX_DESCRIPTION_LENGTH = 64;
		final int MIN_PASS_LENGTH = 6;
		final int MAX_PASS_LENGTH = 16;

		Pattern pattern = Pattern.compile("[^\\x20-\\x7e]");

		if ((description.length() == 0) && (curPass.length() == 0)
				&& (newPass1.length() == 0) && (newPass2.length() == 0)) {
			MessageView error = new MessageView(21078, LogCategorySet.GUI_USER_MANAGE,
					Message.NOT_EXIST);
			session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
			validationFlag = false;
		}

		else if (description.length() != 0) {
			Matcher matcher = pattern.matcher(description);
			if ((description.length() > MAX_DESCRIPTION_LENGTH) || matcher.find() ){
				MessageView error = new MessageView(21079, LogCategorySet.GUI_USER_MANAGE,
						"Description : " + Message.INVALID_VALUE);
				session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
				validationFlag = false;
			}
		}

		if ( (curPass.length() == 0 ) || (newPass1.length() == 0) || (newPass2.length() == 0) ){
			MessageView error = new MessageView(21080, LogCategorySet.GUI_USER_MANAGE,
					"Password : " + Message.REQUIED_ITEM);
			session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
			validationFlag = false;
		} else {
			Matcher matcherCurPass = pattern.matcher(curPass);
			Matcher matcherNewPass1 = pattern.matcher(newPass1);
			Matcher matcherNewPass2 = pattern.matcher(newPass2);

			if (matcherCurPass.find() || matcherNewPass1.find()
					|| matcherNewPass2.find()) {
				MessageView error = new MessageView(21081, LogCategorySet.GUI_USER_MANAGE,
						"Input item : "+ Message.INVALID_VALUE);
				session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
				validationFlag = false;
			} else if (false == newPass1.equals(newPass2)) {
				MessageView error = new MessageView(21082, LogCategorySet.GUI_USER_MANAGE,
						Message.NOT_EQUAL);
				session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
				validationFlag = false;
			}
			else if ((newPass1.length() < MIN_PASS_LENGTH) || (newPass1.length() > MAX_PASS_LENGTH)){ 
				MessageView error = new MessageView(21083, LogCategorySet.GUI_USER_MANAGE,
						Message.INVALID_VALUE);
				session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
				validationFlag = false;
			}
		}

		// --- debug log (out method) ---
		if (logger.isDebugEnabled()) {
            logger.debug("11430 UserModServlet::validationCheck(HttpSession session, String description, String newPass1, String newPass2) out return=" + validationFlag);
		}
		// --- debug log (out method) ---
		return validationFlag;
	}
}