package org.ultramonkey.l7.view;

import java.io.IOException;
import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.servlet.*;
import javax.servlet.http.*;

import org.apache.log4j.Logger;
import org.ultramonkey.l7.model.*;
import org.ultramonkey.l7.controller.*;

/**
 * <p>class VSModServlet</p>
 * <p>Copyright(c) NTT COMWARE 2008</p>
 * @author kubota
 */
public class VSModServlet extends L7guiServletBase {
	static final long serialVersionUID = 1L;	

	private Logger logger = Logger.getLogger(LogCategorySet.GUI_IO);

	/* (non-Java-doc)
	 * @see javax.servlet.http.HttpServlet#HttpServlet()
	 */
	public VSModServlet() {
		super();
        // --- debug log (constructor) ---
		if (logger.isDebugEnabled()) {
			logger.debug("11349 class VSModServlet created.");
		}
		// --- debug log (constructor) ---
	}

	/* (non-Java-doc)
	 * @see javax.servlet.http.HttpServlet#doGet(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doGet(HttpServletRequest request, HttpServletResponse response)
		throws ServletException, IOException {
		// --- debug log (in method) ---
		if (logger.isDebugEnabled()) {
			StringBuffer buf = new StringBuffer();
            buf.append("VSModServlet::doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException in ");
            buf.append("request=(" + request + "), ");
            buf.append("response=(" + response + ")");
            logger.debug("11350 " + buf.toString());
            request.setCharacterEncoding("UTF-8");
			logger.debug("11351 QueryString=\"" + request.getQueryString() + "\"");
		}
		// --- debug log (in method) ---

		response.sendRedirect(RedirectPages.LOGIN);

		// --- debug log (out method) ---
		if (logger.isDebugEnabled()) {
            logger.debug("11352 VSModServlet::doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
		}
		// --- debug log (out method) ---
		return;
    }
	

	/* (non-Java-doc)
	 * @see javax.servlet.http.HttpServlet#doPost(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doPost(HttpServletRequest request, HttpServletResponse response)
		throws ServletException, IOException {
		// --- debug log (in method) ---
		if (logger.isDebugEnabled()) {
			StringBuffer buf = new StringBuffer();
            buf.append("VSModServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException in ");
            buf.append("request=(" + request + "), ");
            buf.append("response=(" + response + ")");
            logger.debug("11353 " + buf.toString());
            request.setCharacterEncoding("UTF-8");
			Enumeration keys = request.getParameterNames();
			String post = "";
			while (keys.hasMoreElements()) {
				if (post.length() != 0)
					post += "&";
				String key = (String) keys.nextElement();
				post += key + "=" + request.getParameter(key);
			}
			logger.debug("11354 PostData=\"" + post + "\"");
		}
		// --- debug log (in method) ---

		// check login session
		super.doPost(request, response);
		
		HttpSession session = request.getSession(false);
		if (login == false || session == null) {
			if (session != null) {
				MessageView error = new MessageView(41087, LogCategorySet.GUI_USER_AUTHENTICATION,
						Message.INVALID_SESSSION);
				session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
			}
			response.sendRedirect(RedirectPages.LOGIN);
			// --- debug log (out method) ---
			if (logger.isDebugEnabled()) {
	            logger.debug("11355 VSModServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
			}
			// --- debug log (out method) ---
			return;
		}

        request.setCharacterEncoding("UTF-8");
		HashMap<String, String[]> tmpMap = (HashMap<String, String[]>) request.getParameterMap();
		if (tmpMap == null){
			MessageView error = new MessageView(41088, LogCategorySet.GUI_VIRTUALSERVICE,
					Message.UNEXPECTED_ERROR);
			session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
			response.sendRedirect(RedirectPages.LOGIN);
			// --- debug log (out method) ---
			if (logger.isDebugEnabled()) {
	            logger.debug("11356 VSModServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
			}
			// --- debug log (out method) ---
			return;
		}
		
		HashMap<String, String> inputVsMap = new HashMap<String, String>();
		ArrayList<Integer> realRemoveKey = new ArrayList<Integer>();
		
		Iterator i = tmpMap.keySet().iterator();
		while (i.hasNext()) {
			String key = (String) i.next();
			
			Pattern p = Pattern.compile("rs(\\d+)_remove");
			Matcher m = p.matcher(key);
			if (m.matches())
				realRemoveKey.add(Integer.parseInt(m.group(1)));
			
			inputVsMap.put(key, tmpMap.get(key)[0]);
		}

		if (inputVsMap.containsKey(ButtonMode.REMOVE) && realRemoveKey.size() > 0) {
			for (int key : realRemoveKey) {
				try {
					inputVsMap.remove("rs" + key + "_ip");
					inputVsMap.remove("rs" + key + "_port");
					inputVsMap.remove("rs" + key + "_weight");
				} catch (Exception e) {	}
			}
		}
		
		HashMap<String, String> invalidMap = new HashMap<String, String>();

		boolean validationFlag = true;
		VirtualSetting vs = new VirtualSetting();
		
		// validation check
		ValidationCheck val = new ValidationCheck();
		validationFlag = val.vsCheck(inputVsMap, invalidMap, vs);
		
		if (inputVsMap.containsKey(ButtonMode.ADD)) {
			String new_ip = inputVsMap.get("new_ip");
			String new_port = inputVsMap.get("new_port");
			String new_weight = inputVsMap.get("new_weight");
			
			if (new_ip != null && new_port != null && new_weight != null &&
				new_ip.length() != 0 && new_ip.length() != 0 && new_weight.length() != 0) {
				try {
					EndPoint new_real = new EndPoint(new_ip, new_port, Integer.parseInt(new_weight), 0, 0);
					for  (EndPoint real : vs.real) {
						if (real.equals(new_real)) {
							new_real = null;
							MessageView error = new MessageView(41089, LogCategorySet.GUI_VIRTUALSERVICE,
									Message.REAL_SERVER_EXIST);
							session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
							break;
						}
					}
					if (new_real != null)
						vs.real.add(new_real);
				} catch (Exception e) {	}
			}
		}
		
		if (inputVsMap.containsKey(ButtonMode.REMOVE) || inputVsMap.containsKey(ButtonMode.ADD)) {
			session.setAttribute(SessionKeys.INPUT_VS, vs);
			response.sendRedirect(RedirectPages.VS_MODIFY);
			// --- debug log (out method) ---
			if (logger.isDebugEnabled()) {
	            logger.debug("11357 VSModServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
			}
			// --- debug log (out method) ---
			return;
		}

		if (validationFlag == false) {
			MessageView error = new MessageView(21048, LogCategorySet.GUI_VIRTUALSERVICE,
					Message.VALIDATION_ERROR);
			session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
			session.setAttribute(SessionKeys.INPUT_VS, vs);
			session.setAttribute(SessionKeys.INVALID_MESSAGE, invalidMap);

			response.sendRedirect(RedirectPages.VS_MODIFY);
			// --- debug log (out method) ---
			if (logger.isDebugEnabled()) {
	            logger.debug("11358 VSModServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
			}
			// --- debug log (out method) ---
			return;
		}
		
		VirtualSetting oldVs = (VirtualSetting) session.getAttribute(SessionKeys.OLD_VS);
		if (oldVs == null) {
			MessageView error = new MessageView(41090, LogCategorySet.GUI_VIRTUALSERVICE,
					Message.UNEXPECTED_ERROR);
			session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
			response.sendRedirect(RedirectPages.LOGIN);
			// --- debug log (out method) ---
			if (logger.isDebugEnabled()) {
	            logger.debug("11359 VSModServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
			}
			// --- debug log (out method) ---
			return;
		}
		
		String vsName = oldVs.virtual.host + ":" + oldVs.virtual.port + " " +
			oldVs.protomod + " " + oldVs.option;
		session.setAttribute(SessionKeys.VS_NAME, vsName);
		
		CommandExecuter thread = new CommandExecuter(session);
		
		ExecuteMode mode;
		String redirectPage;
		
		String button_mode = inputVsMap.get("button");
		// button mode : apply
		if (button_mode != null && button_mode.equals(ButtonMode.APPLY)) {
			mode = ExecuteMode.VS_MODIFY_APPLY;
			redirectPage = RedirectPages.VS_MODIFY_EXECUTIVE;
		}
		// button mode : save
		else if (button_mode != null && button_mode.equals(ButtonMode.SAVE)) {
			mode = ExecuteMode.VS_MODIFY_SAVE;
			redirectPage = RedirectPages.VS_MODIFY_EXECUTIVE;
		}
		// button mode : save and sync
		else if (button_mode != null && button_mode.equals(ButtonMode.SAVESYNC)) {
			mode = ExecuteMode.VS_MODIFY_SAVESYNC;
			redirectPage = RedirectPages.SAVE_SYNC_EXECUTIVE;

			SessionTransData trans = new SessionTransData();
			trans.sourceURI = RedirectPages.VS_MODIFY;
			trans.destURI   = RedirectPages.STATE_INFO;
			trans.errorURI  = RedirectPages.VS_MODIFY_NG;
			session.setAttribute(SessionKeys.PAGE_TRANSDATA, trans);
		}
		else {
			MessageView error = new MessageView(41091, LogCategorySet.GUI_VIRTUALSERVICE,
					Message.UNEXPECTED_ERROR);
			session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
			response.sendRedirect(RedirectPages.LOGIN);
			// --- debug log (out method) ---
			if (logger.isDebugEnabled()) {
	            logger.debug("11360 VSModServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
			}
			// --- debug log (out method) ---
			return;
		}
		
		try {
			thread.setExecute(mode, oldVs, vs);
			thread.start();
		}
		catch(Exception e)
		{
			MessageView error = new MessageView(41092, LogCategorySet.GUI_VIRTUALSERVICE,
					Message.UNEXPECTED_ERROR);
			session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
			response.sendRedirect(RedirectPages.LOGIN);
			// --- debug log (out method) ---
			if (logger.isDebugEnabled()) {
	            logger.debug("11361 VSModServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
			}
			// --- debug log (out method) ---
			return;
		}
		response.sendRedirect(redirectPage);
		// --- debug log (out method) ---
		if (logger.isDebugEnabled()) {
            logger.debug("11362 VSModServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
		}
		// --- debug log (out method) ---
		return;
	}
}
