/*
 * @file  sslproxy.h
 * @brief SSLproxy Header
 *
 * Copyright (C) 2008  NTT COMWARE Corporation.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 **********************************************************************
 *
 * Distributed under the Boost Software Licence, Version 1.0
 * http://www.boost.org/LICENSE_1_0.txt
 *
 **********************************************************************/

#ifndef __SSLPROXY_H__
#define __SSLPROXY_H__

#include <boost/asio.hpp>
#include <boost/asio/ssl.hpp>

#include "logger_wrapper.h"
#include "parameter_wrapper.h"

//! SSLproxy parameter default value.
#define DEFAULT_NUM_THREAD		10
#define DEFAULT_TIMEOUT_SEC		30
#define DEFAULT_CA_DIR			"/etc/l7vs/sslproxy/"
#define DEFAULT_CERT_CHAIN_DIR		"/etc/l7vs/sslproxy/"
#define DEFAULT_PRIVATE_KEY_DIR		"/etc/l7vs/sslproxy/"
#define DEFAULT_PRIVATE_KEY_FILETYPE	boost::asio::ssl::context::pem	//! SSL_FILETYPE_PEM
#define DEFAULT_PRIVATE_KEY_PASSWD_FROM	"console"
#define DEFAULT_PRIVATE_KEY_PASSWD_DIR	"/etc/l7vs/sslproxy/"
#define DEFAULT_VERIFY_OPTIONS		(SSL_VERIFY_PEER | SSL_VERIFY_FAIL_IF_NO_PEER_CERT)
#define DEFAULT_VERIFY_CERT_DEPTH	9
#define DEFAULT_SSL_OPTIONS		(SSL_OP_ALL | SSL_OP_NO_SSLv2 | SSL_OP_SINGLE_DH_USE)
#define DEFAULT_TMP_DH_DIR		"/etc/l7vs/sslproxy/"
#define DEFAULT_CIPHER_LIST		"ALL:!ADH:!LOW:!EXP:!MD5:@STRENGTH"
#define DEFAULT_CONN_LOG_FLAG		"on"

#define DEFAULT_SSL_METHOD		boost::asio::ssl::context::sslv23	//! SSLv23_method
#define MAX_PASSWD_SIZE			256
#define MAX_BUFFER_SIZE			4096
#define MAX_TARGET_ID_SIZE		256
#define TARGET_ID_CHECK_STRING		"/bin/ps -C sslproxy -o args --no-headers | /bin/cut -d\" \" -f2"

//! Target_id.
extern std::string target_id;

//! SSLproxy parameters.
extern std::string recv_endpoint;
extern std::string target_endpoint;
extern int num_thread;
extern int timeout_sec;
extern std::string ca_dir;
extern std::string ca_file;
extern std::string cert_chain_dir;
extern std::string cert_chain_file;
extern std::string private_key_dir;
extern std::string private_key_file;
extern boost::asio::ssl::context::file_format private_key_filetype;
extern std::string private_key_passwd_from;
extern std::string private_key_passwd_dir;
extern std::string private_key_passwd_file;
extern int verify_options;
extern int verify_cert_depth;
extern long int ssl_options;
extern bool tmp_dh_use;
extern std::string tmp_dh_dir;
extern std::string tmp_dh_file;
extern std::string cipher_list;
extern std::string conn_log_flag;

#endif //__SSLPROXY_H__
