/*
 * 注意：このファイルはBF506のMMR定義用にまだ修正してない
 *
 * ADSP-BF506の System MMR 定義。アドレスの指定は .ldファイルとの組み合わせで行う。
 * .ldファイルのサンプルは、 config/blackfin/ezkit_bf506を参照。
 *
 * アドレスが正しく割り当てられているかは、次の方法で検証した.
 *
 $ cat /opt/uClinux/bfin-elf/bfin-elf/include/def_LPBlackfin.h ../jsp/config/blackfin/_common_bf506/defBF51x_base.h ../jsp/config/blackfin/_common_bf506/defBF506.h | tr '[a-z]' '[A-Z]' | grep '0XFF[CE]0' | grep "#DEFINE" | awk '{print $2, $3}' - | grep 0X  | sed 's/0X//' |  sort -k 2 > regdef.txt
 $ awk '{ print $3,$1 }' jsp.syms | grep _mmr | sed 's/_mmr//p'| sort -k 2 | uniq  | tr '[a-z]' '[A-Z]'> regelf.txt
 $ diff regelf.txt regdef.txt > diff.txt

31a32,34
> RTC_PREN FFC00314
> UART0_DLL FFC00400
> UART0_RBR FFC00400
32a36
> UART0_DLH FFC00404
149a154
> DMA_TCPER FFC00B0C
150a156
> DMA_TCCNT FFC00B10
414a421,422
> UART1_DLL FFC02000
> UART1_RBR FFC02000
415a424
> UART1_DLH FFC02004
567a577,580
> OTP_CONTROL FFC03600
> OTP_BEN FFC03604
> OTP_STATUS FFC03608
> OTP_TIMING FFC0360C
619a633
> DCPLB_FAULT_STATUS FFE00008
657d670
< IMEM_DUMMY FFE01000
658a672
> CODE_FAULT_STATUS FFE01008
659a674
> CODE_FAULT_ADDR FFE0100C
712d726
< IDUMMY FFE02100
722d735
< DBGDUMMY FFE05004

 * これらのうち、ELF側にだけ存在するレジスタはDUMMYレジスタであり、これはコアレジスタである。
 * ツールのバージョン違いでインクルードファイルの内容が改変されたためであり、無視していい。
 *
 * DEF側にだけ存在するレジスタには2種類ある。
 * 1. 他のレジスタのエイリアス
 * 2. def***.hには存在するが、cdef***.hには存在しないレジスタ
 *
 * いずれも小さな問題であり、したがって、上の結果は問題ないと言える。
 *
 */

volatile unsigned short  mmrPLL_CTL __attribute ((aligned(4), section("SYSMMR0")));
volatile unsigned short  mmrPLL_DIV __attribute ((aligned(4), section("SYSMMR0")));
volatile unsigned short  mmrVR_CTL __attribute ((aligned(4), section("SYSMMR0")));
volatile unsigned short  mmrPLL_STAT __attribute ((aligned(4), section("SYSMMR0")));
volatile unsigned short  mmrPLL_LOCKCNT __attribute ((aligned(4), section("SYSMMR0")));
volatile unsigned long   mmrCHIPID __attribute ((aligned(4), section("SYSMMR0")));
volatile unsigned short  mmrSWRST __attribute ((aligned(4), section("SYSMMR1")));
volatile unsigned short  mmrSYSCR __attribute ((aligned(4), section("SYSMMR1")));
volatile unsigned long   mmrSIC_IMASK0 __attribute ((aligned(4), section("SYSMMR2")));
volatile unsigned long   mmrSIC_IAR0 __attribute ((aligned(4), section("SYSMMR2")));
volatile unsigned long   mmrSIC_IAR1 __attribute ((aligned(4), section("SYSMMR2")));
volatile unsigned long   mmrSIC_IAR2 __attribute ((aligned(4), section("SYSMMR2")));
volatile unsigned long   mmrSIC_IAR3 __attribute ((aligned(4), section("SYSMMR2")));
volatile unsigned long   mmrSIC_ISR0 __attribute ((aligned(4), section("SYSMMR2")));
volatile unsigned long   mmrSIC_IWR0 __attribute ((aligned(4), section("SYSMMR2")));
volatile unsigned long   mmrSIC_IMASK1 __attribute ((aligned(4), section("SYSMMR3")));
volatile unsigned long   mmrSIC_IAR4 __attribute ((aligned(4), section("SYSMMR3")));
volatile unsigned long   mmrSIC_IAR5 __attribute ((aligned(4), section("SYSMMR3")));
volatile unsigned long   mmrSIC_IAR6 __attribute ((aligned(4), section("SYSMMR3")));
volatile unsigned long   mmrSIC_IAR7 __attribute ((aligned(4), section("SYSMMR3")));
volatile unsigned long   mmrSIC_ISR1 __attribute ((aligned(4), section("SYSMMR3")));
volatile unsigned long   mmrSIC_IWR1 __attribute ((aligned(4), section("SYSMMR3")));
volatile unsigned short  mmrWDOG_CTL __attribute ((aligned(4), section("SYSMMR4")));
volatile unsigned long   mmrWDOG_CNT __attribute ((aligned(4), section("SYSMMR4")));
volatile unsigned long   mmrWDOG_STAT __attribute ((aligned(4), section("SYSMMR4")));
volatile unsigned long   mmrRTC_STAT __attribute ((aligned(4), section("SYSMMR5")));
volatile unsigned short  mmrRTC_ICTL __attribute ((aligned(4), section("SYSMMR5")));
volatile unsigned short  mmrRTC_ISTAT __attribute ((aligned(4), section("SYSMMR5")));
volatile unsigned short  mmrRTC_SWCNT __attribute ((aligned(4), section("SYSMMR5")));
volatile unsigned long   mmrRTC_ALARM __attribute ((aligned(4), section("SYSMMR5")));
volatile unsigned short  mmrRTC_FAST __attribute ((aligned(4), section("SYSMMR5")));
volatile unsigned short  mmrUART0_THR __attribute ((aligned(4), section("SYSMMR6")));
volatile unsigned short  mmrUART0_IER __attribute ((aligned(4), section("SYSMMR6")));
volatile unsigned short  mmrUART0_IIR __attribute ((aligned(4), section("SYSMMR6")));
volatile unsigned short  mmrUART0_LCR __attribute ((aligned(4), section("SYSMMR6")));
volatile unsigned short  mmrUART0_MCR __attribute ((aligned(4), section("SYSMMR6")));
volatile unsigned short  mmrUART0_LSR __attribute ((aligned(4), section("SYSMMR6")));
volatile unsigned short  mmrUART0_SCR __attribute ((aligned(4), section("SYSMMR7")));
volatile unsigned short  mmrUART0_GCTL __attribute ((aligned(4), section("SYSMMR8")));
volatile unsigned short  mmrSPI0_CTL __attribute ((aligned(4), section("SYSMMR9")));
volatile unsigned short  mmrSPI0_FLG __attribute ((aligned(4), section("SYSMMR9")));
volatile unsigned short  mmrSPI0_STAT __attribute ((aligned(4), section("SYSMMR9")));
volatile unsigned short  mmrSPI0_TDBR __attribute ((aligned(4), section("SYSMMR9")));
volatile unsigned short  mmrSPI0_RDBR __attribute ((aligned(4), section("SYSMMR9")));
volatile unsigned short  mmrSPI0_BAUD __attribute ((aligned(4), section("SYSMMR9")));
volatile unsigned short  mmrSPI0_SHADOW __attribute ((aligned(4), section("SYSMMR9")));
volatile unsigned short  mmrTIMER0_CONFIG __attribute ((aligned(4), section("SYSMMR10")));
volatile unsigned long   mmrTIMER0_COUNTER __attribute ((aligned(4), section("SYSMMR10")));
volatile unsigned long   mmrTIMER0_PERIOD __attribute ((aligned(4), section("SYSMMR10")));
volatile unsigned long   mmrTIMER0_WIDTH __attribute ((aligned(4), section("SYSMMR10")));
volatile unsigned short  mmrTIMER1_CONFIG __attribute ((aligned(4), section("SYSMMR10")));
volatile unsigned long   mmrTIMER1_COUNTER __attribute ((aligned(4), section("SYSMMR10")));
volatile unsigned long   mmrTIMER1_PERIOD __attribute ((aligned(4), section("SYSMMR10")));
volatile unsigned long   mmrTIMER1_WIDTH __attribute ((aligned(4), section("SYSMMR10")));
volatile unsigned short  mmrTIMER2_CONFIG __attribute ((aligned(4), section("SYSMMR10")));
volatile unsigned long   mmrTIMER2_COUNTER __attribute ((aligned(4), section("SYSMMR10")));
volatile unsigned long   mmrTIMER2_PERIOD __attribute ((aligned(4), section("SYSMMR10")));
volatile unsigned long   mmrTIMER2_WIDTH __attribute ((aligned(4), section("SYSMMR10")));
volatile unsigned short  mmrTIMER3_CONFIG __attribute ((aligned(4), section("SYSMMR10")));
volatile unsigned long   mmrTIMER3_COUNTER __attribute ((aligned(4), section("SYSMMR10")));
volatile unsigned long   mmrTIMER3_PERIOD __attribute ((aligned(4), section("SYSMMR10")));
volatile unsigned long   mmrTIMER3_WIDTH __attribute ((aligned(4), section("SYSMMR10")));
volatile unsigned short  mmrTIMER4_CONFIG __attribute ((aligned(4), section("SYSMMR10")));
volatile unsigned long   mmrTIMER4_COUNTER __attribute ((aligned(4), section("SYSMMR10")));
volatile unsigned long   mmrTIMER4_PERIOD __attribute ((aligned(4), section("SYSMMR10")));
volatile unsigned long   mmrTIMER4_WIDTH __attribute ((aligned(4), section("SYSMMR10")));
volatile unsigned short  mmrTIMER5_CONFIG __attribute ((aligned(4), section("SYSMMR10")));
volatile unsigned long   mmrTIMER5_COUNTER __attribute ((aligned(4), section("SYSMMR10")));
volatile unsigned long   mmrTIMER5_PERIOD __attribute ((aligned(4), section("SYSMMR10")));
volatile unsigned long   mmrTIMER5_WIDTH __attribute ((aligned(4), section("SYSMMR10")));
volatile unsigned short  mmrTIMER6_CONFIG __attribute ((aligned(4), section("SYSMMR10")));
volatile unsigned long   mmrTIMER6_COUNTER __attribute ((aligned(4), section("SYSMMR10")));
volatile unsigned long   mmrTIMER6_PERIOD __attribute ((aligned(4), section("SYSMMR10")));
volatile unsigned long   mmrTIMER6_WIDTH __attribute ((aligned(4), section("SYSMMR10")));
volatile unsigned short  mmrTIMER7_CONFIG __attribute ((aligned(4), section("SYSMMR10")));
volatile unsigned long   mmrTIMER7_COUNTER __attribute ((aligned(4), section("SYSMMR10")));
volatile unsigned long   mmrTIMER7_PERIOD __attribute ((aligned(4), section("SYSMMR10")));
volatile unsigned long   mmrTIMER7_WIDTH __attribute ((aligned(4), section("SYSMMR10")));
volatile unsigned short  mmrTIMER_ENABLE __attribute ((aligned(4), section("SYSMMR10")));
volatile unsigned short  mmrTIMER_DISABLE __attribute ((aligned(4), section("SYSMMR10")));
volatile unsigned long   mmrTIMER_STATUS __attribute ((aligned(4), section("SYSMMR10")));
volatile unsigned short  mmrPORTFIO __attribute ((aligned(4), section("SYSMMR11")));
volatile unsigned short  mmrPORTFIO_CLEAR __attribute ((aligned(4), section("SYSMMR11")));
volatile unsigned short  mmrPORTFIO_SET __attribute ((aligned(4), section("SYSMMR11")));
volatile unsigned short  mmrPORTFIO_TOGGLE __attribute ((aligned(4), section("SYSMMR11")));
volatile unsigned short  mmrPORTFIO_MASKA __attribute ((aligned(4), section("SYSMMR11")));
volatile unsigned short  mmrPORTFIO_MASKA_CLEAR __attribute ((aligned(4), section("SYSMMR11")));
volatile unsigned short  mmrPORTFIO_MASKA_SET __attribute ((aligned(4), section("SYSMMR11")));
volatile unsigned short  mmrPORTFIO_MASKA_TOGGLE __attribute ((aligned(4), section("SYSMMR11")));
volatile unsigned short  mmrPORTFIO_MASKB __attribute ((aligned(4), section("SYSMMR11")));
volatile unsigned short  mmrPORTFIO_MASKB_CLEAR __attribute ((aligned(4), section("SYSMMR11")));
volatile unsigned short  mmrPORTFIO_MASKB_SET __attribute ((aligned(4), section("SYSMMR11")));
volatile unsigned short  mmrPORTFIO_MASKB_TOGGLE __attribute ((aligned(4), section("SYSMMR11")));
volatile unsigned short  mmrPORTFIO_DIR __attribute ((aligned(4), section("SYSMMR11")));
volatile unsigned short  mmrPORTFIO_POLAR __attribute ((aligned(4), section("SYSMMR11")));
volatile unsigned short  mmrPORTFIO_EDGE __attribute ((aligned(4), section("SYSMMR11")));
volatile unsigned short  mmrPORTFIO_BOTH __attribute ((aligned(4), section("SYSMMR11")));
volatile unsigned short  mmrPORTFIO_INEN __attribute ((aligned(4), section("SYSMMR11")));
volatile unsigned short  mmrSPORT0_TCR1 __attribute ((aligned(4), section("SYSMMR12")));
volatile unsigned short  mmrSPORT0_TCR2 __attribute ((aligned(4), section("SYSMMR12")));
volatile unsigned short  mmrSPORT0_TCLKDIV __attribute ((aligned(4), section("SYSMMR12")));
volatile unsigned short  mmrSPORT0_TFSDIV __attribute ((aligned(4), section("SYSMMR12")));
volatile unsigned long   mmrSPORT0_TX __attribute ((aligned(4), section("SYSMMR12")));
volatile unsigned long   mmrSPORT0_RX __attribute ((aligned(4), section("SYSMMR13")));
volatile unsigned short  mmrSPORT0_RCR1 __attribute ((aligned(4), section("SYSMMR14")));
volatile unsigned short  mmrSPORT0_RCR2 __attribute ((aligned(4), section("SYSMMR14")));
volatile unsigned short  mmrSPORT0_RCLKDIV __attribute ((aligned(4), section("SYSMMR14")));
volatile unsigned short  mmrSPORT0_RFSDIV __attribute ((aligned(4), section("SYSMMR14")));
volatile unsigned short  mmrSPORT0_STAT __attribute ((aligned(4), section("SYSMMR14")));
volatile unsigned short  mmrSPORT0_CHNL __attribute ((aligned(4), section("SYSMMR14")));
volatile unsigned short  mmrSPORT0_MCMC1 __attribute ((aligned(4), section("SYSMMR14")));
volatile unsigned short  mmrSPORT0_MCMC2 __attribute ((aligned(4), section("SYSMMR14")));
volatile unsigned long   mmrSPORT0_MTCS0 __attribute ((aligned(4), section("SYSMMR14")));
volatile unsigned long   mmrSPORT0_MTCS1 __attribute ((aligned(4), section("SYSMMR14")));
volatile unsigned long   mmrSPORT0_MTCS2 __attribute ((aligned(4), section("SYSMMR14")));
volatile unsigned long   mmrSPORT0_MTCS3 __attribute ((aligned(4), section("SYSMMR14")));
volatile unsigned long   mmrSPORT0_MRCS0 __attribute ((aligned(4), section("SYSMMR14")));
volatile unsigned long   mmrSPORT0_MRCS1 __attribute ((aligned(4), section("SYSMMR14")));
volatile unsigned long   mmrSPORT0_MRCS2 __attribute ((aligned(4), section("SYSMMR14")));
volatile unsigned long   mmrSPORT0_MRCS3 __attribute ((aligned(4), section("SYSMMR14")));
volatile unsigned short  mmrSPORT1_TCR1 __attribute ((aligned(4), section("SYSMMR15")));
volatile unsigned short  mmrSPORT1_TCR2 __attribute ((aligned(4), section("SYSMMR15")));
volatile unsigned short  mmrSPORT1_TCLKDIV __attribute ((aligned(4), section("SYSMMR15")));
volatile unsigned short  mmrSPORT1_TFSDIV __attribute ((aligned(4), section("SYSMMR15")));
volatile unsigned long   mmrSPORT1_TX __attribute ((aligned(4), section("SYSMMR15")));
volatile unsigned long   mmrSPORT1_RX __attribute ((aligned(4), section("SYSMMR16")));
volatile unsigned short  mmrSPORT1_RCR1 __attribute ((aligned(4), section("SYSMMR17")));
volatile unsigned short  mmrSPORT1_RCR2 __attribute ((aligned(4), section("SYSMMR17")));
volatile unsigned short  mmrSPORT1_RCLKDIV __attribute ((aligned(4), section("SYSMMR17")));
volatile unsigned short  mmrSPORT1_RFSDIV __attribute ((aligned(4), section("SYSMMR17")));
volatile unsigned short  mmrSPORT1_STAT __attribute ((aligned(4), section("SYSMMR17")));
volatile unsigned short  mmrSPORT1_CHNL __attribute ((aligned(4), section("SYSMMR17")));
volatile unsigned short  mmrSPORT1_MCMC1 __attribute ((aligned(4), section("SYSMMR17")));
volatile unsigned short  mmrSPORT1_MCMC2 __attribute ((aligned(4), section("SYSMMR17")));
volatile unsigned long   mmrSPORT1_MTCS0 __attribute ((aligned(4), section("SYSMMR17")));
volatile unsigned long   mmrSPORT1_MTCS1 __attribute ((aligned(4), section("SYSMMR17")));
volatile unsigned long   mmrSPORT1_MTCS2 __attribute ((aligned(4), section("SYSMMR17")));
volatile unsigned long   mmrSPORT1_MTCS3 __attribute ((aligned(4), section("SYSMMR17")));
volatile unsigned long   mmrSPORT1_MRCS0 __attribute ((aligned(4), section("SYSMMR17")));
volatile unsigned long   mmrSPORT1_MRCS1 __attribute ((aligned(4), section("SYSMMR17")));
volatile unsigned long   mmrSPORT1_MRCS2 __attribute ((aligned(4), section("SYSMMR17")));
volatile unsigned long   mmrSPORT1_MRCS3 __attribute ((aligned(4), section("SYSMMR17")));
volatile unsigned short  mmrEBIU_AMGCTL __attribute ((aligned(4), section("SYSMMR18")));
volatile unsigned long   mmrEBIU_AMBCTL0 __attribute ((aligned(4), section("SYSMMR18")));
volatile unsigned long   mmrEBIU_AMBCTL1 __attribute ((aligned(4), section("SYSMMR18")));
volatile unsigned long   mmrEBIU_SDGCTL __attribute ((aligned(4), section("SYSMMR19")));
volatile unsigned short  mmrEBIU_SDBCTL __attribute ((aligned(4), section("SYSMMR19")));
volatile unsigned short  mmrEBIU_SDRRC __attribute ((aligned(4), section("SYSMMR19")));
volatile unsigned short  mmrEBIU_SDSTAT __attribute ((aligned(4), section("SYSMMR19")));
volatile unsigned short  mmrDMA_TC_PER __attribute ((aligned(4), section("SYSMMR20")));
volatile unsigned short  mmrDMA_TC_CNT __attribute ((aligned(4), section("SYSMMR20")));
volatile unsigned long   mmrDMA0_NEXT_DESC_PTR __attribute ((aligned(4), section("SYSMMR21")));
volatile unsigned long   mmrDMA0_START_ADDR __attribute ((aligned(4), section("SYSMMR21")));
volatile unsigned short  mmrDMA0_CONFIG __attribute ((aligned(4), section("SYSMMR21")));
volatile unsigned short  mmrDMA0_X_COUNT __attribute ((aligned(4), section("SYSMMR22")));
volatile signed   short  mmrDMA0_X_MODIFY __attribute ((aligned(4), section("SYSMMR22")));
volatile unsigned short  mmrDMA0_Y_COUNT __attribute ((aligned(4), section("SYSMMR22")));
volatile signed   short  mmrDMA0_Y_MODIFY __attribute ((aligned(4), section("SYSMMR22")));
volatile unsigned long   mmrDMA0_CURR_DESC_PTR __attribute ((aligned(4), section("SYSMMR22")));
volatile unsigned long   mmrDMA0_CURR_ADDR __attribute ((aligned(4), section("SYSMMR22")));
volatile unsigned short  mmrDMA0_IRQ_STATUS __attribute ((aligned(4), section("SYSMMR22")));
volatile unsigned short  mmrDMA0_PERIPHERAL_MAP __attribute ((aligned(4), section("SYSMMR22")));
volatile unsigned short  mmrDMA0_CURR_X_COUNT __attribute ((aligned(4), section("SYSMMR22")));
volatile unsigned short  mmrDMA0_CURR_Y_COUNT __attribute ((aligned(4), section("SYSMMR23")));
volatile unsigned long   mmrDMA1_NEXT_DESC_PTR __attribute ((aligned(4), section("SYSMMR24")));
volatile unsigned long   mmrDMA1_START_ADDR __attribute ((aligned(4), section("SYSMMR24")));
volatile unsigned short  mmrDMA1_CONFIG __attribute ((aligned(4), section("SYSMMR24")));
volatile unsigned short  mmrDMA1_X_COUNT __attribute ((aligned(4), section("SYSMMR25")));
volatile signed   short  mmrDMA1_X_MODIFY __attribute ((aligned(4), section("SYSMMR25")));
volatile unsigned short  mmrDMA1_Y_COUNT __attribute ((aligned(4), section("SYSMMR25")));
volatile signed   short  mmrDMA1_Y_MODIFY __attribute ((aligned(4), section("SYSMMR25")));
volatile unsigned long   mmrDMA1_CURR_DESC_PTR __attribute ((aligned(4), section("SYSMMR25")));
volatile unsigned long   mmrDMA1_CURR_ADDR __attribute ((aligned(4), section("SYSMMR25")));
volatile unsigned short  mmrDMA1_IRQ_STATUS __attribute ((aligned(4), section("SYSMMR25")));
volatile unsigned short  mmrDMA1_PERIPHERAL_MAP __attribute ((aligned(4), section("SYSMMR25")));
volatile unsigned short  mmrDMA1_CURR_X_COUNT __attribute ((aligned(4), section("SYSMMR25")));
volatile unsigned short  mmrDMA1_CURR_Y_COUNT __attribute ((aligned(4), section("SYSMMR26")));
volatile unsigned long   mmrDMA2_NEXT_DESC_PTR __attribute ((aligned(4), section("SYSMMR27")));
volatile unsigned long   mmrDMA2_START_ADDR __attribute ((aligned(4), section("SYSMMR27")));
volatile unsigned short  mmrDMA2_CONFIG __attribute ((aligned(4), section("SYSMMR27")));
volatile unsigned short  mmrDMA2_X_COUNT __attribute ((aligned(4), section("SYSMMR28")));
volatile signed   short  mmrDMA2_X_MODIFY __attribute ((aligned(4), section("SYSMMR28")));
volatile unsigned short  mmrDMA2_Y_COUNT __attribute ((aligned(4), section("SYSMMR28")));
volatile signed   short  mmrDMA2_Y_MODIFY __attribute ((aligned(4), section("SYSMMR28")));
volatile unsigned long   mmrDMA2_CURR_DESC_PTR __attribute ((aligned(4), section("SYSMMR28")));
volatile unsigned long   mmrDMA2_CURR_ADDR __attribute ((aligned(4), section("SYSMMR28")));
volatile unsigned short  mmrDMA2_IRQ_STATUS __attribute ((aligned(4), section("SYSMMR28")));
volatile unsigned short  mmrDMA2_PERIPHERAL_MAP __attribute ((aligned(4), section("SYSMMR28")));
volatile unsigned short  mmrDMA2_CURR_X_COUNT __attribute ((aligned(4), section("SYSMMR28")));
volatile unsigned short  mmrDMA2_CURR_Y_COUNT __attribute ((aligned(4), section("SYSMMR29")));
volatile unsigned long   mmrDMA3_NEXT_DESC_PTR __attribute ((aligned(4), section("SYSMMR30")));
volatile unsigned long   mmrDMA3_START_ADDR __attribute ((aligned(4), section("SYSMMR30")));
volatile unsigned short  mmrDMA3_CONFIG __attribute ((aligned(4), section("SYSMMR30")));
volatile unsigned short  mmrDMA3_X_COUNT __attribute ((aligned(4), section("SYSMMR31")));
volatile signed   short  mmrDMA3_X_MODIFY __attribute ((aligned(4), section("SYSMMR31")));
volatile unsigned short  mmrDMA3_Y_COUNT __attribute ((aligned(4), section("SYSMMR31")));
volatile signed   short  mmrDMA3_Y_MODIFY __attribute ((aligned(4), section("SYSMMR31")));
volatile unsigned long   mmrDMA3_CURR_DESC_PTR __attribute ((aligned(4), section("SYSMMR31")));
volatile unsigned long   mmrDMA3_CURR_ADDR __attribute ((aligned(4), section("SYSMMR31")));
volatile unsigned short  mmrDMA3_IRQ_STATUS __attribute ((aligned(4), section("SYSMMR31")));
volatile unsigned short  mmrDMA3_PERIPHERAL_MAP __attribute ((aligned(4), section("SYSMMR31")));
volatile unsigned short  mmrDMA3_CURR_X_COUNT __attribute ((aligned(4), section("SYSMMR31")));
volatile unsigned short  mmrDMA3_CURR_Y_COUNT __attribute ((aligned(4), section("SYSMMR32")));
volatile unsigned long   mmrDMA4_NEXT_DESC_PTR __attribute ((aligned(4), section("SYSMMR33")));
volatile unsigned long   mmrDMA4_START_ADDR __attribute ((aligned(4), section("SYSMMR33")));
volatile unsigned short  mmrDMA4_CONFIG __attribute ((aligned(4), section("SYSMMR33")));
volatile unsigned short  mmrDMA4_X_COUNT __attribute ((aligned(4), section("SYSMMR34")));
volatile signed   short  mmrDMA4_X_MODIFY __attribute ((aligned(4), section("SYSMMR34")));
volatile unsigned short  mmrDMA4_Y_COUNT __attribute ((aligned(4), section("SYSMMR34")));
volatile signed   short  mmrDMA4_Y_MODIFY __attribute ((aligned(4), section("SYSMMR34")));
volatile unsigned long   mmrDMA4_CURR_DESC_PTR __attribute ((aligned(4), section("SYSMMR34")));
volatile unsigned long   mmrDMA4_CURR_ADDR __attribute ((aligned(4), section("SYSMMR34")));
volatile unsigned short  mmrDMA4_IRQ_STATUS __attribute ((aligned(4), section("SYSMMR34")));
volatile unsigned short  mmrDMA4_PERIPHERAL_MAP __attribute ((aligned(4), section("SYSMMR34")));
volatile unsigned short  mmrDMA4_CURR_X_COUNT __attribute ((aligned(4), section("SYSMMR34")));
volatile unsigned short  mmrDMA4_CURR_Y_COUNT __attribute ((aligned(4), section("SYSMMR35")));
volatile unsigned long   mmrDMA5_NEXT_DESC_PTR __attribute ((aligned(4), section("SYSMMR36")));
volatile unsigned long   mmrDMA5_START_ADDR __attribute ((aligned(4), section("SYSMMR36")));
volatile unsigned short  mmrDMA5_CONFIG __attribute ((aligned(4), section("SYSMMR36")));
volatile unsigned short  mmrDMA5_X_COUNT __attribute ((aligned(4), section("SYSMMR37")));
volatile signed   short  mmrDMA5_X_MODIFY __attribute ((aligned(4), section("SYSMMR37")));
volatile unsigned short  mmrDMA5_Y_COUNT __attribute ((aligned(4), section("SYSMMR37")));
volatile signed   short  mmrDMA5_Y_MODIFY __attribute ((aligned(4), section("SYSMMR37")));
volatile unsigned long   mmrDMA5_CURR_DESC_PTR __attribute ((aligned(4), section("SYSMMR37")));
volatile unsigned long   mmrDMA5_CURR_ADDR __attribute ((aligned(4), section("SYSMMR37")));
volatile unsigned short  mmrDMA5_IRQ_STATUS __attribute ((aligned(4), section("SYSMMR37")));
volatile unsigned short  mmrDMA5_PERIPHERAL_MAP __attribute ((aligned(4), section("SYSMMR37")));
volatile unsigned short  mmrDMA5_CURR_X_COUNT __attribute ((aligned(4), section("SYSMMR37")));
volatile unsigned short  mmrDMA5_CURR_Y_COUNT __attribute ((aligned(4), section("SYSMMR38")));
volatile unsigned long   mmrDMA6_NEXT_DESC_PTR __attribute ((aligned(4), section("SYSMMR39")));
volatile unsigned long   mmrDMA6_START_ADDR __attribute ((aligned(4), section("SYSMMR39")));
volatile unsigned short  mmrDMA6_CONFIG __attribute ((aligned(4), section("SYSMMR39")));
volatile unsigned short  mmrDMA6_X_COUNT __attribute ((aligned(4), section("SYSMMR40")));
volatile signed   short  mmrDMA6_X_MODIFY __attribute ((aligned(4), section("SYSMMR40")));
volatile unsigned short  mmrDMA6_Y_COUNT __attribute ((aligned(4), section("SYSMMR40")));
volatile signed   short  mmrDMA6_Y_MODIFY __attribute ((aligned(4), section("SYSMMR40")));
volatile unsigned long   mmrDMA6_CURR_DESC_PTR __attribute ((aligned(4), section("SYSMMR40")));
volatile unsigned long   mmrDMA6_CURR_ADDR __attribute ((aligned(4), section("SYSMMR40")));
volatile unsigned short  mmrDMA6_IRQ_STATUS __attribute ((aligned(4), section("SYSMMR40")));
volatile unsigned short  mmrDMA6_PERIPHERAL_MAP __attribute ((aligned(4), section("SYSMMR40")));
volatile unsigned short  mmrDMA6_CURR_X_COUNT __attribute ((aligned(4), section("SYSMMR40")));
volatile unsigned short  mmrDMA6_CURR_Y_COUNT __attribute ((aligned(4), section("SYSMMR41")));
volatile unsigned long   mmrDMA7_NEXT_DESC_PTR __attribute ((aligned(4), section("SYSMMR42")));
volatile unsigned long   mmrDMA7_START_ADDR __attribute ((aligned(4), section("SYSMMR42")));
volatile unsigned short  mmrDMA7_CONFIG __attribute ((aligned(4), section("SYSMMR42")));
volatile unsigned short  mmrDMA7_X_COUNT __attribute ((aligned(4), section("SYSMMR43")));
volatile signed   short  mmrDMA7_X_MODIFY __attribute ((aligned(4), section("SYSMMR43")));
volatile unsigned short  mmrDMA7_Y_COUNT __attribute ((aligned(4), section("SYSMMR43")));
volatile signed   short  mmrDMA7_Y_MODIFY __attribute ((aligned(4), section("SYSMMR43")));
volatile unsigned long   mmrDMA7_CURR_DESC_PTR __attribute ((aligned(4), section("SYSMMR43")));
volatile unsigned long   mmrDMA7_CURR_ADDR __attribute ((aligned(4), section("SYSMMR43")));
volatile unsigned short  mmrDMA7_IRQ_STATUS __attribute ((aligned(4), section("SYSMMR43")));
volatile unsigned short  mmrDMA7_PERIPHERAL_MAP __attribute ((aligned(4), section("SYSMMR43")));
volatile unsigned short  mmrDMA7_CURR_X_COUNT __attribute ((aligned(4), section("SYSMMR43")));
volatile unsigned short  mmrDMA7_CURR_Y_COUNT __attribute ((aligned(4), section("SYSMMR44")));
volatile unsigned long   mmrDMA8_NEXT_DESC_PTR __attribute ((aligned(4), section("SYSMMR45")));
volatile unsigned long   mmrDMA8_START_ADDR __attribute ((aligned(4), section("SYSMMR45")));
volatile unsigned short  mmrDMA8_CONFIG __attribute ((aligned(4), section("SYSMMR45")));
volatile unsigned short  mmrDMA8_X_COUNT __attribute ((aligned(4), section("SYSMMR46")));
volatile signed   short  mmrDMA8_X_MODIFY __attribute ((aligned(4), section("SYSMMR46")));
volatile unsigned short  mmrDMA8_Y_COUNT __attribute ((aligned(4), section("SYSMMR46")));
volatile signed   short  mmrDMA8_Y_MODIFY __attribute ((aligned(4), section("SYSMMR46")));
volatile unsigned long   mmrDMA8_CURR_DESC_PTR __attribute ((aligned(4), section("SYSMMR46")));
volatile unsigned long   mmrDMA8_CURR_ADDR __attribute ((aligned(4), section("SYSMMR46")));
volatile unsigned short  mmrDMA8_IRQ_STATUS __attribute ((aligned(4), section("SYSMMR46")));
volatile unsigned short  mmrDMA8_PERIPHERAL_MAP __attribute ((aligned(4), section("SYSMMR46")));
volatile unsigned short  mmrDMA8_CURR_X_COUNT __attribute ((aligned(4), section("SYSMMR46")));
volatile unsigned short  mmrDMA8_CURR_Y_COUNT __attribute ((aligned(4), section("SYSMMR47")));
volatile unsigned long   mmrDMA9_NEXT_DESC_PTR __attribute ((aligned(4), section("SYSMMR48")));
volatile unsigned long   mmrDMA9_START_ADDR __attribute ((aligned(4), section("SYSMMR48")));
volatile unsigned short  mmrDMA9_CONFIG __attribute ((aligned(4), section("SYSMMR48")));
volatile unsigned short  mmrDMA9_X_COUNT __attribute ((aligned(4), section("SYSMMR49")));
volatile signed   short  mmrDMA9_X_MODIFY __attribute ((aligned(4), section("SYSMMR49")));
volatile unsigned short  mmrDMA9_Y_COUNT __attribute ((aligned(4), section("SYSMMR49")));
volatile signed   short  mmrDMA9_Y_MODIFY __attribute ((aligned(4), section("SYSMMR49")));
volatile unsigned long   mmrDMA9_CURR_DESC_PTR __attribute ((aligned(4), section("SYSMMR49")));
volatile unsigned long   mmrDMA9_CURR_ADDR __attribute ((aligned(4), section("SYSMMR49")));
volatile unsigned short  mmrDMA9_IRQ_STATUS __attribute ((aligned(4), section("SYSMMR49")));
volatile unsigned short  mmrDMA9_PERIPHERAL_MAP __attribute ((aligned(4), section("SYSMMR49")));
volatile unsigned short  mmrDMA9_CURR_X_COUNT __attribute ((aligned(4), section("SYSMMR49")));
volatile unsigned short  mmrDMA9_CURR_Y_COUNT __attribute ((aligned(4), section("SYSMMR50")));
volatile unsigned long   mmrDMA10_NEXT_DESC_PTR __attribute ((aligned(4), section("SYSMMR51")));
volatile unsigned long   mmrDMA10_START_ADDR __attribute ((aligned(4), section("SYSMMR51")));
volatile unsigned short  mmrDMA10_CONFIG __attribute ((aligned(4), section("SYSMMR51")));
volatile unsigned short  mmrDMA10_X_COUNT __attribute ((aligned(4), section("SYSMMR52")));
volatile signed   short  mmrDMA10_X_MODIFY __attribute ((aligned(4), section("SYSMMR52")));
volatile unsigned short  mmrDMA10_Y_COUNT __attribute ((aligned(4), section("SYSMMR52")));
volatile signed   short  mmrDMA10_Y_MODIFY __attribute ((aligned(4), section("SYSMMR52")));
volatile unsigned long   mmrDMA10_CURR_DESC_PTR __attribute ((aligned(4), section("SYSMMR52")));
volatile unsigned long   mmrDMA10_CURR_ADDR __attribute ((aligned(4), section("SYSMMR52")));
volatile unsigned short  mmrDMA10_IRQ_STATUS __attribute ((aligned(4), section("SYSMMR52")));
volatile unsigned short  mmrDMA10_PERIPHERAL_MAP __attribute ((aligned(4), section("SYSMMR52")));
volatile unsigned short  mmrDMA10_CURR_X_COUNT __attribute ((aligned(4), section("SYSMMR52")));
volatile unsigned short  mmrDMA10_CURR_Y_COUNT __attribute ((aligned(4), section("SYSMMR53")));
volatile unsigned long   mmrDMA11_NEXT_DESC_PTR __attribute ((aligned(4), section("SYSMMR54")));
volatile unsigned long   mmrDMA11_START_ADDR __attribute ((aligned(4), section("SYSMMR54")));
volatile unsigned short  mmrDMA11_CONFIG __attribute ((aligned(4), section("SYSMMR54")));
volatile unsigned short  mmrDMA11_X_COUNT __attribute ((aligned(4), section("SYSMMR55")));
volatile signed   short  mmrDMA11_X_MODIFY __attribute ((aligned(4), section("SYSMMR55")));
volatile unsigned short  mmrDMA11_Y_COUNT __attribute ((aligned(4), section("SYSMMR55")));
volatile signed   short  mmrDMA11_Y_MODIFY __attribute ((aligned(4), section("SYSMMR55")));
volatile unsigned long   mmrDMA11_CURR_DESC_PTR __attribute ((aligned(4), section("SYSMMR55")));
volatile unsigned long   mmrDMA11_CURR_ADDR __attribute ((aligned(4), section("SYSMMR55")));
volatile unsigned short  mmrDMA11_IRQ_STATUS __attribute ((aligned(4), section("SYSMMR55")));
volatile unsigned short  mmrDMA11_PERIPHERAL_MAP __attribute ((aligned(4), section("SYSMMR55")));
volatile unsigned short  mmrDMA11_CURR_X_COUNT __attribute ((aligned(4), section("SYSMMR55")));
volatile unsigned short  mmrDMA11_CURR_Y_COUNT __attribute ((aligned(4), section("SYSMMR56")));
volatile unsigned long   mmrMDMA_D0_NEXT_DESC_PTR __attribute ((aligned(4), section("SYSMMR57")));
volatile unsigned long   mmrMDMA_D0_START_ADDR __attribute ((aligned(4), section("SYSMMR57")));
volatile unsigned short  mmrMDMA_D0_CONFIG __attribute ((aligned(4), section("SYSMMR57")));
volatile unsigned short  mmrMDMA_D0_X_COUNT __attribute ((aligned(4), section("SYSMMR58")));
volatile signed   short  mmrMDMA_D0_X_MODIFY __attribute ((aligned(4), section("SYSMMR58")));
volatile unsigned short  mmrMDMA_D0_Y_COUNT __attribute ((aligned(4), section("SYSMMR58")));
volatile signed   short  mmrMDMA_D0_Y_MODIFY __attribute ((aligned(4), section("SYSMMR58")));
volatile unsigned long   mmrMDMA_D0_CURR_DESC_PTR __attribute ((aligned(4), section("SYSMMR58")));
volatile unsigned long   mmrMDMA_D0_CURR_ADDR __attribute ((aligned(4), section("SYSMMR58")));
volatile unsigned short  mmrMDMA_D0_IRQ_STATUS __attribute ((aligned(4), section("SYSMMR58")));
volatile unsigned short  mmrMDMA_D0_PERIPHERAL_MAP __attribute ((aligned(4), section("SYSMMR58")));
volatile unsigned short  mmrMDMA_D0_CURR_X_COUNT __attribute ((aligned(4), section("SYSMMR58")));
volatile unsigned short  mmrMDMA_D0_CURR_Y_COUNT __attribute ((aligned(4), section("SYSMMR59")));
volatile unsigned long   mmrMDMA_S0_NEXT_DESC_PTR __attribute ((aligned(4), section("SYSMMR60")));
volatile unsigned long   mmrMDMA_S0_START_ADDR __attribute ((aligned(4), section("SYSMMR60")));
volatile unsigned short  mmrMDMA_S0_CONFIG __attribute ((aligned(4), section("SYSMMR60")));
volatile unsigned short  mmrMDMA_S0_X_COUNT __attribute ((aligned(4), section("SYSMMR61")));
volatile signed   short  mmrMDMA_S0_X_MODIFY __attribute ((aligned(4), section("SYSMMR61")));
volatile unsigned short  mmrMDMA_S0_Y_COUNT __attribute ((aligned(4), section("SYSMMR61")));
volatile signed   short  mmrMDMA_S0_Y_MODIFY __attribute ((aligned(4), section("SYSMMR61")));
volatile unsigned long   mmrMDMA_S0_CURR_DESC_PTR __attribute ((aligned(4), section("SYSMMR61")));
volatile unsigned long   mmrMDMA_S0_CURR_ADDR __attribute ((aligned(4), section("SYSMMR61")));
volatile unsigned short  mmrMDMA_S0_IRQ_STATUS __attribute ((aligned(4), section("SYSMMR61")));
volatile unsigned short  mmrMDMA_S0_PERIPHERAL_MAP __attribute ((aligned(4), section("SYSMMR61")));
volatile unsigned short  mmrMDMA_S0_CURR_X_COUNT __attribute ((aligned(4), section("SYSMMR61")));
volatile unsigned short  mmrMDMA_S0_CURR_Y_COUNT __attribute ((aligned(4), section("SYSMMR62")));
volatile unsigned long   mmrMDMA_D1_NEXT_DESC_PTR __attribute ((aligned(4), section("SYSMMR63")));
volatile unsigned long   mmrMDMA_D1_START_ADDR __attribute ((aligned(4), section("SYSMMR63")));
volatile unsigned short  mmrMDMA_D1_CONFIG __attribute ((aligned(4), section("SYSMMR63")));
volatile unsigned short  mmrMDMA_D1_X_COUNT __attribute ((aligned(4), section("SYSMMR64")));
volatile signed   short  mmrMDMA_D1_X_MODIFY __attribute ((aligned(4), section("SYSMMR64")));
volatile unsigned short  mmrMDMA_D1_Y_COUNT __attribute ((aligned(4), section("SYSMMR64")));
volatile signed   short  mmrMDMA_D1_Y_MODIFY __attribute ((aligned(4), section("SYSMMR64")));
volatile unsigned long   mmrMDMA_D1_CURR_DESC_PTR __attribute ((aligned(4), section("SYSMMR64")));
volatile unsigned long   mmrMDMA_D1_CURR_ADDR __attribute ((aligned(4), section("SYSMMR64")));
volatile unsigned short  mmrMDMA_D1_IRQ_STATUS __attribute ((aligned(4), section("SYSMMR64")));
volatile unsigned short  mmrMDMA_D1_PERIPHERAL_MAP __attribute ((aligned(4), section("SYSMMR64")));
volatile unsigned short  mmrMDMA_D1_CURR_X_COUNT __attribute ((aligned(4), section("SYSMMR64")));
volatile unsigned short  mmrMDMA_D1_CURR_Y_COUNT __attribute ((aligned(4), section("SYSMMR65")));
volatile unsigned long   mmrMDMA_S1_NEXT_DESC_PTR __attribute ((aligned(4), section("SYSMMR66")));
volatile unsigned long   mmrMDMA_S1_START_ADDR __attribute ((aligned(4), section("SYSMMR66")));
volatile unsigned short  mmrMDMA_S1_CONFIG __attribute ((aligned(4), section("SYSMMR66")));
volatile unsigned short  mmrMDMA_S1_X_COUNT __attribute ((aligned(4), section("SYSMMR67")));
volatile signed   short  mmrMDMA_S1_X_MODIFY __attribute ((aligned(4), section("SYSMMR67")));
volatile unsigned short  mmrMDMA_S1_Y_COUNT __attribute ((aligned(4), section("SYSMMR67")));
volatile signed   short  mmrMDMA_S1_Y_MODIFY __attribute ((aligned(4), section("SYSMMR67")));
volatile unsigned long   mmrMDMA_S1_CURR_DESC_PTR __attribute ((aligned(4), section("SYSMMR67")));
volatile unsigned long   mmrMDMA_S1_CURR_ADDR __attribute ((aligned(4), section("SYSMMR67")));
volatile unsigned short  mmrMDMA_S1_IRQ_STATUS __attribute ((aligned(4), section("SYSMMR67")));
volatile unsigned short  mmrMDMA_S1_PERIPHERAL_MAP __attribute ((aligned(4), section("SYSMMR67")));
volatile unsigned short  mmrMDMA_S1_CURR_X_COUNT __attribute ((aligned(4), section("SYSMMR67")));
volatile unsigned short  mmrMDMA_S1_CURR_Y_COUNT __attribute ((aligned(4), section("SYSMMR68")));
volatile unsigned short  mmrPPI_CONTROL __attribute ((aligned(4), section("SYSMMR69")));
volatile unsigned short  mmrPPI_STATUS __attribute ((aligned(4), section("SYSMMR69")));
volatile unsigned short  mmrPPI_COUNT __attribute ((aligned(4), section("SYSMMR69")));
volatile unsigned short  mmrPPI_DELAY __attribute ((aligned(4), section("SYSMMR69")));
volatile unsigned short  mmrPPI_FRAME __attribute ((aligned(4), section("SYSMMR69")));
volatile unsigned short  mmrTWI_CLKDIV __attribute ((aligned(4), section("SYSMMR70")));
volatile unsigned short  mmrTWI_CONTROL __attribute ((aligned(4), section("SYSMMR70")));
volatile unsigned short  mmrTWI_SLAVE_CTL __attribute ((aligned(4), section("SYSMMR70")));
volatile unsigned short  mmrTWI_SLAVE_STAT __attribute ((aligned(4), section("SYSMMR70")));
volatile unsigned short  mmrTWI_SLAVE_ADDR __attribute ((aligned(4), section("SYSMMR70")));
volatile unsigned short  mmrTWI_MASTER_CTL __attribute ((aligned(4), section("SYSMMR70")));
volatile unsigned short  mmrTWI_MASTER_STAT __attribute ((aligned(4), section("SYSMMR70")));
volatile unsigned short  mmrTWI_MASTER_ADDR __attribute ((aligned(4), section("SYSMMR70")));
volatile unsigned short  mmrTWI_INT_STAT __attribute ((aligned(4), section("SYSMMR70")));
volatile unsigned short  mmrTWI_INT_MASK __attribute ((aligned(4), section("SYSMMR70")));
volatile unsigned short  mmrTWI_FIFO_CTL __attribute ((aligned(4), section("SYSMMR70")));
volatile unsigned short  mmrTWI_FIFO_STAT __attribute ((aligned(4), section("SYSMMR70")));
volatile unsigned short  mmrTWI_XMT_DATA8 __attribute ((aligned(4), section("SYSMMR71")));
volatile unsigned short  mmrTWI_XMT_DATA16 __attribute ((aligned(4), section("SYSMMR71")));
volatile unsigned short  mmrTWI_RCV_DATA8 __attribute ((aligned(4), section("SYSMMR71")));
volatile unsigned short  mmrTWI_RCV_DATA16 __attribute ((aligned(4), section("SYSMMR71")));
volatile unsigned short  mmrPORTGIO __attribute ((aligned(4), section("SYSMMR72")));
volatile unsigned short  mmrPORTGIO_CLEAR __attribute ((aligned(4), section("SYSMMR72")));
volatile unsigned short  mmrPORTGIO_SET __attribute ((aligned(4), section("SYSMMR72")));
volatile unsigned short  mmrPORTGIO_TOGGLE __attribute ((aligned(4), section("SYSMMR72")));
volatile unsigned short  mmrPORTGIO_MASKA __attribute ((aligned(4), section("SYSMMR72")));
volatile unsigned short  mmrPORTGIO_MASKA_CLEAR __attribute ((aligned(4), section("SYSMMR72")));
volatile unsigned short  mmrPORTGIO_MASKA_SET __attribute ((aligned(4), section("SYSMMR72")));
volatile unsigned short  mmrPORTGIO_MASKA_TOGGLE __attribute ((aligned(4), section("SYSMMR72")));
volatile unsigned short  mmrPORTGIO_MASKB __attribute ((aligned(4), section("SYSMMR72")));
volatile unsigned short  mmrPORTGIO_MASKB_CLEAR __attribute ((aligned(4), section("SYSMMR72")));
volatile unsigned short  mmrPORTGIO_MASKB_SET __attribute ((aligned(4), section("SYSMMR72")));
volatile unsigned short  mmrPORTGIO_MASKB_TOGGLE __attribute ((aligned(4), section("SYSMMR72")));
volatile unsigned short  mmrPORTGIO_DIR __attribute ((aligned(4), section("SYSMMR72")));
volatile unsigned short  mmrPORTGIO_POLAR __attribute ((aligned(4), section("SYSMMR72")));
volatile unsigned short  mmrPORTGIO_EDGE __attribute ((aligned(4), section("SYSMMR72")));
volatile unsigned short  mmrPORTGIO_BOTH __attribute ((aligned(4), section("SYSMMR72")));
volatile unsigned short  mmrPORTGIO_INEN __attribute ((aligned(4), section("SYSMMR72")));
volatile unsigned short  mmrPORTHIO __attribute ((aligned(4), section("SYSMMR73")));
volatile unsigned short  mmrPORTHIO_CLEAR __attribute ((aligned(4), section("SYSMMR73")));
volatile unsigned short  mmrPORTHIO_SET __attribute ((aligned(4), section("SYSMMR73")));
volatile unsigned short  mmrPORTHIO_TOGGLE __attribute ((aligned(4), section("SYSMMR73")));
volatile unsigned short  mmrPORTHIO_MASKA __attribute ((aligned(4), section("SYSMMR73")));
volatile unsigned short  mmrPORTHIO_MASKA_CLEAR __attribute ((aligned(4), section("SYSMMR73")));
volatile unsigned short  mmrPORTHIO_MASKA_SET __attribute ((aligned(4), section("SYSMMR73")));
volatile unsigned short  mmrPORTHIO_MASKA_TOGGLE __attribute ((aligned(4), section("SYSMMR73")));
volatile unsigned short  mmrPORTHIO_MASKB __attribute ((aligned(4), section("SYSMMR73")));
volatile unsigned short  mmrPORTHIO_MASKB_CLEAR __attribute ((aligned(4), section("SYSMMR73")));
volatile unsigned short  mmrPORTHIO_MASKB_SET __attribute ((aligned(4), section("SYSMMR73")));
volatile unsigned short  mmrPORTHIO_MASKB_TOGGLE __attribute ((aligned(4), section("SYSMMR73")));
volatile unsigned short  mmrPORTHIO_DIR __attribute ((aligned(4), section("SYSMMR73")));
volatile unsigned short  mmrPORTHIO_POLAR __attribute ((aligned(4), section("SYSMMR73")));
volatile unsigned short  mmrPORTHIO_EDGE __attribute ((aligned(4), section("SYSMMR73")));
volatile unsigned short  mmrPORTHIO_BOTH __attribute ((aligned(4), section("SYSMMR73")));
volatile unsigned short  mmrPORTHIO_INEN __attribute ((aligned(4), section("SYSMMR73")));
volatile unsigned short  mmrUART1_THR __attribute ((aligned(4), section("SYSMMR74")));
volatile unsigned short  mmrUART1_IER __attribute ((aligned(4), section("SYSMMR74")));
volatile unsigned short  mmrUART1_IIR __attribute ((aligned(4), section("SYSMMR74")));
volatile unsigned short  mmrUART1_LCR __attribute ((aligned(4), section("SYSMMR74")));
volatile unsigned short  mmrUART1_MCR __attribute ((aligned(4), section("SYSMMR74")));
volatile unsigned short  mmrUART1_LSR __attribute ((aligned(4), section("SYSMMR74")));
volatile unsigned short  mmrUART1_SCR __attribute ((aligned(4), section("SYSMMR75")));
volatile unsigned short  mmrUART1_GCTL __attribute ((aligned(4), section("SYSMMR76")));
volatile unsigned long   mmrEMAC_OPMODE __attribute ((aligned(4), section("SYSMMR77")));
volatile unsigned long   mmrEMAC_ADDRLO __attribute ((aligned(4), section("SYSMMR77")));
volatile unsigned long   mmrEMAC_ADDRHI __attribute ((aligned(4), section("SYSMMR77")));
volatile unsigned long   mmrEMAC_HASHLO __attribute ((aligned(4), section("SYSMMR77")));
volatile unsigned long   mmrEMAC_HASHHI __attribute ((aligned(4), section("SYSMMR77")));
volatile unsigned long   mmrEMAC_STAADD __attribute ((aligned(4), section("SYSMMR77")));
volatile unsigned long   mmrEMAC_STADAT __attribute ((aligned(4), section("SYSMMR77")));
volatile unsigned long   mmrEMAC_FLC __attribute ((aligned(4), section("SYSMMR77")));
volatile unsigned long   mmrEMAC_VLAN1 __attribute ((aligned(4), section("SYSMMR77")));
volatile unsigned long   mmrEMAC_VLAN2 __attribute ((aligned(4), section("SYSMMR77")));
volatile unsigned long   mmrEMAC_WKUP_CTL __attribute ((aligned(4), section("SYSMMR78")));
volatile unsigned long   mmrEMAC_WKUP_FFMSK0 __attribute ((aligned(4), section("SYSMMR78")));
volatile unsigned long   mmrEMAC_WKUP_FFMSK1 __attribute ((aligned(4), section("SYSMMR78")));
volatile unsigned long   mmrEMAC_WKUP_FFMSK2 __attribute ((aligned(4), section("SYSMMR78")));
volatile unsigned long   mmrEMAC_WKUP_FFMSK3 __attribute ((aligned(4), section("SYSMMR78")));
volatile unsigned long   mmrEMAC_WKUP_FFCMD __attribute ((aligned(4), section("SYSMMR78")));
volatile unsigned long   mmrEMAC_WKUP_FFOFF __attribute ((aligned(4), section("SYSMMR78")));
volatile unsigned long   mmrEMAC_WKUP_FFCRC0 __attribute ((aligned(4), section("SYSMMR78")));
volatile unsigned long   mmrEMAC_WKUP_FFCRC1 __attribute ((aligned(4), section("SYSMMR78")));
volatile unsigned long   mmrEMAC_SYSCTL __attribute ((aligned(4), section("SYSMMR79")));
volatile unsigned long   mmrEMAC_SYSTAT __attribute ((aligned(4), section("SYSMMR79")));
volatile unsigned long   mmrEMAC_RX_STAT __attribute ((aligned(4), section("SYSMMR79")));
volatile unsigned long   mmrEMAC_RX_STKY __attribute ((aligned(4), section("SYSMMR79")));
volatile unsigned long   mmrEMAC_RX_IRQE __attribute ((aligned(4), section("SYSMMR79")));
volatile unsigned long   mmrEMAC_TX_STAT __attribute ((aligned(4), section("SYSMMR79")));
volatile unsigned long   mmrEMAC_TX_STKY __attribute ((aligned(4), section("SYSMMR79")));
volatile unsigned long   mmrEMAC_TX_IRQE __attribute ((aligned(4), section("SYSMMR79")));
volatile unsigned long   mmrEMAC_MMC_CTL __attribute ((aligned(4), section("SYSMMR79")));
volatile unsigned long   mmrEMAC_MMC_RIRQS __attribute ((aligned(4), section("SYSMMR79")));
volatile unsigned long   mmrEMAC_MMC_RIRQE __attribute ((aligned(4), section("SYSMMR79")));
volatile unsigned long   mmrEMAC_MMC_TIRQS __attribute ((aligned(4), section("SYSMMR79")));
volatile unsigned long   mmrEMAC_MMC_TIRQE __attribute ((aligned(4), section("SYSMMR79")));
volatile unsigned short  mmrEMAC_PTP_CTL __attribute ((aligned(4), section("SYSMMR80")));
volatile unsigned short  mmrEMAC_PTP_IE __attribute ((aligned(4), section("SYSMMR80")));
volatile unsigned short  mmrEMAC_PTP_ISTAT __attribute ((aligned(4), section("SYSMMR80")));
volatile unsigned long   mmrEMAC_PTP_FOFF __attribute ((aligned(4), section("SYSMMR80")));
volatile unsigned long   mmrEMAC_PTP_FV1 __attribute ((aligned(4), section("SYSMMR80")));
volatile unsigned long   mmrEMAC_PTP_FV2 __attribute ((aligned(4), section("SYSMMR80")));
volatile unsigned long   mmrEMAC_PTP_FV3 __attribute ((aligned(4), section("SYSMMR80")));
volatile unsigned long   mmrEMAC_PTP_ADDEND __attribute ((aligned(4), section("SYSMMR80")));
volatile unsigned long   mmrEMAC_PTP_ACCR __attribute ((aligned(4), section("SYSMMR80")));
volatile unsigned long   mmrEMAC_PTP_OFFSET __attribute ((aligned(4), section("SYSMMR80")));
volatile unsigned long   mmrEMAC_PTP_TIMELO __attribute ((aligned(4), section("SYSMMR80")));
volatile unsigned long   mmrEMAC_PTP_TIMEHI __attribute ((aligned(4), section("SYSMMR80")));
volatile unsigned long   mmrEMAC_PTP_RXSNAPLO __attribute ((aligned(4), section("SYSMMR80")));
volatile unsigned long   mmrEMAC_PTP_RXSNAPHI __attribute ((aligned(4), section("SYSMMR80")));
volatile unsigned long   mmrEMAC_PTP_TXSNAPLO __attribute ((aligned(4), section("SYSMMR80")));
volatile unsigned long   mmrEMAC_PTP_TXSNAPHI __attribute ((aligned(4), section("SYSMMR80")));
volatile unsigned long   mmrEMAC_PTP_ALARMLO __attribute ((aligned(4), section("SYSMMR80")));
volatile unsigned long   mmrEMAC_PTP_ALARMHI __attribute ((aligned(4), section("SYSMMR80")));
volatile unsigned short  mmrEMAC_PTP_ID_OFF __attribute ((aligned(4), section("SYSMMR80")));
volatile unsigned long   mmrEMAC_PTP_ID_SNAP __attribute ((aligned(4), section("SYSMMR80")));
volatile unsigned long   mmrEMAC_PTP_PPS_STARTLOP __attribute ((aligned(4), section("SYSMMR80")));
volatile unsigned long   mmrEMAC_PTP_PPS_STARTHIP __attribute ((aligned(4), section("SYSMMR80")));
volatile unsigned long   mmrEMAC_PTP_PPS_PERIOD __attribute ((aligned(4), section("SYSMMR80")));
volatile unsigned long   mmrEMAC_RXC_OK __attribute ((aligned(4), section("SYSMMR81")));
volatile unsigned long   mmrEMAC_RXC_FCS __attribute ((aligned(4), section("SYSMMR81")));
volatile unsigned long   mmrEMAC_RXC_ALIGN __attribute ((aligned(4), section("SYSMMR81")));
volatile unsigned long   mmrEMAC_RXC_OCTET __attribute ((aligned(4), section("SYSMMR81")));
volatile unsigned long   mmrEMAC_RXC_DMAOVF __attribute ((aligned(4), section("SYSMMR81")));
volatile unsigned long   mmrEMAC_RXC_UNICST __attribute ((aligned(4), section("SYSMMR81")));
volatile unsigned long   mmrEMAC_RXC_MULTI __attribute ((aligned(4), section("SYSMMR81")));
volatile unsigned long   mmrEMAC_RXC_BROAD __attribute ((aligned(4), section("SYSMMR81")));
volatile unsigned long   mmrEMAC_RXC_LNERRI __attribute ((aligned(4), section("SYSMMR81")));
volatile unsigned long   mmrEMAC_RXC_LNERRO __attribute ((aligned(4), section("SYSMMR81")));
volatile unsigned long   mmrEMAC_RXC_LONG __attribute ((aligned(4), section("SYSMMR81")));
volatile unsigned long   mmrEMAC_RXC_MACCTL __attribute ((aligned(4), section("SYSMMR81")));
volatile unsigned long   mmrEMAC_RXC_OPCODE __attribute ((aligned(4), section("SYSMMR81")));
volatile unsigned long   mmrEMAC_RXC_PAUSE __attribute ((aligned(4), section("SYSMMR81")));
volatile unsigned long   mmrEMAC_RXC_ALLFRM __attribute ((aligned(4), section("SYSMMR81")));
volatile unsigned long   mmrEMAC_RXC_ALLOCT __attribute ((aligned(4), section("SYSMMR81")));
volatile unsigned long   mmrEMAC_RXC_TYPED __attribute ((aligned(4), section("SYSMMR81")));
volatile unsigned long   mmrEMAC_RXC_SHORT __attribute ((aligned(4), section("SYSMMR81")));
volatile unsigned long   mmrEMAC_RXC_EQ64 __attribute ((aligned(4), section("SYSMMR81")));
volatile unsigned long   mmrEMAC_RXC_LT128 __attribute ((aligned(4), section("SYSMMR81")));
volatile unsigned long   mmrEMAC_RXC_LT256 __attribute ((aligned(4), section("SYSMMR81")));
volatile unsigned long   mmrEMAC_RXC_LT512 __attribute ((aligned(4), section("SYSMMR81")));
volatile unsigned long   mmrEMAC_RXC_LT1024 __attribute ((aligned(4), section("SYSMMR81")));
volatile unsigned long   mmrEMAC_RXC_GE1024 __attribute ((aligned(4), section("SYSMMR81")));
volatile unsigned long   mmrEMAC_TXC_OK __attribute ((aligned(4), section("SYSMMR82")));
volatile unsigned long   mmrEMAC_TXC_1COL __attribute ((aligned(4), section("SYSMMR82")));
volatile unsigned long   mmrEMAC_TXC_GT1COL __attribute ((aligned(4), section("SYSMMR82")));
volatile unsigned long   mmrEMAC_TXC_OCTET __attribute ((aligned(4), section("SYSMMR82")));
volatile unsigned long   mmrEMAC_TXC_DEFER __attribute ((aligned(4), section("SYSMMR82")));
volatile unsigned long   mmrEMAC_TXC_LATECL __attribute ((aligned(4), section("SYSMMR82")));
volatile unsigned long   mmrEMAC_TXC_XS_COL __attribute ((aligned(4), section("SYSMMR82")));
volatile unsigned long   mmrEMAC_TXC_DMAUND __attribute ((aligned(4), section("SYSMMR82")));
volatile unsigned long   mmrEMAC_TXC_CRSERR __attribute ((aligned(4), section("SYSMMR82")));
volatile unsigned long   mmrEMAC_TXC_UNICST __attribute ((aligned(4), section("SYSMMR82")));
volatile unsigned long   mmrEMAC_TXC_MULTI __attribute ((aligned(4), section("SYSMMR82")));
volatile unsigned long   mmrEMAC_TXC_BROAD __attribute ((aligned(4), section("SYSMMR82")));
volatile unsigned long   mmrEMAC_TXC_XS_DFR __attribute ((aligned(4), section("SYSMMR82")));
volatile unsigned long   mmrEMAC_TXC_MACCTL __attribute ((aligned(4), section("SYSMMR82")));
volatile unsigned long   mmrEMAC_TXC_ALLFRM __attribute ((aligned(4), section("SYSMMR82")));
volatile unsigned long   mmrEMAC_TXC_ALLOCT __attribute ((aligned(4), section("SYSMMR82")));
volatile unsigned long   mmrEMAC_TXC_EQ64 __attribute ((aligned(4), section("SYSMMR82")));
volatile unsigned long   mmrEMAC_TXC_LT128 __attribute ((aligned(4), section("SYSMMR82")));
volatile unsigned long   mmrEMAC_TXC_LT256 __attribute ((aligned(4), section("SYSMMR82")));
volatile unsigned long   mmrEMAC_TXC_LT512 __attribute ((aligned(4), section("SYSMMR82")));
volatile unsigned long   mmrEMAC_TXC_LT1024 __attribute ((aligned(4), section("SYSMMR82")));
volatile unsigned long   mmrEMAC_TXC_GE1024 __attribute ((aligned(4), section("SYSMMR82")));
volatile unsigned long   mmrEMAC_TXC_ABORT __attribute ((aligned(4), section("SYSMMR82")));
volatile unsigned short  mmrPORTF_FER __attribute ((aligned(4), section("SYSMMR83")));
volatile unsigned short  mmrPORTG_FER __attribute ((aligned(4), section("SYSMMR83")));
volatile unsigned short  mmrPORTH_FER __attribute ((aligned(4), section("SYSMMR83")));
volatile unsigned short  mmrPORTF_MUX __attribute ((aligned(4), section("SYSMMR84")));
volatile unsigned short  mmrPORTG_MUX __attribute ((aligned(4), section("SYSMMR84")));
volatile unsigned short  mmrPORTH_MUX __attribute ((aligned(4), section("SYSMMR84")));
volatile unsigned short  mmrPORTF_DRIVE __attribute ((aligned(4), section("SYSMMR85")));
volatile unsigned short  mmrPORTG_DRIVE __attribute ((aligned(4), section("SYSMMR85")));
volatile unsigned short  mmrPORTH_DRIVE __attribute ((aligned(4), section("SYSMMR85")));
volatile unsigned short  mmrPORTF_HYSTERESIS __attribute ((aligned(4), section("SYSMMR86")));
volatile unsigned short  mmrPORTG_HYSTERESIS __attribute ((aligned(4), section("SYSMMR86")));
volatile unsigned short  mmrPORTH_HYSTERESIS __attribute ((aligned(4), section("SYSMMR86")));
volatile unsigned short  mmrNONGPIO_DRIVE __attribute ((aligned(4), section("SYSMMR87")));
volatile unsigned short  mmrNONGPIO_HYSTERESIS __attribute ((aligned(4), section("SYSMMR88")));
volatile unsigned short  mmrHMDMA0_CONTROL __attribute ((aligned(4), section("SYSMMR89")));
volatile unsigned short  mmrHMDMA0_ECINIT __attribute ((aligned(4), section("SYSMMR89")));
volatile unsigned short  mmrHMDMA0_BCINIT __attribute ((aligned(4), section("SYSMMR89")));
volatile unsigned short  mmrHMDMA0_ECURGENT __attribute ((aligned(4), section("SYSMMR89")));
volatile unsigned short  mmrHMDMA0_ECOVERFLOW __attribute ((aligned(4), section("SYSMMR89")));
volatile unsigned short  mmrHMDMA0_ECOUNT __attribute ((aligned(4), section("SYSMMR89")));
volatile unsigned short  mmrHMDMA0_BCOUNT __attribute ((aligned(4), section("SYSMMR89")));
volatile unsigned short  mmrHMDMA1_CONTROL __attribute ((aligned(4), section("SYSMMR90")));
volatile unsigned short  mmrHMDMA1_ECINIT __attribute ((aligned(4), section("SYSMMR90")));
volatile unsigned short  mmrHMDMA1_BCINIT __attribute ((aligned(4), section("SYSMMR90")));
volatile unsigned short  mmrHMDMA1_ECURGENT __attribute ((aligned(4), section("SYSMMR90")));
volatile unsigned short  mmrHMDMA1_ECOVERFLOW __attribute ((aligned(4), section("SYSMMR90")));
volatile unsigned short  mmrHMDMA1_ECOUNT __attribute ((aligned(4), section("SYSMMR90")));
volatile unsigned short  mmrHMDMA1_BCOUNT __attribute ((aligned(4), section("SYSMMR90")));
volatile unsigned short  mmrSPI1_CTL __attribute ((aligned(4), section("SYSMMR91")));
volatile unsigned short  mmrSPI1_FLG __attribute ((aligned(4), section("SYSMMR91")));
volatile unsigned short  mmrSPI1_STAT __attribute ((aligned(4), section("SYSMMR91")));
volatile unsigned short  mmrSPI1_TDBR __attribute ((aligned(4), section("SYSMMR91")));
volatile unsigned short  mmrSPI1_RDBR __attribute ((aligned(4), section("SYSMMR91")));
volatile unsigned short  mmrSPI1_BAUD __attribute ((aligned(4), section("SYSMMR91")));
volatile unsigned short  mmrSPI1_SHADOW __attribute ((aligned(4), section("SYSMMR91")));
volatile unsigned short  mmrCNT_CONFIG __attribute ((aligned(4), section("SYSMMR92")));
volatile unsigned short  mmrCNT_IMASK __attribute ((aligned(4), section("SYSMMR92")));
volatile unsigned short  mmrCNT_STATUS __attribute ((aligned(4), section("SYSMMR92")));
volatile unsigned short  mmrCNT_COMMAND __attribute ((aligned(4), section("SYSMMR92")));
volatile unsigned short  mmrCNT_DEBOUNCE __attribute ((aligned(4), section("SYSMMR92")));
volatile unsigned long  mmrCNT_COUNTER __attribute ((aligned(4), section("SYSMMR92")));
volatile unsigned long  mmrCNT_MAX __attribute ((aligned(4), section("SYSMMR92")));
volatile unsigned long  mmrCNT_MIN __attribute ((aligned(4), section("SYSMMR92")));
volatile unsigned long  mmrSECURE_SYSSWT __attribute ((aligned(4), section("SYSMMR93")));
volatile unsigned short  mmrSECURE_CONTROL __attribute ((aligned(4), section("SYSMMR93")));
volatile unsigned short  mmrSECURE_STATUS __attribute ((aligned(4), section("SYSMMR93")));
volatile unsigned long  mmrOTP_DATA0 __attribute ((aligned(4), section("SYSMMR94")));
volatile unsigned long  mmrOTP_DATA1 __attribute ((aligned(4), section("SYSMMR94")));
volatile unsigned long  mmrOTP_DATA2 __attribute ((aligned(4), section("SYSMMR94")));
volatile unsigned long  mmrOTP_DATA3 __attribute ((aligned(4), section("SYSMMR94")));
volatile unsigned short  mmrPWM_CTRL __attribute ((aligned(4), section("SYSMMR95")));
volatile unsigned short  mmrPWM_STAT __attribute ((aligned(4), section("SYSMMR95")));
volatile unsigned short  mmrPWM_TM __attribute ((aligned(4), section("SYSMMR95")));
volatile unsigned short  mmrPWM_DT __attribute ((aligned(4), section("SYSMMR95")));
volatile unsigned short  mmrPWM_GATE __attribute ((aligned(4), section("SYSMMR95")));
volatile unsigned short  mmrPWM_CHA __attribute ((aligned(4), section("SYSMMR95")));
volatile unsigned short  mmrPWM_CHB __attribute ((aligned(4), section("SYSMMR95")));
volatile unsigned short  mmrPWM_CHC __attribute ((aligned(4), section("SYSMMR95")));
volatile unsigned short  mmrPWM_SEG __attribute ((aligned(4), section("SYSMMR95")));
volatile unsigned short  mmrPWM_SYNCWT __attribute ((aligned(4), section("SYSMMR95")));
volatile unsigned short  mmrPWM_CHAL __attribute ((aligned(4), section("SYSMMR95")));
volatile unsigned short  mmrPWM_CHBL __attribute ((aligned(4), section("SYSMMR95")));
volatile unsigned short  mmrPWM_CHCL __attribute ((aligned(4), section("SYSMMR95")));
volatile unsigned short  mmrPWM_LSI __attribute ((aligned(4), section("SYSMMR95")));
volatile unsigned short  mmrPWM_STAT2 __attribute ((aligned(4), section("SYSMMR95")));
volatile unsigned short  mmrRSI_PWR_CONTROL __attribute ((aligned(4), section("SYSMMR96")));
volatile unsigned short  mmrRSI_CLK_CONTROL __attribute ((aligned(4), section("SYSMMR96")));
volatile unsigned long   mmrRSI_ARGUMENT __attribute ((aligned(4), section("SYSMMR96")));
volatile unsigned short  mmrRSI_COMMAND __attribute ((aligned(4), section("SYSMMR96")));
volatile unsigned short  mmrRSI_RESP_CMD __attribute ((aligned(4), section("SYSMMR96")));
volatile unsigned long   mmrRSI_RESPONSE0 __attribute ((aligned(4), section("SYSMMR96")));
volatile unsigned long   mmrRSI_RESPONSE1 __attribute ((aligned(4), section("SYSMMR96")));
volatile unsigned long   mmrRSI_RESPONSE2 __attribute ((aligned(4), section("SYSMMR96")));
volatile unsigned long   mmrRSI_RESPONSE3 __attribute ((aligned(4), section("SYSMMR96")));
volatile unsigned long   mmrRSI_DATA_TIMER __attribute ((aligned(4), section("SYSMMR96")));
volatile unsigned short  mmrRSI_DATA_LGTH __attribute ((aligned(4), section("SYSMMR96")));
volatile unsigned short  mmrRSI_DATA_CONTROL __attribute ((aligned(4), section("SYSMMR96")));
volatile unsigned short  mmrRSI_DATA_CNT __attribute ((aligned(4), section("SYSMMR96")));
volatile unsigned long   mmrRSI_STATUS __attribute ((aligned(4), section("SYSMMR96")));
volatile unsigned short  mmrRSI_STATUSCL __attribute ((aligned(4), section("SYSMMR96")));
volatile unsigned long   mmrRSI_MASK0 __attribute ((aligned(4), section("SYSMMR96")));
volatile unsigned long   mmrRSI_MASK1 __attribute ((aligned(4), section("SYSMMR96")));
volatile unsigned short  mmrRSI_FIFO_CNT __attribute ((aligned(4), section("SYSMMR97")));
volatile unsigned short  mmrRSI_CEATA_CONTROL __attribute ((aligned(4), section("SYSMMR97")));
volatile unsigned long   mmrRSI_FIFO __attribute ((aligned(4), section("SYSMMR98")));
volatile unsigned short  mmrRSI_ESTAT __attribute ((aligned(4), section("SYSMMR99")));
volatile unsigned short  mmrRSI_EMASK __attribute ((aligned(4), section("SYSMMR99")));
volatile unsigned short  mmrRSI_CONFIG __attribute ((aligned(4), section("SYSMMR99")));
volatile unsigned short  mmrRSI_RD_WAIT_EN __attribute ((aligned(4), section("SYSMMR99")));
volatile unsigned short  mmrRSI_PID0 __attribute ((aligned(4), section("SYSMMR99")));
volatile unsigned short  mmrRSI_PID1 __attribute ((aligned(4), section("SYSMMR99")));
volatile unsigned short  mmrRSI_PID2 __attribute ((aligned(4), section("SYSMMR99")));
volatile unsigned short  mmrRSI_PID3 __attribute ((aligned(4), section("SYSMMR99")));

