#include <QtGui>
#include "LinkDlg.h"

LinkDlg::LinkDlg(QWidget *parent)
	: QDialog(parent)
{
	QVBoxLayout *vLayout = new QVBoxLayout();
		vLayout->addWidget(new QLabel(tr("Link to:")));
		vLayout->addWidget(m_linkText = new QLineEdit());
		vLayout->addWidget(new QLabel(tr("width for Pixmap:")));
		vLayout->addWidget(m_width = new QLineEdit());
		m_width->setAlignment(Qt::AlignRight);
#if 0
		{QHBoxLayout *hLayout = new QHBoxLayout();
			hLayout->addStretch();
			QPushButton *refButton = new QPushButton(tr("Ref..."));
			connect(refButton, SIGNAL(clicked()), this, SLOT(selectFile()));
			hLayout->addWidget(refButton);
			vLayout->addLayout(hLayout);
		}
#endif
#if 0
		{QHBoxLayout *hLayout = new QHBoxLayout();
			hLayout->addWidget(m_linkText = new QLineEdit());
			vLayout->addLayout(hLayout);
		}
#endif
		{QHBoxLayout *hLayout = new QHBoxLayout();
			QPushButton *refButton = new QPushButton(tr("Ref..."));
			connect(refButton, SIGNAL(clicked()), this, SLOT(selectFile()));
			hLayout->addWidget(refButton);
			hLayout->addStretch();
			QPushButton *okButton = new QPushButton(tr("OK"));
			okButton->setDefault(true);
			connect(okButton, SIGNAL(clicked()), this, SLOT(accept()));
			hLayout->addWidget(okButton);
			vLayout->addLayout(hLayout);
		}
	setLayout(vLayout);
	setSizeGripEnabled(false);		//	TCY֎~
}

LinkDlg::~LinkDlg()
{

}

void LinkDlg::selectFile()
{
    QString fileName = QFileDialog::getOpenFileName(0, tr("Select Link File"));
    if( !fileName.isEmpty() ) {
    	m_linkText->setText(fileName);
    }
}
