#include <QtGui>
#include "SettingsDlg.h"

SettingsDlg::SettingsDlg(QWidget *parent)
	: QDialog(parent)
{
	QVBoxLayout *vLayout = new QVBoxLayout();
		{QGroupBox *gb = new QGroupBox(tr("default font"));
			gb->setSizePolicy(QSizePolicy::Fixed, QSizePolicy::Fixed);
			vLayout->addWidget(gb);
			QHBoxLayout *hLayout = new QHBoxLayout();
			    hLayout->addWidget(m_fontCombo = new QFontComboBox());
			    hLayout->addWidget(m_fontSizeCombo = new QComboBox());
				m_fontSizeCombo->setEditable(true);
				for (int i = 8; i <= 30; i = i + 2)
				    m_fontSizeCombo->addItem(QString().setNum(i));
				for (int i = 40; i <= 60; i = i + 10)
				    m_fontSizeCombo->addItem(QString().setNum(i));
				m_fontSizeCombo->addItem(QString().setNum(100));
				QIntValidator *validator = new QIntValidator(2, 999, this);
				m_fontSizeCombo->setValidator(validator);
				gb->setLayout(hLayout);
		}
		{QGroupBox *gb = new QGroupBox(tr("default node style"));
			gb->setSizePolicy(QSizePolicy::Fixed, QSizePolicy::Fixed);
			vLayout->addWidget(gb);
			QHBoxLayout *hLayout = new QHBoxLayout();
				hLayout->addWidget(m_nodeStyleFork = new QRadioButton(tr("Fork"), gb));
				hLayout->addWidget(m_nodeStyleRect = new QRadioButton(tr("Rect"), gb));
				hLayout->addWidget(m_nodeStyleRoundRect = new QRadioButton(tr("RoundRect"), gb));
				hLayout->addWidget(m_nodeStyleCircleRect = new QRadioButton(tr("CircleRect"), gb));
				gb->setLayout(hLayout);
		}
		{QFormLayout *fl = new QFormLayout;
			fl->setFieldGrowthPolicy(QFormLayout::FieldsStayAtSizeHint);
			fl->setLabelAlignment(Qt::AlignRight);
			vLayout->addLayout(fl);
			fl->addRow(tr("parent-children space:"), m_pcSpaceSB = new QSpinBox());
			m_pcSpaceSB->setRange(0, 100);
			fl->addRow(tr("child-child space:"), m_ccSpaceSB = new QSpinBox());
			m_ccSpaceSB->setRange(2, 100);
			fl->addRow(tr("root's children space:"), m_rccSpaceSB = new QSpinBox());
			m_rccSpaceSB->setRange(2, 100);
			fl->addRow(tr("outline prefix:"), m_outlinePrefix = new QLineEdit());
		}
		{QGroupBox *gb = new QGroupBox(tr("scene background grid"));
			gb->setSizePolicy(QSizePolicy::Fixed, QSizePolicy::Fixed);
			vLayout->addWidget(gb);
			QHBoxLayout *hLayout = new QHBoxLayout();
				hLayout->addWidget(m_bgGridCheck = new QCheckBox(tr("scene bg Grid")));
				hLayout->addWidget(new QLabel(tr("color:")));
				hLayout->addWidget(m_bgColorName = new QLineEdit());
				hLayout->addWidget(new QLabel(tr("alpha:")));
				hLayout->addWidget(m_bgColorAlpha = new QSpinBox());
				m_bgColorAlpha->setRange(0, 255);
				gb->setLayout(hLayout);
		}
		{QHBoxLayout *hLayout = new QHBoxLayout();
			hLayout->addStretch();
			QPushButton *okButton = new QPushButton(tr("OK"));
			okButton->setDefault(true);
			connect(okButton, SIGNAL(clicked()), this, SLOT(accept()));
			hLayout->addWidget(okButton);
			vLayout->addLayout(hLayout);
		}

	setLayout(vLayout);
	setSizeGripEnabled(false);		//	TCY֎~
}

SettingsDlg::~SettingsDlg()
{

}

int SettingsDlg::nodeStyle() const
{
	return	m_nodeStyleFork->isChecked() ? 0 :
			m_nodeStyleRect->isChecked() ? 1 :
			m_nodeStyleRoundRect->isChecked() ? 2 : 3;

}
void SettingsDlg::setNodeStyle(int s)
{
	switch( s ) {
	default: m_nodeStyleFork->setChecked(true); break;
	case 1: m_nodeStyleRect->setChecked(true); break;
	case 2: m_nodeStyleRoundRect->setChecked(true); break;
	case 3: m_nodeStyleCircleRect->setChecked(true); break;
	}
}
