#ifndef VIEW_H
#define VIEW_H

#include <QGraphicsView>

class View : public QGraphicsView
{
	Q_OBJECT

public:
	View(QGraphicsScene * scene, QWidget *parent = 0);
	~View();

public slots:
	void	viewRotateReset();
	void	viewScaleReset();
	void	viewZoomIn();
	void	viewZoomOut();
	void	viewAutoZoom();
	void	fullScreen(bool);

protected:
#if 0
	void	dragEnterEvent ( QDragEnterEvent * event );
	void	dragMoveEvent ( QDragEnterEvent * event );
	void	dropEvent ( QDropEvent * event );
#endif
	void	wheelEvent ( QWheelEvent * event );

	void	viewScale(qreal s);		//	zoomIn/Outi{s{j

signals:
	void	showMessage(const QString &, int = 0);

private:
	qreal	m_rotateAngle;
	//qreal	m_scale;
};

#endif // VIEW_H
