#include <QtGui>
//#include <QDateTime>
#include "Node.h"
#include "Scene.h"
#include "GlobalSettings.h"
#include <algorithm>
//#include <Q3Painter>

//----------------------------------------------------------------------
ClpsExpndButton::ClpsExpndButton(QGraphicsItem * parent)
	: QGraphicsRectItem(-2, -2, 4, 4, parent)
{
	setCursor(Qt::ArrowCursor);
}
#if 0
void ClpsExpndButton::hoverEnterEvent ( QGraphicsSceneHoverEvent * event )
{
}
void ClpsExpndButton::hoverLeaveEvent ( QGraphicsSceneHoverEvent * event )
{
}
#endif
void ClpsExpndButton::mousePressEvent ( QGraphicsSceneMouseEvent * event )
{
	Node *node = dynamic_cast<Node *>(parentItem());
	node->emitSelectedNodeClicked();
}
void ClpsExpndButton::paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget)
{
	Node *node = dynamic_cast<Node *>(parentItem());
	painter->setPen(node->expanded() ? Qt::gray : Qt::red);
	painter->setBrush(Qt::white);
	painter->drawEllipse(rect());
}
//----------------------------------------------------------------------

LinkItem::LinkItem(QGraphicsItem * parent)
	: QGraphicsRectItem(parent)
{
	setCursor(Qt::PointingHandCursor);
	setAcceptHoverEvents(true);
}
Scene *LinkItem::scene()
{
	return dynamic_cast<Scene *>(QGraphicsItem::scene());
}
void LinkItem::hoverEnterEvent ( QGraphicsSceneHoverEvent * event )
{
	//setCursor(Qt::PointingHandCursor);
	Node *node = dynamic_cast<Node *>(parentItem());
	scene()->doShowMessage(QObject::tr("link: %1").arg(node->linkedFileName()));
}
void LinkItem::hoverLeaveEvent ( QGraphicsSceneHoverEvent * event )
{
	scene()->doShowMessage("");
}
void LinkItem::mousePressEvent ( QGraphicsSceneMouseEvent * event )
{
	if( event->buttons() != Qt::LeftButton ) return;
	Node *node = dynamic_cast<Node *>(parentItem());
	node->onLinkIconClicked();
#if 0
	const QString fileName = node->linkedFileName();
#ifdef	WIN32
	if( fileName.endsWith(".png", Qt::CaseInsensitive) ) {
		node->switchingPixmapDisplay();
		return;
	}
#endif
	scene()->emitOpenLink(fileName);
#endif
}
void LinkItem::paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget)
{
	QRectF r = rect();
	const qreal wd5 = r.width() / 5;
	//const qreal wd10 = r.width() / 10;
	painter->setPen(Qt::black);
	//painter->setBrush(QColor("lightyellow"));
	painter->setBrush(Qt::yellow);
	painter->drawRect(wd5, wd5*2, wd5*2, wd5*2);
	//painter->drawRect(wd5*2, wd5, wd5*2, wd5*2);
	QPointF points[7];
	points[0] = QPointF(wd5*2, wd5);		//	_
	points[1] = QPointF(wd5*4, wd5);		//	̐
	points[2] = QPointF(wd5*4, wd5*3);		//	E_
#if 1
	points[3] = QPointF(wd5*3.33, wd5*2.33);
	points[4] = QPointF(wd5*2.33, wd5*3.33);
	points[5] = QPointF(wd5*1.66, wd5*2.66);
	points[6] = QPointF(wd5*2.66, wd5*1.66);
#else
	points[3] = QPointF(wd5*3.5, wd5*2.5);
	points[4] = QPointF(wd5*2.5, wd5*3.5);
	points[5] = QPointF(wd5*1.5, wd5*2.5);
	points[6] = QPointF(wd5*2.5, wd5*1.5);
#endif
	painter->setBrush(QColor("pink"));
	painter->drawPolygon(points, 7);
}
//----------------------------------------------------------------------
Node::Node(QGraphicsItem *parent)
	: QGraphicsTextItem(parent)
#if 0
	, m_isRightSide(true)
	, m_expanded(true)
	, m_parentNode(0)
	, m_branch(0)
	, m_fillColor(QColor("white"))
#endif
{
	init();
}
Node::Node(const QString &text, QGraphicsItem *parent)
	: QGraphicsTextItem(text, parent)
#if 0
	, m_isRightSide(true)
	, m_expanded(true)
	, m_parentNode(0)
	, m_branch(0)
	, m_fillColor(QColor("white"))
#endif
{
	init();
}

void Node::init()
{
	m_isRightSide = true;
	m_expanded = true;
	m_alignColumn = false;
	m_toInsertMode = false;
	m_nodeDownward = false;
	m_isFloatingNode = false;
	m_nodeStyle = CIRCLE_RECT_STYLE;
	m_textAlign = Qt::AlignLeft;
	m_parentNode = 0;
	m_branch = 0;
	m_clpsExpndButton = 0;
	m_pixmapItem = 0;
	m_linkItem = 0;
	m_fillColor = QColor("white");
	m_createdDT = m_modifiedDT = QDateTime::currentDateTime().toTime_t();
	setCursor(Qt::IBeamCursor);
	setAcceptDrops(true);
}

Node::~Node()
{

}
Scene *Node::scene()
{
	return dynamic_cast<Scene *>(QGraphicsItem::scene());
}
const Scene *Node::scene() const
{
	return dynamic_cast<const Scene *>(QGraphicsItem::scene());
}
const GlobalSettings *Node::globalSettings() const
{
	return scene()->globalSettings();
}
//	eLXg͂ދ`iV[WnjԂ
QRectF Node::sceneRect() const
{
	const QRectF rect = QGraphicsTextItem::boundingRect();
	return QRectF(scenePos(), QSizeF(rect.width(), rect.height()));;
}
//	`͈
//		CC}`̈͊܂܂Ȃ
QRectF Node::boundingRect() const
{
	const QRectF rect = QGraphicsTextItem::boundingRect();
	if( !isRootNode() || isFloatingNode() ) {
		const qreal ls = leftSideSpace();
		const qreal rs = rightSideSpace();
		QRectF r(rect.left() - ls, rect.top(), rect.width() + ls + rs, rect.height());
#if 0
		if( m_pixmapItem != 0 && m_pixmapItem->isVisible() ) {
			QRectF pxr = m_pixmapItem->pixmap().rect();
			pxr.setY(pxr.y() + r.height());
			r |= pxr;
		}
#endif
		return r;
	}
	const qreal sqrt2 = sqrt(2.0);
	const qreal wd2 = rect.width() * sqrt2;
	const qreal ht2 = rect.height() * sqrt2;
	return QRectF((rect.width() - wd2) / 2, (rect.height() - ht2) / 2, wd2, ht2);		//	Oڑȉ~
	//return QRectF(rect.left(), rect.top() - rect.height()/2, rect.width(), rect.height() * 2);
}
//	I[m[hԂ
int Node::numberOfLeafNode() const
{
	if( !hasChildren() ) return 1;
	int num = 0;
	foreach(QPointer<Node> ptr, m_children) {
		if( ptr )
			num += ptr->numberOfLeafNode();
	}
	return num;
}
Node *Node::rootNode() const
{
	Node *node = (Node *)this;
	while( node->m_parentNode != 0 )
		node = node->m_parentNode;
	return node;
}

#define	ROUND_R		6

#if 0
void drawRoundRect(QPainter * painter, const QRectF &rect)
{
	QPainterPath path;
	path.addRoundedRect(rect, ROUND_R, ROUND_R);
	painter->drawPath(path);
}
#endif
#if 0
void drawCircleRect(QPainter * painter, const QRectF &rect)
{
	const qreal r = rect.height() / 2;
	QRectF rect2(rect.left() - r / 2, rect.top(), rect.width() + r, rect.height());
	QPainterPath path;
	path.addRoundedRect(rect2, r, r);
	painter->drawPath(path);
}
#endif
void Node::paint(QPainter * painter, const QStyleOptionGraphicsItem * option, QWidget * widget)
{
	//static int c = 0;
	//qDebug() << ++c << " Node::paint() " << (int)this;
	const bool sel = isSelected();
	const qreal space = leftSideSpace();
	QRectF br = boundingRect();
	//const qreal ht = br.height();
	const qreal ht0 = font().pointSize() * 2 + 8;
	//r.setLeft(r.left() - space);
	const Qt::GlobalColor col = !sel ? Qt::gray :
								scene()->mode() == Scene::INSERT ? Qt::red : Qt::blue;
	painter->setBrush(m_fillColor);
	painter->setPen(QPen(col, (isRootNode() || sel || nodeStyle() != FORK_STYLE ? 2 : 1)));
	//QRectF r2;
	if( !isRootNode() || isFloatingNode() ) {
		switch( nodeStyle() ) {
		case FORK_STYLE: {
			//QPointF d(-2, 0);
			//painter->drawLine(br.bottomLeft() + d, br.bottomRight() + d);
			//painter->drawLine(br.bottomLeft(), br.bottomRight());
			painter->drawLine(br.left(), br.bottom() - FORK_STYLE_BOTTOM_OFFSET,
								br.right(), br.bottom() - FORK_STYLE_BOTTOM_OFFSET);
			painter->setPen(Qt::transparent);
			br.setHeight(br.height() - FORK_STYLE_BOTTOM_OFFSET);
			painter->drawRect(br);
			break;
		}
		case RECT_STYLE: painter->drawRect(br); break;
		case ROUND_RECT_STYLE: painter->drawRoundedRect(br, ROUND_R, ROUND_R); break;
		case CIRCLE_RECT_STYLE: painter->drawRoundedRect(br, ht0/2, ht0/2); break;
		}
	} else {	//	[gm[h̏ꍇ
#if 0
		const qreal sqrt2 = sqrt(2.0);
		const qreal wd2 = br.width() * sqrt2;
		const qreal ht2 = br.height() * sqrt2;
		r2 = QRectF((br.width() - wd2) / 2, (br.height() - ht2) / 2, wd2, ht2);		//	Oڑȉ~
#endif
		painter->drawEllipse(br);
	}
#if	0
	if( sel ) {
		setFlag(QGraphicsItem::ItemIsSelectable, false);
		setSelected(false);
	}
#endif
	QStyleOptionGraphicsItem opt(*option);
	opt.state &= !QStyle::State_Selected;	//	I``Ȃ悤
	//if( scene()->mode() == Scene::INSERT && sel )
	//	opt.state |= QStyle::State_HasFocus;	//	I͈͂`悷邽
	//qDebug() << opt.state;
	QGraphicsTextItem::paint(painter, &opt, widget);
#if 0
	if( sel && !isRootNode() ) {
		const Qt::GlobalColor col = scene()->mode() == Scene::INSERT ? Qt::red : Qt::blue;
		painter->setPen(QPen(col, 2));
		painter->setBrush(Qt::transparent);
		painter->drawRect(r);
		//setFlag(QGraphicsItem::ItemIsSelectable);
		//setSelected(true);
	}
#endif
#if 0
	if( !expanded() && hasChildren() ) {	//	܏Ԃ̏ꍇ͐ڑ_`
		painter->setPen(Qt::red);
		painter->setBrush(Qt::white);
		const QPointF pt = leafConnectingPoint() - scenePos();
		painter->drawEllipse(pt, 2.0, 2.0);
	}
#endif
	if( sel && scene()->selectedNode() == this && scene()->mode() == Scene::COMMAND ) {
		painter->setPen(Qt::transparent);
		painter->setBrush(QColor(0xa0, 0xa0, 0xa0, 64));
		if( !isRootNode() || isFloatingNode() ) {
			switch( nodeStyle() ) {
			case FORK_STYLE:
			case RECT_STYLE: painter->drawRect(br); break;
			case ROUND_RECT_STYLE: painter->drawRoundedRect(br, ROUND_R, ROUND_R); break;
			case CIRCLE_RECT_STYLE: painter->drawRoundedRect(br, ht0/2, ht0/2); break;
			}
		} else {	//	[gm[h̏ꍇ
			painter->drawEllipse(br);
		}
	}
	Scene *pScene = scene();
	if( this == pScene->dropTarget() ) {
		painter->setPen(Qt::transparent);
		QColor col("pink");
		col.setAlpha(128);
		//painter->setBrush(col);
	    QLinearGradient lg;
	    if( !isRootNode() && !pScene->toDropAsChild() ) {
		    lg.setColorAt(0, Qt::transparent);
		    lg.setColorAt(1, col);
		    lg.setStart(br.left(), br.top());
		    lg.setFinalStop(br.left(), br.bottom());
	    } else {
		    if( isRootNode() &&
		    			pScene->mousePos().x() - scenePos().x() >= br.width() / 2 ||
				    !isRootNode() && isRightSide() )
		    {
			    lg.setColorAt(0, Qt::transparent);
			    lg.setColorAt(1, col);
		    } else {
			    lg.setColorAt(0, col);
			    lg.setColorAt(1, Qt::transparent);
		    }
		    lg.setStart(br.left(), br.bottom());
		    lg.setFinalStop(br.right(), br.bottom());
	    }
		painter->setBrush(lg);
		if( !isRootNode() || isFloatingNode() ) {
			switch( nodeStyle() ) {
			case FORK_STYLE:
			case RECT_STYLE: painter->drawRect(br); break;
			case ROUND_RECT_STYLE: painter->drawRoundedRect(br, ROUND_R, ROUND_R); break;
			case CIRCLE_RECT_STYLE: painter->drawRoundedRect(br, ht0/2, ht0/2); break;
			}
		} else {	//	[gm[h̏ꍇ
			painter->drawEllipse(br);
		}
	}
}

bool Node::isChildNode(Node *node) const
{
	QList<QPointer<Node> >::const_iterator itr = std::find(m_children.begin(),
														m_children.end(),
														QPointer<Node>(node));
	return itr != m_children.end();
}
bool Node::isAncesterNodeSelected() const
{
	const Node *node = this;
	while( node->m_parentNode != 0 ) {
		node = node->m_parentNode;
		if( node->isSelected() )
			return true;
	}
	return false;
}
//	node  this ̎qm[hǂ`FbN
bool Node::isDescendantNode(const Node *node) const
{
	foreach(QPointer<Node> ptr, m_children) {
		if( ptr == node ||
			ptr != 0 && ptr->isDescendantNode(node) )
		{
			return true;
		}
	}
	return false;
}

QString Node::infoText() const
{
	const int num = numberOfChildren();
	const int nLeaf = numberOfLeafNode();
	QString mess = !num ? tr("selected node has no children.") :
							tr("selected node has %1 child, %2 leaf node(s).").arg(num).arg(nLeaf);
	QDateTime cdt;
	cdt.setTime_t(m_createdDT);
	QDateTime mdt;
	mdt.setTime_t(m_modifiedDT);
	if( cdt != mdt )
		mess += tr(" (%1, %2)")
					.arg(cdt.toString("yy/MM/dd hh:mm:ss"))
					.arg(mdt.toString("yy/MM/dd hh:mm:ss"));
	else
		mess += tr(" (%1)")
					.arg(cdt.toString("yy/MM/dd hh:mm:ss"));
	//	for Debug
#ifdef	_DEBUG
	mess += QString(" this = %1 parentItem = %2").arg((uint)this, 0, 16).arg((uint)parentItem(), 0, 16);
	//mess += QString(" textWidth = %1").arg(textWidth());
	if( m_branch ) {
		mess += QString(" branch.parentItem = %2") .arg((uint)m_branch->parentItem());
	}
	mess += QString(" scene() = %1").arg((uint)scene(), 0, 16);
	//mess += QString(" z = %1").arg(zValue());
#endif
	return mess;
}
//	"." ŃCfgꂽeLXgԂ
QString Node::toOutlineText(int lvl) const
{
	QString buffer;
	if( lvl > 0 ) buffer = globalSettings()->m_outlinePrefix.repeated(lvl);
	//QString buffer(lvl, '.');
	buffer += toPlainText().replace("\n", " ");
	buffer += "\n";
	foreach(QPointer<Node> ptr, m_children) {
		if( ptr )
			buffer += ptr->toOutlineText(lvl+1);
	}
	return buffer;
}
QString Node::toXmlText() const
{
	//	undone B Eʒuo
	QString buffer = "<node TEXT=\"";
	buffer += Qt::escape(toPlainText());
	buffer += "\" ";
	if( isRootNode() ) {
		//if( isFloatingNode() ) {
			const QPointF sp = scenePos();
			buffer += QString("SX=\"%1\" SY=\"%2\" ").arg(sp.x()).arg(sp.y());
		//}
	} else if( !parent() ) {		//	[g̎q̏ꍇ
		if( isRightSide() )
			buffer += "POSITION=\"right\" ";
		else
			buffer += "POSITION=\"left\" ";
	}
	buffer += QString("CREATED=\"%1\" ").arg(m_createdDT);
	buffer += QString("MODIFIED=\"%1\" ").arg(m_modifiedDT);
	switch( nodeStyle() ) {
	case FORK_STYLE: buffer += "STYLE=\"fork\" "; break;
	case RECT_STYLE: buffer += "STYLE=\"rect\" "; break;
	case ROUND_RECT_STYLE: buffer += "STYLE=\"roundRect\" "; break;
	case CIRCLE_RECT_STYLE: buffer += "STYLE=\"circleRect\" "; break;
	}
	buffer += QString("FONTNAME=\"%1\" FONTSIZE=\"%2\" ").
				arg(font().family()).arg(font().pointSize());
	if( !m_linkedFileName.isEmpty() ) {
		buffer += "LINK=\"" + m_linkedFileName + "\" ";
		if( !m_pixmapWidth.isEmpty() )
			buffer += "PXMWIDTH=\"" + m_pixmapWidth + "\" ";
	}
	if( isAlignColumn() )
		buffer += "ALIGNCOLUMN=\"true\" ";
	//const Qt::Alignment align = document()->defaultTextOption().alignment();
	if( m_textAlign == Qt::AlignHCenter )
		buffer += "ALIGN=\"center\" ";
	else if( m_textAlign == Qt::AlignRight )
		buffer += "ALIGN=\"right\" ";
	if( isNodeDownward() )
		buffer += "DOWNWARD=\"true\" ";
	if( expanded() )
		buffer += "EXPANDED=\"true\" ";
	else
		buffer += "EXPANDED=\"false\" ";
	buffer += "FILLCOLOR=\"" + m_fillColor.name() + "\" ";
	if( m_children.isEmpty() )
		buffer += "/>\n";
	else {
		buffer += ">\n";
		foreach(QPointer<Node> ptr, m_children) {
			if( ptr )
				buffer += ptr->toXmlText();
		}
		buffer += "</node>\n";
	}
	return buffer;
}
int Node::childIndexOf(Node *node)
{
	return m_children.indexOf(QPointer<Node>(node));
}
#if 0
//	[g炽ǂāAthis ܂ł̌Zԍi0..*jXgԂ
//		[gm[hF(0)
//		[gm[ĥQԖڂ̎qF(0 1)
//		[gm[ĥQԖڂ̎q̍ŏ̎qF(0 1 0)
QList<int> Node::nodePos()
{
	QList<int> list;
	Node *node = this;
	Node *pNode = node->parentNode();
	while( pNode != 0 ) {
		const int ix = pNode->m_children.indexOf(QPointer<Node>(node));
		list.push_front(ix);
	}
	list.push_front(0);
	return list;
}
#endif
void Node::setNodeDownwardRcsv(bool b)
{
	m_nodeDownward = b;
	foreach(QPointer<Node> ptr, m_children) {
		if( ptr )
			ptr->setNodeDownwardRcsv(b);
	}
}
void Node::setModifiedDT()
{
	setModifiedDT(QDateTime::currentDateTime().toTime_t());
}
void Node::setNodeStyle(uchar t)
{
	m_nodeStyle = t;
	foreach(QPointer<Node> ptr, m_children) {
		if( ptr )
			ptr->setNodeStyle(t);
	}
}
void Node::setPixmapWidth(const QString &width)
{
	if( m_pixmapWidth == width ) return;
	m_pixmapWidth = width;
}
void Node::setLink(const QString &fileName)
{
	if( m_pixmapItem != 0 ) {
		delete m_pixmapItem;
		m_pixmapItem = 0;
	}
	m_linkedFileName = fileName;
	if( fileName.isEmpty() ) {
		delete m_linkItem;
		m_linkItem = 0;
	} else {
		if( !m_linkItem ) {
			m_linkItem = new LinkItem(this);
			//connect(m_linkItem, SIGNAL(openLink(const QString &)), scene(), SIGNAL(openLink(const QString &)));
			//m_linkItem = new QGraphicsPixmapItem(this);
			const qreal ht = QGraphicsTextItem::boundingRect().height();
			const qreal wd = QGraphicsTextItem::boundingRect().width();
			m_linkItem->setPos(isRightSide() ? -ht : wd, 0);
			m_linkItem->setRect(0, 0, ht, ht);
		}
	}
}
void Node::updateLinkIconPos()
{
	if( m_linkItem ) {
		const qreal ht = QGraphicsTextItem::boundingRect().height();
		const qreal wd = QGraphicsTextItem::boundingRect().width();
		m_linkItem->setPos(isRightSide() ? -ht : wd, 0);
		m_linkItem->setRect(0, 0, ht, ht);
	}
}
void Node::updateLinkIconPosRecursive()
{
	updateLinkIconPos();
	foreach(Node *node, m_children) {
		node->updateLinkIconPosRecursive();
	}
}
void Node::makeChildrenVisible(bool b)
{
	foreach(QPointer<Node> ptr, m_children) {
		if( ptr ) {
			ptr->setVisible(b);
			if( ptr->m_branch )
				ptr->m_branch->setVisible(b);
			ptr->makeChildrenVisible(b);
		}
	}
}
void Node::selectAllChildren()
{
	foreach(QPointer<Node> ptr, m_children) {
		if( ptr ) {
			ptr->setSelected(true);
			ptr->selectAllChildren();
		}
	}
}
void Node::expandAll(bool expanded)
{
	foreach(QPointer<Node> ptr, m_children) {
		if( ptr ) {
			ptr->setExpanded(expanded);
			ptr->setVisible(expanded);
			if( ptr->m_branch )
				ptr->m_branch->setVisible(expanded);
			ptr->expandAll(expanded);
		}
	}
}
qreal Node::textWidthEx() const
{
	const qreal wd = textWidth();
	if( wd >= 0 )
		return wd;
	else
		return QGraphicsTextItem::boundingRect().width();
}
qreal Node::height(bool isRightSide) const
{
	qreal brht = QGraphicsTextItem::boundingRect().height();
	if( m_pixmapItem != 0 && m_pixmapItem->isVisible() ) {
		QRectF pxr = m_pixmapItem->pixmap().rect();
		brht += pxr.height();
	}
	if( m_children.isEmpty() || !expanded() )
		return brht;
	if( !isNodeDownward() )
		return qMax(brht, childHeight(isRightSide));
	else {
		return brht + globalSettings()->m_ccSpace + childHeight(isRightSide);
		//return brht + PADDING + childHeight(isRightSide);
	}
}
qreal Node::childHeight(bool isRightSide) const
{
	const qreal brht = QGraphicsTextItem::boundingRect().height();
	if( m_children.isEmpty() || !expanded() )
		return 0;
	const int ccSpace = isRootNode() ? globalSettings()->m_rccSpace : globalSettings()->m_ccSpace;
	qreal h = -ccSpace;
	//qDebug() << m_children.size();
	foreach(QPointer<Node> ptr, m_children) {
		if( ptr && ptr->isRightSide() == isRightSide ) {
			h += ptr->height(isRightSide);
			h += ccSpace;
		}
	}
	return h;
}
//	eKw̍ő啝擾
void Node::getDescendantColumnWidth(QVector<qreal> &vWidth, bool isRightSide, int depth) const
{
	while( vWidth.size() <= depth )
		vWidth.push_back(0.0);
	qreal maxWd = vWidth[depth];
	foreach(QPointer<Node> ptr, m_children) {
		if( ptr && ptr->isRightSide() == isRightSide ) {
			qreal lwd = !ptr->m_linkedFileName.isEmpty() ? lineHeight() : 0;
			maxWd = qMax(maxWd, ptr->QGraphicsTextItem::boundingRect().width() + lwd);
			ptr->getDescendantColumnWidth(vWidth, isRightSide, depth + 1);
		}
	}
	vWidth[depth] = maxWd;
}
void Node::setChildrenTextWidth(const qreal *wdPtr, bool isRightSide)
{
	++wdPtr;
	foreach(QPointer<Node> ptr, m_children) {
		if( ptr && ptr->isRightSide() == isRightSide ) {
			qreal lwd = !ptr->m_linkedFileName.isEmpty() ? lineHeight() : 0;
			ptr->setTextWidth(*wdPtr - lwd);
			ptr->setChildrenTextWidth(wdPtr, isRightSide);
		}
	}
}
void Node::setTextWidthRecursive(bool alignColumn)
{
	if( alignColumn || m_textAlign != Qt::AlignLeft )
		setTextWidth(textWidthEx());
	if( !alignColumn && isAlignColumn() )
		alignColumn = true;
	foreach(QPointer<Node> ptr, m_children) {
		if( ptr )
			ptr->setTextWidthRecursive(alignColumn);
	}
}
void Node::resetChildrenTextWidthRecursive(bool isRightSide)
{
	setTextWidth(-1);
	//const int wd = QGraphicsTextItem::boundingRect().width();
	//setTextWidth(wd);
	foreach(QPointer<Node> ptr, m_children) {
		if( ptr && ptr->isRightSide() == isRightSide )
			ptr->resetChildrenTextWidthRecursive(isRightSide);
	}
}

void Node::createBranch()
{
	m_branch = new QGraphicsPathItem(this);
	//m_branch->setParentItem(node);
	m_branch->setPen(QPen(Qt::gray));
}
Node *Node::addNode(Node *node)
{
	//scene()->addItem(node);
	node->m_parentNode = this;
	node->setParentItem(this);
	m_children.push_back(QPointer<Node>(node));
	if( !node->m_branch ) {
		node->createBranch();
	}
	return node;
}
void Node::insert(int ix, Node *node)
{
	m_children.insert(ix, QPointer<Node>(node));
	node->m_parentNode = this;
	node->setParentItem(this);
}
Node *Node::insertBefore(Node *node)
{
	Node *pNode = parentNode();
	if( !pNode )			//	[gm[ȟZ͍Ȃ
		return addNode(node);
	node->m_parentNode = pNode;
	node->setParentItem(pNode);
	if( !node->m_branch ) {
		node->createBranch();
	}
	int ix = 0;
	foreach(QPointer<Node> ptr, pNode->m_children) {
		if( ptr == this ) {
			pNode->m_children.insert(ix, QPointer<Node>(node));
			break;
		}
		++ix;
	}
	return node;
}
Node *Node::insertAfter(Node *node)
{
	Node *pNode = parentNode();
	if( !pNode )			//	[gm[ȟZ͍Ȃ
		return addNode(node);
	node->m_parentNode = pNode;
	node->setParentItem(pNode);
	if( !node->m_branch ) {
		node->createBranch();
	}
	int ix = 0;
	foreach(QPointer<Node> ptr, pNode->m_children) {
		++ix;
		if( ptr == this ) {
			pNode->m_children.insert(ix, QPointer<Node>(node));
			break;
		}
	}
	return node;
}

void Node::freeNode()
{
	foreach(QPointer<Node> ptr, m_children) {
		if( ptr )
			ptr->freeNode();
	}
	if( m_branch ) {
		delete m_branch;
		m_branch = 0;
	}
	if( m_clpsExpndButton ) {
		delete m_clpsExpndButton;
		m_clpsExpndButton = 0;
	}
	delete this;
}
void Node::addToScene(Scene *scene)		//	qV[ɒǉ
{
	if( parentItem() == 0 )
		scene->addItem(this);

#if 0
	foreach(QPointer<Node> ptr, m_children) {
		if( ptr )
			ptr->addToScene(scene);
	}
	if( m_branch ) {
		scene->addItem(m_branch);
	}
	scene->addItem(this);
#endif
}
//	V[ this ȉ폜
Node *Node::removeFromScene()
{
	foreach(QPointer<Node> ptr, m_children) {
		if( ptr )
			ptr->removeFromScene();
	}
	if( m_branch ) {
		scene()->removeItem(m_branch);
	}
	scene()->removeItem(this);
	return this;
}
#if 0
void Node::removeNode()
{
	foreach(QPointer<Node> ptr, m_children) {
		if( ptr )
			ptr->removeNode();
	}
	if( m_branch ) {
		scene()->removeItem(m_branch);
		delete m_branch;
		m_branch = 0;
	}
	scene()->removeItem(this);
	delete this;
}
#endif
void Node::removeFromChildrenList(Node *node)
{
	QList<QPointer<Node> >::iterator itr = std::find(m_children.begin(),
														m_children.end(),
														QPointer<Node>(node));
	if( itr != m_children.end() )
		m_children.erase(itr);
}

Node *Node::moveUp()
{
	Node *pNode = parentNode();
	if( !pNode ) return this;
	for(QList<QPointer<Node> >::iterator itr = pNode->m_children.begin(),
											iend = pNode->m_children.end();
		itr != iend;
		++itr)
	{
		if( *itr == this ) {
			itr = pNode->m_children.erase(itr);
			if( itr == pNode->m_children.begin() )
				itr = pNode->m_children.end();
			else
				--itr;
			pNode->m_children.insert(itr, this);
			this->setModifiedDT();
			break;
		}
	}
	return this;
}
Node *Node::moveDown()
{
	Node *pNode = parentNode();
	if( !pNode ) return this;
	for(QList<QPointer<Node> >::iterator itr = pNode->m_children.begin(),
											iend = pNode->m_children.end();
		itr != iend;
		++itr)
	{
		if( *itr == this ) {
			itr = pNode->m_children.erase(itr);
			if( itr == pNode->m_children.end() )
				itr = pNode->m_children.begin();
			else
				++itr;
			pNode->m_children.insert(itr, this);
			this->setModifiedDT();
			break;
		}
	}
	return this;
}
Node *Node::levelUp()
{
	Node *pNode = parentNode();
	if( !pNode ) return this;		//	[gm[h̏ꍇ
	Node *ppNode = pNode->parentNode();
	if( !ppNode ) return this;		//	[gm[h̎q̏ꍇ
	QList<QPointer<Node> >::iterator itr = std::find(pNode->m_children.begin(),
														pNode->m_children.end(),
														QPointer<Node>(this));
	pNode->m_children.erase(itr);
	itr = std::find(ppNode->m_children.begin(),
					ppNode->m_children.end(),
					QPointer<Node>(pNode));
	ppNode->m_children.insert(++itr, this);
	m_parentNode = ppNode;
	setParentItem(ppNode);
	this->setModifiedDT();
	return this;
}
Node *Node::levelDown()
{
	Node *pNode = parentNode();
	if( !pNode ) return this;
	Node *dstNode = prevNode();
	if( !dstNode ) {		//	ZȂꍇ
		dstNode = nextNode();	//	Zꍇ͒̉Ɉړ
		if( !dstNode ) return this;	//	Ȃꍇ
	}
	if( !dstNode->expanded() )
		dstNode->setExpanded(true);
	QList<QPointer<Node> >::iterator itr = std::find(pNode->m_children.begin(),
														pNode->m_children.end(),
														QPointer<Node>(this));
	pNode->m_children.erase(itr);
	dstNode->addNode(this);
	this->setModifiedDT();
	return this;
}
Node *Node::moveLeft()
{
	Node *pNode = parentNode();
	if( !pNode ) return this;		//	[gm[h̏ꍇ
	Node *ppNode = pNode->parentNode();
	if( !ppNode && isRightSide() ) {	//	[gm[h̉Eq̏ꍇ
		setRightSideRecursive(LEFT_SIDE);
		moveToLastChild();
		updateLinkIconPosRecursive();
	} else if( isRightSide() )
		levelUp();
	else
		levelDown();
	return this;
}
Node *Node::moveRight()
{
	Node *pNode = parentNode();
	if( !pNode ) return this;		//	[gm[h̏ꍇ
	Node *ppNode = pNode->parentNode();
	if( !ppNode && !isRightSide() ) {	//	[gm[h̍q̏ꍇ
		setRightSideRecursive(RIGHT_SIDE);
		moveToLastChild();
		updateLinkIconPosRecursive();
	} else if( !isRightSide() )
		levelUp();
	else
		levelDown();
	return this;
}
void Node::setRightSideRecursive(bool b)
{
	m_isRightSide = b;
	foreach(QPointer<Node> ptr, m_children) {
		if( ptr )
			ptr->setRightSideRecursive(b);
	}
}
//	m[hŌ̎qʒuɈړ
void Node::moveToLastChild()
{
	Node *pNode = parentNode();
	if( !pNode ) return;		//	[gm[h̏ꍇ
	if( pNode->m_children.size() <= 1 ) return;
	QList<QPointer<Node> >::iterator itr = std::find(pNode->m_children.begin(),
														pNode->m_children.end(),
														QPointer<Node>(this));
	pNode->m_children.erase(itr);
	pNode->m_children.push_back(QPointer<Node>(this));
}
//	
qreal Node::leftSideSpace() const
{
#if 0
	const qreal ht = QGraphicsTextItem::boundingRect().height();
	int pxSize = font().pixelSize();
	qreal poSize = font().pointSizeF();
	QFontInfo fi(font());
	int pxSize2 = fi.pixelSize();
	qDebug() << "ht = " << ht << ", poSize = " << poSize << ", pxSize2 = " << pxSize2;
#endif
	const qreal ht = font().pointSizeF() * 2 + 8;
	qreal space = (!isRootNode() || isFloatingNode()) && nodeStyle() == CIRCLE_RECT_STYLE ? ht / 4 : 0;
	if( !m_linkedFileName.isEmpty() && isRightSide() )
		space += ht;
	return space;
}
//	E
qreal Node::rightSideSpace() const
{
	const qreal ht = font().pointSizeF() * 2 + 8;
	//const qreal ht = QGraphicsTextItem::boundingRect().height();
	qreal space = (!isRootNode() || isFloatingNode()) && nodeStyle() == CIRCLE_RECT_STYLE ? ht / 4 : 0;
	if( !m_linkedFileName.isEmpty() && !isRightSide() )
		space += ht;
	return space;
}
//	[g
qreal Node::spaceForRootDirection() const
{
	const qreal ht = font().pointSizeF() * 2 + 8;
	//const qreal ht = QGraphicsTextItem::boundingRect().height();
	qreal space = (!isRootNode() || isFloatingNode()) && nodeStyle() == CIRCLE_RECT_STYLE ? ht / 4 : 0;
	if( !m_linkedFileName.isEmpty() )
		space += ht;
	return space;
}
//	[
qreal Node::spaceForLeafDirection() const
{
	const qreal ht = font().pointSizeF() * 2 + 8;
	//const qreal ht = QGraphicsTextItem::boundingRect().height();
	qreal space = (!isRootNode() || isFloatingNode()) && nodeStyle() == CIRCLE_RECT_STYLE ? ht / 4 : 0;
	return space;
}
//	[gڑ_WiV[Wnj
QPointF Node::rootConnectingPoint() const
{
	const QRectF r = sceneRect();
	const qreal space = spaceForRootDirection();
	const qreal x = isRightSide() ? r.left() - space : r.right() + space;
	const qreal y = (!isRootNode() || isFloatingNode()) && nodeStyle() == FORK_STYLE ?
						r.bottom() - FORK_STYLE_BOTTOM_OFFSET : r.top() + r.height() / 2;
	return QPointF(x, y);
}
//	[ڑ_WiV[Wnj
QPointF Node::leafConnectingPoint() const
{
	const QRectF r = sceneRect();
	if( isNodeDownward() ) {
		return QPointF(r.left() + r.height(),
						r.bottom() - (nodeStyle() == FORK_STYLE ? FORK_STYLE_BOTTOM_OFFSET :0));
	} else {
		const qreal space = spaceForLeafDirection();
		const qreal y = (!isRootNode() || isFloatingNode()) && nodeStyle() == FORK_STYLE ?
							r.bottom() - FORK_STYLE_BOTTOM_OFFSET : r.top() + r.height() / 2;
		if( m_pixmapItem != 0 && m_pixmapItem->isVisible() ) {
			const qreal pw = m_pixmapItem->pixmap().width();
			const qreal x = !isRightSide() ? (r.width() >= pw ? r.left() - space : r.right() - pw) :
								(r.width() >= pw ? r.right() + space : r.left() + pw);
			return QPointF(x, y + m_pixmapItem->pixmap().height() / 2);
		} else {
			const qreal x = !isRightSide() ? r.left() - space : r.right() + space;
			return QPointF(x, y);
		}
	}
}
QRectF Node::layoutChildren()
{
	QRectF r;
	if( parent() != 0 ) {	//	[gm[hłȂꍇ
		r = layoutChildren(isRightSide(), expanded());
	} else {	//	[gm[h̏ꍇ
		const QRectF rs = layoutChildren(true, true);		//	ECAEg
		const QRectF ls = layoutChildren(false, true);		//	CAEg
		r = ls | rs;
	} 
	setTextWidthRecursive(isAlignColumn());
	return r;
}
void Node::setBranchPath(const QPointF &pp0)		//	ppFem[h̐ڑ_ m[hWn
{
	QPointF pp = pp0;
	const QPointF cp0 = rootConnectingPoint();		//	[g̐ڑ_ V[Wn
	const QPointF cp = cp0 - scenePos();		//	[g̐ڑ_ m[hWn
#if 0
	Node *pNode = parentNode();
	if( pNode->isRootNode() && !isFloatingNode() ) {
		const QRectF pbr = pNode->boundingRect();	//	em[h̃[JWn // m[hWnɕϊ
		const qreal wd2 = pbr.width() * pbr.width() / 4;
		const qreal ht2 = pbr.height() * pbr.height() / 4;
		QPointF d = cp - pbr.center() + pos();			//	[gm[h̕ψ
		const qreal X2 = d.x() * d.x();
		const qreal Y2 = d.y() * d.y();
		qreal x = sqrt((wd2 * ht2 * X2) / (ht2 * X2 + wd2 * Y2));
		qreal y = sqrt((wd2 * ht2 * Y2) / (ht2 * X2 + wd2 * Y2));
		if( d.x() < 0 ) x = -x;
		if( d.y() < 0 ) y = -y;
		pp = cp - QPointF(x, y);
	}
#endif
	QGraphicsPathItem *pi = m_branch;
	pi->setParentItem(this);
	QPainterPath path;
	path.moveTo(pp);			//	em[hڑ_ʒu
	const QPointF c1((pp.x() + cp.x()) / 2, pp.y());		//	_ 1
	const QPointF c2(pp.x(), cp.y());					//	_ 2
	path.cubicTo(c1, c2, cp);
	pi->setPath(path);
}
/*
                        
                              
	y             
            py      
                    
                              
                        
*/
//	@return		ƑSĂ̎q͂ލŏ`Ԃ
//	qm[h͐em[h̎qACeɂȂĂ̂ŁA
//	pos ͐em[hWnł̒lɂȂ
QRectF Node::layoutChildren(bool isRightSide,
							bool exp,
							bool aligned)		//	cm[h́uJ𑵂vtOĂ
{
	//	undone B ɔzuꂽꍇ
	//	undone B [gm[h̏ꍇ
	if( !aligned && isAlignColumn() ) {
		resetChildrenTextWidthRecursive(isRightSide);		//	Um[hZbgi-1 for ˑj
		QVector<qreal> vWidth;
		vWidth.push_back(boundingRect().width());
		getDescendantColumnWidth(vWidth, isRightSide, 1);
		setChildrenTextWidth(vWidth.constData(), isRightSide);
		aligned = true;
	} else if( !aligned && !isAlignColumn() && textWidth() >= 0 ) {
		resetChildrenTextWidthRecursive(isRightSide);
	}
	QPointF psPos = scenePos();		//	em[hʒuiV[Wnj
	QRectF br = boundingRect();
	if( m_pixmapItem != 0 && m_pixmapItem->isVisible() ) {
		QRectF pr = m_pixmapItem->pixmap().rect();
		pr.setY(br.height());
		br |= pr;
	}
	br.translate(psPos);			//	oEh`iV[Wnj
	if( m_children.isEmpty() ) {
		if( m_clpsExpndButton != 0 )
			m_clpsExpndButton->setVisible(false);
		return br;		//	g̈ʒu͈ړȂ
	}
	if( m_clpsExpndButton != 0 )
		m_clpsExpndButton->setVisible(true);
	if( !expanded() ) exp = false;
	const QRectF pr = sceneRect();	//	em[hʒuETCY
	QPointF pp;		//	em[h̐ڑ_ʒu
	qreal ppx;
	if( isRootNode() /*&& !isFloatingNode()*/ ) {
		pp = QPointF(isRightSide ? br.right() : br.left(), br.top() + br.height() / 2);
		ppx = pp.x();
		//if( !isFloatingNode() )
		//	pp.setX(br.left() + br.width() / 2);		//	ڑ_[g
	} else {
		pp = leafConnectingPoint();
		ppx = pp.x();
	}
	if( !isRootNode() ) {
		if( m_clpsExpndButton == 0 ) {
			m_clpsExpndButton = new ClpsExpndButton(this);
			m_clpsExpndButton->setZValue(1.0);
		}
		m_clpsExpndButton->setPos(leafConnectingPoint() - scenePos());
	}
	const int ccSpace = isRootNode() ? globalSettings()->m_rccSpace : globalSettings()->m_ccSpace;
	const qreal ht = childHeight(isRightSide);		//	qm[hŜ̍
	qreal y = scenePos().y() + (isRootNode() || !isNodeDownward()
							? pr.height() / 2 - ht / 2
							: pr.height() + ccSpace);
	if( m_pixmapItem != 0 && m_pixmapItem->isVisible() )
		y += m_pixmapItem->pixmap().height() / 2;
	foreach(QPointer<Node> ptr, m_children) {
		if( ptr && ptr->isRightSide() == isRightSide ) {
			if( exp ) {
				ptr->updatePixmapPos();
				const QRectF r = ptr->QGraphicsTextItem::boundingRect();
				const int pcSpace = globalSettings()->m_pcSpace;
				const qreal space = ptr->spaceForRootDirection() + pcSpace;
				const qreal nx = ppx + (isRightSide ? space : -space - r.width()) - psPos.x();
				const qreal ih = ptr->height(isRightSide);		//	qm[h܂߂
				//	qm[hgbvʒu
				qreal ny = y + (!ptr->isNodeDownward() ? ih / 2 - r.height() / 2 : 0) - psPos.y();
				if( ptr->m_pixmapItem != 0 && ptr->m_pixmapItem->isVisible() )
					ny -= ptr->m_pixmapItem->pixmap().rect().height() / 2;
				const QPointF csPos(nx, ny);
				ptr->setPos(csPos);	//	qm[hʒuݒ
				ptr->setBranchPath(pp - ptr->scenePos());
				QRectF cr = ptr->layoutChildren(isRightSide, exp, aligned /*nextWdPtr*/);
				br |= cr;
				y += ih + ccSpace;
			} else {
				ptr->setVisible(false);
				ptr->m_branch->setVisible(false);
				ptr->layoutChildren(isRightSide, exp, aligned /*nextWdPtr*/);
			}
		}
	}
	return br;
}
void Node::focusOutEvent ( QFocusEvent * event )
{
	if( !m_toInsertMode ) {		//	}[hֈڍsłȂꍇ
		setTextCursor(QTextCursor());
		scene()->setMode(Scene::COMMAND);
	}
	QGraphicsTextItem::focusOutEvent ( event );
}
void Node::keyPressEvent(QKeyEvent *event)
{
	if( event->modifiers() == Qt::ControlModifier && event->key() == Qt::Key_V ) {
		//qDebug() << "Ctrl + V";
		QClipboard *cb = QApplication::clipboard();
		const QMimeData *mime = cb->mimeData();
		if( mime && mime->hasText() ) {
			QString buffer = mime->text();
			textCursor().insertText(buffer);
		}
	} else
		QGraphicsTextItem::keyPressEvent(event);
}
//Node *Node::g_dragSource = 0;
//Node *Node::g_dropTarget = 0;
bool Node::g_pressedNodeSelected = false;
//bool Node::g_shift = false;
//bool Node::g_alt = false;
//bool Node::g_dropedToSameScene = false;
QPointF Node::g_clickedPos;			//	}EXNbNʒuiV[Wnj
QPointF Node::g_clickedItemPos;		//	NbNꂽm[hʒuiV[Wnj
//QPointF Node::g_mousePos;			//	hbv^[Qbgm[h̃}EX|C^ʒu

#if 1
void Node::mousePressEvent ( QGraphicsSceneMouseEvent * event )
{
	Scene *pScene = scene();
	if( pScene == 0 ) return;
	Q_ASSERT(pScene != 0);
	qDebug() << "Node::mousePressEvent() node = " << this;
	g_pressedNodeSelected = isSelected();
	ensureVisible();
	g_clickedPos = event->scenePos();
	g_clickedItemPos = scenePos();
	//pScene->setClickedPos(event->scenePos());
	//pScene->setClickedItemPos(scenePos());
	pScene->setMousePressedNode(this);
	//Node *sNode = pScene->selectedNode();
	if( pScene->mode() == Scene::INSERT ) {
		if( !this->isSelected() )		//	ҏWm[hȊONbNꂽꍇ
			pScene->setMode(Scene::COMMAND);
	}
	QGraphicsTextItem::mousePressEvent( event );
}

void Node::mouseMoveEvent ( QGraphicsSceneMouseEvent * event )
{
	qDebug() << "Node::mouseMoveEvent() event->scenePos() = " << event->scenePos();
	const bool alt = (event->modifiers() & Qt::AltModifier) != 0;
	Scene *pScene = scene();
	if( isRootNode() && (!isFloatingNode() || alt) && pScene->mode() == Scene::COMMAND ) {
		QPointF pnt = event->scenePos() - g_clickedPos + g_clickedItemPos;
		setPos(pnt);
	} else if( (!isRootNode() || isFloatingNode()) && pScene->mode() == Scene::COMMAND &&
				QLineF(event->scenePos(), event->buttonDownScenePos(Qt::LeftButton))
				.length() >= QApplication::startDragDistance() )
	{
		pScene->setDragSource(this);
		pScene->setDropTarget(0);
		//g_dragSource = this;
		pScene->setDroppedToSameScene(false);
		//g_dropTarget = 0;
		QDrag *drag = new QDrag(event->widget());
		QMimeData *mime = new QMimeData;
		QString buffer = "<map>\n";
		buffer += toXmlText();
		buffer += "</map>\n";
		//mime->setData("Node", QByteArray());
		mime->setHtml(buffer);
		drag->setMimeData(mime);
		//g_shift = (event->modifiers() & Qt::ShiftModifier) != 0;
		//g_alt = (event->modifiers() & Qt::AltModifier) != 0;
		//qDebug() << g_alt;
		if( Qt::MoveAction == drag->exec() && !pScene->droppedToSameScene() ) {
			qDebug() << "Qt::MoveAction";
			emit doDelete(this);
		}
		pScene->setDragSource(0);
		pScene->setDropTarget(0);
		//g_dragSource = 0;
		//g_dropTarget = 0;
		return;
	}
	QGraphicsTextItem::mouseMoveEvent( event );
}
void Node::mouseReleaseEvent ( QGraphicsSceneMouseEvent * event )
{
	Scene *pScene = scene();
	if( pScene->mode() == Scene::COMMAND ) {
		if( isRootNode() /*&& !isFloatingNode()*/ ) {
			QPointF pnt = event->scenePos() - g_clickedPos + g_clickedItemPos;
			setPos(g_clickedItemPos);
			emit rootNodeMoved(this, pnt);
		} //else if( g_pressedNodeSelected )
			//emit selectedNodeClicked(this);
	}
	QGraphicsTextItem::mouseReleaseEvent( event );
}
void Node::mouseDoubleClickEvent ( QGraphicsSceneMouseEvent * mouseEvent )
{
	setTextInteractionFlags(Qt::TextEditorInteraction);
	QTextCursor cur = textCursor();
	cur.movePosition(QTextCursor::Start);
	setTextCursor(cur);
	setFocus();
	scene()->setFocusItem(this);
	dynamic_cast<Scene *>(scene())->setMode(Scene::INSERT);
}
#endif

#if 0
void Node::contextMenuEvent ( QGraphicsSceneContextMenuEvent * event )
{
	ensureVisible();
	Scene *scn = scene();
	scn->setMousePressedNode(this);
	//Node *sNode = scn->selectedNode();
	if( scn->mode() != Scene::COMMAND ) {
		event->ignore();
		return;
	}
	scn->setSelectedNode(this);
	QMenu menu;
	QAction *deleteAct = new QAction(tr("delete"), this);
	connect(deleteAct, SIGNAL(triggered()), scn, SLOT(deleteSelectedItems()));
	menu.addAction(deleteAct);
	menu.exec(event->screenPos());
}
#endif
void Node::deleteThis()
{
}
Node *Node::firstChildNode()
{
	if( m_children.isEmpty() ) return 0;
	//return *m_children.begin();
	foreach(QPointer<Node> ptr, m_children) {
		if( ptr ) {
			return ptr;
		}
	}
	return 0;
}
Node *Node::firstChildNode(bool isRightSide)
{
	if( m_children.isEmpty() ) return 0;
	//return *m_children.begin();
	foreach(QPointer<Node> ptr, m_children) {
		if( ptr && ptr->isRightSide() == isRightSide ) {
			return ptr;
		}
	}
	return 0;
}
Node *Node::lastChildNode()
{
	if( m_children.isEmpty() ) return 0;
	for(QList<QPointer<Node> >::iterator itr = m_children.end(),
											iend = m_children.begin();
		itr != iend;)
	{
		if( *--itr ) {
			return *itr;
		}
	}
	return 0;
}
Node *Node::lastChildNode(bool isRightSide)
{
	if( m_children.isEmpty() ) return 0;
	for(QList<QPointer<Node> >::iterator itr = m_children.end(),
											iend = m_children.begin();
		itr != iend;)
	{
		if( *--itr && (*itr)->isRightSide() == isRightSide ) {
			return *itr;
		}
	}
	return 0;
}
Node *Node::lastDescendantNode(bool isRightSide)
{
	Node *ptr = this;
	for(;;) {
		Node *node = ptr->lastChildNode(isRightSide);
		if( !node )
			return ptr;
		ptr = node;
	}
}
Node *Node::prevNode()
{
	Node *p = parentNode();
	if( !p ) return 0;
	if( p->m_children.size() <= 1 ) return 0;	//	qlȂꍇ
	const bool isRS = isRightSide();
	Node *prev = 0;
	foreach(QPointer<Node> ptr, p->m_children) {
		if( ptr && ptr->isRightSide() == isRS ) {
			if( ptr == this )
				break;
			prev = ptr;
		}
	}
	return prev;
}
Node *Node::nextNode()
{
	Node *p = parentNode();
	if( !p ) return 0;
	if( p->m_children.size() <= 1 ) return 0;	//	qlȂꍇ
	const bool isRS = isRightSide();
	bool next = false;
	foreach(QPointer<Node> ptr, p->m_children) {
		if( ptr && ptr->isRightSide() == isRS ) {
			if( next )
				return ptr;
			if( ptr == this )
				next = true;
		}
	}
	return 0;
}
Node *Node::prevSiblingCousinNode()
{
	Node *p = parentNode();
	if( !p ) return 0;
	if( p->firstChildNode() != this )	//	Zł͖ꍇ
		return prevNode();
	return 0;
}
void Node::collapse(int lvl)
{
	setExpanded(lvl != 0);
	if( --lvl >= 0 ) {
		foreach(Node *node, m_children) {
			node->collapse(lvl);
		}
	}
}
void Node::setTextAlign(Qt::Alignment align)
{
	document()->setDefaultTextOption(QTextOption(m_textAlign = align));
}
void Node::onLinkIconClicked()
{
	const QString fileName = linkedFileName();
	if( fileName.isEmpty() ) return;
#ifdef	WIN32
	if( fileName.endsWith(".png", Qt::CaseInsensitive) ||
		fileName.endsWith(".bmp", Qt::CaseInsensitive) ||
		fileName.endsWith(".gif", Qt::CaseInsensitive) ||
		fileName.endsWith(".jpg", Qt::CaseInsensitive) ||
		fileName.endsWith(".jpeg", Qt::CaseInsensitive) )
	{
		switchingPixmapDisplay();
		return;
	}
	if( fileName.endsWith(".wav", Qt::CaseInsensitive) ) {
		QSound::play(fileName);
		return;
	}
#endif
	scene()->emitOpenLink(fileName);
}
void Node::updatePixmapPos()
{
	if( !m_pixmapItem ) return;
	const qreal pwd = m_pixmapItem->pixmap().width();
	QRectF br = boundingRect();
	m_pixmapItem->setPos(isRightSide() ? -leftSideSpace() :
								(br.width() < pwd ? br.right() - pwd : br.left()),
							br.height());
}
void Node::switchingPixmapDisplay()
{
	if( m_pixmapItem == 0 ) {
		QString fileName = linkedFileName();
		QString curFileName;
		scene()->getCurFileName(curFileName);
		if( !curFileName.isEmpty() ) {
			QDir dir(curFileName);
			dir.cdUp();
			fileName = dir.absoluteFilePath(fileName);
		}
		QPixmap pxm;
		if( !pxm.load(fileName) ) {
			scene()->doShowMessage(QObject::tr("'%1' is not found.").arg(fileName));
			return;
		}
		m_pixmapItem = new QGraphicsPixmapItem(pxm, this);
		updatePixmapPos();
	} else
		m_pixmapItem->setVisible(!m_pixmapItem->isVisible());
	scene()->layoutAll();
}
void Node::findNewerNode(const Node *rNode, Node *&node)
{
	if( op_lt(rNode, this) && (!node || op_lt(this, node)) )
		node = this;
	foreach(QPointer<Node> ptr, m_children) {
		if( ptr )
			ptr->findNewerNode(rNode, node);
	}
}
void Node::findOlderNode(const Node *rNode, Node *&node)
{
	if( op_lt(this, rNode) && (!node || op_lt(node, this)) )
		node = this;
	foreach(QPointer<Node> ptr, m_children) {
		if( ptr )
			ptr->findOlderNode(rNode, node);
	}
}
void Node::findNewestNode(Node *&node)
{
	if( !node || op_lt(node, this) )
		node = this;
	foreach(QPointer<Node> ptr, m_children) {
		if( ptr )
			ptr->findNewestNode(node);
	}
}
void Node::findOldestNode(Node *&node)
{
	if( !node || op_lt(this, node) )
		node = this;
	foreach(QPointer<Node> ptr, m_children) {
		if( ptr )
			ptr->findOldestNode(node);
	}
}
