package gnu.awt.virtual.swing;

import java.awt.*;
import java.awt.peer.*;
import java.awt.BufferCapabilities.FlipContents;
import java.awt.event.*;
import javax.swing.*;

import sun.awt.CausedFocusEvent.Cause;
import sun.java2d.pipe.Region;

/**
* AWT text area peer implemented as a {@link javax.swing.JTextArea}.
**/

@SuppressWarnings("serial")
class SwingTextAreaPeer extends JTextArea implements TextAreaPeer
{
	//
	// Construction
	//
	
	public SwingTextAreaPeer( TextArea textArea )
	{
		super();
		
		switch( textArea.getScrollbarVisibility() )
		{
			case TextArea.SCROLLBARS_BOTH:
				SwingFramePeer.add( textArea, new JScrollPane( this, ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS, ScrollPaneConstants.HORIZONTAL_SCROLLBAR_ALWAYS ) );
				break;
			case TextArea.SCROLLBARS_HORIZONTAL_ONLY:
				SwingFramePeer.add( textArea, new JScrollPane( this, ScrollPaneConstants.VERTICAL_SCROLLBAR_NEVER, ScrollPaneConstants.HORIZONTAL_SCROLLBAR_ALWAYS ) );
				break;
			case TextArea.SCROLLBARS_VERTICAL_ONLY:
				SwingFramePeer.add( textArea, new JScrollPane( this, ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS, ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER ) );
				break;
			case TextArea.SCROLLBARS_NONE:
				SwingFramePeer.add( textArea, this );
				break;
		}

		setText( textArea.getText() );
		setRows( textArea.getRows() );
		setColumns( textArea.getColumns() );
		setEditable( textArea.isEditable() );
	}
	
	//
	// TextAreaPeer
	//
	
	public Dimension getPreferredSize( int rows, int columns )
	{
		return null;
	}
	
	public Dimension getMinimumSize( int rows, int columns )
	{
		return null;
	}
	
	// Deprectated
	
	public void insertText( String txt, int pos )
	{
		insert( txt, pos );
	}	
	
	public void replaceText( String txt, int start, int end )
	{
		replaceRange( txt, start, end );
	}
	
	public Dimension preferredSize( int rows, int cols )
	{
		return getPreferredSize( rows, cols );
	}
	
	public Dimension minimumSize( int rows, int cols )
	{
		return getMinimumSize( rows, cols );
	}
	
	//
	// TextComponentPeer
	//
	
	public int getIndexAtPoint( int x, int y )
	{
		return 0;
	}
	
	public Rectangle getCharacterBounds( int i )
	{
		return null;
	}
	
	public long filterEvents( long mask )
	{
		return 0;
	}
	
	//
	// ComponentPeer
	//
	
	// Events
	
	public void handleEvent( AWTEvent e )
	{
		//System.err.println(e);
	}
	
	public void coalescePaintEvent( PaintEvent e )
	{
		System.err.println(e);
	}
	
	public boolean handlesWheelScrolling()
	{
		return false;
	}
	
	// Obscurity
	
	public boolean isObscured()
	{
		return false;
	}
	
	public boolean canDetermineObscurity()
	{
		return false;
	}
	
	// Focus
	
	public boolean requestFocus( Component lightweightChild, boolean temporary, boolean focusedWindowChangeAllowed, long time )
	{
		return true;
	}
	
	// Buffer
	
	public void createBuffers( int x, BufferCapabilities bufferCapabilities )
	{
	}
	
	public void destroyBuffers()
	{
	}
	
	public void flip( BufferCapabilities.FlipContents flipContents )
	{
	}
	
	public Image getBackBuffer()
	{
		return null;
	}
	
	// Cursor
	
	public void updateCursorImmediately()
	{
	}
	
	// Misc
	
	public void dispose()
	{
	}

	public void applyShape(Region arg0) {
		// TODO Auto-generated method stub
		
	}

	public void flip(int arg0, int arg1, int arg2, int arg3, FlipContents arg4) {
		// TODO Auto-generated method stub
		
	}

	public boolean isReparentSupported() {
		// TODO Auto-generated method stub
		return false;
	}

	public void reparent(ContainerPeer arg0) {
		// TODO Auto-generated method stub
		
	}

	public boolean requestFocus(Component arg0, boolean arg1, boolean arg2,
			long arg3, Cause arg4) {
		// TODO Auto-generated method stub
		return false;
	}

	public void setBounds(int arg0, int arg1, int arg2, int arg3, int arg4) {
		// TODO Auto-generated method stub
		
	}
	
	///////////////////////////////////////////////////////////////////////////////////////
	// Private
}
