package gnu.awt.virtual.swing;

import gnu.awt.virtual.*;
import gnu.swing.virtual.*;

import java.awt.*;
import java.awt.peer.*;
import java.awt.dnd.*;
import java.awt.dnd.peer.*;
import java.awt.image.*;

import javax.swing.*;

/**
* AWT toolkit implemented entirely with JFC peers, thus allowing a lightweight simulation
* of the operating system desktop.
**/

public class VirtualDesktop extends VirtualToolkit
{
	//
	// Construction
	//
	
	public VirtualDesktop( DirectColorModel colorModel, String title, int width, int height )
	{
		super( colorModel, width, height );
		init( title );
	}
	
	public VirtualDesktop( int bitsPerPixel, int rMask, int gMask, int bMask, String title, int width, int height )
	{
		super( bitsPerPixel, rMask, gMask, bMask, width, height );
		init( title );
	}
	
	public VirtualDesktop( String title, int width, int height )
	{
		super( width, height );
		init( title );
	}
	
	//
	// Operations
	//
	
	@SuppressWarnings("deprecation")
	public void show()
	{
		desktopFrame.show();
	}
	
	public void dispose()
	{
		desktopFrame.dispose();
	}
	
	//
	// Toolkit
	//

	// Peers
	
	@Override
	protected ButtonPeer createButton( Button target )
	{
		return new SwingButtonPeer( target );
	}

	@Override
	protected CanvasPeer createCanvas( Canvas target )
	{
		//return super.createCanvas( target );
		return new SwingCanvasPeer( target );
	}

	@Override
	protected CheckboxPeer createCheckbox( Checkbox target )
	{
		return new SwingCheckboxPeer( target );
	}

	@Override
	protected CheckboxMenuItemPeer createCheckboxMenuItem( CheckboxMenuItem target )
	{
		return new SwingCheckboxMenuItemPeer( target );
	}

	@Override
	protected ChoicePeer createChoice( Choice target )
	{
		return new SwingChoicePeer( target );
	}

	@Override
	protected LightweightPeer createComponent( Component target )
	{
		return super.createComponent( target );
	}

	@Override
	protected DialogPeer createDialog( Dialog target )
	{
		return new SwingDialogPeer( target );
	}

	@Override
	public DragSourceContextPeer createDragSourceContextPeer( DragGestureEvent dge )
	{
		return null;
	}

	@Override
	protected FileDialogPeer createFileDialog( FileDialog target )
	{
		return null;
	}
 
	@Override
	protected FramePeer createFrame( Frame target )
	{
		if( !initialized )
		{
			// Only desktop is real frame
			initialized = true;
			return super.createFrame( target );
		}
		else
			// Other frames are emulated
			return new SwingFramePeer( desktop, target );
	}

	@Override
	protected LabelPeer createLabel( Label target )
	{
		return new SwingLabelPeer( target );
	}

	@Override
	protected ListPeer createList( java.awt.List target )
	{
		return new SwingListPeer( target );
	}

	@Override
	protected MenuPeer createMenu( Menu target )
	{
		return new SwingMenuPeer( target );
	}

	@Override
	protected MenuBarPeer createMenuBar( MenuBar target )
	{
		return new SwingMenuBarPeer( target );
	}

	@Override
	protected MenuItemPeer createMenuItem( MenuItem target )
	{
		return new SwingMenuItemPeer( target );
	}

	@Override
	protected PanelPeer createPanel( Panel target )
	{
		return new SwingPanelPeer( target );
	}

	@Override
	protected PopupMenuPeer createPopupMenu( PopupMenu target )
	{
		return new SwingPopupMenuPeer( target );
	}

	@Override
	protected ScrollbarPeer createScrollbar( Scrollbar target )
	{
		return new SwingScrollbarPeer( target );
	}

	@Override
	protected ScrollPanePeer createScrollPane( ScrollPane target )
	{
		return new SwingScrollPanePeer( target );
	}

	@Override
	protected TextAreaPeer createTextArea( TextArea target )
	{
		return new SwingTextAreaPeer( target );
	}

	@Override
	protected TextFieldPeer createTextField( TextField target )
	{
		return new SwingTextFieldPeer( target );
	}

	@Override
	protected WindowPeer createWindow( Window target )
	{
		return new SwingWindowPeer( target );
	}

	///////////////////////////////////////////////////////////////////////////////////////
	// Private
	
	protected VirtualJFrame desktopFrame = null;
	protected JDesktopPane desktop = null;
	private boolean initialized = false;
	
	private void init( String title )
	{
		desktopFrame = new VirtualJFrame( this, title );
		desktopFrame.setSize( getScreenSize().width, getScreenSize().height );
		desktop = new JDesktopPane();
		desktopFrame.getContentPane().add( desktop );
	}
}
