unit Unit1;

interface

uses
  System.SysUtils, System.Types, System.UITypes, System.Classes,
  System.Variants,
  FMX.Types, FMX.Controls, FMX.Forms, FMX.Graphics, FMX.Dialogs,
  Data.Bind.EngExt, FMX.Bind.DBEngExt, System.Rtti, System.Bindings.Outputs,
  FMX.Bind.Editors, Data.Bind.Components, FMX.StdCtrls, FMX.Effects,
  FMX.Filter.Effects, FMX.Ani, FMX.Objects, FMX.Menus, FMX.ListView.Types,
  FMX.ListView, System.TypInfo, FMX.Layouts, FMX.ListBox,
  FMX.Controls.Presentation, FMX.Edit, FMX.EditBox, FMX.SpinBox, FMX.Media,
  Math;

type
  TForm1 = class(TForm)
    BlurTransitionEffect1: TBlurTransitionEffect;
    Image1: TImage;
    Timer1: TTimer;
    BandedSwirlTransitionEffect1: TBandedSwirlTransitionEffect;
    MainMenu1: TMainMenu;
    BlindTransitionEffect1: TBlindTransitionEffect;
    CircleTransitionEffect1: TCircleTransitionEffect;
    MagnifyTransitionEffect1: TMagnifyTransitionEffect;
    CrumpleTransitionEffect1: TCrumpleTransitionEffect;
    DissolveTransitionEffect1: TDissolveTransitionEffect;
    DropTransitionEffect1: TDropTransitionEffect;
    FadeTransitionEffect1: TFadeTransitionEffect;
    BrightTransitionEffect1: TBrightTransitionEffect;
    PixelateTransitionEffect1: TPixelateTransitionEffect;
    WiggleTransitionEffect1: TWiggleTransitionEffect;
    ShapeTransitionEffect1: TShapeTransitionEffect;
    RippleTransitionEffect1: TRippleTransitionEffect;
    RotateCrumpleTransitionEffect1: TRotateCrumpleTransitionEffect;
    SaturateTransitionEffect1: TSaturateTransitionEffect;
    SlideTransitionEffect1: TSlideTransitionEffect;
    SwirlTransitionEffect1: TSwirlTransitionEffect;
    WaterTransitionEffect1: TWaterTransitionEffect;
    WaveTransitionEffect1: TWaveTransitionEffect;
    LineTransitionEffect1: TLineTransitionEffect;
    FloatAnimation1: TFloatAnimation;
    ListView1: TListView;
    Button1: TButton;
    OpenDialog1: TOpenDialog;
    Button2: TButton;
    MenuItem1: TMenuItem;
    MenuItem2: TMenuItem;
    MenuItem3: TMenuItem;
    MenuItem4: TMenuItem;
    MenuItem5: TMenuItem;
    MenuItem6: TMenuItem;
    ComboBox1: TComboBox;
    MenuItem7: TMenuItem;
    MenuItem8: TMenuItem;
    MenuItem9: TMenuItem;
    MenuItem10: TMenuItem;
    Button3: TButton;
    MenuItem11: TMenuItem;
    SpinBox1: TSpinBox;
    Label1: TLabel;
    Label2: TLabel;
    MediaPlayer1: TMediaPlayer;
    Label3: TLabel;
    MenuItem12: TMenuItem;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure ListView1Change(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FloatAnimation1Finish(Sender: TObject);
    procedure MenuItem5Click(Sender: TObject);
    procedure MenuItem8Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure SpinBox1Change(Sender: TObject);
    procedure MenuItem12Click(Sender: TObject);
  private
    progress: Boolean;
    { private 錾 }
  public
    { public 錾 }
  end;

var
  Form1: TForm1;

implementation

{$R *.fmx}

uses Unit2, Unit3;

procedure TForm1.Button1Click(Sender: TObject);
var
  i: Integer;
  s: TListViewItem;
begin
  if OpenDialog1.Execute = true then
  begin
    for i := 0 to OpenDialog1.Files.Count - 1 do
    begin
      s := ListView1.Items.Add;
      s.Text := ExtractFileName(OpenDialog1.Files[i]);
      s.Detail := OpenDialog1.Files[i];
      s.Bitmap.LoadFromFile(OpenDialog1.Files[i]);
    end;
    if ListView1.ItemCount > 0 then
    begin
      ListView1.ItemIndex := 0;
      Image1.Bitmap.Assign(ListView1.Items[0].Bitmap);
      Randomize;
    end;
  end;
end;

procedure TForm1.Button2Click(Sender: TObject);
var
  s: TFmxObject;
  i: Integer;
begin
  if (ListView1.ItemIndex > -1) and (ComboBox1.Items.Count > 0) and
    (ListView1.ItemIndex < ListView1.ItemCount - 1) then
  begin
    if FloatAnimation1.Running = true then
    begin
      progress := true;
      FloatAnimation1.Stop;
    end;
    for i := 0 to Image1.ChildrenCount - 1 do
      if Image1.Children[i].ClassName = ComboBox1.Items[ComboBox1.ItemIndex]
      then
      begin
        s := Image1.Children[i];
        (s as TEffect).Enabled := true;
        FloatAnimation1.Parent := s;
        SetObjectProp(s, 'target',
          ListView1.Items[ListView1.ItemIndex + 1].Bitmap);
        FloatAnimation1.Start;
        if Sender = Button2 then
          MediaPlayer1.Play;
        break;
      end;
  end;
end;

procedure TForm1.Button3Click(Sender: TObject);
var
  i: Integer;
begin
  for i := ListView1.Items.Count - 1 downto 0 do
    if ListView1.Items[i].Checked = true then
      ListView1.Items.Delete(i);
end;

procedure TForm1.FloatAnimation1Finish(Sender: TObject);
begin
  (FloatAnimation1.Parent as TEffect).Enabled := false;
  if (ListView1.ItemIndex < ListView1.ItemCount - 1) and (progress = false) then
  begin
    ListView1.ItemIndex := ListView1.ItemIndex + 1;
    Image1.Bitmap.Assign(ListView1.Items[ListView1.ItemIndex].Bitmap);
    if ListView1.ItemIndex < ListView1.ItemCount - 1 then
    begin
      ComboBox1.ItemIndex := Random(ComboBox1.Items.Count);
      FloatAnimation1.Stop;
      Button2Click(Sender);
    end;
  end
  else
  begin
    progress := false;
    MediaPlayer1.Stop;
  end;
end;

procedure TForm1.FormCreate(Sender: TObject);
var
  i: Integer;
begin
  for i := 0 to Image1.ChildrenCount - 1 do
    ComboBox1.Items.Add(Image1.Children[i].ClassName);
  ComboBox1.ItemIndex := 0;
end;

procedure TForm1.ListView1Change(Sender: TObject);
begin
  if FloatAnimation1.Running = true then
  begin
    progress := true;
    FloatAnimation1.Stop;
  end;
  SpinBox1Change(Sender);
  if (Form3.CheckBox1.IsChecked = true) and
    (MediaPlayer1.CurrentTime > MediaPlayer1.Duration) then
    MediaPlayer1.CurrentTime :=
      MediaPlayer1.CurrentTime mod MediaPlayer1.Duration;
  Image1.Bitmap.Assign(ListView1.Items[ListView1.ItemIndex].Bitmap);
end;

procedure TForm1.MenuItem12Click(Sender: TObject);
begin
  if Form3.ShowModal = mrOK then
    if Form3.FIleName = '' then
    begin
      MediaPlayer1.Clear;
      Label3.Text := 't@CF' + 'Ȃ';
    end
    else
    begin
      MediaPlayer1.FIleName := Form3.FIleName;
      if Form3.Switch1.IsChecked = true then
        MediaPlayer1.Volume := 0
      else
        MediaPlayer1.Volume := Form3.MediaPlayer1.Volume;
      Label3.Text := 't@CF' + ExtractFileName(Form3.FIleName);
    end;
end;

procedure TForm1.MenuItem5Click(Sender: TObject);
begin
  Close;
end;

procedure TForm1.MenuItem8Click(Sender: TObject);
var
  s: string;
  i: Integer;
begin
  if ComboBox1.Items.Count > 0 then
    s := ComboBox1.Items[ComboBox1.ItemIndex];
  if Form2.ShowModal = mrOK then
  begin
    ComboBox1.Items.Assign(Form2.ListBox2.Items);
    i := ComboBox1.Items.IndexOf(s);
    if i > -1 then
      ComboBox1.ItemIndex := i
    else if ComboBox1.Items.Count > 0 then
      ComboBox1.ItemIndex := 0;
  end;
end;

procedure TForm1.SpinBox1Change(Sender: TObject);
begin
  with FloatAnimation1 do
  begin
    if Running = true then
    begin
      progress := true;
      Stop;
    end;
    Delay := SpinBox1.Value - Duration;
  end;
  if ListView1.Items.Count > 0 then
    MediaPlayer1.CurrentTime := Floor(SpinBox1.Value * MediaPlayer1.Duration *
      MediaTimeScale * ListView1.ItemIndex / ListView1.Items.Count);
  Label2.Visible := SpinBox1.Value = 2.50;
end;

end.
